<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title><?php
	global $page, $paged;
	wp_title( '|', true, 'right' );
	bloginfo( 'name' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'zipe' ), max( $paged, $page ) );
	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="shortcut icon" href="<?php echo home_url( '/' ); ?>favicon.ico" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php if(stripos($_SERVER["HTTP_USER_AGENT"],"MSIE")) { ?>
<!--[if lt IE 9]><script type="text/javascript">(function(){if(!/*@cc_on!@*/0)return;var e = "article,aside,footer,hgroup,header,nav,section,time".split(','),i=0,length=e.length;while(i<length){document.createElement(e[i++])}})();</script><![endif]-->
<?php } ?>
<?php
	if ( is_singular() && comments_open() ) {
		wp_enqueue_script( 'comment-reply' );
		wp_enqueue_script('jquery');
	}
	wp_head();
?>
</head>

<body <?php body_class(); ?>>
<header id="branding" role="banner">
	<div id="logo">
		<a href="<?php echo home_url(); ?>" rel="home"><img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" /></a>
	</div>
	
	<nav id="access" class="clearfix" role="navigation">
	<?php if ( is_search() || is_archive() ) : ?>
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php _e('Home', 'zipe'); ?></a> > 
	<?php endif; ?>
	<?php if ( is_search() ) {
		printf( __( 'Search Results for: %s', 'zipe' ), get_search_query() );
	} elseif ( is_category() ) {
		echo __( 'Category Archives: ', 'zipe' ) . single_cat_title('', false);
	} elseif ( is_tag() ) {
		echo __( 'Tag Archives: ', 'zipe' ) . single_tag_title('', false);
	} elseif ( is_day() ) {
		echo __( 'Daily Archives: ', 'zipe' ) . get_the_date(__('d M Y', 'zipe' ));
	} elseif ( is_month() ) {
		echo __( 'Monthly Archives: ', 'zipe' ) . get_the_date(__('M Y', 'zipe' ));
	} elseif ( is_year() ) {
		echo __( 'Yearly Archives: ', 'zipe' ) . get_the_date(__('Y', 'zipe' ));
	} elseif ( is_author() ) {
		if ( have_posts() ) {
			the_post();
			echo __( 'Author Archives: ', 'zipe' ) . get_the_author();
			rewind_posts();
		}
	} elseif ( is_archive() ) {
		echo __( 'Blog Archives', 'zipe' );
	} else {
		wp_nav_menu( array( 'container' => false, 'menu' => 'mobile' ) );
	}
	?>
	</nav><!-- #access -->
</header><!-- #branding -->
<section id="main" role="main">