<?php if ( ! have_posts() ) : ?>
	<article id="post-0" class="post no-results not-found">
		<h1 class="entry-title"><?php _e( 'Nothing Found', 'zipe' ); ?></h1>
		<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'zipe' ); ?></p>
	</article>
<?php endif; ?>

<?php $count = 1; ?>
<?php while ( have_posts() ) : the_post(); ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'zipe' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark" class="post clearfix entry-thumb"><img src="<?php echo get_first_image(); ?>" alt="" /></a>
		<div class="entry-body">
			<h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'zipe' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark" class="post"><?php the_title(); ?></a></h2>
			<div class="entry-meta"><img src="<?php echo home_url( '/' ); ?>wp-content/themes/MiniWS/images/ico1.png"><?php the_category(', '); ?><span class="comments"><img src="<?php echo home_url( '/' ); ?>wp-content/themes/MiniWS/images/ico2.png"><?php comments_popup_link('0条评论', '1条评论', '%条评论'); ?></span></div>
			<div class="entry-summary">
				<?php echo mb_strimwidth(strip_tags($post->post_content),0,184,' ...'); ?>
			</div>
		</div>
	</article>
	<?php if ($count == 10) get_template_part('ad'); ?>
	<?php $count++; ?>
<?php endwhile; ?>

<?php if ( $wp_query->max_num_pages > 1 ) : ?>
	<nav id="nav-below">
		<div class="nav-previous"><?php previous_posts_link(__( '&laquo; Previous', 'zipe')); ?></div>
		<div class="nav-next"><?php next_posts_link(__( 'Next &raquo;', 'zipe')); ?></div>
	</nav>
<?php endif; ?>