<?php
/*
Template Name: Archives
*/
?>

<?php get_header(); ?>
	<article <?php post_class(); ?>>
		<h2 class="entry-title"><?php _e( 'Tag Archives', 'zipe' ); ?></h2>
		<div class="entry-content">
			<?php wp_tag_cloud('smallest=7&largest=24'); ?>
		</div>
		<h2 class="entry-title"><?php _e( 'Category Archives', 'zipe' ); ?></h2>
		<div class="entry-content">
			<ul>
				<?php wp_list_categories('show_count=1&title_li='); ?>
			</ul>
		</div>
		<h2 class="entry-title"><?php _e( 'Page Archives', 'zipe' ); ?></h2>
		<div class="entry-content">
			<ul>
				<?php wp_list_pages('title_li='); ?>
			</ul>
		</div>
		<h2 class="entry-title"><?php _e( 'Blog Archives', 'zipe' ); ?></h2>
		<div class="entry-content">
			<?php if(function_exists('clean_archives_reloaded')) { clean_archives_reloaded(); } else { ?>
				<ul>
					<?php wp_get_archives('type=alpha'); ?>
				</ul>
			<?php } ?>
		</div>
	</article>
	<?php get_template_part('ad'); ?>

<?php get_footer(); ?>