/* Most of the code from Menéame by Ricardo Galli */

// create the tooltip object
function tooltip(){}

// setup properties of tooltip object
tooltip.id="tooltip";
tooltip.main=null;
tooltip.offsetx = 10;
tooltip.offsety = 10;
tooltip.shoffsetx = 8;
tooltip.shoffsety = 8;
tooltip.x = 0;
tooltip.y = 0;
tooltip.tooltipShadow=null;
tooltip.tooltipText=null;
tooltip.title_saved='';
tooltip.saveonmouseover=null;
tooltip.timeout = null;
tooltip.active = false;

tooltip.cache = new JSOC();

tooltip.ie = (document.all)? true:false; // check if ie
if(tooltip.ie) tooltip.ie5 = (navigator.userAgent.indexOf('MSIE 5')>0);
else tooltip.ie5 = false;
tooltip.dom2 = ((document.getElementById) && !(tooltip.ie5))? true:false; // check the W3C DOM level2 compliance. ie4, ie5, ns4 are not dom level2 compliance !! grrrr >:-(

/**
* Open ToolTip. The title attribute of the htmlelement is the text of the tooltip
* Call this method on the mouseover event on your htmlelement
* ex :  <div id="myHtmlElement" onmouseover="tooltip.show(this)"...></div>
*/

tooltip.show = function (event, text) {
      // we save text of title attribute to avoid the showing of tooltip generated by browser
	if (this.dom2  == false ) return false;
	if (this.tooltipShadow == null) {
		this.tooltipShadow = document.createElement("div");
		this.tooltipShadow.setAttribute("id", "tooltip-shadow");
		document.body.appendChild(tooltip.tooltipShadow);

		this.tooltipText = document.createElement("div");
		this.tooltipText.setAttribute("id", "tooltip-text");
		document.body.appendChild(this.tooltipText);
	}
	this.saveonmouseover=document.onmousemove;
	document.onmousemove = this.mouseMove;
	this.mouseMove(event); // This already moves the div to the right position
	this.setText(text);
	this.tooltipText.style.visibility ="visible";
	this.tooltipShadow.style.visibility ="visible";
	this.active = true;
	return false;
}


tooltip.setText = function (text) {
	tooltip.tooltipShadow.style.width = 0+"px";
	tooltip.tooltipShadow.style.height = 0+"px";
	this.tooltipText.innerHTML=text;
	setTimeout('tooltip.setShadow()', 1);
	return false;
}

tooltip.setShadow = function () {
	tooltip.tooltipShadow.style.width = tooltip.tooltipText.clientWidth+"px";
	tooltip.tooltipShadow.style.height = tooltip.tooltipText.clientHeight+"px";
}


/**
* hide tooltip
* call this method on the mouseout event of the html element
* ex : <div id="myHtmlElement" ... onmouseout="tooltip.hide(this)"></div>
*/
tooltip.hide = function (event) {
	if (this.dom2  == false) return false;
	document.onmousemove=this.saveonmouseover;
	this.saveonmouseover=null;
	if (this.tooltipShadow != null ) {
		this.tooltipText.style.visibility = "hidden";
		this.tooltipShadow.style.visibility = "hidden";
		this.tooltipText.innerHTML='';
	}
	this.active = false;
}



// Moves the tooltip element
tooltip.mouseMove = function (e) {
   // we don't use "this", but tooltip because this method is assign to an event of document
   // and so is dreferenced

	if (tooltip.ie) {
		tooltip.x = event.clientX;
		tooltip.y = event.clientY;
	} else {
		tooltip.x = e.pageX;
		tooltip.y = e.pageY;
	}
	tooltip.moveTo( tooltip.x +tooltip.offsetx , tooltip.y + tooltip.offsety);
}

// Move the tooltip element
tooltip.moveTo = function (xL,yL) {
	if (this.ie) {
		xL +=  document.documentElement.scrollLeft;
		yL +=  document.documentElement.scrollTop;
	}
	if (this.tooltipText.clientWidth > 0  && document.documentElement.clientWidth > 0 && xL > document.documentElement.clientWidth * 0.55) {
		xL = xL - this.tooltipText.clientWidth - 2*this.offsetx;
	}
	this.tooltipText.style.left = xL +"px";
	this.tooltipText.style.top = yL +"px";
	xLS = xL + this.shoffsetx;
	yLS = yL + this.shoffsety;
	this.tooltipShadow.style.left = xLS +"px";
	this.tooltipShadow.style.top = yLS +"px";
}

tooltip.ajax_delayed = function (event, script, id, maxcache) {
	maxcache = maxcache || 600000; // 10 minutes in cache
	if (this.active) return false;
	if ((object = this.cache.get(script+id)) != undefined) {
		json = object[script+id];
		var show = '';
		if (json['type'] == 'profile') {
			if (json['error']) show = '<span class="tooltip_bold">'+translations[24]+'</span> '+translations[25];
			else {
				if (json['realname']) show = '<span class="tooltip_bold">'+translations[26]+'</span> ' + json['realname'] + '<br />';
				if (json['url']) show += '<span class="tooltip_bold">'+translations[29]+'</span> ' + json['url'] + '<br />';
				if (json['location']) show += '<span class="tooltip_bold">'+translations[27]+'</span> ' + json['location'] + '<br />';
				if (json['bio']) show += '<span class="tooltip_bold">'+translations[28]+'</span> ' + json['bio'] + '<br />';
				show += '<span class="tooltip_bold">'+translations[30]+'</span> ' + json['since'] + '<br />';
			}
		}
		if (json.type == 'note') {
			if (json.error !== undefined) show = '<span class="tooltip_bold">'+translations[24]+'</span> '+translations[25];
			else {
				var show = '<div style="padding:2 0 0 2;"><span class="tooltip_bold">'+translations[31]+'</span> ' + json['text'] + '</div>';
			}
		}
		tooltip.show(event, show);
	} else {
		this.show(event, translations[0]);
		this.timeout = setTimeout("tooltip.ajax_request('"+script+"', '"+id+"', "+maxcache+")", 100);
	}
}

tooltip.ajax_request = function(script, id, maxcache) {
	var url = baseURL.replace('%s', 'ajax').replace('%i', script).replace('%d', id);
	tooltip.timeout = null;
	$.getJSON(url, function(json) {
		tooltip.cache.set(script+id, json, {'ttl':maxcache});
		var show = '';
		if (json['type'] == 'profile') {
			if (json['error']) show = '<span class="tooltip_bold">'+translations[24]+'</span> '+translations[25]+'</span>';
			else {
				if (json['realname']) show = '<span class="tooltip_bold">'+translations[26]+'</span> ' + json['realname'] + '<br />';
				if (json['url']) show += '<span class="tooltip_bold">'+translations[29]+'</span> ' + json['url'] + '<br />';
				if (json['location']) show += '<span class="tooltip_bold">'+translations[27]+'</span> ' + json['location'] + '<br />';
				show += '<span class="tooltip_bold">'+translations[30]+'</span> ' + json['since'] + '<br />';
			}
		}
		if (json.type == 'note') {
			if (json.error !== undefined) var show = '<span class="tooltip_bold">'+translations[24]+'</span> '+translations[25];
			else {
				var show = '<div style="padding:2 0 0 2;"><span class="tooltip_bold">'+translations[31]+'</span> ' + json['text'] + '</div>';
			}
		}
		tooltip.setText(show);
	});
}