<?php

$themename = 'WPCnblogs';

add_action('admin_menu', 'simple_theme_page');

function simple_theme_page (){
	if ( count($_POST) > 0 && isset($_POST['simple_settings']) ){
		$options = array ('keywords','description','analytics','approve');
		foreach ( $options as $opt ){
			update_option( 'swt_'.$opt, $_POST[$opt] );
		}
	}
	add_theme_page($themename." Options", "当前主题设置", 'edit_themes', basename(__FILE__), 'theme_settings');
	wp_enqueue_style("functions", $file_dir."/includes/options/options.css", false, "1.0", "all");

}

function theme_settings(){?>
<div class="wrap">
	<h2><?php echo $themename; ?> 主题选项</h2>
	<p>当前使用主题: WPCnblogs 1.0版 | 制作者:<a href="http://www.zxlive.net" target="_blank"> 飘无痕</a> | <a href="http://www.syet.net" target="_blank">查看主题演示</a></p>

	<form method="post" action="">
		<fieldset>
		<legend><strong>SEO 代码添加</strong></legend>
			<table class="form-table">
				<tr><td>
					<em>网站关键词（Meta Keywords），中间用半角逗号隔开</em><br />
					<textarea name="keywords" id="keywords" rows="3" cols="70"><?php echo get_option('swt_keywords'); ?></textarea>
				</td></tr>
				<tr><td>
					<em>网站描述（Meta Description），针对搜索引擎设置的网页描述</em><br />
					<textarea name="description" id="description" rows="3" cols="70"><?php echo get_option('swt_description'); ?></textarea>
				</td></tr>
			</table>
		</fieldset>
		<fieldset>
		<legend><strong>统计代码添加</strong></legend>
			<table class="form-table">
				<tr><td>
					<textarea name="analytics" id="analytics" rows="5" cols="70"><?php echo stripslashes(get_option('swt_analytics')); ?></textarea>
				</td></tr>
			</table>
		</fieldset>
		<p class="submit">
			<input type="submit" name="Submit" class="button-primary" value="保存设置" />
			<input type="hidden" name="simple_settings" value="save" style="display:none;" />
		</p>
	</form>
</div>
<?php
}

?>