<?php
/**
 * Plugin Name: 评论邮件通知
 * Version: 1.1
 * Plugin URL: http://www.liuzp.com
 * Description: 在收到评论和回复时自动将评论内容发送到被评人邮箱
 * Author: Liuzp
 * Author Email: root@liuzp.com
 * Author URL: http://www.liuzp.com
 */

!defined('EMLOG_ROOT') && exit ('access deined!');
require (EMLOG_ROOT . '/content/plugins/commentNotice/class/class.phpmailer.php');
function smtp_mail($sendto_email, $subject, $body, $extra_hdrs, $user_name) {
	require (EMLOG_ROOT . '/content/plugins/commentNotice/commentNotice_config.php');
	//var_dump($config);
	$mail = new PHPMailer();
	$mail->IsSMTP(); // send via SMTP
	$mail->Host = $config["smtpHost"]; // SMTP servers
	$mail->SMTPAuth = true; // turn on SMTP authentication
	$mail->Username = $config["smtpUser"]; // SMTP username  注意：普通邮件认证不需要加 @域名
	$mail->Password = $config["smtpPwd"]; // SMTP password
	$mail->From = $config["smtpUser"]; // 发件人邮箱
	$mail->FromName = $user_name; // 发件人
	$mail->CharSet = "utf-8"; // 这里指定字符集
	$mail->Encoding = "base64";
	$mail->AddAddress($sendto_email, "username"); // 收件人邮箱和姓名
	$mail->AddReplyTo($this[From], $this[Username]);
	$mail->IsHTML(true); // send as HTML
	// 邮件主题    
	$mail->Subject = $subject;
	// 邮件内容    
	$mail->Body = $body;
	$mail->AltBody = "text/html";
	$mail->Send();
}

function send_notice() {
	require (EMLOG_ROOT . '/content/plugins/commentNotice/commentNotice_config.php');
	$DB = MySql :: getInstance();
	$comname = isset ($_POST['comname']) ? addslashes(trim($_POST['comname'])) : 'admin';
	$comment = $_POST['comment'];
	$articleUrl = $_SERVER['HTTP_REFERER'];
	$_POST['gid'] == "" ? $gid = $_GET['gid'] : $gid = $_POST['gid'];
	$_POST['pid'] == "" ? $pid = $_GET['pid'] : $pid = $_POST['pid'];
	if ($pid != 0 && $config["rule"]==0) {
		$query = $DB->query("select mail from " . DB_PREFIX . "comment where cid=" . $pid);
		while ($rs = $DB->fetch_array($query)) {
			$sendto_email = $rs['mail'];
		}
	} else {
		$sendto_email = $config["smtpUser"];
	}
	//判断是否在排除列表中
	if (in_array($sendto_email, $config[exclude])){
		$sendto_email = "";
	}
	$excludeUrl = $_SERVER['HTTP_HOST']."/content/plugins/commentNotice/commentNotice_exclude.php";
	$blogname = Option :: get('blogname');
	$Log_Model = new Log_Model();
	$logData = $Log_Model->getOneLogForHome($gid);
	$log_title = $logData['log_title'];
	$send_title = '您在[' . $blogname . ']中收到了[' . $comname . ']的评论';
	$send_content = '[' . $comname . ']在文章《' . $log_title . '》中评论了您：<br />' . $comment . '<br /><a href="' . $articleUrl . '" target="_blank">详情请点击</a><br />如果您不喜欢这种邮件通知的方式，请<a href="http://'.$excludeUrl.'?email='.$sendto_email.'" target="_blank">点此取消</a>';
	
	if($sendto_email!=""){
		// 参数说明(发送到, 邮件主题, 邮件内容, 附加信息, 用户名)  
		smtp_mail($sendto_email, $send_title, $send_content, "liuzp.com", $comname);
	}
}

function set_menu() {
	echo '<div class="sidebarsubmenu" id="comment_notice"><a href="./plugin.php?plugin=commentNotice">评论邮件通知</a></div>';
}
addAction('comment_saved', 'send_notice');
addAction('adm_sidebar_ext', 'set_menu');