<?php
class UserModel extends Model {
	 // 自动验证设置 
	protected $_validate = array( 
		array('uname', 'require', '用户名必须填写！'),
		array('email', 'require', '邮箱必须填写！'),
		array('uname', 'checklen', '用户名长度不能超过20！', 0,'callback'),
		array('email', 'email', '邮箱格式错误！', 0),
		array('password', 'require', '密码必须填写！'),
		array('password', 'checkpwd', '密码需要大于6位！', 0,'callback'),
		array('repassword','password','确认密码和密码不一致!',0,'confirm'), // 验证确认密码是否和密码一致
		array('uname', '', '用户名已经存在', 0, 'unique', 1),
		array('email', '', '邮箱已经存在!请更换', 0, 'unique', 1), 
	);

	// 自动填充设置
    protected $_auto = array(
        array('jointime','time',1, 'function'),
		array('lasttime','time',1,'function'),
		array('password','safepwd',3,'callback'),
		array('joinip','returnip',1,'callback'),
		array('lastip','returnip',1,'callback'),
    ); 
	
	//转换IP.自动填充时使用
	function returnip(){
			return ip2long($_SERVER['REMOTE_ADDR']);
	}
	
	//安全密码,根据用户的密码加自定义字符串加密!
	function safepwd($data){
		return md5($data);
	}
	
	//验证长度是否超过15个字符,检测用户名时使用.
	function checklen($data){
		if(strlen($data)>20){
			return false;
		}else{
			return true;
		}
	}
	function checkpwd($data){
		if(strlen($data)<6) return false;
		else return true;
	}
}
?>