<?php
/*
Template Name: 投稿页面
*/
?>
<?php    
	if( isset($_POST['tougao_form']) && $_POST['tougao_form'] == 'send'){
		global $wpdb;
		$last_post = $wpdb->get_var("SELECT post_date FROM $wpdb->posts WHERE post_type = 'post' ORDER BY post_date DESC LIMIT 1");
		// 博客当前最新文章发布时间与要投稿的文章至少间隔120秒。
		// 可自行修改时间间隔，修改下面代码中的120即可
		// 相比Cookie来验证两次投稿的时间差，读数据库的方式更加安全
		if ( current_time('timestamp') - strtotime($last_post) < 120 ){
			wp_die('您投稿也太勤快了吧，先歇会儿！');
		}       
		// 表单变量初始化
		$name = isset( $_POST['tougao_authorname'] ) ? trim(htmlspecialchars($_POST['tougao_authorname'], ENT_QUOTES)) : '';
		$email =  isset( $_POST['tougao_authoremail'] ) ? trim(htmlspecialchars($_POST['tougao_authoremail'], ENT_QUOTES)) : '';
		$blog =  isset( $_POST['tougao_authorblog'] ) ? trim(htmlspecialchars($_POST['tougao_authorblog'], ENT_QUOTES)) : '';
		$title =  isset( $_POST['tougao_title'] ) ? trim(htmlspecialchars($_POST['tougao_title'], ENT_QUOTES)) : '';
		$category =  isset( $_POST['cat'] ) ? (int)$_POST['cat'] : 0;
		$content = isset( $_POST['tougao_content'] ) ? $_POST['tougao_content'] : '';
		// 表单项数据验证
		if ( empty($name) || mb_strlen($name) > 20 ){
			wp_die('昵称必须填写，且长度不得超过20字');
		}  
		if ( empty($email) || strlen($email) > 60 || !preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $email)){
			wp_die('Email必须填写，且长度不得超过60字，必须符合Email格式');
		}   
		if ( empty($title) || mb_strlen($title) > 100 ){
			wp_die('标题必须填写，且长度不得超过100字');
		}
		if ( empty($content) || mb_strlen($content) > 3000 || mb_strlen($content) < 100){
			wp_die('内容必须填写，且长度不得超过3000字，不得少于100字');
		}   
		$post_content = $content.'<br />昵称: '.$name.'<br />Email: '.$email.'<br />blog: '.$blog; 
		$tougao = array(
			'post_title' => $title,
			'post_content' => $post_content,
			'post_category' => array($category)
		);
		// 将文章插入数据库
		$status = wp_insert_post( $tougao ); 
		if ($status != 0){ 
			// 投稿成功给博主发送邮件
			// somebody#example.com替换博主邮箱
			// My subject替换为邮件标题，content替换为邮件内容
			wp_mail("somebody#example.com","My subject","content");
			wp_die('投稿成功！感谢投稿！<a href="'.get_permalink( $status ).'">点此查看发布的文章</a>', '投稿成功');
		} else {
			wp_die('投稿失败！');
		}
	}
?>
<?php get_header(); ?>
<!--#single main start-->	
<div id="container">

    	<div class="content">
			<div id="mainbox">
			<?php include(TEMPLATEPATH . '/toolbar.php'); ?>
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				<div class="post-content" id="post-<?php the_ID(); ?>" >
					<h1><?php the_title(); ?></h1>		
					<div class="content-c">									
						<?php the_content(); ?>
						<!-- 关于表单样式，请自行调整-->
						<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
							<div class="contribute">
								<label for="tougao_title">文章标题[必填]:(不超过100字)</label>
								<input type="text" size="40" value="" id="tougao_title" name="tougao_title" />
								<label for="tougaocategorg">分类[必填]:</label>
								<?php wp_dropdown_categories('id=tougaocategorg&hierarchical=1'); ?>
								<label style="vertical-align:top" for="tougao_content">文章内容[必填]:(不少于100字,不多于3000字)</label>
								<textarea id="tougao_content" name="tougao_content" style="width:670px;height:300px;"></textarea>
								<label for="tougao_authorname">昵称[必填]:</label>
								<input type="text" size="40" value="" id="tougao_authorname" name="tougao_authorname" />
								<label for="tougao_authoremail">E-Mail[必填]:</label>
								<input type="text" size="40" value="" id="tougao_authoremail" name="tougao_authoremail" />
								<label for="tougao_authorblog">您的博客或微博[选填]:</label>
								<input type="text" size="40" value="" id="tougao_authorblog" name="tougao_authorblog" />
								<br clear="all">
								<div class="submit">
									<input type="hidden" value="send" name="tougao_form" />
									<input type="submit" value="提交" />
									<input type="reset" value="重填" />
								</div>
							</div>  
						</form>
					</div>			
				<?php setPostViews(get_the_ID());?>	<!-- postviews not plugin -->
				
			<?php endwhile; endif; wp_reset_query();?>
			</div>	 
					
		</div>
		<?php get_sidebar(); ?>
		
	</div>
	
	
</div>
<!-- #single main end-->
<script charset="utf-8" src="<?php bloginfo('template_url'); ?>/editor/kindeditor.js"></script>
<script charset="utf-8" src="<?php bloginfo('template_url'); ?>/editor/lang/zh_CN.js"></script>
<script>
	var editor;
		KindEditor.ready(function(K) {
			editor = K.create('textarea[name="tougao_content"]', {
				resizeType : 1,
				allowPreviewEmoticons : false,
				allowImageUpload : false,
				items : [
					'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline',
					'removeformat', '|', 'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist',
					'insertunorderedlist', '|', 'emoticons', 'image', 'link']
			});
		});
</script>	

<?php get_footer(); ?>