<?php
/**
 *
 * 数据表 buddy_follow_group 相关操作类
 *
 *
 * This is NOT a freeware, use is subject to license terms
 *
 * @copyright Copyright (C) 2005 - 2099 Cenwor Inc.
 * @license http://www.cenwor.com
 * @link http://www.jishigou.net
 * @author 狐狸<foxis@qq.com>
 * @version $Id$
 */

if(!defined('IN_JISHIGOU')) {
	exit('invalid request');
}

class table_buddy_follow_group extends table {
	
	
	var $table = 'buddy_follow_group';
	
	function table_buddy_follow_group() {
		$this->init($this->table);
	}
	
	
	function row($name, $uid) {
		$rets = array();
		$name = jfilter($name, 'trim');
		$uid = jfilter($uid, 'int');
		if($uid > 0 && $name) {
			$p = array(
				'uid' => $uid,
				'name' => $name,
			);
			$rets = $this->info($p);
		}
		return $rets;
	}

	
	function add($name, $uid = MEMBER_ID) {
		$uid = jfilter($uid, 'int');
		if($uid < 1) {
			return jerror('UID不能为空');
		}
		
		$name = jfilter($name, 'txt');
		if(($c_rets = $this->_check($name, $uid))) {
			return $c_rets;
		}
		
		$p = array(
			'uid' => $uid,
			'name' => $name,
			'dateline' => TIMESTAMP,
		);
		$id = $this->insert($p, true);
		
		$this->_rm_my_cache($uid);
		
		return $id;
	}
	
	
	function modify($p) {
		$ret = false;
		$id = jfilter($p['id'], 'int');
		if($id < 1) {
			return jerror('分组ID不能为空');
		}		
		$info = $this->info($id);
		if(!$info) {
			return jerror('请指定一个正确的分组ID');
		}
		if(MEMBER_ID != $info['uid'] && 'admin' != MEMBER_ROLE_TYPE) {
			return jerror('您没有权限修改该分组信息');
		}
		
		$ps = array();
		if(isset($p['name']) && $p['name'] != $info['name']) {
			$p['name'] = jfilter($p['name'], 'txt');
			if(($c_rets = $this->_check($p['name'], $info['uid']))) {
				return $c_rets;
			}
			$ps['name'] = $p['name'];
		}
		if(isset($p['order']) && $p['order'] != $info['order']) {
			$ps['order'] = jfilter($p['order'], 'int');
		}
		if(isset($p['count']) && $p['count'] != $info['count']) {
			$ps['count'] = jfilter($p['count'], 'int');
		}
		if($ps && false != ($this->update($ps, $id))) {
			$ret = true;
		}
		$this->_rm_my_cache($info['uid']);
		return $ret;
	}
	
	
	function del($id) {
		$id = jfilter($id, 'int');
		if($id < 1) {
			return jerror('分组ID不能为空');
		}		
		$info = $this->info($id);
		if(!$info) {
			return jerror('请指定一个正确的分组ID');
		}
		if(MEMBER_ID != $info['uid'] && 'admin' != MEMBER_ROLE_TYPE) {
			return jerror('您没有权限删除该分组信息');
		}
		jtable('buddy_follow_group_relation')->del_multi($uid, 0, $id);
		
		$this->_rm_my_cache($info['uid']);

		return $this->delete($id, 1);
	}
	
	
	function get_my_group($uid, $limit = 0) {
		$list = array();
		$uid = jfilter($uid, 'int');
		if($uid > 0) {		
			if($limit < 1) {
				$cache_key = $this->table . '-get_my_group-' . $uid;
				$cache_time = 300;
				if(false !== ($list = cache_db('mget', $cache_key))) {
					return $list;
				}
			}
			$limit = jfilter($limit, 'int');
			$p = array(
				'uid' => $uid,
				'sql_order' => '`count` DESC, `order` ASC, `id` ASC',
				'result_count' => ($limit > 0 ? $limit : 999)
			);
			$rets = $this->get($p);
			$list = array();
			if($rets['list']) {
				foreach($rets['list'] as $row) {
					$list[$row['id']] = $row;
				}
			}
			if($cache_time) {
				cache_db('mset', $cache_key, $list, $cache_time);
			}
		}
		return $list;
	}
	
	
	function get_group_list($gids, $my_group_list) {
		if(empty($gids) || empty($my_group_list)) {
			return false;
		}
		if(is_numeric($my_group_list)) {
			$my_group_list = $this->get_my_group($my_group_list);
		}
		$list = array();
		if($my_group_list && is_array($my_group_list)) {
			$ids = array();
			if(is_numeric($gids)) {
				$ids = array($gids);
			} elseif (is_string($gids)) {
				$ids = explode(',', $gids);
			} elseif (is_array($gids)) {
				$ids = $gids;
			}
			foreach($ids as $id) {
				if(($row = $my_group_list[$id])) {
					$list[$id] = $row;
				}
			}
		}
		return $list;
	}
	
	
	function _check($name, $uid = 0) {
		if(empty($name)) {
			return jerror('分组名称不能为空');
		}
		if(strlen($name) > 100) {
			return jerror('分组名称的长度不能超过100个字符');
		}
		if(preg_match('~[\~\`\!\@\#\$\%\^\&\*\(\)\=\+\[\{\]\}\;\:\'\"\,\<\.\>\/\?]~', $name)) {
			return jerror('分组名称不能包含特殊字符');
		}
		$f_rets = filter($name);
		if($f_rets && $f_rets['error']) {
			return jerror($f_rets['msg']);
		}
		$uid = jget($uid, 'int');
		if($uid > 0 && ($this->row($name, $uid))) {
			return jerror('分组名称已经存在了');
		}
	}
	
	function _rm_my_cache($uid) {
		cache_db('mrm', $this->table . '-get_my_group-' . $uid);
	}
	
}

?>