<?php
/**
 * [JishiGou] (C)2005 - 2099 Cenwor Inc.
 *
 * This is NOT a freeware, use is subject to license terms
 *
 * @Filename channel.mod.php $
 *
 * @Author http://www.jishigou.net $
 *
 * @Date 2013-05-21 17:04:54 1680421756 1726759803 8023 $
 */




if(!defined('IN_JISHIGOU'))
{
    exit('invalid request');
}

class ModuleObject extends MasterObject
{
	var $TopicLogic;
	function ModuleObject($config)
	{
		$this->MasterObject($config);
		Load::logic('channel');
		$this->ChannelLogic = new ChannelLogic($this);
		$this->Execute();
	}

	
	function Execute()
	{
		ob_start();
		switch($this->Code)
		{
			case 'docategory':
				$this->docategory();
				break;
			case 'delcat':
				$this->delcat();
				break;
			case 'edit':
				$this->edit();
				break;
			case 'doedit':
				$this->doedit();
				break;
			case 'move':
				$this->move();
				break;
			case 'domove':
				$this->domove();
				break;
			case 'config':
				$this->set();
				break;
			case 'doset':
				$this->doset();
				break;
			case 'updata':
				$this->updata();
				break;
			case 'index':
			default:
				$this->category();
				break;
		}
		$body = ob_get_clean();

		$this->ShowBody($body);

	}

	
	function updata()
	{
		$this->ChannelLogic->update_data();
		$this->Messager('操作成功了','admin.php?mod=channel');
	}

	
	function set()
	{
		$action = 'admin.php?mod=channel&code=doset';
		$c_l = $this->Config['channel_list'] == 'pic' ? 'pic' : 'txt';
		Load::lib('form');
        $FormHandler = new FormHandler();
		$channel_enable_html = $FormHandler->YesNoRadio('channel[enable]',(int)($this->Config['channel_enable']));
		$channel_must_html = $FormHandler->YesNoRadio('channel[must]',(int)($this->Config['channel_must']));
		include(template('admin/channel_info'));
	}

	function doset()
	{
		$channel = $this->Post['channel'];
		$config = array();
		$config['channel_enable'] = $channel['enable'] ? 1 : 0;
		$config['channel_must'] = $channel['must'] ? 1 : 0;
		ConfigHandler::update($config);
		$this->Messager("修改成功");
	}

	

	function move()
	{
		$ch_id = jget('id','int','G');
		$channel_info = $this->ChannelLogic->id2category($ch_id);
		if(!$channel_info) {
			$this->Messager("您要移动的频道不存在!");
		}
		$have_child = $this->ChannelLogic->have_child($ch_id);
		if($have_child) {
			$this->Messager("您要移动的频道存在子频道，请先移动子频道!");
		}
		$action = 'admin.php?mod=channel&code=domove';
		$channels = $this->ChannelLogic->get_select_channel();
		include template('admin/channel_move');
	}

	function domove()
	{
		$ch_id = jget('id','int','P');
		$item_id = jget('item_id','int','P');
		$cutc = jget('cutc','int','P');
		$return = $this->ChannelLogic->move_channel($ch_id,$item_id,$cutc);
		if($return){
			$this->Messager('操作成功了','admin.php?mod=channel');
		}else{
			$this->Messager('操作失败，没有选择目标频道','admin.php?mod=channel');
		}
	}

	
	function edit()
	{
		$ch_id = jget('id','int','G');
		$channel_info = $this->ChannelLogic->id2category($ch_id);
		if(!$channel_info) {
			$this->Messager("您要编辑的频道信息不存在!");
		}
		$action = 'admin.php?mod=channel&code=doedit';
		$FormHandler = jlib('form');
		$role_list = array();
		$query = DB::query("select `name`, `id` as `value` from ".DB::table('role')." where `id`!='1' order by `type` desc, `id` asc");
		$v = 0;
		while (false != ($row = DB::fetch($query))) {
			$v = $row['value'];
			$role_list[$v] = $row;
		}
		$radiohtml = $FormHandler->YesNoRadio('verify',$channel_info['verify']);
		$purviewhtml = $FormHandler->CheckBox('purview[]', $role_list, explode(',',$channel_info['purview']));
		$selecthtml = $this->ChannelLogic->get_catselect($channel_info['parent_id']);
		$filterhtml = $FormHandler->CheckBox('filter[]', $role_list, explode(',',$channel_info['filter']));
		$list_html = $FormHandler->Radio('display_list[]',array(array("name"=>"列表","value"=>"txt"),array("name"=>"瀑布流","value"=>"pic")),$channel_info['display_list']);
		$view_html = $FormHandler->Radio('display_view[]',array(array("name"=>"最新发布","value"=>"post"),array("name"=>"最新被赞","value"=>"dig"),array("name"=>"最新回应","value"=>"mark"),array("name"=>"近期热赞","value"=>"ldig"),array("name"=>"推荐置顶","value"=>"top")),$channel_info['display_view']);
		include template('admin/channel_info');
	}

	function doedit()
	{
		$ch_id = jget('id','int','P');
		$channel_info = $this->ChannelLogic->id2category($ch_id);
		if(!$channel_info) {
			$this->Messager("您要编辑的频道信息不存在!");
		}
		$set_ary = array(
			'ch_name' => jget('ch_name'),
			'parent_id' => jget('parent_id','int','P'),
			'display_order' => jget('display_order','int','P'),
			'description' => cutstr(jget('description'),120),
			'purview' => is_array($this->Post['purview']) ? implode(',',$this->Post['purview']) : '',
			'verify' => jget('verify','int'),
			'filter' => (jget('verify','int')==0) ? '' : (is_array($this->Post['filter']) ? implode(',',$this->Post['filter']) : ''),
			'display_list' => ($this->Post['display_list'][0]== 'pic') ? 'pic' : 'txt',
			'display_view' => in_array($this->Post['display_view'][0],array('post','dig','mark','ldig','top')) ? $this->Post['display_view'][0] : 'post',
		);
		DB::update('channel', $set_ary, array('ch_id' => $ch_id));
		if(!empty($_FILES['image']['name'])){
						$this->ChannelLogic->upload_pic($ch_id);
		}
				$this->ChannelLogic->update_category_cache();
		$this->Messager('操作成功了','admin.php?mod=channel');
	}

	
	function category()
	{
				$tree = $this->ChannelLogic->get_category_tree();
		include template('admin/channel');
	}

	function docategory()
	{
				$cat_ary = &$this->Post['cat'];
		if (!empty($cat_ary)) {
			$cat_order_ary = &$this->Post['cat_order'];
			foreach ($cat_ary as $key => $cat) {
				$ch_name = getstr($cat, 30, 1, 1);
								$display_order = intval($cat_order_ary[$key]);
				$this->ChannelLogic->update_category($key, $ch_name, $display_order);
			}
		}

				$tcat_ary = &$this->Post['new_tcat'];
		if (!empty($tcat_ary)) {
			$tcat_order_ary = &$this->Post['new_tcat_order'];
			$this->_batch_add_category($tcat_ary, $tcat_order_ary);
		}

				$scat_ary = &$this->Post['new_scat'];
		if (!empty($scat_ary)) {
			$scat_order = &$this->Post['new_scat_order'];
			foreach ($scat_ary as $p => $cats) {
				$this->_batch_add_category($cats, $scat_order[$p], $p);
			}
		}

				$this->ChannelLogic->update_category_cache();
		$this->Messager('操作成功了');
	}

	
	function _batch_add_category($cat_ary, $order_ary, $parent_id = 0)
	{
		foreach ($cat_ary as $key => $cat) {
						$ch_name = getstr($cat, 30, 1, 1);
			if (empty($ch_name) || $this->ChannelLogic->category_exists($ch_name, $parent_id)) {
				continue;
			}
			$display_order = intval($order_ary[$key]);
			$this->ChannelLogic->add_category($ch_name, $display_order, $parent_id);
		}
	}

	
	function delcat()
	{
		$ch_id = empty($this->Get['ch_id']) ? 0 : intval($this->Get['ch_id']);
		if (empty($ch_id)) {
			$this->Messager('没有指定频道ID');
		}

		$ret = $this->ChannelLogic->delete_category($ch_id);

				$this->ChannelLogic->update_category_cache();

		if ($ret == 1) {
			$this->Messager('删除频道成功');
		} else if ($ret == -1) {
			$this->Messager('当前频道不存在');
		} else if ($ret == -2) {
			$this->Messager('当前频道下面存在微博，不能被删除，请先移出该频道下的微博，然后再进行该操作！','',10);
		} else if ($ret == -3) {
			$this->Messager('当前频道存在子频道，不能被删除，请先删除子频道，然后再进行该操作！','',10);
		}
	}
}
?>
