<?php
/**
 *
 * 连续登录错误被限制的IP地址设置及列表模块
 *
 *
 * This is NOT a freeware, use is subject to license terms
 *
 * @copyright Copyright (C) 2005 - 2099 Cenwor Inc.
 * @license http://www.cenwor.com
 * @link http://www.jishigou.net
 * @author 狐狸<foxis@qq.com>
 * @version $Id: failedlogins.mod.php 1095121265 2013-05-21 2364 foxis@qq.com $
 */

if(!defined('IN_JISHIGOU')) {
	exit('invalid request');
}


class ModuleObject extends MasterObject {

	
	function ModuleObject($config) {
		$this->MasterObject($config);

		ob_start();
		
		if($this->Code && method_exists('ModuleObject', $this->Code)) {
			$this->{$this->Code}();
		} else {
			$this->index();
		}
		$this->ShowBody(ob_get_clean());
	}

	function index() {
		$failedlogins = ConfigHandler::get('failedlogins');
		if(!$failedlogins) {
			$failedlogins = array(
				'limit' => 15,
				'time' => 15,
				'white_list' => array(),
			);
			ConfigHandler::set('failedlogins', $failedlogins);
		}
		$failedlogins_white_list = ((is_array($failedlogins['white_list']) && count($failedlogins['white_list'])) ? implode("\n", $failedlogins['white_list']) : '');
		
		
		
		
		$p = array();
		$p['result_count'] = 500;
		$ip = jget('ip');
		if($ip) {
			$p['ip'] = $ip;
		}
		$order = jget('order');
		if($order && in_array($order, array('ip', 'count', 'lastupdate'))) {
			$p['sql_order'] = " `{$order}` DESC ";
		}
		$rets = jtable('failedlogins')->get($p);
		
		
		include template('admin/failedlogins_index');
	}
	
	function modify() {
		$limit = jget('limit', 'int');
		if($limit < 1) {
			$limit = 15;
		}
		$time = jget('time', 'int');
		if($time < 1) {
			$time = 15;
		}
		$white_list = jget('white_list');
		if($white_list) {
			$white_list = explode("\n", $white_list);
			foreach($white_list as $k=>$v) {
				$white_list[$k] = trim($v);
			}
			$white_list = array_remove_empty(array_unique($white_list));
		}
		$failedlogins = array(
			'limit' => $limit,
			'time' => $time,
			'white_list' => $white_list,
		);
		ConfigHandler::set('failedlogins', $failedlogins);
		
		
		$this->Messager('设置成功');
	}
	
	function clean() {
		jtable('failedlogins')->truncate();
		
		
		$this->Messager('已经清空所有被限制登录的IP地址');
	}

}

?>
