<?php
/**
 * 文件名：uploadify.mod.php
 * @version $Id: uploadify.mod.php 3664 2013-05-21 08:01:00Z wuliyong $
 * 作者：狐狸<foxis@qq.com>
 * 功能描述: 测试模块
 */

if(!defined('IN_JISHIGOU'))
{
    exit('invalid request');
}

class ModuleObject extends MasterObject
{
	var $ImageLogic;

	var $Type;


	function ModuleObject($config)
	{
		$this->MasterObject($config);

		$this->ImageLogic = jlogic('image');

		$this->Execute();
	}

	function Execute()
	{
		switch($this->Code)
		{
            case 'searchimage':
                $this->SearchImageByBaiDu();
                break;
            case 'urlimage':
                $this->UrlImage();
                break;
			case 'image':
				$this->Image();
				break;
			case 'delete_image':
				$this->DeleteImage();
				break;

			case 'html':
				$this->Html();
				break;

			default:
				$this->Main();
				break;
		}
	}

	function Main()
	{
		response_text('正在建设中……');

	}

	function Html()
	{
		$tid = max(0, (int) ($this->Post['tid'] ? $this->Post['tid'] : $this->Get['tid']));
		$image_uploadify_topic = array();
		if($tid > 0)
		{

			$TopicLogic = jlogic('topic');

			$image_uploadify_topic = $TopicLogic->Get($tid);
		}


		$from = (get_param('image_uploadify_from') ? get_param('image_uploadify_from') : get_param('from'));
		$image_uploadify_from = '';
		if('topic_publish' == $from)
		{
			$image_uploadify_from = $from;
		}


		$only_js = (get_param('image_uploadify_only_js') ? get_param('image_uploadify_only_js') : get_param('only_js'));
		$image_uploadify_only_js = 0;
		if($only_js)
		{
			$image_uploadify_only_js = 1;
		}


		$topic_uid = max(0, (int) (get_param('image_uploadify_topic_uid') ? get_param('image_uploadify_topic_uid') : get_param('topic_uid')));
		$image_uploadify_topic_uid = 0;
		if($topic_uid)
		{
			$image_uploadify_topic_uid = $image_uploadify_topic['uid'];
		}


		$image_small_size = max(0, (int) (get_param('image_uploadify_image_small_size') ? get_param('image_uploadify_image_small_size') : get_param('image_small_size')));
		$image_uploadify_image_small_size = 45;
		if($image_small_size)
		{
			$image_uploadify_image_small_size = $image_small_size;
		}


		$image_uploadify_new = (get_param('image_uploadify_new') ? get_param('image_uploadify_new') : get_param('new'));

		$image_uploadify_modify = (get_param('image_uploadify_modify') ? get_param('image_uploadify_modify') : get_param('modify'));

		$image_uploadify_type = (get_param('image_uploadify_type') ? get_param('image_uploadify_type') : get_param('type'));

		$content_textarea_id = (get_param('content_textarea_id') ? get_param('content_textarea_id') : get_param('content_id'));

		if(!is_null(get_param('content_textarea_empty_val')))
		{
			$content_textarea_empty_val = get_param('content_textarea_empty_val');
		}



		include(template('image_uploadify.inc'));
	}

	function Image() {
				$this->_init_auth();

		$item = $this->Get['iitem'];
		$itemid = max(0, (int)($this->Get['iitemid']));
		$p = array(
			'item' => $item,
			'itemid' => $itemid,
		);
		$rets = $this->ImageLogic->upload($p);
		if($rets['code']<0 && $rets['error']) {
			$this->_image_error($rets['error']);
		}

				$retval = array(
			'id' => $rets['id'],
			'src' => $rets['src'],
			'name' => $rets['name'],
		);
		$this->_image_result('ok',$retval);
	}

    
    function UrlImage(){
        if(MEMBER_ID < 1){
            $this->_image_error('你无权上传图片。');
        }
        $url = jget('url','url');
        if(!$url){
            $this->_image_error('请上传正确的图片格式。');
        }

		$p = array(
			'pic_url' => $url
		);
		$rets = jlogic('image')->upload($p);
		if($rets['code']<0 && $rets['error']) {
			$this->_image_error($rets['error']);
		}

				$retval = array(
			'id' => $rets['id'],
			'src' => $rets['src'],
			'name' => $rets['name'],
		);
		$this->_image_result('ok',$retval);
    }

    
    function SearchImageByBaiDu() {
    	$word = jget('word');
    	$word = getSafeCode($word);
    	if(!$word) {
    		exit('请输入搜索关键词');
    	}
    	$page = jget('page', 'int');
		$page = (($page > 0 && $page < 30) ? $page : 0);
		$per = jget('per','int');
        $per = (($per > 0 && $per < 30) ? $per : 6);
        if(false === ($data = cache_file('get', ($cache_id = "misc/image/search_by_baidu-".substr(md5($word), -16)."-{$per}-{$page}")))) {
        		        			$word = str_replace(' ', '+', $word);
			$url = "http:/"."/image.baidu.com/i?tn=baiduimagejson&ct=201326592&cl=2&lm=-1&st=-1&fm=result&fr=&sf=1&fmq=1349413075627_R&pv=&ic=0&nc=1&z=&se=1&showtab=0&fb=0&width=&height=&face=0&istype=2&word=$word&rn=$per&pn=" . $page * $per;
			$data = file_get_contents($url);

        	cache_file('set', $cache_id, $data, 86400);
        }
        exit($data);
    }

		function DeleteImage()
	{

		if(MEMBER_ID < 1)
		{
			json_error("请先登录或者注册一个帐号");
		}

		$id = max(0, (int) ($this->Post['id'] ? $this->Post['id'] : $this->Get['id']));
		$topic_image = $this->ImageLogic->get_info($id);
		if(!$topic_image)
		{
			json_error('请指定一个正确的图片ID');
		}

		if($topic_image['uid'] != MEMBER_ID && 'admin' != MEMBER_ROLE_TYPE)
		{
			json_error('您无权删除该图片');
		}


		$ret = $this->ImageLogic->delete($id);
		if(!$ret)
		{
			json_error('删除失败');
		}


		json_result('删除成功');
	}

	function _init_auth()
	{
		$type = ($this->Post['type'] ? $this->Post['type'] : $this->Get['type']);
		$this->Type = $type;

		if('normal' == $type)
		{

		}
		else
		{
			$uid = 0;
			$password = '';
			$members = array();

			$cookie_auth = ($this->Post['cookie_auth'] ? $this->Post['cookie_auth'] : $this->Get['cookie_auth']);

			list($password,$uid) = ($cookie_auth ? explode("\t", authcode(str_replace(' ', '+', $cookie_auth), 'DECODE')) : array('', 0));

			if($uid > 0)
			{
				$members = DB::fetch_first("select `uid`, `username`, `nickname`, `role_type` from ".TABLE_PREFIX."members where `uid`='$uid'");
			}

			if(!$members)
			{
				json_error('auth is invalid');
			}
			else
			{
				$topic_uid = max(0, (int) ($this->Post['topic_uid'] ? $this->Post['topic_uid'] : $this->Get['topic_uid']));
				if($topic_uid > 0 && $topic_uid != $uid && 'admin'==$members['role_type'])
				{
					$members = DB::fetch_first("select `uid`, `username`, `nickname`, `role_type` from ".TABLE_PREFIX."members where `uid`='$topic_uid'");
				}

				define('MEMBER_ID', $members['uid']);
				define('MEMBER_NAME', $members['username']);
				define('MEMBER_NICKNAME', $members['nickname']);
				define('MEMBER_ROLE_TYPE', $members['role_type']);
			}
		}
	}

	function _image_error($msg)
	{
		if('normal' == $this->Type)
		{
						echo "<script type='text/javascript'>window.parent.MessageBox('warning', '{$msg}');</script>";
			exit ;
		}
		else
		{
			json_error($msg);
		}
	}
	function _image_result($msg, $retval=null)
	{
		if('normal' == $this->Type)
		{
			$image_uploadify_id = ($this->Post['image_uploadify_id'] ? $this->Post['image_uploadify_id'] : $this->Get['image_uploadify_id']);

			echo "<script type='text/javascript'>
			window.parent.imageUploadifyComplete{$image_uploadify_id}('{$retval['id']}', '{$retval['src']}', '{$retval['name']}');
			window.parent.imageUploadifyAllComplete{$image_uploadify_id}();
			</script>";
			exit ;
		}
		else
		{
			json_result($msg, $retval);
		}
	}

}

?>
