<?php
/**
 * 文件名：report.mod.php
 * @version $Id: report.mod.php 3664 2013-05-21 08:01:00Z wuliyong $
 * 作者：狐狸<foxis@qq.com>
 * 功能描述: 举报模块
 */

if(!defined('IN_JISHIGOU'))
{
    exit('invalid request');
}

class ModuleObject extends MasterObject
{

	function ModuleObject($config)
	{
		$this->MasterObject($config);

		$this->Execute();
	}

	
	function Execute()
	{
		switch($this->Code)
		{
			case 'do':
				$this->DoReport();
				break;

			default:
				$this->Main();
				break;
		}
	}

	function Main()
	{
		$url = urlencode(getSafeCode(urldecode($this->Get['url'])));

		$report_config = ConfigHandler::get('report');


		include(template('report.inc'));
	}

	function DoReport()
	{
		$url = get_param('url');
		$report_url = get_param('report_url');

		$url = getSafeCode(urldecode(urldecode(($url ? $url : $report_url))));

		$data = array(
			'uid' => MEMBER_ID,
			'username' => MEMBER_NAME,
			'ip' => client_ip(),
			'reason' => (int) get_param('report_reason'),
			'content' => strip_tags(get_param('report_content')),
			'url' => strip_tags(urldecode($url)),
			'dateline' => time(),
		);
		$result = jtaboe('report')->insert($data);


		$this->Messager("举报成功");
	}

}

?>
