<?php
/**
 * 文件名：topic.mod.php
 * @version $Id: topic.mod.php 3664 2013-05-21 08:01:00Z wuliyong $
 * 作者：狐狸<foxis@qq.com>
 * 功能描述: 微博话题模块
 */

if(!defined('IN_JISHIGOU'))
{
	exit('invalid request');
}

class ModuleObject extends MasterObject
{
	var $ShowConfig;

	var $CacheConfig;

	var $TopicLogic;

	var $ID = '';


	function ModuleObject($config)
	{
		$this->MasterObject($config);

		$this->ID = (int) ($this->Post['id'] ? $this->Post['id'] : $this->Get['id']);

		$this->TopicLogic = jlogic('topic');
		$this->ChannelLogic = jlogic('channel');

		$this->CacheConfig = ConfigHandler::get('cache');

		$this->ShowConfig = ConfigHandler::get('show');

		$this->Execute();

	}

	
	function Execute()
	{
		ob_start();
		if('normal' == $this->Code){
			$this->normalIndex();
		}elseif('simple' == $this->Code){
			$this->simpleIndex();
		}elseif('only_login' == $this->Code){
			$this->only_login_index();
		}elseif('channellogin' == $this->Code){
			$this->channelIndex();
		}elseif('fans' == $this->Code) {
			$this->Fans();
		}elseif ('follow' == $this->Code) {
			$this->Follow();
		} elseif ('top' == $this->Code) {
			$this->Top();
		} elseif ('group' == $this->Code) {
			$this->ViewGroup();
		} elseif (in_array($this->Code,array('new','hotforward','newforward','hotreply','newreply','tc'))) {
			$this->Hot();
		} elseif ('view' == $this->Code) {
			$this->View();
		} elseif ('photo' == $this->Code) {
			$this->Photo();
		} elseif (is_numeric($this->Code)) {
			$this->ID = (int) $this->Code;
			$this->View();
		} else {
			$this->Main();
		}
		$body=ob_get_clean();

		$this->ShowBody($body);
	}

	function Main()
	{
				$code_ary = array (
			'myblog',
			'mycomment',
			'tocomment',
			'myhome',
			'myat',
			'myfavorite',
			'favoritemy',
			'tag',
					'qun',
			'recd',
			'other',
			'bbs',
			'cms',
			'department',
			'channel',
			'topicnew',
		);
		if(!in_array($this->Code,$code_ary)){
			unset($this->Code);
		}
		$FormHandler = jlib('form');
		$channel_enable = ConfigHandler::get('channel') ? true : false;
		$content_dstr = $this->Config['in_publish_notice_str'];
		$content_ostr = $this->Config['on_publish_notice_str'];
				if ('topic'==trim($this->Get['mod']) && empty($this->Code) && empty($this->Get['mod_original'])) {
						if (MEMBER_ID > 0) {
				$this->Code = 'myhome';
			} else {
				$this->Messager('请<a onclick="ShowLoginDialog();return false;" title="快捷登录" rel="nofollow" href="index.php?mod=login" class="r_loginbtn">点此登录</a>，
					或<a href="index.php?mod=member">点此注册</a>一个帐号', null);
				return ;
			}
		}

				$member = $this->_member();
		if(!$member) {
			$this->Messager('请<a onclick="ShowLoginDialog();return false;" title="快捷登录" rel="nofollow" href="index.php?mod=login" class="r_loginbtn">点此登录</a>，
					或<a href="index.php?mod=member">点此注册</a>一个帐号', null);
			return false;
		}

		$title = '';
				$per_page_num = 20;
		$topic_uids = $topic_ids = $order_list = $where_list = $params = array();
		$where = $order = $limit = "";
		$cache_time = 0;
		$cache_key = '';

				$options = array();
		$gets = array(
			'mod' => ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module),
			'code' => $this->Code,
			'type' => $this->Get['type'],
			'gid' => $this->Get['gid'],
			'qid' => $this->Get['qid'],
			'chid' => $this->Get['chid'],
			'view' => $this->Get['view'],
			'filter' => $this->Get['filter'],
			'orderby' => $this->Get['orderby'],
		);
		$options['page_url'] = "index.php?".url_implode($gets);
		unset($gets['type']);
		$type_url = "index.php?".url_implode($gets);

		$params['uid'] = $uid = $member['uid'];

				$is_personal = ($uid == MEMBER_ID);
		$params['is_personal'] = $is_personal;

		$params['code'] = $this->Code;

		if (!in_array($params['code'], $code_ary)) {
						$params['code'] = 'myblog';
		}

				$page_str = $params['code'];
		if($params['code'] == 'bbs' || $params['code'] == 'cms') {
			$page_str = 'myhome'; 		}
		if (($show_topic_num = (int) $this->ShowConfig['topic'][$page_str]) > 0) {
			$per_page_num = $show_topic_num;
		}

		$options['perpage'] = $per_page_num;

				$groupname = '';
		$groupid = 0;

		$TopicListLogic = jlogic('topic_list');

		#if NEDU
		if (defined('NEDU_MOYO'))
		{
			nui('jsg')->cindex($this, $params, $topic_list_get);
		}
		#endif

		
		$sendMail = false;
		$checkUser = false;
		if($this->Config['sendmailday'] > 0) {
			if(!jsg_getcookie('mail_cookie')) {
				jsg_setcookie('mail_cookie', TIMESTAMP, 300);
				$sendMail = true;
			}
			if(!jsg_getcookie('check_user')) {
				jsg_setcookie('check_user', TIMESTAMP, 86400);
				$checkUser = true;
			}
		}

				$tpl = 'topic_index';
		if ('myhome'==$params['code']) {
			$tpl = 'topic_myhome';
			
			$topic_selected = 'myhome';

						$type = get_param('type');
			if($type && !in_array($type, array('pic', 'video', 'music', 'vote', 'event', ))) {
				$type = '';
			}
			if($type) {
				$params['type'] = $type;
			}

						$gid = max(0, (int) get_param('gid'));
			if($gid) {
				$params['gid'] = $gid;
			}

						$topic_myhome_time_limit = 0;
			if($this->Config['topic_myhome_time_limit'] > 0) {
				$topic_myhome_time_limit = (TIMESTAMP - ($this->Config['topic_myhome_time_limit'] * 86400));
				if ($topic_myhome_time_limit > 0) {
					$options['dateline'] = $topic_myhome_time_limit;
				}
			}

						$options['uid'] = array($member['uid']);
			if ($member['uid'] == MEMBER_ID) {
				$cache_time = 600;
				$cache_key = "{$member['uid']}-topic-myhome-{$type}-{$gid}";
				$title = '我的首页';
				
								$refresh_time = max(30, (int) $this->Config['ajax_topic_time']);
				if(get_param('page') < 2 && ($member['lastactivity'] + $refresh_time < TIMESTAMP)) {
					$new_topic = jmodel('buddy')->check_new_topic($uid, 1);
					if($new_topic > 0) {
						cache_db('rm', "{$uid}-topic-%", 1);
					}
				}

								if ($gid) {
					$group_info = jtable('buddy_follow_group')->info($gid);
					if (empty($group_info) || MEMBER_ID != $group_info['uid']) {
						$this->Messager("当前分组不存在", 'index.php?mod=myhome');
					}
					$query_link = "index.php?mod=" . ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module) . ($this->Code ? "&code={$this->Code}&type={$this->Get['type']}&gid={$this->Get['gid']}" : "");
					if($group_info['count'] > 0) {
						$g_view_uids = jtable('buddy_follow_group_relation')->get_my_group_uids(MEMBER_ID, $gid);
					}
					$groupid = $gid;
					$groupname = $group_info['name'];

										if($g_view_uids) {
						$options['uid'] = $g_view_uids;
					} else {
						$this->Messager("没有设置用户，无法查看这个组的微博",'index.php?mod=topic&code=group&gid='.$gid);
					}
					$active[$gid] = "current";
				} else {
					if($type || false === (cache_db('get', $cache_key))) {
						$buddyids = get_buddyids($params['uid'], $this->Config['topic_myhome_time_limit']);
						if($buddyids) {
							$options['uid'] = array_merge($options['uid'], $buddyids);
						}
					}

					$active['all'] = "current";
				}
			} else {
				$title = "{$member['nickname']}的微博";
				$this->_initTheme($member);
			}

						if($type) {
				$getTypeTidReturn = $TopicListLogic->GetTypeTid($type,$options['uid'],$options);
				$options['tid'] = $getTypeTidReturn['tid'];
				$options['count'] = $getTypeTidReturn['count'];
				$options['limit'] = $per_page_num;
			}

		} else if ('channel' == $params['code'] && $this->Channel_enable && $this->Config['channel_enable']) {
			$title = '我的频道微博';
			if ($member['uid'] != MEMBER_ID) {
				$this->Messager("您无权查看该页面",null);
			}
						jtable('members')->clean_new_remind('channel_new', MEMBER_ID);

			$orderby = in_array($this->Get['orderby'],array('post','dig','mark','ldig','top')) ? $this->Get['orderby'] : 'dig';
			$ChannelLogic = jlogic('channel');
			$my_buddy_channel = $ChannelLogic->mychannel();
			$cachefile = ConfigHandler::get('channel');
			$channel_channels = $cachefile['channels'];
			$channel_ids = array();
			if(empty($my_buddy_channel)){
				$channel_ids = array(0);
			}else{
				$my_chs = array_keys($my_buddy_channel);
				foreach($my_chs as $val){
					$channel_ids = array_merge($channel_ids,(array) $channel_channels[$val]);
				}
				if(is_array($channel_ids)) {
					$channel_ids = array_unique($channel_ids);
				}
			}
			$options['item'] = 'channel';
			$options['item_id'] = $channel_ids;
			if($orderby == 'mark'){
				$order = ' lastupdate DESC';
			}elseif($orderby == 'dig'){
				$order = ' lastdigtime DESC';
			}elseif($orderby == 'ldig'){
				$order = ' digcounts DESC,lastdigtime DESC';
			}else{
				$order = ' dateline DESC';
			}
			$options['order'] = $order;
			if($orderby == 'top'){
				$where = $channel_ids ? "tr.item = 'channel' AND tr.item_id IN(".implode(",",$channel_ids).")" : "tr.item = 'channel'";
				$options = array('where'=>$where,'perpage'=>$per_page_num);
				$info = $TopicListLogic->get_recd_list($options);
				if (!empty($info)) {
					$total_record = $info['count'];
					$topic_list = $info['list'];
					$page_arr = $info['page'];
					}
				$topic_list_get = true;
			}
		}  else if('department' == $params['code']) {
			$tpl = 'topic_department';
			$title = ($this->Config['default_department'] ? $this->Config['default_department'] : '部门').'微博';
			if ($member['uid'] != MEMBER_ID) {
				$this->Messager("您无权查看该页面",null);
			}
			if (!$this->Config['department_enable']){
				$this->Messager("网站没有开启该功能",null);
			}
			$views = array('all', 'my', 'other');
			$view = trim($this->Get['view']);
			if (!in_array($view, $views)) {
				$view = 'other';
			}
			$active[$view] = 'current';
			$dids = array();
			if($member['departmentid']>0){ 				if($view == 'my'){
					$dids[] = $member['departmentid'];
				}else{
					$sql = "select did	from `".TABLE_PREFIX."buddy_department` where `uid`='".MEMBER_ID."'";
					$query = $this->DatabaseHandler->Query($sql);
					while (false != ($row = $query->GetRow())) {
						$dids[] = $row['did'];
					}
					if($view == 'all'){
						$dids[] = $member['departmentid'];
					}
				}
			}
			if($dids){
								$sql = "select `uid` from `".TABLE_PREFIX."members` where  `departmentid` in(".jimplode($dids).")";
				$query = $this->DatabaseHandler->Query($sql);
				$options['uid'] = array();
				while (false != ($row = $query->GetRow())) {
					$options['uid'][] = $row['uid'];
				}
								if(false != ($type = $this->Get['type']) && 'all' != $type){
					$options['tid'] = $TopicListLogic->GetTypeTid($type,$options['uid']);
				}
			}else{
				$options['tid'] = array();
			}
			if($member['departmentid']){
				$department = DB::fetch_first("SELECT * FROM ".DB::table('department')." WHERE id='".$member['departmentid']."'");
			}
			$user_lp = $this->TopicLogic->GetMember(array($department['leaderid'],$department['managerid']), "`uid`,`ucuid`,`username`,`nickname`,`face`,`face_url`,`validate`,`validate_category`,`aboutme`");
			$mybuddys = (array) get_buddyids(MEMBER_ID);
						$user_l = $user_lp[$department['leaderid']];
			if($user_l){
				$user_l['here_name'] = $department['leadername'];
				$user_l['follow_html'] = follow_html2($department['leaderid'],in_array($department['leaderid'],$mybuddys));
				$leader_list[] = $user_l;
			}
						$user_m = $user_lp[$department['managerid']];
			if($user_m){
				$user_m['here_name'] = $department['managername'];
				$user_m['follow_html'] = follow_html2($department['managerid'],in_array($department['managerid'],$mybuddys));
				$manager_list[] = $user_m;
			}
						$CpLogic = jlogic('cp');
			$department_list = $CpLogic->Getdepartment($member['companyid'],$member['departmentid']);

		}  else if('tag' == $params['code']) {

			$tpl = 'topic_tag';
			
			$title = '我关注的话题';
			if ($member['uid'] != MEMBER_ID) {
				$this->Messager("您无权查看该页面",null);
			}

			$views = array('new', 'new_reply', 'my_reply', 'recd');
			$view = trim($this->Get['view']);
			if (!in_array($view, $views)) {
				$view = 'new';
			}
			$active[$view] = 'current';

			$tag_ids = jmodel('tag_favorite')->my_favorite_tag_ids(MEMBER_ID);
			if($tag_ids) {
				if('new' == $view) {
										$p = $options;
					$p['tag_id'] = $tag_ids;
					$p['sql_order'] = ' `item_id` DESC ';
					$rets = jtable('topic_tag')->get_ids($p, 'item_id', 1);
					$topic_list_get = true;
					$total_record = $rets['count'];
					$page_arr = $rets['page'];
					$topic_list = (($total_record > 0 && $rets['ids']) ? $this->TopicLogic->Get($rets['ids']) : array());
				} else {
										$sql = "select `item_id` from `".TABLE_PREFIX."topic_tag` where  `tag_id` in('".implode("','",$tag_ids)."') ORDER BY `item_id` DESC LIMIT 2000 ";
					$query = $this->DatabaseHandler->Query($sql);
					$topic_ids = array();
					while (false != ($row = $query->GetRow())) {
						$topic_ids[$row['item_id']] = $row['item_id'];
					}
					$options['tid'] = $topic_ids;
					unset($topic_ids);
				}

								if ($this->Get['type']) {
					$options['filter'] = $this->Get['type'];
				}

				if ($view == 'new_reply') {
					$options['where'] = " replys>0 ";
					$options['order'] = " lastupdate DESC ";
				} else if ($view == 'recd') {

					$p = array(
						'where' => " tr.recd >= 1 AND tr.item='tag' AND tr.item_id IN(".jimplode($tag_ids).") ",
						'perpage' => 10,
						'filter' => $this->Get['type'],
					);
					$info = $TopicListLogic->get_recd_list($p);
					if (!empty($info)) {
						$total_record = $info['count'];
						$topic_list = $info['list'];
						$page_arr = $info['page'];
					}
					$topic_list_get = true;
				}
			}else{
				$topic_list_get = true;
			}

						if($GLOBALS['_J']['member']['topic_new']) {
				jtable('members')->clean_new_remind('topic_new', MEMBER_ID);
			}

		} else if ('mycomment' == $params['code']) {
			$tpl = 'topic_mycomment';
			

			$title = '评论我的';
			if ($member['uid']!=MEMBER_ID || $member['uid'] < 1) {
				$this->Messager("您无权查看该页面",null);
			}

						if ($member['comment_new']) {
				jtable('members')->clean_new_remind('comment_new', $member['uid']);
			}

			$topic_selected = 'mycomment';
						$_rets = jtable('member_relation')->get_tids($member['uid'], array('perpage'=>$per_page_num), 1);
						
			if($_rets) {
				$topic_list = $this->TopicLogic->Get($_rets['ids']);
				$total_record = $_rets['count'];
				$page_arr = $_rets['page'];
				unset($_rets);
			}
			$topic_list_get = true;

		} else if ('tocomment' == $params['code']) {
						

			$title = '我评论的';

			if($member['uid']!=MEMBER_ID) {
				$this->Messager("您无权查看该页面",null);
			}

			$topic_selected = 'mycomment';
			$options['where'] = "`uid` = '{$member['uid']}' and `type` in ('both','reply')";

		} else if ('myblog' == $params['code']) {
                        $this->myblog_no_recommend = TRUE;
			$tpl = 'topic_myblog';
			
			$where = " 1 ";
						$options['uid'] = array($member['uid']);

						if ($this->Get['type']) {
								if ('profile' == $this->Get['type']) {
                    $title = $member['gender_ta'].'的资料';
					$type = 'profile';
					#用户填写的自定义添加项
					$member_profile = jlogic('member')->getMemberProfileInfo($member['uid']);
					if($member_profile){
						$member = array_merge($member,$member_profile);
					}
					#用户自定义添加项的可见度
					$memberProfileSet = jlogic('member')->getMemberProfileSet($member['uid']);
                                        $member_info = $member;
                    if($member_info['gender']){
                        if($member_info['gender'] == 1){
                            $member_info['gender'] = '男';
                        }elseif($member_info['gender'] == 2){
                            $member_info['gender'] = '女';
                        }
                    }
                                        if($member_info['bday']){
                        $bdayInt = strtotime($member_info['bday']);
                        if(!$bdayInt){
                            unset($member_info['bday']);
                        }
                    }
                    $member_info = array_filter($member_info);

					$groupProfile = ConfigHandler::get('groupprofile');
                                        foreach($groupProfile as $key_p=>$group_p){
                        $keys_p = array_keys($group_p['list']);
                        foreach($keys_p as $key_one){
                            if($member_info[$key_one]){
                                $groupProfile[$key_p]['isProfile'] = true;
                            }
                            continue;
                        }
                    }


				}
                                if('mycomment' == $this->Get['type']){
                    $title = '评论'.$member['gender_ta'].'的';
                    if ($member['uid'] < 1) {
                        $this->Messager("您无权查看该页面",null);
                    }

                                        if ($member['comment_new']) {
                        jtable('members')->clean_new_remind('comment_new', $member['uid']);
                    }

                    $topic_selected = 'mycomment';
                                        $_rets = jtable('member_relation')->get_tids($member['uid'], array('perpage'=>$per_page_num), 1);
                                        
                    if($_rets) {
                        $topic_list = $this->TopicLogic->Get($_rets['ids']);
                        $total_record = $_rets['count'];
                        $page_arr = $_rets['page'];
                        unset($_rets);
                    }
                    $topic_list_get = true;
                }
                                if('tocomment' == $this->Get['type']){
                    $tpl = 'topic_myblog';
                    $title = $member['gender_ta'].'评论的';
                    $topic_selected = 'mycomment';
                    unset($options['uid']);
                    $options['where'] = "`uid` = '{$member['uid']}' and `type` in ('both','reply')";
                }

								if('vote' == $this->Get['type']){
					$type = 'vote';
					$tpl = 'topic_vote';
					$perpage = $this->ShowConfig['vote']['list'];
					$perpage = empty($perpage) ? 20 : $perpage;
					$vote_where = ' 1 ';
										$filter = get_param('filter');
					if ($filter == 'joined') {
												$vids = jlogic('vote')->get_joined($member['uid']);
						if (!empty($vids)) {
							$vote_where .= " AND `v`.`vid` IN(".jimplode($vids).") ";
						} else {
							$vote_where = ' 0 ';
						}
					} else if ($filter == 'new_update') {
												jtable('members')->clean_new_remind('vote_new', $uid);

						$vids = jlogic('vote')->get_joined($uid);
						if (!empty($vids)) {
							$vote_where .= " AND `v`.`vid` IN(".jimplode($vids).") ";
						}
						$vote_where .= " OR `v`.`uid`='{$uid}' ";
					}  else {
						$vote_where .= " AND `v`.`uid`='{$uid}' ";
						$filter = 'created';
					}
					$vote_order_sql = ' ORDER BY lastvote DESC ';
					$vote_where .=" AND v.verify = 1";
					$param = array(
						'where' => $vote_where,
						'order' => $vote_order_sql,
						'page' => true,
						'perpage' => $perpage,
						'page_url' => $options['page_url'],
					);
					$vote_info = jlogic('vote')->find($param);
					$count = 0;
					$vote_list = array();
					$page_arr['html'] = '';
					$uid_ary = array();
					if (!empty($vote_info)) {
						$count = $vote_info['count'];
						$vote_list = $vote_info['vote_list'];
						$page_arr['html'] = $vote_info['page']['html'];
						$uid_ary = $vote_info['uids'];
					}
										if (!empty($uid_ary)) {
						$members = $this->TopicLogic->GetMember($uid_ary);
					}
					$topic_list_get = true;
				}
								if('event' == $this->Get['type']){
					$type = 'event';
					$tpl = 'topic_event';
					$filter = get_param('filter');
					$param = array('perpage'=>"10",'page'=>true,);
					$return = array();
					if($filter == 'joined'){
						$this->Title = $member['nickname']."参与的活动";
						$param['where'] = " m.play = 1 and m.fid = '$uid' ";
						$param['order'] = " order by a.lasttime desc,a.app_num desc,a.posttime desc ";
						$param['page_url'] = $options['page_url'];
						$return = jlogic('event')->getEvents($param);
										} else if ($filter == 'new_update'){
												jtable('members')->clean_new_remind('event_new', $uid);

						$this->Title = "最近更新的活动";
						$param['uid'] = $uid;
						$param['page_url'] = $options['page_url'];
						$return = jlogic('event')->getNewEvent($param);
										}else{
						$filter = 'created';
						$this->Title = $member['nickname']."的活动";
						$param['where'] = " a.postman = '$uid' and a.verify = 1 ";
						$param['order'] = " order by a.lasttime desc,a.app_num desc,a.posttime desc ";
						$param['page_url'] = $options['page_url'];
						$return = jlogic('event')->getEventInfo($param);
					}
					$rs = $return['event_list'];
					$count = $return['count'];
					$page_arr = $return['page'];
					$topic_list_get = true;
				}

								if ('my_reply' == $this->Get['type']) {
					$title = $member['gender_ta'].'评论的';
					if($member['uid']!=MEMBER_ID) {
						$this->Messager("您无权查看该页面", null);
					}
														}
								if ('mydig' == $this->Get['type']) {
					if ($member['dig_new']) {
						jtable('members')->clean_new_remind('dig_new', $member['uid']);
					}
				}
								if(in_array($this->Get['type'],array('pic','video','music','attach','mydig','mydigout', 'my_reply'))){
					if($this->Get['follow'] && 'my_reply'!=$this->Get['type']) {
						$buddyids = get_buddyids($params['uid'], $this->Config['topic_myhome_time_limit']);

						if($buddyids) {
							$options['uid'] = $buddyids;
						}
					}
					$type = $dtype = $this->Get['type'];
					$options['get_list'] = 1;
					$getTypeTidReturn = $TopicListLogic->GetTypeTid($dtype,$options['uid'],$options);
					if(isset($getTypeTidReturn['list'])) {
						$topic_list = $getTypeTidReturn['list'];
						$total_record = $getTypeTidReturn['count'];
						$page_arr = $getTypeTidReturn['page'];
						$topic_list_get = true;
					} else {
						$options['tid'] = $getTypeTidReturn['tid'];
						$options['count'] = $getTypeTidReturn['count'];
						$options['limit'] = $per_page_num;
						if($type == 'mydigout'){$options['uid']=array();}
						if($type == 'mydig' || $type == 'mydigout'){$options['order'] = ' lastdigtime DESC ';}
					}
				}

                if('forward' == $this->Get['type'] || 'first' == $this->Get['type']){
                    $p = $options;
                    $p['type'] = 'forward';
                    if('first' == $this->Get['type']){
                        $p['type'] = 'first';
                    }
                    $p['sql_order'] = ' `forwards` DESC, `dateline` DESC ';

                    if(!$p['sql_order']) {
                        $p['sql_order'] = ' `dateline` DESC ';
                    }
                    $_rets = jtable('member_topic')->get_tids($member['uid'], $p, 1);
                    $total_record = $_rets['count'];
                    $page_arr = $_rets['page'];
                    $topic_list = $this->TopicLogic->Get($_rets['ids']);
                    $topic_list_get = true;
                }
				if('my_verify' == $this->Get['type']){
					
					$title = '审核中的微博';
					if('admin' != MEMBER_ROLE_TYPE){
						if ($member['uid'] != MEMBER_ID) {
							$this->Messager("您无权查看该页面",-1);
						}
					}

										$sql = "select count(*) as `total_record` from `".TABLE_PREFIX."topic_verify` where managetype = 0";
					$total_record = DB::result_first($sql);

										$page_arr = page($total_record,$per_page_num,$query_link,array('return'=>"Array"));

										$sql = "select v.*
							from `".TABLE_PREFIX."topic_verify` v

							where v.uid='{$uid}'
							and v.managetype = 0
							order by v.lastupdate desc {$page_arr['limit']}";
					$query = $this->DatabaseHandler->Query($sql);
					while (false != ($row = $query->GetRow())) {
						if ($row['id']<1) {
							continue;
						}
						$row['tid'] = $row['id'];
						if($row['longtextid']) {
							$row['content'] = jlogic('longtext')->longtext($row['longtextid']);
							unset($row['content2'], $row['longtextid']);
						}
						$topic_list[$row['id']]= $row;
					}
					$topic_list = $this->TopicLogic->MakeAll($topic_list);
					$topic_list_get = true;
				}
			}

            
                        if($this->Config['channel_enable']){
                $myBuddyChannel = jlogic('channel')->mychannel($member['uid']);
            }
						$dateline = TIMESTAMP - 2592000;
			if(empty($this->Get['type']) || in_array($this->Get['type'], array('hot_reply', 'hot_forward', 'hot_dig'))) {
				$p = $options;
				$p['type'] = array('first', 'forward', 'both');
				if($this->Get['type']) {
					if('hot_reply' == $this->Get['type']) {
						$p['>@replys'] = 0;
						$p['>@dateline'] = $dateline;
						$p['sql_order'] = ' `replys` DESC, `dateline` DESC ';
					} elseif('hot_forward' == $this->Get['type']) {
						$p['>@forwards'] = 0;
						$p['>@dateline'] = $dateline;
						$p['sql_order'] = ' `forwards` DESC, `dateline` DESC ';
					}elseif('hot_dig' == $this->Get['type']) {
						$p['>@digcounts'] = 0;
						$p['>@dateline'] = $dateline;
						$p['sql_order'] = ' `digcounts` DESC, `dateline` DESC ';
					}
				}
				if(!$p['sql_order']) {
					$p['sql_order'] = ' `dateline` DESC ';
				}
				$_rets = jtable('member_topic')->get_tids($member['uid'], $p, 1);
				$total_record = $_rets['count'];
				$page_arr = $_rets['page'];
				$topic_list = $this->TopicLogic->Get($_rets['ids']);
				$topic_list_get = true;
			}

			if ($member['uid'] != MEMBER_ID) {
				$title = "{$member['nickname']}的微博";

								$list_blacklist = is_blacklist($member['uid'], MEMBER_ID);


								$fg_code = 'hisblog';
				$this->_initTheme($member);
			} else {
				$title = '我的微博';
				$this->MetaKeywords ="{$member['nickname']}的微博";
			}
			$buddys = array();

						if (MEMBER_ID > 0 && $member['uid'] != MEMBER_ID) {
				$buddys = jmodel('buddy')->info($member['uid'], MEMBER_ID);
				$buddys['id'] = $buddys['touid'];
			}

		} elseif ('myat' == $params['code']) {
			
			$tpl = 'topic_myat';
			$title = '@提到我的';
						$topic_selected = 'myat';
			if($member['uid'] != MEMBER_ID) {
				$this->Messager("您无权查看该页面",null);
			}

						if ($member['at_new']) {
								jtable('members')->clean_new_remind('at_new', $member['uid']);
			}

			$rets = jtable('topic_mention')->get_ids(array(
				'uid' => $uid,
				'sql_order' => ' `id` DESC ',
				'perpage' => $options['perpage'],
				'page_url' => $options['page_url'],
			), 'tid', 1);
			$total_record = $rets['count'];
			$page_arr = $rets['page'];
			$topic_list = (($total_record > 0 && $rets['ids']) ? $this->TopicLogic->Get($rets['ids']) : array());
			$topic_list_get = true;

		} else if ('myfavorite' == $params['code']) {
			$tpl = 'topic_myfavorite';
			

			$topic_selected = 'myfavorite';
			$title = '我的收藏';
			if ($member['uid'] != MEMBER_ID) {
				$this->Messager("您无权查看该页面",null);
			}

									$total_record = $member['topic_favorite_count'];

						$page_arr = page($total_record,$per_page_num,$query_link,array('return'=>"Array"));

			if($total_record > 0) {
								$sql = "select TF.dateline as favorite_time , T.*
						from `".TABLE_PREFIX."topic_favorite` TF
						left join `".TABLE_PREFIX."topic` T
						on T.tid=TF.tid
						where TF.uid='{$uid}'
						order by TF.id desc {$page_arr['limit']}";
				$query = $this->DatabaseHandler->Query($sql);
				while (false != ($row = $query->GetRow())) {
					if ($row['tid']<1) {
						continue;
					}
					$row['favorite_time'] = my_date_format2($row['favorite_time']);
					$topic_list[$row['tid']] = $row;
				}
				$topic_list = $this->TopicLogic->MakeAll($topic_list);
			}
			$topic_list_get = true;

		} else if ('favoritemy' == $params['code']) {
						

			$topic_selected = 'favoritemy';
			$title = '收藏我的';
			if ($member['uid'] != MEMBER_ID) {
				$this->Messager("您无权查看该页面",null);
			}

						if ($member['favoritemy_new'] > 0) {
				jtable('members')->clean_new_remind('favoritemy_new', $member['uid']);
			}

						$sql = "select count(*) as `total_record` from `".TABLE_PREFIX."topic_favorite` TF where TF.tuid='{$uid}'";
			$total_record = DB::result_first($sql);

						$page_arr = page($total_record,$per_page_num,$query_link,array('return'=>"Array"));

			if($total_record > 0) {
								$sql = "select TF.dateline as favorite_time , TF.uid as fuid , T.*
						from `".TABLE_PREFIX."topic_favorite` TF
						left join `".TABLE_PREFIX."topic` T
						on T.tid=TF.tid
						where TF.tuid='{$uid}'
						order by TF.id desc {$page_arr['limit']}";
				$query = $this->DatabaseHandler->Query($sql);
				$fuids = array();
				while (false != ($row = $query->GetRow())) {
					if ($row['tid']<1) {
						continue;
					}
					$row['favorite_time'] = my_date_format2($row['favorite_time']);
					$topic_list[$row['tid']] = $row;
					$fuids[$row['fuid']] = $row['fuid'];
				}
				$topic_list = $this->TopicLogic->MakeAll($topic_list);
				if($fuids) {
					$favorite_members = $this->TopicLogic->GetMember($fuids,"`uid`,`ucuid`,`username`,`nickname`,`face_url`,`face`,`validate`,`validate_category`");
				}
			}

						$topic_list_get = true;

		} else if ('qun' == $params['code']) {
			$tpl = 'topic_qun';
			$title = "我的".$this->Config[changeword][weiqun];

			$qun_setting = $this->Config['qun_setting'];
			if (!$qun_setting['qun_open']) {
				$this->Messager("当前站点没有开放".$this->Config[changeword][weiqun]."功能", null);
			}
						if(0 != $GLOBALS['_J']['member']['qun_new']) {
				jtable('members')->clean_new_remind('qun_new', MEMBER_ID);
			}

			$views = array('new', 'new_reply', 'my_reply', 'recd');
			$view = trim($this->Get['view']);
			if (!in_array($view, $views)) {
				$view = 'new';
			}
			$active[$view] = "current";

			$u = MEMBER_ID;

						if(false === ($my_qun_ids = cache_db('get', ($cache_id = 'topic/'.$u.'-my_qun_ids')))) {
				$my_qun_ids = jtable('qun_user')->get_ids(array('uid'=>$u), 'qid', 1);
				cache_db('set', $cache_id, $my_qun_ids, 300);
			}
			$qid_ary = $my_qun_ids['ids'];
			$join_qun_count = $my_qun_ids['count'];

			$qun_name = '';
			if (!empty($qid_ary) && $join_qun_count > 0) {
				$where_sql = " 1 ";
				$order_sql = " t.dateline DESC ";
				$jget_type = jget('type', 'txt');
				$jget_type = (in_array($type, array('pic', 'video', 'music', 'vote')) ? $jget_type : '');
				if ($jget_type) {
					if ('pic' == $jget_type){
						$where_sql .= " AND t.`imageid` > 0 ";
					} else if('video' == $jget_type) {
						$where_sql .= " AND t.`videoid` > 0 ";
					} else if('music' == $jget_type) {
						$where_sql .= " AND t.`musicid` > 0 ";
					} else if ('vote' == $jget_type) {
						$where_sql .= " AND t.item='vote' ";
					} else {
						$jget_type = '';
					}
				}

				$topic_get_flg = false;
				if ($view == 'new') {
					if(empty($jget_type)) {
						$p = $options;
						$p['item_id'] = $qid_ary;
						$p['sql_order'] = ' `tid` DESC ';
						$rets = jtable('topic_qun')->get_ids($p, 'tid', 1);
						$total_record = $rets['count'];
						$page_arr = $rets['page'];
						$topic_list = (($total_record > 0 && $rets['ids']) ? $this->TopicLogic->Get($rets['ids']) : array());
						$topic_get_flg = true;
					} else {
						$where_sql .= " AND tq.item_id IN(".jimplode($qid_ary).") ";
					}
				} else if ($view == 'new_reply') {
					$where_sql .= " AND tq.item_id IN(".jimplode($qid_ary).") AND t.replys>0 ";
					$order_sql = " t.lastupdate DESC ";
				} else if ($view == 'recd') {
					$p = array(
						'where' => " tr.recd >= 1 AND tr.item='qun' AND tr.item_id IN(".jimplode($qid_ary).") ",
						'perpage' => $options['perpage'],
						'filter' => $this->Get['type'],
					);
					$info = $TopicListLogic->get_recd_list($p);
					if (!empty($info)) {
						$total_record = $info['count'];
						$topic_list = $info['list'];
						$page_arr = $info['page'];
					}
					$topic_get_flg = true;
				}

				if (!$topic_get_flg) {
					$total_record = DB::result_first("SELECT COUNT(*)
											   FROM ".DB::table('topic')." AS t
											   LEFT JOIN ".DB::table('topic_qun')." AS tq
											   USING(tid)
											   WHERE {$where_sql}");
					if ($total_record > 0) {
												$page_arr = page($total_record, $options['perpage'], $options['page_url'], array('return'=>'array'));
						$query = DB::query("SELECT t.*
											FROM ".DB::table('topic')." AS t
											LEFT JOIN ".DB::table('topic_qun')." AS tq
											USING(tid)
											WHERE {$where_sql}
											ORDER BY {$order_sql}
											{$page_arr['limit']} ");
						$topic_list = array();
						while ($row = DB::fetch($query)) {
							$topic_list[$row['tid']] = $row;
						}
						$topic_list = $this->TopicLogic->MakeAll($topic_list);
					}
				}

								if(0 != $GLOBALS['_J']['member']['qun_new']) {
					jtable('members')->clean_new_remind('qun_new', MEMBER_ID);
				}
			}

						$showConfig = $this->ShowConfig;
			$recd_qun_limit = (int) $showConfig['page_r']['recd_qun'];
						if($recd_qun_limit) {
				$cache_id = 'topic/hot_qun-' . $recd_qun_limit;
				if(false === ($hot_qun = cache_file('get', $cache_id))) {
					$sql = "select * from `".TABLE_PREFIX."qun`  where `recd` = 1 order by `member_num` desc limit $recd_qun_limit  ";

					$query = $this->DatabaseHandler->Query($sql);
					$hot_qun = array();
					$qunLogic = jlogic('qun');
					while (false != ($row = $query->GetRow()))
					{
						$row['icon'] = $qunLogic->qun_avatar($row['qid'], 's');
						$hot_qun[] = $row;
					}
					cache_file('set', $cache_id, $hot_qun, 3600);
				}
			}
			$topic_list_get = true;

		} else if ('recd' == $params['code']) {
			
			$title = "官方推荐";
			$view = trim($this->Get['view']);
			$where_sql = '';
			if ($view == 'new_reply') {
				$where_sql = ' AND t.replys>0 ';
			} else {
				$view = 'all';
			}
			$active[$view] = 'current';

			$p = array(
				'where' => ' tr.recd > 0 '.$where_sql,
				'perpage' => $options['perpage'],
				'filter' => $this->Get['type'],
			);
			$info = $TopicListLogic->get_recd_list($p);
			if (!empty($info)) {
				$total_record = $info['count'];
				$topic_list = $info['list'];
				$page_arr = $info['page'];
			}
			$topic_list_get = true;

		} else if ('cms' == $params['code']) {
			
			$title = "网站资讯";
			$param = array(
				'perpage' => $options['perpage'],
				'page_url' => $options['page_url'],
			);
			$view = 'all';
			$active[$view] = 'current';
			$info = array();
						if($this->Config['dedecms_enable'] && (ConfigHandler::get('dedecms'))){
				Load::logic("topic_cms");
				$TopicCmsLogic = new TopicCmsLogic();
				$info = $TopicCmsLogic->get_cms($param);
				$cms_url = CMS_API_URL;
			}
			if (!empty($info)) {
				$total_record = $info['count'];
				$topic_list = $info['list'];
				$page_arr = $info['page'];
			}
			$topic_list_get = true;

		} else if ('bbs' == $params['code']) {
			
			$title = "我的论坛";
			$view = trim($this->Get['view']);
			$where_sql = '';
			if ($view == 'favorites') {
				$where_sql = 'favorites';
			}else if($view == 'favorite'){
				$where_sql = 'favorite';
			}else if($view == 'thread'){
				$where_sql = 'thread';
			}else if($view == 'reply'){
				$where_sql = 'reply';
			}else if($view == 'all'){
				$where_sql = 'all';
			} else {
				if($this->Config['dzbbs_enable']){
					$view = 'favorites';
					$where_sql = 'favorites';
				}else{
					$view = 'all';
					$where_sql = 'all';
				}
			}
			$active[$view] = 'current';
			$info = array();
			$param = array(
				'where' => $where_sql,
				'perpage' => $options['perpage'],
				'page_url' => $options['page_url'],
			);
						if(($this->Config['dzbbs_enable'] && ConfigHandler::get('dzbbs')) || ($this->Config['phpwind_enable'] && $this->Config['pwbbs_enable'] && ConfigHandler::get('phpwind'))){
				Load::logic("topic_bbs");
				$TopicBbsLogic = new TopicBbsLogic();
				$info = $TopicBbsLogic->get_bbs($param);
				$bbs_url = BBS_API_URL;
			}

			if (!empty($info)) {
				$total_record = $info['count'];
				$topic_list = $info['list'];
				$page_arr = $info['page'];
			}
			$topic_list_get = true;
		} else if ('topicnew' == $params['code']) {
			$title = '最新内容';
			$options['where'] = '';
			$orderby = in_array($this->Get['orderby'],array('post','dig','mark')) ? $this->Get['orderby'] : 'dig';
			if($orderby == 'mark'){
				$order = ' lastupdate DESC';
			}elseif($orderby == 'dig'){
				$order = ' lastdigtime DESC';
			}else{
				$options['where'] = " type <> 'reply'";
				$order = ' dateline DESC';
			}

            if($this->Get["date"] && strtotime($this->Get["date"])>0){
                $dateline = strtotime($this->Get["date"]);
                $options['where'] .= " dateline > ".$dateline.' and dateline<'.($dateline+(60*60*24));
            }else{
                $this->Get["date"] = date("Y-m-d",time());
            }

			$options['order'] = $order;
		}

		if (!$topic_list_get) {
						if($cache_time > 0 && !$options['tid']) { 				$cache_key = ($cache_key ? $cache_key : "{$member['uid']}-topic-{$params['code']}-{$params['type']}-{$params['gid']}-{$params['qid']}-{$params['view']}");

				$options = $TopicListLogic->get_options($options, $cache_time, $cache_key);
			}
						$info = $TopicListLogic->get_data($options);
			$topic_list = array();
			$total_record = 0;
			if (!empty($info)) {
				$topic_list = $info['list'];
				$total_record = $info['count'];
				if($info['page']){
					$page_arr = $info['page'];
				}else{
					$page_arr = $getTypeTidReturn['page'];
				}
			}
		}

		$topic_list_count = 0;
		if ($topic_list) {
			if($GLOBALS['_J']['config']['is_topic_user_follow'] && !$GLOBALS['_J']['disable_user_follow']) {
				$topic_list = jmodel('buddy')->follow_html2($topic_list);
			}
			$topic_list_count = count($topic_list);
			if (!$topic_parent_disable && ('bbs' != $this->Code || 'cms' != $this->Code)) {
								$parent_list = $this->TopicLogic->GetParentTopic($topic_list, ('mycomment' == $this->Code));
							}
		}

				if (!in_array($params['code'],array('bbs','cms'))){			$ajaxkey = array();			$ajaxnum = 10;			if(count($topic_list)>$ajaxnum){				$topic_keys = array_keys($topic_list);				$topic_list = array_slice($topic_list,0,$ajaxnum);				array_splice($topic_keys,0,$ajaxnum);				$num = ceil(count($topic_keys)/$ajaxnum);				for($i=0;$i<$num;$i++){
					if(count($topic_keys)>$ajaxnum){
						$topic_key = array_splice($topic_keys,0,$ajaxnum);					}else{
						$topic_key = $topic_keys;
					}
					$ajaxkey[] = base64_encode(serialize($topic_key));				}
				$isloading = true;			}
		}

				$group_list = $grouplist2 = array();
		$group_list = $this->_myGroup($member['uid']);
		$cut_num = 5;
		if ($group_list) {
			$group_count = count($group_list);
			if ($group_count > $cut_num) {
				$grouplist2 = array_slice($group_list,0,$cut_num);
				$grouplist_more = array_slice($group_list, $cut_num);
				foreach ($grouplist_more as $key => $value) {
					if ($value['id'] == $gid) {
						$tmp = $grouplist2[$cut_num-1];
						$grouplist2[$cut_num-1] = $value;
						$grouplist_more[] = $tmp;
						unset($grouplist_more[$key]);
						break;
					}
				}
				$group_list = $grouplist_more;
			} else {
				$grouplist2 = $group_list;
				$group_list = array();
			}
		}

				if(!$this->Config['acceleration_mode']){
			$member_medal = $my_member ? $my_member : $member;
			if ($member_medal['medal_id']) {
				$medal_list = $this->_Medal($member_medal['medal_id'],$member_medal['uid']);
			}
		}
		
		$exp_return = user_exp($member_medal['level'],$member_medal['credits']);
		if($exp_return['exp_width'] >= 1){
			$exp_width = $exp_return['exp_width'];
		} else {
			$exp_width = 0;
		}
				$nex_exp_credit  = $exp_return['nex_exp_credit'];
				$nex_level  = $exp_return['nex_exp_level'];

		$this->Title || $this->Title = $title;
		$tpl = $tpl ? $tpl : 'topic_index';

				if(in_array($tpl,array('topic_index','topic_myhome'))){
			$tid = jmodel('buddy')->check_new_recd_topic(MEMBER_ID);
			if($tid && $topic_list){
				foreach($topic_list as $key => $val){
					if($tid == $val['tid']) {
						unset($topic_list[$key]);
					}
				}
			}
		}

		include(template($tpl));
	}


		function View()
	{
		if ($this->ID < 1) {
			$this->Messager("请指定一个ID",null);
		}
		$per_page_num = 20;
		$query_link = "index.php?mod=" . ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module) . ($this->Code ? "&amp;code={$this->Code}" : "");

		        $topic_info = jlogic('longtext')->get_info($this->ID, array('type'=>'artZoom2'));
        if($topic_info['longtextid'] > 0) {
        	$topic_info['content'] = nl2br($topic_info['content']);
        }

		if (!$topic_info) {
			$this->Messager("您要查看的微博已经不存在了",null);
		}

				$allow_op = 1;

		
		if ($topic_info['item'] == 'qun' && !empty($topic_info['item_id'])) {
			Load::logic('qun');
			$QunLogic = new QunLogic();
			$qun_info = $QunLogic->get_qun_info($topic_info['item_id']);
			if (!empty($qun_info)) {
				$qun_info['icon'] = $QunLogic->qun_avatar($qun_info['qid'], 's');
				$allow_op = $is_qun_member = $QunLogic->is_qun_member($topic_info['item_id'], MEMBER_ID);
				if ($qun_info['gview_perm'] == 1) {
					if (!$is_qun_member) {
						$this->Messager("你不是当前".$this->Config[changeword][weiqun]."的成员，无法查看", 'index.php?mod=qun&qid='.$topic_info['item_id']);
					}
				}
			}
		} else {
									if ($topic_info['type'] == 'reply') {
				$roottid = $topic_info['roottid'];

								if (empty($roottid)) {
					$root_type = 'reply';
				} else {
					$root_type = DB::result_first("SELECT type FROM ".DB::table('topic')." WHERE tid='{$roottid}'");
				}
			} else {
				$root_type = $topic_info['type'];
			}
			if (!$this->TopicLogic->check_view_perm($topic_info['uid'], $root_type)) {
				$this->Messager("你没有权限查看");
			}
		}


		$parent_list = $t_parent_list = array();
		if($topic_info['parent_id'])
		{
			$parent_id_list = array
			(
			$topic_info['parent_id'],
			$topic_info['top_parent_id'],
			);

			if($parent_id_list)
			{
				                $t_parent_list[$topic_info['top_parent_id']] = jlogic('longtext')->get_info($topic_info['top_parent_id'], array('type'=>'artZoom2'));
			}
		}

				if ($topic_info['digcounts'] > 0) {
			$dig_users = array();
			$user = $this->TopicLogic->GetDigUids($topic_info['tid']);
						if(!$user || count($user) != $topic_info['digcounts']){
				$query = DB::query("SELECT uid FROM `".TABLE_PREFIX."topic_dig`	WHERE tid = '".$topic_info['tid']."' ORDER BY id DESC");
				while ($rs = DB::fetch($query)){
					$user[$rs['uid']] = $rs['uid'];
				}
			}
						$dig_users = $this->TopicLogic->GetMember($user, "`uid`,`username`,`nickname`,`face`");
			foreach($dig_users as $k => $v){
				array_splice($dig_users[$k],4,3);
			}
			$listotherdig = true;
		}

		if ($topic_info['replys'] > 0) {
			$total_record = $topic_info['replys'];
			$p = array(
				'perpage' => $per_page_num,
				'result_count' => $total_record,
			);
			$orderby = jget('orderby');
			if('dig' == $orderby) {
				$p['sql_order'] = ' `digcounts` DESC, `lastdigtime` DESC ';
			} elseif('post' == $orderby) {
				$p['sql_order'] = ' `dateline` DESC ';
			} else {
				$p['sql_order'] = ' `dateline` ASC ';
			}
			$reply_list_ajax_disable = 1;
			$rets = jtable('topic_relation')->get_list($topic_info['tid'], $p);
						$page_arr = $reply_list = array();
			if($rets) {
				$page_arr = $rets['page'];
				$reply_list = $rets['list'];
				$total_record = $rets['count'];
				$parent_list = $rets['parent_list'];
			}

			if($reply_list) {
				$ajaxkey = array();
				$ajaxnum = 10;
				if(count($reply_list)>$ajaxnum){
					$topic_keys = array_keys($reply_list);
					$reply_list = array_slice($reply_list,0,$ajaxnum);
					array_splice($topic_keys,0,$ajaxnum);
					$num = ceil(count($topic_keys)/$ajaxnum);
					for($i=0;$i<$num;$i++){
						if(count($topic_keys)>$ajaxnum){
							$topic_key = array_splice($topic_keys,0,$ajaxnum);
						}else{
							$topic_key = $topic_keys;
						}
						$ajaxkey[] = base64_encode(serialize($topic_key));
					}
					$isloading = true;
				}
											}
		}
		if($t_parent_list) {
			foreach($t_parent_list as $k=>$v) {
				if(!isset($parent_list[$k])) {
					$parent_list[$k] = $v;
				}
			}
		}

		if($parent_list) {
						foreach($parent_list as $key => $val){
				if(strlen($val['content'])>120){
					$parent_list[$key]['content'] = cutstr(strip_tags($val['content']),120,'…');					if($val['longtextid'] < 1) {
						$parent_list[$key]['longtextid'] = $val['tid'];					}
				}
			}
		}

		if (MEMBER_ID > 0) {
			$sql = "select * from `".TABLE_PREFIX."topic_favorite` where `uid`='".MEMBER_ID."' and `tid`='{$topic_info['tid']}'";
			$query = $this->DatabaseHandler->Query($sql);
			$is_favorite = $query->GetRow();
		}

		$member = $this->_member($topic_info['uid']);

				$member_medal = $member;
		if($member_medal['medal_id'])
		{
			$medal_list = $this->_Medal($member_medal['medal_id'],$member_medal['uid']);
		}

		
		$this->Title = cut_str(strip_tags($topic_info['content']),50)." - {$member['nickname']}的微博";

				$Keywords = array();
		if(strpos($topic_info['content'],'#'))
		{
			preg_match_all('~\#([^\#\s\'\"\/\<\>\?\\\\]+?)\#~',strip_tags($topic_info['content']),$Keywords);
		}
		if(is_array($Keywords[1]) && count($Keywords[1]))
		{
			$this->MetaKeywords = implode(',',$Keywords[1]);
		}

		$this->MetaDescription = cutstr(strip_tags($topic_info['content']), 140);
		


		if(MEMBER_ID != $member['uid'])
		{
			$this->_initTheme($member);
		}


		$topic_view = 1;
		$this->item = $topic_info['item'];
		$this->item_id = $topic_info['item_id'];

		include(template('topic_view'));
	}

	function Follow() {
		$member =  $this->_member();
		if (!$member) {
			$this->Messager("请先<a href='index.php?mod=login'>点此登录</a>或者<a href='index.php?mod=member'>点此注册</a>一个帐号",'index.php?mod=login');
		}

		$my_member = $this->_member($this->Get['mod_original']);

				$gid = jget('gid', 'int');
		$keyword = $this->Post['nickname'] ? $this->Post['nickname'] : $this->Get['nickname'];

				$per_page_num = empty($this->ShowConfig['topic']['follow']) ? 10 : $this->ShowConfig['topic']['follow'];
		$gets = array(
			'mod' => $_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module,
			'code' => $this->Code,
			'gid' => $this->Get['gid'],
			'nickname' => $this->Get['nickname'],
			'type' => $this->Get['type'],
		);
		$page_url = "index.php?".url_implode($gets);


				$orderBy = ' ORDER BY ';
		if("fans_count" == $this->Get['type']){
			$orderBy .= " m.`fans_count` DESC ";
		} else if ("lastpost" == $this->Get['type']) {
			$orderBy .= " m.`lastpost` DESC ";
		} else {
			$orderBy .= " b.`dateline` DESC ";
		}

		$member_list = array();

		
		if (!empty($keyword)) {
			if (strlen($keyword) < 2) {
				$this->Messager("请输入至少3个字节的关键词", -1);
			}

			$search_sql = build_like_query("m.`nickname`", $keyword);
			$where_sql = " b.uid='".MEMBER_ID."' AND {$search_sql} ";
			$count = DB::result_first("SELECT COUNT(*)
									   FROM ".DB::table(jtable('buddy_follow')->table_name(MEMBER_ID))." AS b
									   LEFT JOIN ".DB::table('members')." AS m
									   ON m.uid=b.touid
									   WHERE {$where_sql}");
			if ($count > 0) {
				$page_arr = page($count, $per_page_num, $page_url, array('return' => 'array'));
				$member_list = DB::fetch_all("SELECT b.remark, b.gids, m.*
									FROM ".DB::table(jtable('buddy_follow')->table_name(MEMBER_ID))." AS b
									LEFT JOIN ".DB::table('members')." AS m
									ON m.uid=b.touid
									WHERE {$where_sql}
									{$orderBy}
									{$page_arr['limit']}");
			}
		} elseif ($gid > 0) {
						$group_view = jtable('buddy_follow_group')->info($gid);
			if (empty($group_view) || $group_view['uid'] != MEMBER_ID) {
				$this->Messager("这个不是你的分组，你不能查看", -1);
			}

						$count = $group_view['count'];
			if ($count > 0) {
				$page_arr = page($count, $per_page_num, $page_url, array('return' => 'array'));
								$sql = "SELECT b.remark, b.gids, m.*
						FROM ".DB::table(jtable('buddy_follow_group_relation')->table_name(MEMBER_ID))." AS g
						LEFT JOIN ".DB::table('members')." AS m
						ON m.`uid` = g.`touid`
						LEFT JOIN  ".DB::table(jtable('buddy_follow')->table_name(MEMBER_ID))." AS b
						ON (b.uid='".MEMBER_ID."' AND b.`touid` = m.`uid`)
						WHERE g.`gid`='{$gid}' AND g.uid='".MEMBER_ID."'
						{$orderBy}
						{$page_arr['limit']}";
						$member_list = DB::fetch_all($sql);
			}
		} else {
						$count = $member['follow_count'];
			if ($count > 0) {
								$page_arr = page($count, $per_page_num, $page_url, array('return' => 'array'));

								$sql = "SELECT b.remark, b.gids, m.*
						FROM ".DB::table(jtable('buddy_follow')->table_name($member['uid']))." AS b
						LEFT JOIN ".DB::table('members')." AS m
						ON m.`uid` = b.`touid`
						WHERE b.`uid`='{$member['uid']}'
						{$orderBy}
						{$page_arr['limit']}";
				$member_list = DB::fetch_all($sql);
			}
		}

				$group_list = $grouplist2 = array();
		$group_list = $this->_myGroup($member['uid']);
		if($group_list) {
			$grouplist2 = array_slice($group_list,0,min(4,count($group_list)));
		}

				$my_group_list = array();
		if(MEMBER_ID == $member['uid']) {
			$my_group_list = $group_list;
		} else {
					}

				if($member_list) {
			foreach($member_list as $k => $row) {
				if($row['uid'] > 0) {
					$member_list[$k] = jsg_member_make($row);
					if($row['gids'] && $my_group_list) {
						$member_list[$k]['buddy_group_list'] = jtable('buddy_follow_group')->get_group_list($row['gids'], $my_group_list);
					}
				} else {
					unset($member_list[$k]);
				}
			}
			$member_list = buddy_follow_html($member_list);
		}

				$member_medal = $my_member ? $my_member : $member;
		if ($member_medal['medal_id']) {
			$medal_list = $this->_Medal($member_medal['medal_id'],$member_medal['uid']);
		}

		$this->Title = "{$member['nickname']}关注的微博";

		include(template('topic_follow'));

	}

	function ViewGroup()
	{
		$member = $this->_member();
		if (!$member || MEMBER_ID < 1) {
			$this->Messager("请先<a href='index.php?mod=login'>点此登录</a>或者<a href='index.php?mod=member'>点此注册</a>一个帐号",'index.php?mod=login');
		}
				$gid = (int) $this->Get['gid'];
		if($gid < 1) {
			$this->Messager('分组ID不能为空');
		}
				$group_view = jtable('buddy_follow_group')->info(array(
			'id' => $gid,
			'uid' => MEMBER_ID,
		));
		if(!$group_view) {
			$this->Messager('您要查看的分组不存在');
		}

				$count = $member['follow_count'];
		if($count > 0) {
			$per_page_num = 24;
			$page_arr = page($count,$per_page_num,"index.php?mod=topic&code=group&gid={$gid}", array('return'=>'Array'));

			$p = array(
				'result_count' => $count,
				'sql_order' => ' `dateline` DESC ',
				'sql_limit' => " {$page_arr['limit']} ",
				'uid' => $member['uid'],
			);
			$uids = get_buddyids($p);

			if($uids) {
				$buddysList = $this->TopicLogic->GetMember($uids,"`uid`,`ucuid`,`username`,`face_url`,`face`,`province`,`city`,`fans_count`,`topic_count`,`validate`,`validate_category`,`nickname`");
			}
		}

				$group_list = $grouplist2 = array();
		$group_list = $this->_myGroup($member['uid']);
		if($group_list) {
			$grouplist2 = array_slice($group_list,0,min(4,count($group_list)));
		}

		
		include(template('topic_group'));
	}

	function Fans() {
				$member = $this->_member();
		if (!$member) {
			$this->Messager("链接错误，请检查",null);
		}

		$my_member = $this->_member($this->Get['mod_original']);

				$per_page_num = $this->ShowConfig['topic']['fans'];

				if ($member['uid']==MEMBER_ID && $member['fans_new']>0) {
			jtable('members')->clean_new_remind('fans_new', $member['uid']);
		}

				$orderBy = $orderBy2 = '';
		if("fans_count" == $this->Get['type']){
			$orderBy = " order by m.`fans_count` DESC ";
		} else if ("lastpost" == $this->Get['type']){
			$orderBy = " order by m.`lastpost` DESC ";
		} else {
			$orderBy = " order by b.dateline DESC ";
		}

				$keyword = jget('nickname', 'txt');

		$member_list = array();
				if (!empty($keyword) && $member['uid'] == MEMBER_ID) {
			if (strlen($keyword) < 2) {
				$this->Messager("请输入至少3个字节的关键词", -1);
			}

			$search_sql = build_like_query("m.`nickname`", $keyword);
			$where_sql = " b.uid='".MEMBER_ID."' AND {$search_sql} ";
			$count = DB::result_first("SELECT COUNT(*)
									   FROM ".DB::table(jtable('buddy_fans')->table_name(MEMBER_ID))." AS b
									   LEFT JOIN ".DB::table('members')." AS m
									   ON m.uid=b.touid
									   WHERE {$where_sql}");
			if ($count > 0) {
				$page_arr = page($count, $per_page_num, $page_url, array('return' => 'Array'));
				$member_list = DB::fetch_all("SELECT m.*
									FROM ".DB::table(jtable('buddy_fans')->table_name(MEMBER_ID))." AS b
									LEFT JOIN ".DB::table('members')." AS m
									ON m.uid=b.touid
									WHERE {$where_sql}
									{$orderBy}
									{$page_arr['limit']}");
			}
		} else {
						$count = $member['fans_count'];
			if($count > 0) {
								$page_url = "index.php?mod={$member['username']}&code=fans";
				$page_arr = page($count, $per_page_num, $page_url, array('return' => 'Array'));

				$sql = "select m.* from ".DB::table(jtable('buddy_fans')->table_name($member['uid']))." b
					left join `".TABLE_PREFIX."members` m on m.`uid`=b.`touid`
					where b.`uid`='{$member['uid']}' ". $orderBy ."{$page_arr['limit']}";
				$member_list = DB::fetch_all($sql);
			}
		}

				if($member_list) {
			foreach($member_list as $k => $row) {
				if($row['uid'] > 0) {
					$member_list[$k] = jsg_member_make($row);
				} else {
					unset($member_list[$k]);
				}
			}
			$member_list = buddy_follow_html($member_list);
		}

				$member_medal = $my_member ? $my_member : $member;
		if ($member_medal['medal_id']) {
			$medal_list = $this->_Medal($member_medal['medal_id'],$member_medal['uid']);
		}

		$this->Title = "关注{$member['nickname']}的人";

		include(template('topic_fans'));
	}



	function Top()
	{


		$limit = $this->ShowConfig['topic_top']['guanzhu'];
		$cache_id = "misc/top_users-{$limit}";
		if($limit>0 && false === ($r_users = cache_file('get', $cache_id))) {
			$r_users = $this->TopicLogic->GetMember("where face!='' order by `fans_count` desc limit {$limit}","`uid`,`ucuid`,`username`,`fans_count`,`topic_count`,`digcount`,`validate`,`validate_category`,`province`,`city`,`face`,`nickname`");

			cache_file('set', $cache_id, $r_users, $this->CacheConfig['topic_top']['guanzhu']);
		}
		$r_users = buddy_follow_html($r_users, 'uid', 'follow_html2');

				$limit = $this->ShowConfig['topic_top']['renqi'];
		$cache_id = "misc/top_day7_r_buddys";
		if ($limit>0 && false === ($day7_r_buddys = cache_file('get', $cache_id))) {
			$day7_r_buddys = array();

						
						$sql = "select DISTINCT(B.uid) AS uid, COUNT(B.touid) AS `count`
				FROM ".DB::table(jtable('buddy_fans')->table_name(max(1, MEMBER_ID)))." B
					LEFT JOIN `".TABLE_PREFIX."members` M on (M.uid=B.uid)
				WHERE B.dateline>='".(TIMESTAMP - 86400 * 7)."' AND M.face!=''
				GROUP BY B.uid
				ORDER BY `count` DESC
				LIMIT {$limit}";

			$query = $this->DatabaseHandler->Query($sql);
			$uids = $_ids = array();
			while (false != ($row = $query->GetRow()))
			{
				$uids[$row['uid']] = $row['uid'];
				$_ids[$row['uid']] = $row;
			}


			if($_ids) {
				$_list = $this->TopicLogic->GetMember($uids, "`uid`,`ucuid`,`username`,`fans_count`,`topic_count`,`digcount`,`validate`,`validate_category`,`province`,`city`,`face`,`nickname`");

				foreach ($_ids as $id=>$row) {
					$row['uid'] = $_list[$id]['uid'];
					$row['username'] = $_list[$id]['username'];
					$row['nickname'] = $_list[$id]['nickname'];
					$row['face'] = $_list[$id]['face'];
					$row['from_area'] = $_list[$id]['from_area'];
					$row['validate_html'] = $_list[$id]['validate_html'];
					$row['fans_count'] = $_list[$id]['fans_count'];
					$row['topic_count'] = $_list[$id]['topic_count'];
					$row['digcount'] = $_list[$id]['digcount'];
					if(isset($_list[$id])) {
						$day7_r_buddys[$id] = $row;
					}
				}
			}
			cache_file('set', $cache_id, $day7_r_buddys, $this->CacheConfig['topic_top']['renqi']);
		}
		$day7_r_buddys = buddy_follow_html($day7_r_buddys, 'uid', 'follow_html2');

				$limit = $this->ShowConfig['topic_top']['huoyue'];
		$cache_id = "misc/top_day7_r_users";
		if ($limit>0 && false === ($day7_r_users = cache_file('get', $cache_id))) {
						$sql = "select DISTINCT(T.uid) AS uid , COUNT(T.tid) AS `count` from `".TABLE_PREFIX."topic` T left join `".TABLE_PREFIX."members` M on T.uid=M.uid WHERE T.dateline>='".(TIMESTAMP - 86400 * 7)."' and M.face!='' GROUP BY uid ORDER BY `count` DESC LIMIT {$limit}";

			$query = $this->DatabaseHandler->Query($sql);
			$uids = $day7_r_users = array();
			while (false != ($row = $query->GetRow()))
			{
				$day7_r_users[$row['uid']] = $row;
				$uids[$row['uid']] = $row['uid'];
			}

			if ($day7_r_users) {
				$members = $this->TopicLogic->GetMember("where `uid` in ('".implode("','",$uids)."') limit {$limit}", "`uid`,`ucuid`,`username`,`fans_count`,`topic_count`,`digcount`,`validate`,`validate_category`,`province`,`city`,`face`,`nickname`");

				foreach ($members as $_m) {
					$day7_r_users[$_m['uid']]['validate_html'] = $_m['validate_html'];
					$day7_r_users[$_m['uid']]['face'] = $_m['face'];
					$day7_r_users[$_m['uid']]['uid'] = $_m['uid'];
					$day7_r_users[$_m['uid']]['from_area'] = $_m['from_area'];
					$day7_r_users[$_m['uid']]['username'] = $_m['username'];
					$day7_r_users[$_m['uid']]['nickname'] = $_m['nickname'];
					$day7_r_users[$_m['uid']]['fans_count'] = $_m['fans_count'];
					$day7_r_users[$_m['uid']]['topic_count'] = $_m['topic_count'];
					$day7_r_users[$_m['uid']]['digcount'] = $_m['digcount'];
				}
			}
			cache_file('set', $cache_id, $day7_r_users, $this->CacheConfig['topic_top']['huoyue']);
		}
		$day7_r_users = buddy_follow_html($day7_r_users, 'uid', 'follow_html2');

				$limit = $this->ShowConfig['topic_top']['yingxiang'];
		$cache_id = "misc/top_day7_r_topics";
		if ($limit>0 && false === ($day7_r_topics = cache_file('get', $cache_id))) {
						$sql = "select DISTINCT(T.touid) AS uid ,  COUNT(T.tid) AS `count` from `".TABLE_PREFIX."topic` T left join `".TABLE_PREFIX."members` M on T.touid=M.uid WHERE M.face !='' and  T.dateline>='".(TIMESTAMP - 86400 * 7)."' and T.touid > 0  GROUP BY `uid` ORDER BY `count` DESC LIMIT {$limit}";

			$query = $this->DatabaseHandler->Query($sql);
			$uids = $day7_r_topics = array();
			while (false != ($row = $query->GetRow()))
			{
				$day7_r_topics[$row['uid']] = $row;
				$uids[$row['uid']] = $row['uid'];

			}
			if ($day7_r_topics) {
				$members = $this->TopicLogic->GetMember("where `face` !='' and `uid` in ('".implode("','",$uids)."') limit {$limit}","`uid`,`ucuid`,`username`,`fans_count`,`topic_count`,`digcount`,`validate`,`validate_category`,`province`,`city`,`face`,`nickname`");

				foreach ($members as $_m) {
					$day7_r_topics[$_m['uid']]['validate_html'] = $_m['validate_html'];
					$day7_r_topics[$_m['uid']]['face'] = $_m['face'];
					$day7_r_topics[$_m['uid']]['uid'] = $_m['uid'];
					$day7_r_topics[$_m['uid']]['from_area'] = $_m['from_area'];
					$day7_r_topics[$_m['uid']]['username'] = $_m['username'];
					$day7_r_topics[$_m['uid']]['nickname'] = $_m['nickname'];
					$day7_r_topics[$_m['uid']]['fans_count'] = $_m['fans_count'];
					$day7_r_topics[$_m['uid']]['digcount'] = $_m['digcount'];
					$day7_r_topics[$_m['uid']]['topic_count'] = $_m['topic_count'];
				}

			}

			cache_file('set', $cache_id, $day7_r_topics, $this->CacheConfig['topic_top']['yingxiang']);
		}
		$day7_r_topics = buddy_follow_html($day7_r_topics, 'uid', 'follow_html2');

				$limit = isset($this->ShowConfig['topic_top']['credits']) ? $this->ShowConfig['topic_top']['credits'] : 20;
		$credits = $this->Config['credits_filed'];
		$credits_name = $this->Config['credits']['ext'][$credits]['name'];
		$cache_id = "misc/top_day7_r_sign";
		if ($limit>0 && false === ($top_day7_r_sign = cache_file('get', $cache_id))) {
						if($credits){
				$members = $this->TopicLogic->GetMember(" where `$credits` > 0 order by `$credits` desc limit {$limit}","`uid`,`ucuid`,`username`,`fans_count`,`topic_count`,`digcount`,`validate`,`validate_category`,`province`,`city`,`face`,`nickname`,`$credits`");

				$top_day7_r_sign = array();
				if($members) {
					foreach ($members as $_m) {
						$top_day7_r_sign[$_m['uid']]['validate_html'] = $_m['validate_html'];
						$top_day7_r_sign[$_m['uid']]['face'] = $_m['face'];
						$top_day7_r_sign[$_m['uid']]['uid'] = $_m['uid'];
						$top_day7_r_sign[$_m['uid']]['from_area'] = $_m['from_area'];
						$top_day7_r_sign[$_m['uid']]['nickname'] = $_m['nickname'];
						$top_day7_r_sign[$_m['uid']]['username'] = $_m['username'];
						$top_day7_r_sign[$_m['uid']]['fans_count'] = $_m['fans_count'];
						$top_day7_r_sign[$_m['uid']]['topic_count'] = $_m['topic_count'];
						$top_day7_r_sign[$_m['uid']]['digcount'] = $_m['digcount'];
						$top_day7_r_sign[$_m['uid']]['credit'] = $_m[$credits];
					}
				}

				cache_file('set', $cache_id, $top_day7_r_sign, $this->CacheConfig['topic_top']['credits']);
			}
		}
		$top_day7_r_sign = buddy_follow_html($top_day7_r_sign, 'uid', 'follow_html2');


		$this->Title = "人气用户推荐";
		include(template('topic_top'));
	}

	function Hot()
	{
		if(MEMBER_ID > 0) {
			$member = jsg_member_info(MEMBER_ID);
		}

				$vip_uids_in = '';
		$vip_uids = array();
		if($this->Config['only_show_vip_topic']) {
			$vip_uids = jsg_get_vip_uids();

			if($vip_uids) {
				$vip_uids_in = " `uid` in ('".implode("','", $vip_uids)."') and ";
			}
		}


		
		$TopicListLogic = jlogic('topic_list');

		if('hotforward' == $this->Code) {
			$title = '热门转发';

			$d_list = array(1=>'近一天',7=>'近一周',14=>'近两周',30=>'近一月',);
			$d = isset($d_list[$this->Get['d']]) ? $this->Get['d'] : 7;
			$time = $d * 86400;
			$dateline = TIMESTAMP - $time;

						$per_page_num = (int) $this->ShowConfig['topic_hot']["day{$d}"];
			if($per_page_num < 1) {
				$per_page_num = 20;
			}
			$cache_time = max(300, (int) ($this->CacheConfig['topic_hot']["day{$d}"] ? $this->CacheConfig['topic_hot']["day{$d}"] : $time / 90));
			$query_link = "index.php?mod=" . ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module) . ($this->Code ? "&amp;code={$this->Code}&d={$d}" : "");

			$options = array(
				'cache_time' => $cache_time,
				'cache_key' => "topic-hotforward-{$d}",
				'perpage' => $per_page_num,
				'page_url' => $query_link,
				'type' => 'first',
				'where' => " $vip_uids_in `forwards`>'0' AND `dateline`>='$dateline' ",
				'order' => " `forwards` DESC , `dateline` DESC ",
			);
			$info = $TopicListLogic->get_data($options);
			if($info) {
				$page_arr = $info['page'];
				$topics = $info['list'];
				$total_record = $info['count'];
			}
			$params = array('d'=>$d,'pp_time'=>$per_page_num,'c_time'=>$cache_time,'uid_sql'=>$vip_uids_in);
		}  elseif('newforward' == $this->Code) {
			$title = '最新转发';

						$per_page_num = $this->ShowConfig['new_forward']['forward'];
			if($per_page_num < 1) {
				$per_page_num = 20;
			}
			$cache_time = max(180, (int) $this->CacheConfig['new_forward']["forward"]);
			$query_link = "index.php?mod=" . ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module) . ($this->Code ? "&amp;code={$this->Code}" : "");

			$options = array(
				'cache_time' => $cache_time,
				'cache_key' => "topic-newforward",
				'perpage' => $per_page_num,
				'page_url' => $query_link,
				'where' => " $vip_uids_in `type` IN ('forward','both') AND `totid`>'0' ",
				'order' => " `dateline` DESC ",
			);
			$info = $TopicListLogic->get_data($options);
			if (!empty($info)) {
				$page_arr = $info['page'];
				$topics = $info['list'];
				$total_record = $info['count'];
			}
		} elseif('hotreply' == $this->Code) {
			$title = '热门评论';

			$d_list = array(1=>'近一天',7=>'近一周',14=>'近两周',30=>'近一月',);
			$d = isset($d_list[$this->Get['d']]) ? $this->Get['d'] : 7;
			$time = $d * 86400;
			$dateline = TIMESTAMP - $time;

						$per_page_num = $this->ShowConfig['reply_hot']["day{$d}"];
			if($per_page_num < 1) {
				$per_page_num = 20;
			}
			$cache_time = max(300, (int) ($this->CacheConfig['reply_hot']["day{$d}"] ? $this->CacheConfig['reply_hot']["day{$d}"] : $time / 90));
			$query_link = "index.php?mod=" . ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module) . ($this->Code ? "&amp;code={$this->Code}&d={$d}" : "");

			$options = array(
				'cache_time' => $cache_time,
				'cache_key' => "topic-hotreply-{$d}",
				'perpage' => $per_page_num,
				'page_url' => $query_link,
				'type' => 'first',
				'where' => " $vip_uids_in `replys`>'0' AND `dateline`>='{$dateline}' ",
				'order' => " `replys` DESC , `dateline` DESC ",
			);
			$info = $TopicListLogic->get_data($options);
			if (!empty($info)) {
				$page_arr = $info['page'];
				$topics = $info['list'];
				$total_record = $info['count'];
			}
		} elseif('newreply' == $this->Code) {
			$title = '最新评论';

						$per_page_num = $this->ShowConfig['new_reply']['reply'];
			if($per_page_num < 1) {
				$per_page_num = 20;
			}
			$cache_time = max(180, (int) $this->CacheConfig['new_reply']["reply"]);
			$query_link = "index.php?mod=" . ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module) . ($this->Code ? "&amp;code={$this->Code}" : "");

			$options = array(
				'cache_time' => $cache_time,
				'cache_key' => "topic-newreply",
				'perpage' => $per_page_num,
				'page_url' => $query_link,
				'where' => " $vip_uids_in `type` IN ('reply','both') AND `totid`>'0' ",
				'order' => " `dateline` DESC ",
			);
			$info = $TopicListLogic->get_data($options);
			if (!empty($info)) {
				$page_arr = $info['page'];
				$topics = $info['list'];
				$total_record = $info['count'];
			}
		} elseif ($this->Code =='new') {
			$title = '最新微博';
						$per_page_num = $this->ShowConfig['topic_new']['topic'];
			if($per_page_num < 1) {
				$per_page_num = 20;
			}
			$cache_time = max(0, (int) $this->CacheConfig['topic_new']["topic"]);
			$query_link = "index.php?mod=" . ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module) . ($this->Code ? "&amp;code={$this->Code}" : "");


			
			if($this->ShowConfig['topic_new']['topic'] > 0) {
				$options = array(
					'cache_time' => $cache_time,
					'cache_key' => 'topic-newtopic',
					'type' => get_topic_type(),
					'page_url' => $query_link,
					'perpage' => $per_page_num,
					'order' => ' dateline DESC ',
					'filter' => $this->Get['type'],
				);

                if($this->Get["date"] && strtotime($this->Get["date"])>0){
                    $dateline = strtotime($this->Get["date"]);
                    $options['cache_key'] .= $dateline;
                    $options['where'] = " dateline > ".$dateline.' and dateline<'.($dateline+(60*60*24));
                }else{
                    $this->Get["date"] = date("Y-m-d",time());
                }

				if($this->Get['type'] && in_array($this->Get['type'],array('pic','music','video'))){
					$getTypeTidReturn = $TopicListLogic->GetTypeTid($type,$options['uid'],$this->Get['page'],$per_page_num);
					$options['tid'] = $getTypeTidReturn['tid'];
					$options['count'] = $getTypeTidReturn['count'];
				}else{
					$options['filter'] = $this->Get['type'];
				}

				if($this->Config['only_show_vip_topic']) {
					$options['uid'] = $vip_uids;
					$title = '最新V博';
					$NewVipUid9 = $TopicListLogic->GetVipUid();
					$new_vip_user_list = $this->TopicLogic->GetMember($NewVipUid9);
					if($options['uid'] && $NewVipUid9){
						$info = $TopicListLogic->get_data($options);
					}else{
						$info = array();
					}
				}else{
					$info = $TopicListLogic->get_data($options);
				}

				$topics = array();
				$total_record = 0;
				$page_arr = array();
				if (!empty($info)) {
					$topics = $info['list'];
					$total_record = $info['count'];
					$page_arr = $info['page'];
				}
			}
			$params = array('pp_time'=>$per_page_num,'c_time'=>$cache_time,'uid'=>base64_encode(serialize($vip_uids)));
		} elseif('tc' == $this->Code) {
			if(!$this->Config['same_city']){
				$this->Messager('管理员已关闭同城微博。','index.php?mod=topic&code=new');
			}
			$title = '同城微博';

			$province_id = (int) $this->Get['province'];
			$city_id = (int) $this->Get['city'];
			$area_id = (int) $this->Get['area'];

			if($province_id < 1){
				if($member['province']){
					$province_name = $member['province'];
					$province_id = DB::result_first("select id from ".TABLE_PREFIX."common_district where name = '".$member['province']."' and `upid` = '0'");
					if($member['city']){
						$city_name = $member['city'];
						$city_id = DB::result_first("select id from ".TABLE_PREFIX."common_district where name = '".$member['city']."' ");
						if($member['area']){
							$area_name = $member['area'];
						}
					}
				}
			}else{
				if($city_id){
					$city_name = DB::result_first("select name from ".TABLE_PREFIX."common_district where id = '$city_id' ");
					if($area_id){
						$area_name = DB::result_first("select name from ".TABLE_PREFIX."common_district where id = '$area_id' ");
					}
				}
			}

			$query = $this->DatabaseHandler->Query("select id,name from ".TABLE_PREFIX."common_district where `upid` = '0' order by list");
			while ($rsdb = $query->GetRow()){
				$province[$rsdb['id']]['value']  = $rsdb['id'];
				$province[$rsdb['id']]['name']  = $rsdb['name'];
				if($province_id == $rsdb['id']){
					$province_name = $rsdb['name'];
				}
			}
			$province_list = jlib('form')->Select("tc_province",$province,$province_id," onchange=\"changeProvince();\" style=\"width:150px\" ");

						$per_page_num = $this->ShowConfig['topic_new']['topic'];
			if($per_page_num < 1) {
				$per_page_num = 20;
			}
			$cache_time = max(0, (int) $this->CacheConfig['topic_new']["topic"]);
			$query_link = "index.php?mod=" . ($_GET['mod_original'] ? get_safe_code($_GET['mod_original']) : $this->Module) . ($this->Code ? "&amp;code={$this->Code}" : "")."&province=$province_id&city=$city_id&area=$area_id";

			$info = array();
			if($province_name || $city_name) {
				if($this->ShowConfig['topic_new']['topic'] > 0) {
					$options = array(
						'cache_time' => $cache_time,
						'cache_key' => "topic-tctopic-{$province_name}-{$city_name}-{$area_name}",
						'type' => get_topic_type(),
						'vip' => $this->Config['only_show_vip_topic'],
						'page_url' => $query_link,
						'perpage' => $per_page_num,
					);
					if($area_name){
						$options['area'] = $area_name;
					}elseif($city_name){
						$options['city'] = $city_name;
					}elseif($province_name){
						$options['province'] = $province_name;
					}

					$info = $TopicListLogic->get_tc_data($options);
					$topics = array();
					$total_record = 0;
					$page_arr = array();
					if (!empty($info)) {
						$topics = $info['list'];
						$total_record = $info['count'];
						$page_arr = $info['page'];
					}
				}
			}
			$params = array('province'=>$province_name,'city'=>$city_name,'area'=>$area_name,'pp_time'=>$per_page_num,'c_time'=>$cache_time,'vip'=> $options['vip']);

						$events = array();
			$event_limit = (int) $this->ShowConfig['page_r']['tc_event'];
			if($city_id){
				$event_where = " city_id = '$city_id' ";
			}elseif($province_id){
				$event_where = " province_id = '$province_id' ";
			}
			if($event_limit && $event_where){
				$sql = "select id,title,app_num from ".TABLE_PREFIX."event where $event_where order by lasttime desc limit $event_limit ";
				$query = $this->DatabaseHandler->Query($sql);
				$events = $query->GetAll();
			}
		}


				if ('forward' != $this->Code) {
			$parent_id_list = array();
			if ($topics) {
				foreach ($topics as $row) {
					if(0 < ($p = (int) $row['parent_id'])) {
						$parent_id_list[$row['tid']] = $p;
					}
					if (0 < ($p = (int) $row['top_parent_id'])) {
						$parent_id_list[$row['tid']] = $p;
					}
				}
			}

			if($parent_id_list) {
								$pcount = count($parent_id_list);
				$options = array(
					'tid' => $parent_id_list,
					'type' => get_topic_type(),
					'count' => $pcount,
				);

				$p_info = $TopicListLogic->get_data($options);

				$parent_list = array();
				if (!empty($p_info)) {
					$parent_list = $p_info['list'];
					$keys = array_keys($parent_list);
				} else {
					$keys = array();
				}

								foreach ($parent_id_list as $key => $val) {
					if (in_array($val, $keys)) {
						continue;
					}
					unset($topics[$key]);
				}
			}
		}
		
		

		$this->Title = $title;
		if($_GET['filter_type']=='pic' && in_array($this->Code,array('new','hotforward','tc'))){
			if($page_arr['html']){
				$ajax_num = ceil($total_record/$per_page_num);
			}
			foreach ($topics as $key => $row) {				if($row['parent_id'] || $row['top_parent_id']) {
					unset($topics[$key]);
				}
			}
			$topic_pic_keys = array('ji','shi','gou');
			include(template('topic_new_pic'));
		}else{
		$ajaxkey = array();
		$ajaxnum = 10;
		if(count($topics)>$ajaxnum){
			$topic_keys = array_keys($topics);
			$topics = array_slice($topics,0,$ajaxnum);
			array_splice($topic_keys,0,$ajaxnum);
			$num = ceil(count($topic_keys)/$ajaxnum);
			for($i=0;$i<$num;$i++){
				if(count($topic_keys)>$ajaxnum){
					$topic_key = array_splice($topic_keys,0,$ajaxnum);
				}else{
					$topic_key = $topic_keys;
				}
				$ajaxkey[] = base64_encode(serialize($topic_key));
			}
			$isloading = true;
		}

				
		$Gz_limit = $this->ShowConfig['topic_index']['guanzhu'];
		if($Gz_limit > 0) {
			$cache_time  = max(0, $this->CacheConfig['topic_index']['guanzhu']);
			$cache_id = 'misc/topic-index-guanzhu-'.$Gz_limit;
			if(!$cache_time || (false === ($concern_users = cache_file('get', $cache_id)))) {
				$concern_users = $this->TopicLogic->GetMember(" WHERE 1 order by `fans_count` desc limit {$Gz_limit}","`uid`,`ucuid`,`username`,`face_url`,`face`,`fans_count`,`validate`,`validate_category`,`nickname`");

				if($cache_time) {
					cache_file('set', $cache_id, $concern_users, $cache_time);
				}
			}
		}

		

				$Tg_limit = $this->ShowConfig['topic_new']['tag'];
		if($Tg_limit > 0) {
						$Tg_date  = max(43200, (int) $this->CacheConfig['topic_new']['day_tag']);
			$dateline = TIMESTAMP - $Tg_date;
			$cache_time  = max(0, (int) $this->CacheConfig['topic_new']['tag']);
			$cache_id = "misc/topic-new-tag-{$Tg_limit}-{$Tg_date}";

			if(!$cache_time || false === ($tags = cache_file('get', $cache_id))) {
				$sql = "select `id`,`name`,`topic_count`,`last_post` from `".TABLE_PREFIX."tag` where `last_post` > '{$dateline}' order by `topic_count` desc limit {$Tg_limit}";
				$query = $this->DatabaseHandler->Query($sql);
				$tags = $query->GetAll();

				if($cache_time) {
					cache_file('set', $cache_id, $tags, $cache_time);
				}
			}
		}

		include(template('topic_new'));
		}
	}

	
	function _member($uid=0)
	{
		$member = array();
		if($uid < 1)
		{
			$member = jsg_member_info_by_mod();
		}

		$uid = (int) ($uid ? $uid : MEMBER_ID);
		if($uid > 0 && !$member)
		{
			$member = $this->TopicLogic->GetMember($uid);
		}
		if(!$member)
		{
			return false;
		}
		$uid = $member['uid'];

		if (!$member['follow_html'] && $uid!=MEMBER_ID && MEMBER_ID>0)
		{
			$member['follow_html'] = buddy_follow_html($member, 'uid', 'follow_html', 1);
		}

				if(true === UCENTER_FACE && MEMBER_ID == $uid && MEMBER_UCUID > 0 && !($member['__face__']))
		{
			include_once(ROOT_PATH . './api/uc_client/client.php');

			$uc_check_result = uc_check_avatar(MEMBER_UCUID);

			if($uc_check_result)
			{
				$this->DatabaseHandler->Query("update ".TABLE_PREFIX."members set `face`='./images/noavatar.gif' where `uid`='{$uid}'");
			}
		}

		return $member;
	}

	function _recommendTag($day=1,$limit=12,$cache_time=0)
	{
		if($limit < 1) return false;

		$time = $day * 86400;
		$cache_time = ($cache_time ? $cache_time : $time / 90);
		$cache_id = "misc/recommendTopicTag-{$day}-{$limit}";

		if (false === ($list = cache_file('get', $cache_id))) {
			$dateline = TIMESTAMP - $time;
			$sql = "SELECT DISTINCT(tag_id) AS tag_id, COUNT(item_id) AS item_id_count FROM `".TABLE_PREFIX."topic_tag` WHERE dateline>=$dateline GROUP BY tag_id ORDER BY item_id_count DESC LIMIT {$limit}";
			$query = $this->DatabaseHandler->Query($sql);
			$ids = array();
			while (false != ($row = $query->GetRow()))
			{
				$ids[$row['tag_id']] = $row['tag_id'];
			}

			$list = array();
			if($ids) {
				$sql = "select `id`,`name`,`topic_count` from `".TABLE_PREFIX."tag` where `id` in('".implode("','",$ids)."')";
				$query = $this->DatabaseHandler->Query($sql);
				$list = $query->GetAll();
			}

			cache_file('set', $cache_id, $list, $cache_time);
		}

		return $list;

	}

	function _recommendUser($day=1,$limit=12,$cache_time=0) {
		return jmodel('data_block')->recommend_topic_user($day, $limit, $cache_time);
	}

		function _myGroup($uid=0,$limit = 0) {
		return jtable('buddy_follow_group')->get_my_group($uid, $limit);
	}

		function _GroupFields($uid=0)
	{
		$list = array();

		if(MEMBER_ID > 0)
		{
			$list = jtable('buddy_follow_group_relation')->get_user_group(MEMBER_ID, $uid);
		}

		return $list;
	}

	function _Medal($medalid=0,$uid=0)
	{
		
		
		

		$uid = (is_numeric($uid) ? $uid : 0);

		$medal_list = array();

		if($uid > 0)
		{
			$sql = "select  U_MEDAL.dateline ,  MEDAL.medal_img , MEDAL.conditions , MEDAL.medal_name ,MEDAL.medal_depict ,MEDAL.id , U_MEDAL.*
					from `".TABLE_PREFIX."medal` MEDAL
					left join `".TABLE_PREFIX."user_medal` U_MEDAL on MEDAL.id=U_MEDAL.medalid
					where U_MEDAL.uid='{$uid}'
					and U_MEDAL.is_index = 1
					and MEDAL.is_open = 1 ";

			$query = $this->DatabaseHandler->Query($sql);
			while (false != ($row = $query->GetRow()))
			{
				$row['dateline'] = date('m-d日 H:s ',$row['dateline']);
				$medal_list[$row['id']] = $row;
			}
		}

		return $medal_list;
	}

		function Photo()
	{
		$this->Title = '图片墙';
		if($_GET['type']=='3d'){
			$xml = '<?xml version="1.0"?>';
			$xml .= '<!DOCTYPE cross-domain-policy SYSTEM "http:/'.'/www.macromedia.com/xml/dtds/cross-domain-policy.dtd">';
			$xml .= '<cross-domain-policy>';
			$xml .= '<allow-access-from domain="'.$this->Config['site_domain'].'" />';
			$xml .= '<allow-access-from domain="*.cooliris.com" />';
			$xml .= '<allow-http-request-headers-from domain="*" headers="*" />';
			$xml .= '</cross-domain-policy>';
			if(@!is_file("crossdomain.xml")){
				file_put_contents("crossdomain.xml",$xml);
			}else{
				$oxml = file_get_contents("crossdomain.xml");
				if(strcmp($xml,$oxml)){
					file_put_contents("crossdomain.xml",$xml);
				}
			}
			$this->Title .= '—3D浏览';
			include(template('topic_photo_3d'));
		}
		else
		{
			$nickname = '我';
			$uid = 0;
			if(isset($this->Get['uid'])){
				if((int)$this->Get['uid']>0){
					$uid = (int)$this->Get['uid'];
					$type = 1;
					if($uid != MEMBER_ID){
						$nickname = DB::result_first("select `nickname` from ".TABLE_PREFIX."members where uid = '$uid'");
						$this->Title = $nickname."关注的人的图片";
					}else{
						$this->Title = '我关注人的图片';
					}
				}
			}

			$TopicListLogic = jlogic('topic_list');
			$photo_num = 21; 			$p = array(
				'count' => $photo_num,
				'vip' => $this->Config['only_show_vip_topic'],
				'limit' => $photo_num,
				'uid' => $uid,
			);
			$info = $TopicListLogic->get_photo_list($p);
			if (!empty($info)) {
				$topic_list = $info['list'];
				$isloading = ($info['count'] >= $p['limit'] ? true : false);
			}else{
				$isloading = false;
			}
			if($this->Config['attach_enable']){$allow_attach = 1;}else{$allow_attach = 0;}

			$t_col_foot = 't_col_foot'; 			$t_col_backTop = 't_col_backTop';
			$url_uid = ($uid ? $uid : MEMBER_ID); 			include(template('topic_photo'));
		}
	}

	function normalIndex(){
		if(MEMBER_ID > 0) {
			$member = jsg_member_info(MEMBER_ID);
			if($member){
				header('Location: index.php?mod=topic');
				exit;
			}
		}
		$username = jget('username') ? jget('username') : (jget('email') ? jget('email') : $this->Config['changeword']['username']);

				$this->ShowConfig = ConfigHandler::get('show');
		$this->CacheConfig = ConfigHandler::get('cache');
		$limit = $this->ShowConfig['topic_index']['guanzhu'];
		if ($limit > 0) {
			$cache_id = "index/r_users";
			if(false === ($r_users = cache_file('get', $cache_id))) {
				$r_users = jlogic('topic')->GetMember("where face !='' order by `fans_count` desc limit {$limit}","`uid`,`ucuid`,`username`,`face_url`,`face`,`fans_count`,`validate`,`validate_category`,`nickname`");

				cache_file('set', $cache_id, $r_users, $this->CacheConfig['topic_index']['guanzhu']);
			}
		}

				$day2_r_users = $this->_recommendUser(7,$this->ShowConfig['topic_index']['new_user'],$this->CacheConfig['topic_index']['new_user']);

				$r_tags = $this->_recommendTag(2,$this->ShowConfig['topic_index']['hot_tag'],$this->CacheConfig['topic_index']['hot_tag']);

		$recommend_count = 0;
		if ($this->ShowConfig['topic_index']['recommend_topic']) {
			$cache_id = "index/recommend_topics";
			if (false === ($cache_recommend_topics = cache_file('get', $cache_id))) {
				
				$TopicListLogic = jlogic('topic_list');
				$type_sql = jimplode(get_topic_type());
				$fields = " a.* ";
				$vip_t = $vip_w = '';
				if($this->Config['only_show_vip_topic']) {
					$vip_t = ', '.DB::table('members').' m ';
					$vip_w = ' and m.uid=a.uid and m.validate="1" ';
				}
				$table = " ".DB::table("topic")." a,(SELECT uid, max(dateline) max_dateline FROM ".DB::table("topic")." WHERE type IN(".$type_sql.") GROUP BY uid) b $vip_t ";
				$where = "  WHERE a.uid = b.uid AND a.dateline = b.max_dateline AND a.type IN({$type_sql}) $vip_w ORDER BY a.dateline DESC LIMIT {$this->ShowConfig['topic_index']['recommend_topic']}";
				$recommend_topics = jlogic('topic')->Get($where, $fields, 'Make', $table);

								$parent_list = jlogic('topic')->GetParentTopic($recommend_topics);
				
				$cache_recommend_topics = array(
					'recommend_topics' => $recommend_topics,
					'parent_list' => $parent_list,
				);
				cache_file('set', $cache_id, $cache_recommend_topics, $this->CacheConfig['topic_index']['recommend_topic']);
			} else {
				$recommend_topics = $cache_recommend_topics['recommend_topics'];
				$parent_list = $cache_recommend_topics['parent_list'];
			}
			$recommend_count = count($recommend_topics);
		}


		include(template('login_index'));
	}

	function simpleIndex(){
		if(MEMBER_ID > 0) {
			$member = jsg_member_info(MEMBER_ID);
			if($member){
				header('Location: index.php?mod=topic');
				exit;
			}
		}
		$username = jget('username') ? jget('username') : (jget('email') ? jget('email') : $this->Config['changeword']['username']);

				$cache_id = 'notice/list-topic_index_guest';
		if (false===($list_notice = cache_file('get', $cache_id))) {
			$sql="select `id`,`title` from ".TABLE_PREFIX.'notice'." order by `id` desc limit 5 ";
			$query = $this->DatabaseHandler->Query($sql);
			$list_notice = array();
			while (false != ($row = $query->GetRow())) {
				$row['titles']	= $row['title'];
				$row['title'] 	= cutstr($row['title'],30);
				$list_notice[] 	= $row;
			}
			cache_file('set', $cache_id, $list_notice, 86400);
		}
		$channels = jlogic('channel')->get_category_tree(1);
		$returnchs = array();
		if(count($channels)>8){			$keys = array_rand($channels,8);
			foreach($keys as $v){
				$returnchs[$v] = $channels[$v];
			}
		}else{
			if($channels){
				shuffle($channels);			}
			$returnchs = $channels;
		}
		include(template('login_index_simpler'));
	}

	function only_login_index() {
		if(MEMBER_ID > 0) {
			$this->Messager(null, 'index.php?mod=topic');
		}

		include template('login_index_simplest');
	}

	function channelIndex(){
		if(MEMBER_ID > 0) {
			$member = jsg_member_info(MEMBER_ID);
			if($member){
				header('Location: index.php?mod=topic');
				exit;
			}
		}else{
			$channeltoptopic =  $this->ChannelLogic->getChannelTopTopic();
			$channelrectopic =  $this->ChannelLogic->getChannelRecTopic();
			$channellist =  $this->ChannelLogic->getChannelAll();
			$userfanstop =  $this->ChannelLogic->getUserFansTop();
			include template('channel_index');
			exit;
		}
	}
}

?>