<?php 
/**
 * 头像模型 - 业务逻辑模型
 * @author jason <yangjs17@yeah.net>
 * @version TS3.0
 */
class AvatarModel {

	protected $_uid;			// 用户UID字段

	/**
	 * 初始化模型，加载相应的文件
	 * @param integer $uid 用户UID
	 * @return object 头像模型对象
	 */
	public function __construct($uid) {
		if(!$uid)
			$uid = intval($_SESSION['mid']);
		$this->_uid = intval($uid);
		return $this;
	}

	/**
	 * 初始化模型，加载相应的文件
	 * @param integer $uid 用户UID
	 * @return object 头像模型对象
	 */
	public function init($uid) {
		$this->_uid = intval($uid);
		return $this;
	}

	/**
	 * 获取当前登录用户头像
	 * @return array 用户的头像链接
	 */
	public function getUserAvatar() {
		$empty_url = THEME_URL.'/_static/image/noavatar';
		$avatar_url = array(
			'avatar_original' 	=> $empty_url.'/big.jpg',
			'avatar_big' 		=> $empty_url.'/big.jpg',
			'avatar_middle' 	=> $empty_url.'/middle.jpg',
			'avatar_small' 		=> $empty_url.'/small.jpg',
			'avatar_tiny' 		=> $empty_url.'/tiny.jpg'
		); 

		$original_file_name = '/avatar'.$this->convertUidToPath($this->_uid).'/original.jpg';

		//头像云存储
		$cloud = model('CloudImage');
        if($cloud->isOpen()){
        	$original_file_info = $cloud->getFileInfo($original_file_name);
        	if($original_file_info){
	        	$filemtime = @intval($original_file_info['date']);
	        	$avatar_url['avatar_original'] = getImageUrl($original_file_name);
	        	$avatar_url['avatar_big'] = getImageUrl($original_file_name).'!big.avatar.jpg?v'.$filemtime;
	        	$avatar_url['avatar_middle'] = getImageUrl($original_file_name).'!middle.avatar.jpg?v'.$filemtime;
	        	$avatar_url['avatar_small'] = getImageUrl($original_file_name).'!small.avatar.jpg?v'.$filemtime;
	        	$avatar_url['avatar_tiny'] = getImageUrl($original_file_name).'!tiny.avatar.jpg?v'.$filemtime;
        	}
        	
        //头像本地存储
        }elseif(file_exists(UPLOAD_PATH.$original_file_name)){
    		$filemtime = @filemtime(UPLOAD_PATH.$original_file_name);
    		$avatar_url['avatar_original'] = getImageUrl($original_file_name);
			$avatar_url['avatar_big'] = getImageUrl($original_file_name,200,200).'?v'.$filemtime;
	    	$avatar_url['avatar_middle'] = getImageUrl($original_file_name,100,100).'?v'.$filemtime;
	    	$avatar_url['avatar_small'] = getImageUrl($original_file_name,50,50).'?v'.$filemtime;
	    	$avatar_url['avatar_tiny'] = getImageUrl($original_file_name,30,30).'?v'.$filemtime;
    	}

		return $avatar_url;
	}

	/**
	 * 保存Flash提交的数据 - flash上传
	 * @param array $data 用户头像的相关信息
	 * @param array $oldUserInfo 貌似无用字段，与此flash组件有关
	 * @return boolean 是否保存成功
	 */
	public function saveUploadAvatar($data, $oldUserInfo) {
		$original_file_name = '/avatar'.$this->convertUidToPath($this->_uid).'/original.jpg';
		Log::write(var_export($data));
		//如果是又拍上传
        $cloud = model('CloudImage');
        if($cloud->isOpen()){
        	@$cloud->deleteFile($original_file_name);
        	//重新上传新头像原图
        	$imageAsString = $data['big'];
        	$res = $cloud->writeFile($original_file_name,$imageAsString,true);
        }else{
        	$res = file_put_contents(UPLOAD_PATH.$original_file_name, $data['big']);
			getThumbImage($original_file_name,200,200,true,true);
			getThumbImage($original_file_name,100,100,true,true);
			getThumbImage($original_file_name,50,50,true,true);
			getThumbImage($original_file_name,30,30,true,true);
        }

        if(!$res){
        	return false;
        }else{
		    // 清理用户缓存
		    model('User')->cleanCache($this->_uid);
			return true;
        }
	}

    /**
     * 上传头像
     * @return array 上传头像操作信息
     */
    public function upload() {
		$data['attach_type'] = 'avatar';
        $data['upload_type'] = 'image';
        $info = model('Attach')->upload($data);
    	if($info['status']){
    		$data = $info['info'][0];
    		$image_url = getImageUrl($data['save_path'].$data['save_name']);
    		$image_info = getimagesize($image_url);
    		if($image_info){
    			unset($return);
    			$return['data']['picwidth'] = $image_info[0];
    			$return['data']['picheight'] = $image_info[1];
    			$return['data']['picurl'] 	 = $data['save_path'].$data['save_name'];
    			$return['data']['fullpicurl'] = getImageUrl($data['save_path'].$data['save_name']);
    			$return['status'] = '1';
    			if($image_info[0] < 300){
    				die(json_encode(array('status'=>0,'info'=>'请选择一个较大的照片作为头像，宽度不小于300px')));
    			}else{
    				die(json_encode($return));
    			}
    		}else{
    			die(json_encode(array('status'=>0,'info'=>'不是有效的图片格式，请重新选择照片上传')));
    		}
    	}else{
    		die(json_encode(array('status'=>0,'info'=>$info['info'])));
    	}
    }

    /**
     * 保存用户头像图片 - 本地上传
     * @return array 头像图片信息
     */
    public function dosave() {
    	//header("Content-type: image/jpeg"); 
		$picWidth = intval($_POST['picwidth']); //原图的宽度
		$scale = $picWidth/300;	//缩放比例
		$x1 = intval($_POST['x1'])*$scale;		// 选择区域左上角x轴坐标
		$y1 = intval($_POST['y1'])*$scale;		// 选择区域左上角y轴坐标
		$x2 = intval($_POST['x2'])*$scale;		// 选择区域右下角x轴坐标
		$y2 = intval($_POST['y2'])*$scale;		// 选择区域右下角x轴坐标
		$w  = intval($_POST['w'])*$scale;		// 选择区的宽度
		$h  = intval($_POST['h'])*$scale;		// 选择区的高度

		$src = getImageUrl($_POST['picurl']);	// 图片的路径

		//原图存储地址
		$original_file_name = '/avatar'.$this->convertUidToPath($this->_uid).'/original.jpg';

		//切割原图
		require_once SITE_PATH.'/addons/library/phpthumb/ThumbLib.inc.php';
		$thumb = PhpThumbFactory::create($src);
		$res = $thumb->crop($x1, $y1, $w, $h);

		//获取获取缩图后的数据
		if(!$res){
			die(json_encode(array('status'=>0,'info'=>'头像切割失败')));
		}

		$filemtime = microtime(true);

		//如果是又拍上传
        $cloud = model('CloudImage');
        if($cloud->isOpen()){
        	@$cloud->deleteFile($original_file_name);
        	//重新上传新头像原图
        	$imageAsString = $thumb->getImageAsString();
        	$res = $cloud->writeFile($original_file_name,$imageAsString,true);
        	if($res){
	 			unset($return);
	 			$return['data']['big'] 		= getImageUrl($original_file_name).'!big.avatar.jpg?v'.$filemtime;
				$return['data']['middle'] 	= getImageUrl($original_file_name).'!middle.avatar.jpg?v'.$filemtime;
				$return['data']['small'] 	= getImageUrl($original_file_name).'!small.avatar.jpg?v'.$filemtime;
				$return['data']['tiny'] 	= getImageUrl($original_file_name).'!tiny.avatar.jpg?v'.$filemtime;
				$return['status'] = 1;
			    // 清理用户缓存
	    		model('User')->cleanCache($this->_uid);
        	}else{
        		$return['status'] = '0';
        		$return['info']	  = '切割头像失败';
        	}
        }else{
        	if(!file_exists(UPLOAD_PATH.$original_file_name)) {
        		$this->_createFolder(UPLOAD_PATH.'/avatar'.$this->convertUidToPath($this->_uid));
        	}
			$thumb->save(UPLOAD_PATH.$original_file_name);
			unset($return);
			$return['data']['big'] 		= getImageUrl($original_file_name,200,200,true,true).'?v'.$filemtime;
			$return['data']['middle'] 	= getImageUrl($original_file_name,100,100,true,true).'?v'.$filemtime;
			$return['data']['small'] 	= getImageUrl($original_file_name,50,50,true,true).'?v'.$filemtime;
			$return['data']['tiny'] 	= getImageUrl($original_file_name,30,30,true,true).'?v'.$filemtime;
		    $return['status'] = 1;
        }

        die(json_encode($return));
    }

	/**
	 * 将用户的UID转换为三级路径
	 * @param integer $uid 用户UID
	 * @return string 用户路径
	 */
	public function convertUidToPath($uid) {
		// 静态缓存
		$sc = static_cache('avatar_uidpath_'.$uid);
		if(!empty($sc)) {
			return $sc;
		}
		$md5 = md5($uid);
		$sc = '/'.substr($md5, 0, 2).'/'.substr($md5, 2, 2).'/'.substr($md5, 4, 2);
		static_cache('avatar_uidpath_'.$uid, $sc);
		return $sc;
	}

	/**
	 * 创建多级文件目录
	 * @param string $path 路径名称
	 * @return void
	 */
	private function _createFolder($path)
	{
		if(!is_dir($path)) {
			$this->_createFolder(dirname($path));
			mkdir($path, 0777, true);
		}
	}
}