<?php

defined('IN_SYSTEM') === false && exit('PHPnew Blog.');

function fun_http_build_query($data, $prefix='', $sep='&', $key='') { 
     $ret = array();
     is_array($data) === false && $data = array();
     foreach ($data as $k => $v) { 
         if (is_int($k) && $prefix != null) { 
             $k = urlencode($prefix . $k);
         } 
         if ((!empty($key)) || ($key === 0))  $k = $key.'['.urlencode($k).']'; 
         if (is_array($v) || is_object($v)) { 
             array_push($ret, fun_http_build_query($v, '', $sep, $k)); 
         } else { 
             array_push($ret, $k.'='.urlencode($v)); 
         } 
     } 
     if (empty($sep)) $sep = ini_get('arg_separator.output'); 
     return implode($sep, $ret); 
 }

// 兼容性的trim
function fun_trim($string, $trim_str,$state = false){ 
    if(isset($string) === false || isset($trim_str) === false){
        return $string;
    }
    $string = trim($string);
    $lines = explode($trim_str, $string);
    $data = array();
    $len = count($lines);
    if($state === 0 || $state === false){
        $l = 0;
        for($i = 0; $i < $len; $i++ ){
            if($lines[$i] === '' && $l ===  0){
                unset($lines[$i]);
                break;
            }else if($l === 0 && $lines[$i]){
                $l = 1;
            }
        }
    }
    if($state === 1 || $state === false){
        $r = 0;
        for($i = $len; $i > 0; $i-- ){
            if($lines[$i] === '' && $r ===  0){
                unset($lines[$i]);
                break;
            }else if($r === 0 && $lines[$i]){
                $r = 1;
            }
        }
    }
    
    if(empty($lines) === true)
        return $string;
    
    return implode($trim_str,$lines);
}

// 日志功能
function fun_log($path,$data = 0,$t = FILE_APPEND){
    global $_config;
    if(is_file($path) === false){
        $data = $path;
        $path = DIR_ROOT.'/Data/run_log/'.strtoupper(md5($_config['default']['ankey']));
    }

    if(is_file($path) === true && filesize($path) >= 10000000){
        $new_file = $path = DIR_ROOT.'/Data/run_log/log_'.md5(GET_TIME.$_config['default']['ankey']);
        rename($path,$new_file);
        if(is_file($path) === true)
            unlink($path);
    }
    
    $fileend = $t | LOCK_EX;
    # 最后写入文件.
    fun_put_contents($path,$data,$fileend);
}

// 返回所有分类, 缓存
function fun_get_cat(){
    $query = mysql::query("SELECT c_id,c_name,c_tags,c_asc,c_tpl FROM DB_cat ORDER BY c_id ASC");
    $return_array = array();
    while(($row = mysql::fetch_array($query)) !== false){
        $row['link'] = fun_parse_url("./index.php?main=cat&{$row['c_id']}.html");
        $row['rss_link'] = fun_parse_url("./index.php?main=rss&cats={$row['c_id']}.html");
        $row['c_tags'] = nl2br($row['c_tags']);
        $return_array[$row['c_id']] = $row;
    }
    
    # 排序并且保持key值
    $return_arrays = fun_array_sort($return_array,array('c_asc'=>SORT_DESC, 'c_id'=>SORT_DESC));
    $return_array = $meun_array = array();
    $i = 0;
    foreach($return_arrays as $val){
        $golink = 0;
        $return_array[$val['c_id']] = $val;
        $return_array[$val['c_id']]['c_name'] = strip_tags($return_array[$val['c_id']]['c_name']);
        $val['blank'] = 0;
        #如果有纯url的说明则理解为跳转
        if(strpos($val['c_tags'],'link:') === 0){
            $val['link'] = fun_trim($val['c_tags'],'link:',0);
            if(strpos($val['link'], 'http') !== false)
                $val['blank'] = 1;
            $val['rss_link'] = $val['c_tags'] = 0;
            unset($return_array[$val['c_id']]);
            $golink = 1;
        }
        # 过滤出可以在导航上显示的栏目
        if((empty($val['c_asc']) === false || $golink === 1) && $i < 10){
            $return_array['meun'][$val['c_id']] = $val;
            $i++;
        }
    }
    return $return_array;
}

// 修正url的转换
function fun_parse_url($url,$state = 1){
    global $_CFG;
    if(empty($url) === true)
        return false;
        
    # 转换过程很简单, 替换几个符号即可.
    if(empty($_CFG['htaccess']) === false && $state === 1 && strpos($url,'.php?') !== false){
        $url = strtr(fun_trim($url,'.html').'.html', array(URL_HOST=>'./','.php?'=>'/','&'=>'/','='=>'/'));
    }else{
        $url = strtr(fun_trim($url,'.html').'.html', array(URL_HOST=>'./'));
    }
     $url = strtr($url,array('.php.html'=>'.php'));
     return $url;
}

// 排序函数
function fun_array_sort($array, $cols){
     $colarr = array();
     foreach ($cols AS $col => $order) {
         $colarr[$col] = array();
         foreach ($array AS $k => $row) { $colarr[$col]['_'.$k] = strtolower($row[$col]); }
     }
     $eval = 'array_multisort(';
     foreach ($cols AS $col => $order) {
         $eval .= '$colarr[\''.$col.'\'],'.$order.',';
     }
     $eval = substr($eval,0,-1).');';
     eval($eval);
     $ret = array();
     foreach ($colarr AS $col => $arr) {
         foreach ($arr AS $k => $v) {
             $k = substr($k,1);
             if (!isset($ret[$k])) $ret[$k] = $array[$k];
             $ret[$k][$col] = $array[$k][$col];
         }
     }
     return $ret;
}

function fun_source($keys='',$vals = 0,$types = 0){ 
    $types = addslashes($types);
    $keys = fun_enhtml($keys);
    if($vals === 0){
        $one = mysql::get_one("SELECT `vals` FROM DB_source WHERE `keys`='$keys'");
        $return_data = array();
        if(empty($one['vals']) === false)
            parse_str($one['vals'],$return_data);
        unset($one,$keys);
        return $return_data;
    }else{
        if(empty($vals) === false && is_array($vals) === false){
            $newdata = array();
            $newdata[] = $vals;
        }else{
            $newdata = $vals;
        }
        unset($vals);
        
        $newdata = fun_http_build_query($newdata);
        mysql::query("REPLACE INTO DB_source(`keys`,`vals`,`types`) VALUES ('$keys','$newdata','$types')");
    }
    return true;
}

function fun_getlogo($uid,$logo=0){
    if(!$logo){
        return './Data/user_logo/logo.jpg';
    }else{
        if(is_file("./Data/user_logo/{$uid}.jpg") === false)
            $logo = 0;
        return $logo?"./Data/user_logo/{$uid}.jpg":'./Data/user_logo/logo.jpg';
    }
}

function fun_get_contents($filename , $second = 10){
    if(empty($filename) === true)
        return false;
    $second += 0;
    if(function_exists('file_get_contents') === true && is_file($filename) === false){
        $opts = array(  
            'http'=>array(  
            'method'=>"GET",
            'timeout'=>$second,
            )  
        );  
        $context = stream_context_create($opts);
        return file_get_contents($filename, false, $context);
        exit();
    }
     if (false === $fh = fopen($filename, 'rb')) {
         return false;
     }
     clearstatcache();
     if ($fsize = filesize($filename)) {
         $data = fread($fh, $fsize);
     } else {
         $data = '';
         while (!feof($fh)) {
             $data .= fread($fh, 1024);
         }
     }
     fclose($fh);
     return $data;
}


function fun_put_contents($filename, $data, $lock = false) {
    if(empty($lock) === false && function_exists('file_put_contents')){
        return file_put_contents($filename, $data, $lock);
    }else{
       $f = fopen($filename, 'w');
       if (!$f) {
           return false;
       } else {
            if (flock($fp, LOCK_EX)){
               $bytes = fwrite($f, $data);
               flock($fp, LOCK_UN);
            }
            fclose($f);
           return $bytes;
       }
    }
}

function fun_post_contents($url,$headers=true) {
   $url = parse_url($url);
   if (!isset($url['port'])) {
     if ($url['scheme'] == 'http') { $url['port']=80; }
     elseif ($url['scheme'] == 'https') { $url['port']=443; }
   }
   $url['query']=isset($url['query'])?$url['query']:'';
   $url['protocol']=$url['scheme'].'://';
   $eol="\r\n";
   $headers =  "POST ".$url['protocol'].$url['host'].$url['path']." HTTP/1.0".$eol.
               "Host: ".$url['host'].$eol.
               "Referer: ".$url['protocol'].$url['host'].$url['path'].$eol.
               "Content-Type: application/x-www-form-urlencoded".$eol.
               "Content-Length: ".strlen($url['query']).$eol.
               $eol.$url['query'];
   $fp = fsockopen($url['host'], $url['port'], $errno, $errstr, 30);
   if($fp) {
     fputs($fp, $headers);
     $result = '';
     while(!feof($fp)) { $result .= fgets($fp, 128); }
     fclose($fp);
     if (!$headers) {
       //removes headers
       $pattern="/^.*\r\n\r\n/s";
       $result=preg_replace($pattern,'',$result);
     }
     return $result;
   }
}

//取得连接
function fun_geturl($url_array ,$second=29) {
    if(empty($url_array) === true)
        return false;
    $second += 0;
    $query_state = 0; 
    if(is_array($url_array) === false){
        $query_state = 1;
        $url_array = array($url_array);
    }
    set_time_limit(0);
    if(function_exists('curl_init') === false){
        foreach($url_array as $key => $url) {
            $url_array[$key] = file_get_contents($url);
        }
        # 只有一条时将直接返回数据.
        if($query_state === 1) {
            return $url_array[0];
        } else {
            return $url_array;
        }
    }
    
    static $data = array();
    static $error_url = array();
    static $sort_url = array();
    if(empty($sort_url) === true)
        $sort_url = array_keys($url_array);
    $handle = array();
    $queue = curl_multi_init(); // multi curl handler
    $i = 0;
    foreach($url_array as $key => $url) {
        $i ++;
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_REFERER,$url);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1); // return don't print
        curl_setopt($ch,CURLOPT_TIMEOUT,$second);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        if(stripos($url,"https://") !== false){
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }
        
        curl_setopt($ch,CURLOPT_USERAGENT,'Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 5.1; Trident/4.0; TencentTraveler 4.0; Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 5.1; SV1) ; InfoPath.2)');
		if ((ini_get('open_basedir') == '') && (ini_get('safe_mode') == 'Off' || !ini_get('safe_mode'))){
			curl_setopt($ch,CURLOPT_FOLLOWLOCATION,1); // 302 redirect
			curl_setopt($ch,CURLOPT_MAXREDIRS,7);
	   }

        curl_multi_add_handle($queue,$ch); // 把 curl resource 放进 multi curl handler 里
        $handle[(string) $ch] = $key;
        if($i >= 20)
            break;
    }

    $responses = $run_err = array(); 
    do { 
        while (($code = curl_multi_exec($queue, $active)) == CURLM_CALL_MULTI_PERFORM) ;
        if ($code != CURLM_OK) { break; } 
        while ($done = curl_multi_info_read($queue)) { 
            $ikey = $handle[(string) $done['handle']];
            $data[$ikey] = curl_multi_getcontent($done['handle']);

            # 对无法取到信息的补取一次.
            if($data[$ikey] === null && empty($error_url[$ikey]) === true){
                $run_err[$ikey] = $url_array[$ikey]; 
                $error_url[$ikey] = 1;
            }else{
                unset($error_url[$ikey]);
            }
            
            unset($url_array[$ikey]);
            curl_multi_remove_handle($queue, $done['handle']); 
            curl_close($done['handle']);
        } 
         if ($active > 0) {
            curl_multi_select($queue, $i);
        } 
  
    } while ($active);
    curl_multi_close($queue); 
    
    if(empty($run_err) === false){
        fun_geturl($run_err);
    }
    
    if(empty($url_array) === false){
        fun_geturl($url_array);
    }
    
    # 只有一条时将直接返回数据.
    if($query_state === 1) {
        return $data[0];
    } else {
        # 排列顺序
        $newarr = array();
        foreach($sort_url AS $val)
            $newarr[$val] = $data[$val];
        return $newarr;
    }
}

function fun_mimetype($filepre) {
	$a = array(
			'rar'=>'application/x-rar-compressed',
			'ez' => 'application/andrew-inset',
			'hqx' => 'application/mac-binhex40',
			'cpt' => 'application/mac-compactpro',
			'doc' => 'application/msword',
			'bin' => 'application/octet-stream',
			'dms' => 'application/octet-stream',
			'lha' => 'application/octet-stream',
			'lzh' => 'application/octet-stream',
			'exe' => 'application/octet-stream',
			'class' => 'application/octet-stream',
			'so' => 'application/octet-stream',
			'dll' => 'application/octet-stream',
			'oda' => 'application/oda',
			'pdf' => 'application/pdf',
			'ai' => 'application/postscrīpt',
			'eps' => 'application/postscrīpt',
			'ps' => 'application/postscrīpt',
			'smi' => 'application/smil',
			'smil' => 'application/smil',
			'mif' => 'application/vnd.mif',
			'xls' => 'application/vnd.ms-excel',
			'ppt' => 'application/vnd.ms-powerpoint',
			'wbxml' => 'application/vnd.wap.wbxml',
			'wmlc' => 'application/vnd.wap.wmlc',
			'wmlsc' => 'application/vnd.wap.wmlscrīptc',
			'bcpio' => 'application/x-bcpio',
			'vcd' => 'application/x-cdlink',
			'pgn' => 'application/x-chess-pgn',
			'cpio' => 'application/x-cpio',
			'csh' => 'application/x-csh',
			'dcr' => 'application/x-director',
			'dir' => 'application/x-director',
			'dxr' => 'application/x-director',
			'dvi' => 'application/x-dvi',
			'spl' => 'application/x-futuresplash',
			'gtar' => 'application/x-gtar',
			'hdf' => 'application/x-hdf',
			'js' => 'application/x-javascrīpt',
			'skp' => 'application/x-koan',
			'skd' => 'application/x-koan',
			'skt' => 'application/x-koan',
			'skm' => 'application/x-koan',
			'latex' => 'application/x-latex',
			'nc' => 'application/x-netcdf',
			'cdf' => 'application/x-netcdf',
			'sh' => 'application/x-sh',
			'shar' => 'application/x-shar',
			'swf' => 'application/x-shockwave-flash',
			'sit' => 'application/x-stuffit',
			'sv4cpio' => 'application/x-sv4cpio',
			'sv4crc' => 'application/x-sv4crc',
			'tar' => 'application/x-tar',
			'tcl' => 'application/x-tcl',
			'tex' => 'application/x-tex',
			'texinfo' => 'application/x-texinfo',
			'texi' => 'application/x-texinfo',
			't' => 'application/x-troff',
			'tr' => 'application/x-troff',
			'roff' => 'application/x-troff',
			'man' => 'application/x-troff-man',
			'me' => 'application/x-troff-me',
			'ms' => 'application/x-troff-ms',
			'ustar' => 'application/x-ustar',
			'src' => 'application/x-wais-source',
			'xhtml' => 'application/xhtml+xml',
			'xht' => 'application/xhtml+xml',
			'zip' => 'application/zip',
			'au' => 'audio/basic',
			'snd' => 'audio/basic',
			'mid' => 'audio/midi',
			'midi' => 'audio/midi',
			'kar' => 'audio/midi',
			'mpga' => 'audio/mpeg',
			'mp2' => 'audio/mpeg',
			'mp3' => 'audio/mpeg',
			'wma' => 'audio/mpeg',
			'aif' => 'audio/x-aiff',
			'aiff' => 'audio/x-aiff',
			'aifc' => 'audio/x-aiff',
			'm3u' => 'audio/x-mpegurl',
			'ram' => 'audio/x-pn-realaudio',
			'rm' => 'audio/x-pn-realaudio',
			'rpm' => 'audio/x-pn-realaudio-plugin',
			'ra' => 'audio/x-realaudio',
			'wav' => 'audio/x-wav',
			'pdb' => 'chemical/x-pdb',
			'xyz' => 'chemical/x-xyz',
			'bmp' => 'image/bmp',
			'gif' => 'image/gif',
			'ief' => 'image/ief',
			'jpeg' => 'image/jpeg',
			'jpg' => 'image/pjpeg',
			'jpe' => 'image/jpeg',
			'png' => 'image/png',
			'tiff' => 'image/tiff',
			'tif' => 'image/tiff',
			'djvu' => 'image/vnd.djvu',
			'djv' => 'image/vnd.djvu',
			'wbmp' => 'image/vnd.wap.wbmp',
			'ras' => 'image/x-cmu-raster',
			'pnm' => 'image/x-portable-anymap',
			'pbm' => 'image/x-portable-bitmap',
			'pgm' => 'image/x-portable-graymap',
			'ppm' => 'image/x-portable-pixmap',
			'rgb' => 'image/x-rgb',
			'xbm' => 'image/x-xbitmap',
			'xpm' => 'image/x-xpixmap',
			'xwd' => 'image/x-xwindowdump',
			'igs' => 'model/iges',
			'iges' => 'model/iges',
			'msh' => 'model/mesh',
			'mesh' => 'model/mesh',
			'silo' => 'model/mesh',
			'wrl' => 'model/vrml',
			'vrml' => 'model/vrml',
			'css' => 'text/css',
			'html' => 'text/html',
			'htm' => 'text/html',
			'asc' => 'text/plain',
			'txt' => 'text/plain',
			'rtx' => 'text/richtext',
			'rtf' => 'text/rtf',
			'sgml' => 'text/sgml',
			'sgm' => 'text/sgml',
			'tsv' => 'text/tab-separated-values',
			'wml' => 'text/vnd.wap.wml',
			'wmls' => 'text/vnd.wap.wmlscrīpt',
			'etx' => 'text/x-setext',
			'xsl' => 'text/xml',
			'xml' => 'text/xml',
			'mpeg' => 'video/mpeg',
			'mpg' => 'video/mpeg',
			'mpe' => 'video/mpeg',
			'qt' => 'video/quicktime',
			'mov' => 'video/quicktime',
			'mxu' => 'video/vnd.mpegurl',
			'avi' => 'video/x-msvideo',
			'movie' => 'video/x-sgi-movie',
			'wmv' => 'application/x-mplayer2',
			'ice' => 'x-conference/x-cooltalk',
		);
		$filepre = trim(strtolower($filepre),'.');
		if(empty($a[$filepre]) === true)
			return false;
		return $a[$filepre];
}

function fun_thread_url($tid) {
    $tid += 0;
    if($tid === 0)
        return './index.php';
	return "./index/main/thread/{$tid}.html";
}

function fun_message($mess = false,$url=false,$times=2){
    define('SHOWMESS',true);
	$GLOBALS['mess'] = $mess;
    if($url === 1){
        $i = 1;
       $url = $mess;
    }
	if(empty($url) === false && strpos($url, 'http://') === false){
		$url =URL_HOST.ltrim(strtr($url,array('./'=>'')),'/');
	}
    if($i === 1){
        fun_header($url);
        exit();
    }
    $GLOBALS['html']['title'] = '温馨提示';
	$GLOBALS['url'] = empty($url) === true?fun_referer():$url;
	$times += 0;
	header("refresh:$times;url={$GLOBALS['url']}");
	common_function_template('showmessage');
	exit();
}

function fun_setcookie($var, $value = '', $life = 0, $prefix = 1, $httponly = false) {
	global $_config;
	$config = $_config['cookie'];
	$var = ($prefix ? $config['cookiepre'] : '').$var;
	if($value == '' || $life < 0) {
		$value = '';
		$life = -1;
	}

	$life = $life > 0 ? time() + $life : ($life < 0 ? time() - 31536000 : 0);
	$path = $httponly && PHP_VERSION < '5.2.0' ? $config['cookiepath'].'; HttpOnly' : $config['cookiepath'];

	$secure = $_SERVER['SERVER_PORT'] == 443 ? 1 : 0;

	if(PHP_VERSION < '5.2.0') {
		setcookie($var, $value, $life, $path, $config['cookiedomain'], $secure);
	} else {
		setcookie($var, $value, $life, $path, $config['cookiedomain'], $secure, $httponly);
	}
}

function fun_getcookie($name,$prefix=0){
	global $_config;
	$config = $_config['cookie'];
	$name = ($prefix ? $prefix:$config['cookiepre']).$name;
	if(isset($_COOKIE[$name])){
		if(function_exists('get_magic_quotes_gpc') === true && get_magic_quotes_gpc())
			$_COOKIE[$name] = stripslashes($_COOKIE[$name]);
		return $_COOKIE[$name];
	}
	return false;
}

function fun_getrobot() {
	if(!defined('IS_ROBOT')) {
		$kw_spiders = 'Bot|Crawl|Spider|slurp|sohu-search|lycos|robozilla';
		$kw_browsers = 'MSIE|Netscape|Opera|Konqueror|Mozilla';
		if(!strexists($_SERVER['HTTP_USER_AGENT'], 'http://') && preg_match("/($kw_browsers)/i", $_SERVER['HTTP_USER_AGENT'])) {
			define('IS_ROBOT', FALSE);
		} elseif(preg_match("/($kw_spiders)/i", $_SERVER['HTTP_USER_AGENT'])) {
			define('IS_ROBOT', TRUE);
		} else {
			define('IS_ROBOT', FALSE);
		}
	}
	return IS_ROBOT;
}


function fun_get_ip(){
       $ip=false;
       if(!empty($_SERVER["HTTP_CLIENT_IP"])){
            $ip = $_SERVER["HTTP_CLIENT_IP"];
       }
       if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
            $ips = explode (", ", $_SERVER['HTTP_X_FORWARDED_FOR']);
            if ($ip){
                     array_unshift($ips, $ip); $ip = FALSE;
            }
            for ($i = 0; $i < count($ips); $i++){
                     if (!eregi ("^(10|172\.16|192\.168)\.", $ips[$i])){
                               $ip = $ips[$i];
                               break;
                     }
            }
       }
       return ($ip ? $ip : $_SERVER['REMOTE_ADDR']);
}

function fun_parse_var(){
		$list = array();
		$ietm = unserialize('a:77:{i:0;s:7:"GLOBALS";i:1;s:4:"_ENV";i:2;s:13:"HTTP_ENV_VARS";i:3;s:15:"ALLUSERSPROFILE";i:4;s:18:"CommonProgramFiles";i:5;s:12:"COMPUTERNAME";i:6;s:7:"ComSpec";i:7;s:16:"FP_NO_HOST_CHECK";i:8;s:20:"NUMBER_OF_PROCESSORS";i:9;s:2:"OS";i:10;s:4:"Path";i:11;s:7:"PATHEXT";i:12;s:22:"PROCESSOR_ARCHITECTURE";i:13;s:20:"PROCESSOR_IDENTIFIER";i:14;s:15:"PROCESSOR_LEVEL";i:15;s:18:"PROCESSOR_REVISION";i:16;s:12:"ProgramFiles";i:17;s:11:"SystemDrive";i:18;s:10:"SystemRoot";i:19;s:4:"TEMP";i:20;s:3:"TMP";i:21;s:11:"USERPROFILE";i:22;s:17:"VBOX_INSTALL_PATH";i:23;s:6:"windir";i:24;s:13:"AP_PARENT_PID";i:25;s:16:"uchome_loginuser";i:26;s:15:"supe_cookietime";i:27;s:9:"supe_auth";i:28;s:14:"Mwp6_lastvisit";i:29;s:18:"Mwp6_home_readfeed";i:30;s:10:"Mwp6_smile";i:31;s:16:"Mwp6_onlineindex";i:32;s:8:"Mwp6_sid";i:33;s:12:"Mwp6_lastact";i:34;s:9:"PHPSESSID";i:35;s:11:"HTTP_ACCEPT";i:36;s:12:"HTTP_REFERER";i:37;s:20:"HTTP_ACCEPT_LANGUAGE";i:38;s:15:"HTTP_USER_AGENT";i:39;s:20:"HTTP_ACCEPT_ENCODING";i:40;s:9:"HTTP_HOST";i:41;s:15:"HTTP_CONNECTION";i:42;s:11:"HTTP_COOKIE";i:43;s:4:"PATH";i:44;s:7:"COMSPEC";i:45;s:6:"WINDIR";i:46;s:16:"SERVER_SIGNATURE";i:47;s:15:"SERVER_SOFTWARE";i:48;s:11:"SERVER_NAME";i:49;s:11:"SERVER_ADDR";i:50;s:11:"SERVER_PORT";i:51;s:11:"REMOTE_ADDR";i:52;s:13:"DOCUMENT_ROOT";i:53;s:12:"SERVER_ADMIN";i:54;s:15:"SCRIPT_FILENAME";i:55;s:11:"REMOTE_PORT";i:56;s:17:"GATEWAY_INTERFACE";i:57;s:15:"SERVER_PROTOCOL";i:58;s:14:"REQUEST_METHOD";i:59;s:12:"QUERY_STRING";i:60;s:11:"REQUEST_URI";i:61;s:11:"SCRIPT_NAME";i:62;s:8:"PHP_SELF";i:63;s:12:"REQUEST_TIME";i:64;s:4:"argv";i:65;s:4:"argc";i:66;s:5:"_POST";i:67;s:14:"HTTP_POST_VARS";i:68;s:4:"_GET";i:69;s:13:"HTTP_GET_VARS";i:70;s:7:"_COOKIE";i:71;s:16:"HTTP_COOKIE_VARS";i:72;s:7:"_SERVER";i:73;s:16:"HTTP_SERVER_VARS";i:74;s:6:"_FILES";i:75;s:15:"HTTP_POST_FILES";i:76;s:8:"_REQUEST";}');
		$temp_list = $GLOBALS;
		foreach ($temp_list as $key => $val){
			if(in_array($key,$ietm) === false)
				$list[$key] = $val;
		}
		return $list;
}

function fun_debug($var = null) {
	echo '<pre>';
	if($var === null) {
		print_r($GLOBALS);
	} else {
		if(is_string($var) === true){
			echo 'String:<br> '.$var;
		}else {
			echo 'Array:<br> '.var_export($var,true);
		}
	}
	exit('</pre>');
}

function fun_stripslashes($string) {
	/* 强行为数据反转义 */
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = fun_stripslashes($val);
		}
	} else {
		$string = stripslashes($string);
	}
	return $string;
}

function fun_cutstr($string, $length, $dot = ' ...') {
	/* 截取字符串指定长度 */
	if(strlen($string) <= $length) {
		return $string;
	}

	$pre = '{%';
	$end = '%}';
	$string = str_replace(array('&amp;', '&quot;', '&lt;', '&gt;'), array($pre.'&'.$end, $pre.'"'.$end, $pre.'<'.$end, $pre.'>'.$end), $string);

	$strcut = '';
	if(strtolower(CHARSET) == 'utf-8') {
		$n = $tn = $noc = 0;
		while($n < strlen($string)) {

			$t = ord($string[$n]);
			if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1; $n++; $noc++;
			} elseif(194 <= $t && $t <= 223) {
				$tn = 2; $n += 2; $noc += 2;
			} elseif(224 <= $t && $t <= 239) {
				$tn = 3; $n += 3; $noc += 2;
			} elseif(240 <= $t && $t <= 247) {
				$tn = 4; $n += 4; $noc += 2;
			} elseif(248 <= $t && $t <= 251) {
				$tn = 5; $n += 5; $noc += 2;
			} elseif($t == 252 || $t == 253) {
				$tn = 6; $n += 6; $noc += 2;
			} else {
				$n++;
			}

			if($noc >= $length) {
				break;
			}

		}
		if($noc > $length) {
			$n -= $tn;
		}

		$strcut = substr($string, 0, $n);

	} else {
		for($i = 0; $i < $length; $i++) {
			$strcut .= ord($string[$i]) > 127 ? $string[$i].$string[++$i] : $string[$i];
		}
	}

	$strcut = str_replace(array($pre.'&'.$end, $pre.'"'.$end, $pre.'<'.$end, $pre.'>'.$end), array('&amp;', '&quot;', '&lt;', '&gt;'), $strcut);

	return $strcut.$dot;
}

function fun_random($length, $numeric = 0) {
	/* 返回指定长度随机字符 $numeric 是否是数字*/
	$seed = base_convert(md5(microtime().$_SERVER['DOCUMENT_ROOT']), 16, $numeric ? 10 : 35);
	$seed = $numeric ? (str_replace('0', '', $seed).'012340567890') : ($seed.'zZ'.strtoupper($seed));
	$hash = '';
	$max = strlen($seed) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $seed{mt_rand(0, $max)};
	}
	return $hash;
}

function fun_isemail($email) {
	/* 判断是否为email */
	return strlen($email) > 6 && preg_match("/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/", $email);
}

function fun_authcode($string, $operation = 'ENCODE', $key = GET_ANKEY){
	$key = md5($key);
	$key_length = strlen($key);
	$string = $operation == 'DECODE' ? base64_decode($string) : substr(md5($string . $key), 0, 8) . $string;
	$string_length = strlen($string);
	$rndkey = $box = array();
	$result = '';
	for($i = 0; $i <= 255; $i ++){
		$rndkey[$i] = ord($key[$i % $key_length]);
		$box[$i] = $i;
	}
	for($j = $i = 0; $i < 256; $i ++){
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}
	for($a = $j = $i = 0; $i < $string_length; $i ++){
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}
	if($operation == 'DECODE'){
		if(substr($result, 0, 8) == substr(md5(substr($result, 8) . $key), 0, 8)){
			return substr($result, 8);
		} else{
			return '';
		}
	} else{
		return str_replace('=', '', base64_encode($result));
	}
}

function fun_fsockopen($url, $limit = 0, $post = '', $cookie = '', $bysocket = false, $ip = '', $timeout = 30, $block = true) {
	/* fsockopen函数 */
	$return = '';
	$matches = parse_url($url);
	$host = $matches['host'];
	$path = empty($matches['path']) === false? $matches['path'].($matches['query'] ? '?'.$matches['query'] : '') : '/';
	$port = !empty($matches['port']) ? $matches['port'] : 80;

	if($post) {
		$out = "POST $path HTTP/1.0\r\n";
		$out .= "Accept: */*\r\n";
		$out .= "Accept-Language: zh-cn\r\n";
		$out .= "Content-Type: application/x-www-form-urlencoded\r\n";
		$out .= "User-Agent: $_SERVER[HTTP_USER_AGENT]\r\n";
		$out .= "Host: $host\r\n";
		$out .= 'Content-Length: '.strlen($post)."\r\n";
		$out .= "Connection: Close\r\n";
		$out .= "Cache-Control: no-cache\r\n";
		$out .= "Cookie: $cookie\r\n\r\n";
		$out .= $post;
	} else {
		$out = "GET $path HTTP/1.0\r\n";
		$out .= "Accept: */*\r\n";
		$out .= "Accept-Language: zh-cn\r\n";
		$out .= "User-Agent: $_SERVER[HTTP_USER_AGENT]\r\n";
		$out .= "Host: $host\r\n";
		$out .= "Connection: Close\r\n";
		$out .= "Cookie: $cookie\r\n\r\n";
	}
    $hostname = ($ip ? $ip : $host);
    if(function_exists('fsockopen')) {
             $fp = @fsockopen($hostname, $port, $errno, $errstr, $timeout); 
     } elseif(function_exists('pfsockopen')) {
             $fp = @pfsockopen($hostname, $port, $errno, $errstr, $timeout);
     } elseif(function_exists('stream_socket_client')) {
             $fp = @stream_socket_client($hostname.':'.$port, $errno, $errstr, $timeout);
     }
	if(!$fp) {
		return '';
	} else {
		stream_set_blocking($fp, $block);
		stream_set_timeout($fp, $timeout);
		@fwrite($fp, $out);
		$status = stream_get_meta_data($fp);
		if(!$status['timed_out']) {
			while (!feof($fp)) {
				if(($header = @fgets($fp)) && ($header == "\r\n" ||  $header == "\n")) {
					break;
				}
			}

			$stop = false;
			while(!feof($fp) && !$stop) {
				$data = fread($fp, ($limit == 0 || $limit > 8192 ? 8192 : $limit));
				$return .= $data;
				if($limit) {
					$limit -= strlen($data);
					$stop = $limit <= 0;
				}
			}
		}
		@fclose($fp);
		return $return;
	}
}

function fun_enhtml($string) {
	/*  安全html码转义 */
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = fun_enhtml($val);
		}
	} else {
		$string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4}));)/', '&\\1',str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $string));
	}
	return $string;
}
function fun_isajax(){
    # 区分几种ajax返回值.
    if($_SERVER['HTTP_X_REQUESTED_WITH'] && $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest'){
         $data = 0;
        if(stripos($_SERVER['HTTP_ACCEPT'],'text/xml') !== false){
            $data = '<?xml version="1.0" encoding="ISO-8859-1"?>
    -<note><to>Ajax</to><from>Tuesday</from><heading>'.GET_DATE.'</heading><body>'.PHPNEW.'</body></note>';
        }else if(stripos($_SERVER['HTTP_ACCEPT'],'text/javascript') !== false){
            if(stripos($_SERVER['HTTP_ACCEPT'],'json') !== false){
                $data = json::encode(array());
            }else{
                $data = '<script type="text/javascript">alert("'.PHPNEW.'")</script>';
            }
        }
        echo $data;
        exit();
    }
}
function fun_header($url = 0) {
    if(empty($url) === true){
        $url = fun_referer();
    }else{
   	    if(empty($url) === false && strpos($url, 'http') !== 0){
		  $url = URL_HOST.ltrim(strtr($url,array('./'=>'')),'/');
	   }
    }
    fun_isajax();
    header('Location: '.$url);
    exit();
}

function fun_multi($num, $perpage, $curpage, $mpurl, $maxpages = 0, $page = 10, $autogoto = false, $simple = false) {
	$_G = array();
	$ajaxtarget = '';
	$a_name = '';
		$shownum = $showkbd = false;
		$lang['prev'] = '&lsaquo;&lsaquo;';
		$lang['next'] = '&rsaquo;&rsaquo;';

	$multipage = '';
	//$mpurl .= strpos($mpurl, '?') ? '&amp;' : '?';

	$realpages = 1;
	$_G['page_next'] = 0;
	if($num > $perpage) {
		$offset = 2;

		$realpages = @ceil($num / $perpage);
		$pages = $maxpages && $maxpages < $realpages ? $maxpages : $realpages;

		if($page > $pages) {
			$from = 1;
			$to = $pages;
		} else {
			$from = $curpage - $offset;
			$to = $from + $page - 1;
			if($from < 1) {
				$to = $curpage + 1 - $from;
				$from = 1;
				if($to - $from < $page) {
					$to = $page;
				}
			} elseif($to > $pages) {
				$from = $pages - $page + 1;
				$to = $pages;
			}
		}
		if($curpage>=100){
			$to = $from +5;
		}
		if($curpage>=1000){
			$to = $from+3;
		}
		$_G['page_next'] = $to;

		$multipage = ($curpage - $offset > 1 && $pages > $page ? '<a href="'.strtr($mpurl,array('{#1}'=>1)).$a_name.'" class="first"'.$ajaxtarget.'>Fir</a>' : '').
		($curpage > 1 && !$simple ? '<a href="'.strtr($mpurl,array('{#1}'=>($curpage - 1))).$a_name.'" class="prev"'.$ajaxtarget.'>'.$lang['prev'].'</a>' : '');
		for($i = $from; $i <= $to; $i++) {
			$url = strtr($mpurl,array('{#1}'=>$i));
			$multipage .= $i == $curpage ? '<strong>'.$i.'</strong>' :
			'<a href="'.$url.'">'.$i.'</a>';
		}

		$multipage .= (false ? '<a href="'.strtr($mpurl,array('{#1}'=>$pages)).'" class="last">End</a>' : '').
		($curpage < $pages && !$simple ? '<a href="'.strtr($mpurl,array('{#1}'=>($curpage + 1))).'" class="nxt"'.$ajaxtarget.'>'.$lang['next'].'</a>' : '').($showkbd && !$simple && $pages > $page && !$ajaxtarget ? '<kbd><input type="text" name="custompage" size="3" onkeydown="if(event.keyCode==13) {window.location=\''.$mpurl.'page=\'+this.value; doane(event);}" /></kbd>' : '');

		$multipage = $multipage ? '<div class="pg">'.($shownum && !$simple ? '<em>&nbsp;'.$num.'&nbsp;</em>' : '').$multipage.'</div>' : '';
	}
	$maxpage = $realpages;
	empty($multipage) === true && $multipage = '';
	return $multipage;
}

function fun_referer($default = '') {
	$referer = empty($default) === true?$_SERVER['HTTP_REFERER']:$default;
	empty($referer) === true && $referer = URL_HOST.'index.php';
	return strip_tags($referer);
}

function fun_sizecount($size) {
	if($size >= 1073741824) {
		$size = round($size / 1073741824 * 100) / 100 . ' GB';
	} elseif($size >= 1048576) {
		$size = round($size / 1048576 * 100) / 100 . ' MB';
	} elseif($size >= 1024) {
		$size = round($size / 1024 * 100) / 100 . ' KB';
	} else {
		$size = $size . ' Bytes';
	}
	return $size;
}

function fun_date($date_str, $times=0){
	empty($times) === true && $times = GET_TIME;
    if(is_numeric($date_str) == true){
        $times = $date_str;
        $date_str = 'Y-m-d H:i:s';
    }
	return gmdate($date_str,$times+GET_TIMEOFFSET);
}

/* 过滤危险html */
function fun_fillter_html( $str ) {
        /* 过滤样式正文 */
        function fillter_css( $str ) {
                /* 删除注释、javascript协议、表达式 */
                return preg_replace(array('/(\/\*((?!\*\/).)*\*\/|\/\*|\*\/)/i', '/expression\s*\((.*?\))?|javascript\s*\:/i',), '', $str);
        }
        /* 过滤style标签 */
        return preg_replace_callback(
                        /* 过滤style标签内容 */
                        '/(\<\s*style[^\>]*\>)((?:(?!\<\s*\/\s*style\s*\>).)*)(\<\s*\/\s*style\s*\>)?/i',
                        create_function('$str', 'return $str[1] . fillter_css($str[2]) . $str[3];'),
                        preg_replace(
                                array(
                                        /* 删除html注释 */
                                        '/\<\!\-\-.*?\-\-\>/i',
                                        /* 删除标签：script、link、object、embed、iframe、frame、frameset */
                                        '/\<\s*(script|object|embed|link|i?frame(set)?)[^\>]*\>(.*?\<\s*\/\s*\\1\s*\>)?/i',
                                        /* 删除事件、javascript协议、css表达式 */
                                        '/\<[^\>]+((on[a-z]+\s*\=|javascript\:[^\;\"\\\']|expression\s*\()[^\>]*)+\>?/i',
                                ),
                                '',
                                $str
                        )
        );
}


//返回程序当次运行所有的函数/常量/变量/及引入文件
function fun_vars($on=null){
 $array = array();
 $array['var'] = fun_parse_var();
 $func = get_defined_functions();
 $cons = get_defined_constants(true);
 $array['function'] = $func['user'];
 $array['constants'] = $cons['user'];
 $array['include'] = get_included_files();
 unset($array['_DCACHE']);
 $ons = array('变量'=>1,'数组'=>2,'函数'=>3,'常量'=>4,'文件'=>5);
 in_array($on,array_keys($ons)) &&  $on = $ons[$on];
   switch ($on){
       case null:
           return $array;
           break;
       case 1:   //变量
        return $array['var'];
        break;
       case 2:  //数组
           $arrays = array();
         foreach ($array as $key => $val){
            if(is_array($val)===true)
            $arrays[$key] = $val;
        }
        unset($arrays['function'],$arrays['include'],$arrays['constants']);
        return $arrays;
        break;
       case 3:   //函数
           return $array['function'];
           break;
       case 4:   //常量
        return $array['constants'];
        break;
       case 5:   //引入文件
           return $array['include'];
           break;
   }
}

function fun_ubb2html($Text) { 
       $Text= rtrim($Text);
       $Text=preg_replace("/\\t/is","  ",$Text); 
       $Text=preg_replace("/\[hr\]/is","<hr />",$Text); 
       $Text=preg_replace("/\[separator\]/is","<br />",$Text); 
       $Text=preg_replace("/\[h1\](.+?)\[\/h1\]/is","<h1>$1</h1>",$Text); 
       $Text=preg_replace("/\[h2\](.+?)\[\/h2\]/is","<h2>$1</h2>",$Text); 
       $Text=preg_replace("/\[h3\](.+?)\[\/h3\]/is","<h3>$1</h3>",$Text); 
       $Text=preg_replace("/\[h4\](.+?)\[\/h4\]/is","<h4>$1</h4>",$Text); 
       $Text=preg_replace("/\[h5\](.+?)\[\/h5\]/is","<h5>$1</h5>",$Text); 
       $Text=preg_replace("/\[h6\](.+?)\[\/h6\]/is","<h6>$1</h6>",$Text); 
       $Text=preg_replace("/\[center\](.+?)\[\/center\]/is",'<span style="text-align: center;">$1</span>',$Text); 
       $Text=preg_replace("/\[url\](.+?)\[\/url\]/is",'<a href="$1" target="_blank">$1</a>',$Text); 
       $Text=preg_replace("/\[url=(http:\/\/.+?)\](.+?)\[\/url\]/is",'<a href="$1" target="_blank">$2</a>',$Text); 
       $Text=preg_replace("/\[url=(.+?)\](.+?)\[\/url\]/is",'<a href="$1">$2</a>',$Text); 
       $Text=preg_replace("/\[img\](.+?)\[\/img\]/is",'<img src="$1" />',$Text); 
       $Text=preg_replace("/\[img\s(.+?)\](.+?)\[\/img\]/is",'<img $1 src="$2" />',$Text); 
       $Text=preg_replace("/\[color=(.+?)\](.+?)\[\/color\]/is",'<span style="color:$1">$2</span>',$Text);
       $Text=preg_replace("/\[size=(.+?)\](.+?)\[\/size\]/is",'<span style="font-size:$1">$2</span>',$Text); 
       $Text=preg_replace("/\[sup\](.+?)\[\/sup\]/is","<sup>$1</sup>",$Text); 
       $Text=preg_replace("/\[pre\](.+?)\[\/pre\]/is","<pre>$1</pre>",$Text);
       $Text=preg_replace("/\[email\](.+?)\[\/email\]/is",'<a href="mailto:$1">$1</a>',$Text); 
       $Text=preg_replace("/\[i\](.+?)\[\/i\]/is","<i>$1</i>",$Text); 
       $Text=preg_replace("/\[u\](.+?)\[\/u\]/is","<u>$1</u>",$Text); 
       $Text=preg_replace("/\[b\](.+?)\[\/b\]/is","<b>$1</b>",$Text); 
       $Text=preg_replace("/\[attch\][0-9]*\[\/attch\]/isU",'',$Text);
       $Text=preg_replace("/\[code\](.+?)\[\/code\]/isU",'', $Text);
       $Text=preg_replace("/\[quote\](.+?)\[\/quote\]/isU",'', $Text);
       $Text=preg_replace("/\[.*\]/isU",'', $Text);
       $Text = preg_replace("/[\s]{2,}/is","\n",$Text);
       return nl2br($Text); 
}

function fun_ismobile(){
  $mobile_browser = false;
  $user_agent = $_SERVER['HTTP_USER_AGENT'];
  $accept = $_SERVER['HTTP_ACCEPT'];
  $mobile_browser_type = "0"; //0 - PC, 1 - Smart Phone, 2- Standard Phone

    switch(true){
        case (preg_match('/ipod/i',$user_agent)||preg_match('/iphone/i',$user_agent)||preg_match('/ipad/i',$user_agent)); //iPhone or iPod
             $mobile_browser = true;
        break;
        case (preg_match('/android/i',$user_agent)); //Android
            $mobile_browser = true;
        break;
        case (preg_match('/opera mini/i',$user_agent)); //Opera Mini
             $mobile_browser = true;
        break;
        case (preg_match('/blackberry/i',$user_agent)); //Blackberry
            $mobile_browser = true;
         break;

        case (preg_match('/(series60|series 60)/i',$user_agent)); //Symbian OS
             $mobile_browser = true;
             
         break;

        case (preg_match('/(pre\/|palm os|palm|hiptop|avantgo|plucker|xiino|blazer|elaine)/i',$user_agent)); //Palm OS
            $mobile_browser = true;
            
         break;

        case (preg_match('/(iris|3g_t|windows ce|opera mobi|iemobile)/i',$user_agent)); //Windows OS
            $mobile_browser = true;
            
        break;

        case (preg_match('/(maemo|tablet|qt embedded|com2)/i',$user_agent)); //Nokia Tablet
            $mobile_browser = true;
            $mobile_browser_type = "1"; //Smart Device
        break;

        
        case (preg_match('/(mini 9.5|vx1000|lge |m800|e860|u940|ux840|compal|wireless| mobi|ahong|lg380|lgku|lgu900|lg210|lg47|lg920|lg840|lg370|sam-r|mg50|s55|g83|t66|vx400|mk99|d615|d763|el370|sl900|mp500|samu3|samu4|vx10|xda_|samu5|samu6|samu7|samu9|a615|b832|m881|s920|n210|s700|c-810|_h797|mob-x|sk16d|848b|mowser|s580|r800|471x|v120|rim8|c500foma:|160x|x160|480x|x640|t503|w839|i250|sprint|w398samr810|m5252|c7100|mt126|x225|s5330|s820|htil-g1|fly v71|s302|-x113|novarra|k610i|-three|8325rc|8352rc|sanyo|vx54|c888|nx250|n120|mtk |c5588|s710|t880|c5005|i;458x|p404i|s210|c5100|teleca|s940|c500|s590|foma|samsu|vx8|vx9|a1000|_mms|myx|a700|gu1100|bc831|e300|ems100|me701|me702m-three|sd588|s800|8325rc|ac831|mw200|brew |d88|htc\/|htc_touch|355x|m50|km100|d736|p-9521|telco|sl74|ktouch|m4u\/|me702|8325rc|kddi|phone|lg |sonyericsson|samsung|240x|x320|vx10|nokia|sony cmd|motorola|up.browser|up.link|mmp|symbian|smartphone|midp|wap|vodafone|o2|pocket|kindle|mobile|psp|treo|vnd.rim|wml|nitro|nintendo|wii|xbox|archos|openweb|mini|docomo)/i',$user_agent)); //Mix of standard phones
            $mobile_browser = true;
            
         break;

        case ((strpos($accept,'text/vnd.wap.wml')>0)||(strpos($accept,'application/vnd.wap.xhtml+xml')>0)); //Any falling through the cracks
            $mobile_browser = true;
            
         break;

        case (isset($_SERVER['HTTP_X_WAP_PROFILE'])||isset($_SERVER['HTTP_PROFILE'])); //Any falling through the cracks
            $mobile_browser = true;
            
        break;

        case (in_array(strtolower(substr($user_agent,0,4)),array('1207'=>'1207','3gso'=>'3gso','4thp'=>'4thp','501i'=>'501i','502i'=>'502i','503i'=>'503i','504i'=>'504i','505i'=>'505i','506i'=>'506i','6310'=>'6310','6590'=>'6590','770s'=>'770s','802s'=>'802s','a wa'=>'a wa','acer'=>'acer','acs-'=>'acs-','airn'=>'airn','alav'=>'alav','asus'=>'asus','attw'=>'attw','au-m'=>'au-m','aur '=>'aur ','aus '=>'aus ','abac'=>'abac','acoo'=>'acoo','aiko'=>'aiko','alco'=>'alco','alca'=>'alca','amoi'=>'amoi','anex'=>'anex','anny'=>'anny','anyw'=>'anyw','aptu'=>'aptu','arch'=>'arch','argo'=>'argo','bell'=>'bell','bird'=>'bird','bw-n'=>'bw-n','bw-u'=>'bw-u','beck'=>'beck','benq'=>'benq','bilb'=>'bilb','blac'=>'blac','c55/'=>'c55/','cdm-'=>'cdm-','chtm'=>'chtm','capi'=>'capi','cond'=>'cond','craw'=>'craw','dall'=>'dall','dbte'=>'dbte','dc-s'=>'dc-s','dica'=>'dica','ds-d'=>'ds-d','ds12'=>'ds12','dait'=>'dait','devi'=>'devi','dmob'=>'dmob','doco'=>'doco','dopo'=>'dopo','el49'=>'el49','erk0'=>'erk0','esl8'=>'esl8','ez40'=>'ez40','ez60'=>'ez60','ez70'=>'ez70','ezos'=>'ezos','ezze'=>'ezze','elai'=>'elai','emul'=>'emul','eric'=>'eric','ezwa'=>'ezwa','fake'=>'fake','fly-'=>'fly-','fly_'=>'fly_','g-mo'=>'g-mo','g1 u'=>'g1 u','g560'=>'g560','gf-5'=>'gf-5','grun'=>'grun','gene'=>'gene','go.w'=>'go.w','good'=>'good','grad'=>'grad','hcit'=>'hcit','hd-m'=>'hd-m','hd-p'=>'hd-p','hd-t'=>'hd-t','hei-'=>'hei-','hp i'=>'hp i','hpip'=>'hpip','hs-c'=>'hs-c','htc '=>'htc ','htc-'=>'htc-','htca'=>'htca','htcg'=>'htcg','htcp'=>'htcp','htcs'=>'htcs','htct'=>'htct','htc_'=>'htc_','haie'=>'haie','hita'=>'hita','huaw'=>'huaw','hutc'=>'hutc','i-20'=>'i-20','i-go'=>'i-go','i-ma'=>'i-ma','i230'=>'i230','iac'=>'iac','iac-'=>'iac-','iac/'=>'iac/','ig01'=>'ig01','im1k'=>'im1k','inno'=>'inno','iris'=>'iris','jata'=>'jata','java'=>'java','kddi'=>'kddi','kgt'=>'kgt','kgt/'=>'kgt/','kpt '=>'kpt ','kwc-'=>'kwc-','klon'=>'klon','lexi'=>'lexi','lg g'=>'lg g','lg-a'=>'lg-a','lg-b'=>'lg-b','lg-c'=>'lg-c','lg-d'=>'lg-d','lg-f'=>'lg-f','lg-g'=>'lg-g','lg-k'=>'lg-k','lg-l'=>'lg-l','lg-m'=>'lg-m','lg-o'=>'lg-o','lg-p'=>'lg-p','lg-s'=>'lg-s','lg-t'=>'lg-t','lg-u'=>'lg-u','lg-w'=>'lg-w','lg/k'=>'lg/k','lg/l'=>'lg/l','lg/u'=>'lg/u','lg50'=>'lg50','lg54'=>'lg54','lge-'=>'lge-','lge/'=>'lge/','lynx'=>'lynx','leno'=>'leno','m1-w'=>'m1-w','m3ga'=>'m3ga','m50/'=>'m50/','maui'=>'maui','mc01'=>'mc01','mc21'=>'mc21','mcca'=>'mcca','medi'=>'medi','meri'=>'meri','mio8'=>'mio8','mioa'=>'mioa','mo01'=>'mo01','mo02'=>'mo02','mode'=>'mode','modo'=>'modo','mot '=>'mot ','mot-'=>'mot-','mt50'=>'mt50','mtp1'=>'mtp1','mtv '=>'mtv ','mate'=>'mate','maxo'=>'maxo','merc'=>'merc','mits'=>'mits','mobi'=>'mobi','motv'=>'motv','mozz'=>'mozz','n100'=>'n100','n101'=>'n101','n102'=>'n102','n202'=>'n202','n203'=>'n203','n300'=>'n300','n302'=>'n302','n500'=>'n500','n502'=>'n502','n505'=>'n505','n700'=>'n700','n701'=>'n701','n710'=>'n710','nec-'=>'nec-','nem-'=>'nem-','newg'=>'newg','neon'=>'neon','netf'=>'netf','noki'=>'noki','nzph'=>'nzph','o2 x'=>'o2 x','o2-x'=>'o2-x','opwv'=>'opwv','owg1'=>'owg1','opti'=>'opti','oran'=>'oran','p800'=>'p800','pand'=>'pand','pg-1'=>'pg-1','pg-2'=>'pg-2','pg-3'=>'pg-3','pg-6'=>'pg-6','pg-8'=>'pg-8','pg-c'=>'pg-c','pg13'=>'pg13','phil'=>'phil','pn-2'=>'pn-2','pt-g'=>'pt-g','palm'=>'palm','pana'=>'pana','pire'=>'pire','pock'=>'pock','pose'=>'pose','psio'=>'psio','qa-a'=>'qa-a','qc-2'=>'qc-2','qc-3'=>'qc-3','qc-5'=>'qc-5','qc-7'=>'qc-7','qc07'=>'qc07','qc12'=>'qc12','qc21'=>'qc21','qc32'=>'qc32','qc60'=>'qc60','qci-'=>'qci-','qwap'=>'qwap','qtek'=>'qtek','r380'=>'r380','r600'=>'r600','raks'=>'raks','rim9'=>'rim9','rove'=>'rove','s55/'=>'s55/','sage'=>'sage','sams'=>'sams','sc01'=>'sc01','sch-'=>'sch-','scp-'=>'scp-','sdk/'=>'sdk/','se47'=>'se47','sec-'=>'sec-','sec0'=>'sec0','sec1'=>'sec1','semc'=>'semc','sgh-'=>'sgh-','shar'=>'shar','sie-'=>'sie-','sk-0'=>'sk-0','sl45'=>'sl45','slid'=>'slid','smb3'=>'smb3','smt5'=>'smt5','sp01'=>'sp01','sph-'=>'sph-','spv '=>'spv ','spv-'=>'spv-','sy01'=>'sy01','samm'=>'samm','sany'=>'sany','sava'=>'sava','scoo'=>'scoo','send'=>'send','siem'=>'siem','smar'=>'smar','smit'=>'smit','soft'=>'soft','sony'=>'sony','t-mo'=>'t-mo','t218'=>'t218','t250'=>'t250','t600'=>'t600','t610'=>'t610','t618'=>'t618','tcl-'=>'tcl-','tdg-'=>'tdg-','telm'=>'telm','tim-'=>'tim-','ts70'=>'ts70','tsm-'=>'tsm-','tsm3'=>'tsm3','tsm5'=>'tsm5','tx-9'=>'tx-9','tagt'=>'tagt','talk'=>'talk','teli'=>'teli','topl'=>'topl','hiba'=>'hiba','up.b'=>'up.b','upg1'=>'upg1','utst'=>'utst','v400'=>'v400','v750'=>'v750','veri'=>'veri','vk-v'=>'vk-v','vk40'=>'vk40','vk50'=>'vk50','vk52'=>'vk52','vk53'=>'vk53','vm40'=>'vm40','vx98'=>'vx98','virg'=>'virg','vite'=>'vite','voda'=>'voda','vulc'=>'vulc','w3c '=>'w3c ','w3c-'=>'w3c-','wapj'=>'wapj','wapp'=>'wapp','wapu'=>'wapu','wapm'=>'wapm','wig '=>'wig ','wapi'=>'wapi','wapr'=>'wapr','wapv'=>'wapv','wapy'=>'wapy','wapa'=>'wapa','waps'=>'waps','wapt'=>'wapt','winc'=>'winc','winw'=>'winw','wonu'=>'wonu','x700'=>'x700','xda2'=>'xda2','xdag'=>'xdag','yas-'=>'yas-','your'=>'your','zte-'=>'zte-','zeto'=>'zeto','acs-'=>'acs-','alav'=>'alav','alca'=>'alca','amoi'=>'amoi','aste'=>'aste','audi'=>'audi','avan'=>'avan','benq'=>'benq','bird'=>'bird','blac'=>'blac','blaz'=>'blaz','brew'=>'brew','brvw'=>'brvw','bumb'=>'bumb','ccwa'=>'ccwa','cell'=>'cell','cldc'=>'cldc','cmd-'=>'cmd-','dang'=>'dang','doco'=>'doco','eml2'=>'eml2','eric'=>'eric','fetc'=>'fetc','hipt'=>'hipt','http'=>'http','ibro'=>'ibro','idea'=>'idea','ikom'=>'ikom','inno'=>'inno','ipaq'=>'ipaq','jbro'=>'jbro','jemu'=>'jemu','java'=>'java','jigs'=>'jigs','kddi'=>'kddi','keji'=>'keji','kyoc'=>'kyoc','kyok'=>'kyok','leno'=>'leno','lg-c'=>'lg-c','lg-d'=>'lg-d','lg-g'=>'lg-g','lge-'=>'lge-','libw'=>'libw','m-cr'=>'m-cr','maui'=>'maui','maxo'=>'maxo','midp'=>'midp','mits'=>'mits','mmef'=>'mmef','mobi'=>'mobi','mot-'=>'mot-','moto'=>'moto','mwbp'=>'mwbp','mywa'=>'mywa','nec-'=>'nec-','newt'=>'newt','nok6'=>'nok6','noki'=>'noki','o2im'=>'o2im','opwv'=>'opwv','palm'=>'palm','pana'=>'pana','pant'=>'pant','pdxg'=>'pdxg','phil'=>'phil','play'=>'play','pluc'=>'pluc','port'=>'port','prox'=>'prox','qtek'=>'qtek','qwap'=>'qwap','rozo'=>'rozo','sage'=>'sage','sama'=>'sama','sams'=>'sams','sany'=>'sany','sch-'=>'sch-','sec-'=>'sec-','send'=>'send','seri'=>'seri','sgh-'=>'sgh-','shar'=>'shar','sie-'=>'sie-','siem'=>'siem','smal'=>'smal','smar'=>'smar','sony'=>'sony','sph-'=>'sph-','symb'=>'symb','t-mo'=>'t-mo','teli'=>'teli','tim-'=>'tim-','tosh'=>'tosh','treo'=>'treo','tsm-'=>'tsm-','upg1'=>'upg1','upsi'=>'upsi','vk-v'=>'vk-v','voda'=>'voda','vx52'=>'vx52','vx53'=>'vx53','vx60'=>'vx60','vx61'=>'vx61','vx70'=>'vx70','vx80'=>'vx80','vx81'=>'vx81','vx83'=>'vx83','vx85'=>'vx85','wap-'=>'wap-','wapa'=>'wapa','wapi'=>'wapi','wapp'=>'wapp','wapr'=>'wapr','webc'=>'webc','whit'=>'whit','winw'=>'winw','wmlb'=>'wmlb','xda-'=>'xda-'))); //Catch all
             $mobile_browser = true;
            
         break;

        default;
            $mobile_browser = false;
        break;
    }

    return $mobile_browser;
}

?>