<?php
/**
* @version define
*/

defined('IN_SYSTEM') === false && exit('PHPnew Blog.');

// 几点常规设置
ini_set('allow_url_fopen','On');
ini_set('include_path',$root = substr(dirname(__FILE__),0,-10)); 
ini_set('default_charset',$_config['default']['charset']);
ini_set('display_errors','Off');
ini_set('error_reporting',0); 
ini_set('date.timezone','Etc/GMT');

// 常量定义
define('ROOT',$root);
define('SYSTE_ROOT',$_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR);
define('PHPNEW','PHPnew Blog 3.3');
define('VERSION',20130114);
define('PHPVERSION',phpversion());
define('APACHEVERSION',function_exists('apache_get_version')?apache_get_version():'ngihx');

$site_get = '';
$php_selfs = dirname($_SERVER['PHP_SELF']); // /test
if($_SERVER['REQUEST_URI']){
    $_SERVER['REQUEST_URI'] = '/'.ltrim($_SERVER['REQUEST_URI'],'/');
    $site_get = empty($_SERVER['REQUEST_URI']) === false? strtr($_SERVER['REQUEST_URI'], array('/'.trim($php_selfs,'/').'/'=>'','.php?' => '/', '=' => '/', '&' => '/')) : basename($_SERVER['SCRIPT_NAME'], '.php').'/' . strtr(ltrim($_SERVER['QUERY_STRING'],'/'), array('=' => '/', '&' => '/'));
}

$site_get = trim($site_get,'/');
$httppre = (empty($_SERVER["HTTPS"]) === false || $_SERVER["HTTPS"] !== 'on')?'http':'https';
define('URL_HOST',trim($httppre.'://'.$_SERVER['HTTP_HOST'].$php_selfs,DIRECTORY_SEPARATOR).'/');
define('URL_SITE',URL_HOST . $site_get);
define('URL_PHP',$httppre.'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].(empty($_SERVER['QUERY_STRING']) === false? '?'.$_SERVER['QUERY_STRING']:''));

// 判断信息类
define('IS_POST',(empty($_POST) === false && count($_POST) !== 0)?1:0);
define('IS_GET',(empty($_GET) === false && count($_GET) !== 0)?1:0);
define('IS_REQUEST',empty($_REQUEST) === false?1:0);
define('IS_FILES',empty($_FILES) === false?1:0);
define('IS_COOKIE',empty($_COOKIE) === false?1:0);
define('IS_SESSION',empty($_SESSION) === false?1:0);
define('IS_REFERER',empty($_SERVER['HTTP_REFERER']) === false?1:0);
define('IS_SAFE',ini_get('safe_mode') ? 1 : 0);

// 判断组件
define('IS_CURL',extension_loaded('CURL') === true? 1:0);
define('IS_PDO',extension_loaded('PDO') === true? 1:0);
define('IS_SQLITE',extension_loaded('SQLITE') === true? 1:0);
define('IS_MBSTRING',extension_loaded('MBSTRING') === true? 1:0);
define('IS_ICONV',extension_loaded('ICONV') === true? 1:0);
define('IS_FTP',extension_loaded('FTP') === true? 1:0);
define('IS_GD',extension_loaded('GD') === true? 1:0);
define('IS_JSON',extension_loaded('JSON') === true? 1:0);
define('IS_MYSQL',extension_loaded('MYSQL') === true? 1:0);
define('IS_GPC', function_exists('get_magic_quotes_gpc') && @get_magic_quotes_gpc()? 1:0);
define('IS_GZIP',(strpos($_SERVER['HTTP_ACCEPT_ENCODING'],"gzip")!==false && extension_loaded("zlib") === true && function_exists('ob_gzhandler')=== true)?1:0);
define('IS_IE', strpos($_SERVER['HTTP_USER_AGENT'],'MSIE') !== false?1:0);

// 取得数据常量
define('GET_REFERER',empty($_SERVER['HTTP_REFERER']) === false?$_SERVER['HTTP_REFERER']:'./index.php');
define('GET_TIME',empty($_SERVER['REQUEST_TIME']) === false?$_SERVER['REQUEST_TIME']:time());
define('GET_GD',(IS_GD===1 && is_array($gd_array = gd_info()))?$gd_array['GD Version']:0);
define('GET_INCLUDE',get_include_path());
define('GET_TIMEZONE',ini_get('date.timezone'));
define('GET_CHARSET',ini_get('default_charset'));
define('GET_DATE',date('Y-m-d H:i:s',GET_TIME));
define('GET_UPLOADS',ini_get('file_uploads')?ini_get('upload_max_filesize'):0);
define('GET_MICROTIME',array_sum(explode(' ', microtime())));
define('CHARSET',empty($_config['default']['charset']) === true?GET_CHARSET:$_config['default']['charset']);
define('GET_ANKEY',$_config['default']['ankey']);
define('GET_RAND',substr_replace(md5(GET_TIME),8,-16));
define('GET_ALERT', ' onclick="if(confirm(\'请确认你的操作?\')){return true;}else{return false;}"');

// 主题的一些定义
define('THREAD_TOP',1);
define('THREAD_DIGEST',2);
define('THREAD_HOT',3);
define('THREAD_SHOW',4);
define('THREAD_EDIT',5);
// 定义路径
define('DIR_CLASS','./Source/Class/');
define('DIR_FUNCTION','./Source/Function/');
define('DIR_INC','./Source/Inc/');
define('DIR_APP','./App/');
define('DIR_DATA','./Data/');
define('DIR_IMAGES', './Static/Images/');
define('DIR_JQUERY','./Source/Default_data/Jquery.js');
define('DIR_ROOT',$path = rtrim(dirname(dirname(dirname(__file__))),DIRECTORY_SEPARATOR));