<?php
/**
 * IndexController.class.php
 * 
 * SMILE BLOG前台首页等处理页面
 * @author tommy <www.tommycode.com>
 * @copyright www.doitphp.com
 * @package application
 * @version smile blog 1.0 2011-07-17 22:40:30 Z tommy $
 * @since 1.0
 */
class IndexController extends Controller {
        
        /**
         * 首页
         */
        public function indexAction() {
            
            //获取参数
            $page = (int)$this->get('page');
            $page = (!$page) ? 1 : $page;
            
            //实例化model
            $post_model = $this->model('posts');            
            
            
            $config_data    = auth::get_config_data();
            
            $page_list_num = (!$config_data['max_list_num']) ? 10 : $config_data['max_list_num'];
            
            //管理员登陆信息
            $admin_login_data   = cookie::get('smile_admin_login');
            $admin_login_status = $admin_login_data['status'];
            
            if ($admin_login_status == true) {
                $list_data =  $post_model->from('posts')->where('post_type=0')->order('post_id desc')->page_limit($page, $page_list_num)->select();
            } else {
                $list_data = $post_model->from('posts')->where('post_type=0')->where('post_status=0')->order('post_id desc')->page_limit($page, $page_list_num)->select();
            }
            
            $list_array = array();
            if($list_data){
                foreach ($list_data as $key=>$lines) {
                    
                    $list_array[$key]['id']         = $lines['post_id'];
                    $list_array[$key]['title']      = $lines['post_title'];
                    $list_array[$key]['time']       = $lines['date_added'];
                    $list_array[$key]['content']    = auth::parse_ban_words($lines['post_content']);
                    
                    //作者信息
                    $author_data = $post_model->from('admin_users', 'user_name')->where('user_id=' . $lines['post_author'])->select(false);
                    $list_array[$key]['author']     = $author_data['user_name'];
                    
                    //分类信息
                    $term_data = $post_model->from('terms', 'term_name')->where('term_id=' . $lines['post_class'])->select(false);
                    $list_array[$key]['class']  = '<a href="' . $this->get_action_url('term') . '/?id=' . $lines['post_class'] . '" target="_self">' . $term_data['term_name'] . '</a>';
                    
                    //标签信息
                    $tag_data = $post_model->from(array('pt'=>'post_tags', 't'=>'tags'), 't.tag_name')->where('pt.post_id=' . $lines['post_id'])->where('pt.tag_id=t.tag_id')->select();
                    $tag_array = array();
                    if ($tag_data) {
                        foreach ($tag_data as $rows) {
                            $tag_array[] = '<a href="' . $this->get_action_url('tag'). '/?tag_name=' . urlencode($rows['tag_name']) . '" target="_self">' . $rows['tag_name'] . '</a>';
                        }
                    }
                    $list_array[$key]['tag'] = implode(',', $tag_array);
                    unset ($tag_array);
                    
                    //评论信息
                    if($lines['comment_status'] == 1) {                        
                        $list_array[$key]['comment']= $post_model->count('comments', 'comment_id', 'post_id=' . $lines['post_id']);
                        
                    } else {
                        $list_array[$key]['comment']    = 0;
                    }
                }
            }
            
            $pagelist = $this->instance('pagelist');
            
            if ($admin_login_status == true) {                 
                 $total_num_data = $post_model->count('posts', 'post_id', 'post_type=0');                 
            } else {                
                 $total_num_data = $post_model->count('posts', 'post_id', array('post_type=0', 'post_status=0'));
            }
            
            $this->assign(array(
                'admin_login_status'    => $admin_login_status,
                'list_data'             => $list_array,
                'pagelist_css'          => $pagelist->load_css(),
                'pagelist_html'         => $pagelist->url($this->get_self_url() . '/?page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
            ));
            
            //display page
            $this->display();
        }
        
        /**
         * 归档页面
         */
        public function archiveAction() {
            
           //获取参数
            $archive_id = $this->get('id');
            if (!$archive_id) {
                $this->show_message('你输入的网址有错误');
            }
            $page = (int)$this->get('page');
            $page = (!$page) ? 1 : $page;
            
            $archive_id_array = explode('-', $archive_id);
            $archive_year   = $archive_id_array[0];
            $archive_month  = $archive_id_array[1];
            
            //实例化model
            $post_model = $this->model('posts');
            
            
            $config_data    = auth::get_config_data();
            
            $page_list_num = (!$config_data['max_list_num']) ? 10 : $config_data['max_list_num'];
            
            //管理员登陆信息
            $admin_login_data   = cookie::get('smile_admin_login');
            $admin_login_status = $admin_login_data['status'];
                        
            $limit_start = $page_list_num * ($page -1);            
            if($admin_login_status == true) {
                $list_sql = "SELECT * FROM `posts` WHERE `post_type`=0 AND YEAR(`date_added`)={$archive_year} AND MONTH(`date_added`)={$archive_month} ORDER BY `post_id` DESC LIMIT {$limit_start}, {$page_list_num}";
            } else {
                $list_sql = "SELECT * FROM `posts` WHERE `post_type`=0 AND `post_status`=0 AND YEAR(`date_added`)={$archive_year} AND MONTH(`date_added`)={$archive_month} ORDER BY `post_id` DESC LIMIT {$limit_start}, {$page_list_num}";
            }
            $list_data = $post_model->execute($list_sql);
            
            $list_array = array();
            if($list_data){
                foreach ($list_data as $key=>$lines) {
                    
                    $list_array[$key]['id']         = $lines['post_id'];
                    $list_array[$key]['title']      = $lines['post_title'];
                    $list_array[$key]['time']       = $lines['date_added'];
                    $list_array[$key]['content']    = auth::parse_ban_words($lines['post_content']);
                    
                    //作者信息
                    $author_data = $post_model->from('admin_users', 'user_name')->where('user_id=' . $lines['post_author'])->select(false);
                    $list_array[$key]['author']     = $author_data['user_name'];
                    
                    //分类信息
                    $term_data = $post_model->from('terms', 'term_name')->where('term_id=' . $lines['post_class'])->select(false);
                    $list_array[$key]['class']  = '<a href="' . $this->get_action_url('term') . '/?id=' . $lines['post_class'] . '" target="_self">' . $term_data['term_name'] . '</a>';
                    
                    //标签信息
                    $tag_data = $post_model->from(array('pt'=>'post_tags', 't'=>'tags'), 't.tag_name')->where('pt.post_id=' . $lines['post_id'])->where('pt.tag_id=t.tag_id')->select();
                    $tag_array = array();
                    if ($tag_data) {
                        foreach ($tag_data as $rows) {
                            $tag_array[] = '<a href="' . $this->get_action_url('tag'). '/?tag_name=' . urlencode($rows['tag_name']) . '" target="_self">' . $rows['tag_name'] . '</a>';
                        }
                    }
                    $list_array[$key]['tag'] = implode(',', $tag_array);
                    unset ($tag_array);
                    
                    //评论信息
                    if($lines['comment_status'] == 1) {                                              
                        $list_array[$key]['comment'] = $post_model->count('comments', 'comment_id', 'post_id=' . $lines['post_id']);
                    } else {
                        $list_array[$key]['comment']    = 0;
                    }
                }
            }
            
            $pagelist = $this->instance('pagelist');
            $total_num_data = ($admin_login_status == true) ? $post_model->count('posts', 'post_id', 'post_type=0') : $post_model->count('posts', 'post_id', arr('post_type=0','post_status=0'));
            
            $this->assign(array(
                'admin_login_status'    => $admin_login_status,
                'list_data'             => $list_array,
                'pagelist_css'          => $pagelist->load_css(),
                'pagelist_html'         => $pagelist->url($this->get_self_url() . '/?page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
            ));
            
            //display page
            $this->display('index');
        }
        
        /**
         * 特殊页面(Page)
         */
        public function pageAction() {
            
            //获取参数
            $post_id = (int)$this->get('id');           
            if (!$post_id) {
                $this->show_message('你输入的网址出错,现在返回首页', $this->get_action_url('index'));
            }
            
            //实例model
            $post_model = $this->model('posts');
            $post_data  = $post_model->find($post_id);
            if (!$post_data) {
                $this->show_message('对不起,你访问的文章不存在！');
            }
            
            $autor_data = $post_model->from('admin_users', 'user_name')->where('user_id=' . $post_data['post_author'])->select(false);
            
            //管理员登陆信息
            $admin_login_data   = cookie::get('smile_admin_login');
            $admin_login_status = $admin_login_data['status'];
            
             //评论信息
            
            $config_data    = auth::get_config_data();
             //标签信息
            $tag_data = $post_model->from(array('pt'=>'post_tags', 't'=>'tags'), 't.tag_name')->where('pt.post_id=' . $post_id)->where('pt.tag_id=t.tag_id')->select();
            $tag_array = array();
            if ($tag_data) {
                foreach ($tag_data as $rows) {
                    $tag_array[] = '<a href="' . $this->get_action_url('tag'). '/?tag_name=' . urlencode($rows['tag_name']) . '" target="_self">' . $rows['tag_name'] . '</a>';
                 }
            }
            $tag_str = implode(', ', $tag_array);
            unset ($tag_array);
            
            //assign params
            $this->assign(array(
                'post_data'             => $post_data,
                'admin_login_status'    => $admin_login_status,
                'post_author'           => $autor_data['user_name'],
                'is_verify'             => $config_data['is_verify'],
                'tag_str'               => $tag_str,
            ));
            
            //display page
            $this->display();
        }
        
        /**
         * 分类页面
         */
        public function termAction() {
            
            //获取参数
            $term_id = (int)$this->get('id');
            if (!$term_id) {
                $this->show_message('你输入的网址有错误');
            }
            $page = (int)$this->get('page');
            $page = (!$page) ? 1 : $page;
            
            //实例化model
            $post_model = $this->model('posts');
            
            
            $config_data    = auth::get_config_data();
            
            $page_list_num = (!$config_data['max_list_num']) ? 10 : $config_data['max_list_num'];
            
            //管理员登陆信息
            $admin_login_data   = cookie::get('smile_admin_login');
            $admin_login_status = $admin_login_data['status'];
            $list_data = ($admin_login_status == true) ? $post_model->from('posts')->where('post_type=0')->where('post_class=' . $term_id)->order('post_id desc')->page_limit($page, $page_list_num)->select() : $post_model->from('posts')->where('post_type=0')->where('post_status=0')->where('post_class=' . $term_id)->order('post_id desc')->page_limit($page, $page_list_num)->select();
            
            $list_array = array();
            if($list_data){
                foreach ($list_data as $key=>$lines) {
                    
                    $list_array[$key]['id']         = $lines['post_id'];
                    $list_array[$key]['title']      = $lines['post_title'];
                    $list_array[$key]['time']       = $lines['date_added'];
                    $list_array[$key]['content']    = auth::parse_ban_words($lines['post_content']);
                    
                    //作者信息
                    $author_data = $post_model->from('admin_users', 'user_name')->where('user_id=' . $lines['post_author'])->select(false);
                    $list_array[$key]['author']     = $author_data['user_name'];
                    
                    //分类信息
                    $term_data = $post_model->from('terms', 'term_name')->where('term_id=' . $lines['post_class'])->select(false);
                    $list_array[$key]['class']  = '<a href="' . $this->get_action_url('term') . '/?id=' . $lines['post_class'] . '" target="_self">' . $term_data['term_name'] . '</a>';
                    
                    //标签信息
                    $tag_data = $post_model->from(array('pt'=>'post_tags', 't'=>'tags'), 't.tag_name')->where('pt.post_id=' . $lines['post_id'])->where('pt.tag_id=t.tag_id')->select();
                    $tag_array = array();
                    if ($tag_data) {
                        foreach ($tag_data as $rows) {
                            $tag_array[] = '<a href="' . $this->get_action_url('tag'). '/?tag_name=' . urlencode($rows['tag_name']) . '" target="_self">' . $rows['tag_name'] . '</a>';
                        }
                    }
                    $list_array[$key]['tag'] = implode(',', $tag_array);
                    unset ($tag_array);
                    
                    //评论信息
                    if($lines['comment_status'] == 1) {                      
                        $list_array[$key]['comment']    = $post_model->count('comments', 'comment_id', 'post_id=' . $lines['post_id']);
                    } else {
                        $list_array[$key]['comment']    = 0;
                    }
                }
            }
            
            $pagelist = $this->instance('pagelist');
            $total_num_data = ($admin_login_status == true) ? $post_model->count('posts', 'post_id', 'post_type=0') : $post_model->count('posts', 'post_id', array('post_type=0','post_status=0'));
            
            $this->assign(array(
                'admin_login_status'    => $admin_login_status,
                'list_data'             => $list_array,
                'pagelist_css'          => $pagelist->load_css(),
                'pagelist_html'         => $pagelist->url($this->get_self_url() . '/?page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
            ));
            
            //display page
            $this->display('index');
        }
        
        /**
         * 标签页面
         */
        public function tagAction() {
            
            //获取参数
            $tag_name   = urldecode($this->get('tag_name'));
            if (!$tag_name) {
                $this->show_message('你输入的网址有错误');
            }
            $page = (int)$this->get('page');
            $page = (!$page) ? 1 : $page;
            
            //实例化model
            $post_model = $this->model('posts');
            
            
            $config_data    = auth::get_config_data();
            
            $page_list_num = (!$config_data['max_list_num']) ? 10 : $config_data['max_list_num'];
            
            //管理员登陆信息
            $admin_login_data   = cookie::get('smile_admin_login');
            $admin_login_status = $admin_login_data['status'];
            
            //标签处理
            $tag_id_data = $post_model->from('tags', 'tag_id')->where('tag_name=?', $tag_name)->select(false);
            
            $list_data = ($admin_login_status == true) ? $post_model->from(array('p'=>'posts', 't'=>'post_tags'), array('p.post_id', 'p.post_title', 'p.date_added', 'post_content', 'p.post_author', 'post_class', 'p.comment_status'))->where('t.tag_id=' . $tag_id_data['tag_id'])->where('p.post_id=t.post_id')->order('p.post_id desc')->page_limit($page, $page_list_num)->select() : $post_model->from(array('p'=>'posts', 't'=>'post_tags'), array('p.post_id', 'p.post_title', 'p.date_added', 'post_content', 'p.post_author', 'post_class', 'p.comment_status'))->where('t.tag_id=' . $tag_id_data['tag_id'])->where('p.post_id=t.post_id')->where('p.post_status=0')->order('p.post_id desc')->page_limit($page, $page_list_num)->select();
           
            $list_array = array();
            if($list_data){
                foreach ($list_data as $key=>$lines) {
                    
                    $list_array[$key]['id']         = $lines['post_id'];
                    $list_array[$key]['title']      = $lines['post_title'];
                    $list_array[$key]['time']       = $lines['date_added'];
                    $list_array[$key]['content']    = auth::parse_ban_words($lines['post_content']);
                    
                    //作者信息
                    $author_data = $post_model->from('admin_users', 'user_name')->where('user_id=' . $lines['post_author'])->select(false);
                    $list_array[$key]['author']     = $author_data['user_name'];
                    
                    //分类信息
                    $term_data = $post_model->from('terms', 'term_name')->where('term_id=' . $lines['post_class'])->select(false);
                    $list_array[$key]['class']  = '<a href="' . $this->get_action_url('term') . '/?id=' . $lines['post_class'] . '" target="_self">' . $term_data['term_name'] . '</a>';
                    
                    //标签信息
                    $tag_data = $post_model->from(array('pt'=>'post_tags', 't'=>'tags'), 't.tag_name')->where('pt.post_id=' . $lines['post_id'])->where('pt.tag_id=t.tag_id')->select();
                    $tag_array = array();
                    if ($tag_data) {
                        foreach ($tag_data as $rows) {
                            $tag_array[] = '<a href="' . $this->get_action_url('tag'). '/?tag_name=' . urlencode($rows['tag_name']) . '" target="_self">' . $rows['tag_name'] . '</a>';
                        }
                    }
                    $list_array[$key]['tag'] = implode(',', $tag_array);
                    unset ($tag_array);
                    
                    //评论信息
                    if($lines['comment_status'] == 1) {                        
                        $list_array[$key]['comment'] = $post_model->count('comments', 'comment_id', 'post_id=' . $lines['post_id']);
                    } else {
                        $list_array[$key]['comment']    = 0;
                    }
                }
            }
            
            $pagelist = $this->instance('pagelist');
            $total_num_data = ($admin_login_status == true) ? $post_model->count('posts', 'post_id', 'post_type=0') : $post_model->count('posts', 'post_id', array('post_type=0','post_status=0'));
            
            $this->assign(array(
                'admin_login_status'    => $admin_login_status,
                'list_data'             => $list_array,
                'pagelist_css'          => $pagelist->load_css(),
                'pagelist_html'         => $pagelist->url($this->get_self_url() . '/?page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
            ));
            
            //display page
            $this->display('index');
        }
        
        /**
         * 文章内容页面
         */
        public function articleAction() {
            
            //获取参数
            $post_id    = (int)$this->get('id');
            if (!$post_id) {
                $this->show_message('你输入的网址出错,现在返回首页', $this->get_action_url('index'), 3);
            }
            
            //管理员登陆信息
            $admin_login_data   = cookie::get('smile_admin_login');
            $admin_login_status = $admin_login_data['status'];
            
            //实例化model
            $post_model     = $this->model('posts');
            $comment_model  = $this->model('comments');
            
            $post_data = $post_model->find($post_id);
            if (!$post_data) {
                $this->show_message('对不起,你访问的文章不存在！');
            }
            
            $autor_data = $post_model->from('admin_users', 'user_name')->where('user_id=' . $post_data['post_author'])->select(false);
            $term_data  = $post_model->from('terms', 'term_name')->where('term_id=' . $post_data['post_class'])->select(false);
            
            //标签信息
            $tag_data = $post_model->from(array('pt'=>'post_tags', 't'=>'tags'), 't.tag_name')->where('pt.post_id=' . $post_id)->where('pt.tag_id=t.tag_id')->select();
            $tag_array = array();
            if ($tag_data) {
                foreach ($tag_data as $rows) {
                    $tag_array[] = '<a href="' . $this->get_action_url('tag'). '/?tag_name=' . urlencode($rows['tag_name']) . '" target="_self">' . $rows['tag_name'] . '</a>';
                 }
            }
            $tag_str = implode(',', $tag_array);
            unset ($tag_array);
            
            //评论信息
            
            $config_data    = auth::get_config_data();
            
            $comment_data = ($config_data['is_verify'] ==1) ? $comment_model->from('comments')->where('post_id=' . $post_id)->where('approved=1')->select() : $comment_model->from('comments')->where('post_id=' . $post_id)->select();
            
            $this->assign(array(
                'post_data'             => $post_data,
                'admin_login_status'    => $admin_login_status,
                'post_author'            => $autor_data['user_name'],
                'post_class'            => $term_data['term_name'],
                'tag_str'               => $tag_str,
                'comment_data'          => $comment_data,
                'is_verify'             => $config_data['is_verify'],
            ));
            
            //display page
            $this->display();
        }
        
        /**
         * ajax添加评论
         */
        public function ajax_insert_commentAction() {
            
            //获取参数
            $post_id    = (int)$this->post('post_id');
            if (!$post_id) {
                exit ();
            }
            $nickname   = $this->post('nickname');
            $email      = $this->post('email_url');
            $site       = $this->post('site_url');
            $content    = $this->post('content');
            if (!check::is_email($email)) {
                echo '你输入的邮箱地址格式不正确!请重新输入';
                exit ();
            }
            
            //实例化model
            $comment_model  = $this->model('comments');
            $post_model     = $this->model('posts');
            
            $insert_comment_array = array(
                'post_id'   => $post_id,
                'comment_author'    => $nickname,
                'comment_content'   => $content,
                'comment_ip'        => $_SERVER['REMOTE_ADDR'],
                'comment_date'      => date('Y-m-d H:i:s'),
                'author_email'      => $email,
            );
            if ($site) {
                $insert_comment_array['author_site'] = $site;
            }
            
            $result_status = false;
            if ($comment_model->insert($insert_comment_array)) {
                $result_status = $post_model->update(array('comment_status'=>1), 'post_id=' . $post_id);
            }
            
            echo ($result_status == true) ? 101 : '对不起!添加评论操作失败,请重新操作';
        }
}