<?php
/**
 * SearchController.class.php
 * 
 * SMILE BLOG前台的搜索处理
 * @author tommy <www.tommycode.com>
 * @copyright www.doitphp.com
 * @package application
 * @version smile blog 1.0 2011-07-17 22:40:30 Z tommy $
 * @since 1.0
 */
class SearchController extends Controller {
        
        /**
         * 搜索页面结果显示页
         */
        public function resultAction() {
            //获取参数
            $keyword = $this->post('search_keyword') ;
            $keyword = (!$keyword) ? urldecode($this->get('keyword')) : $keyword;
            if (!$keyword) {
                exit ();
            }
            $page = (int)$this->get('page');
            $page = (!$page) ? 1 : $page;
            
            //实例化model
            $post_model = $this->model('posts');            
            
            
            $config_data    = auth::get_config_data();
            
            $page_list_num = (!$config_data['max_list_num']) ? 10 : $config_data['max_list_num'];
            
            //管理员登陆信息
            $admin_login_data   = cookie::get('smile_admin_login');
            $admin_login_status = $admin_login_data['status'];
            
            //搜索分词
            $list_data = ($admin_login_status == true) ? $post_model->from('posts')->where('post_type=0')->where('`post_title` LIKE ?', '%' . $keyword . '%')->order('post_id desc')->page_limit($page, $page_list_num)->select() : $post_model->from('posts')->where('post_type=0')->where('post_status=0')->where('`post_title` LIKE ?', '%' . $keyword . '%')->order('post_id desc')->page_limit($page, $page_list_num)->select();
            
            $list_array = array();
            if($list_data){
                foreach ($list_data as $key=>$lines) {
                    
                    $list_array[$key]['id']         = $lines['post_id'];
                    $list_array[$key]['title']      = str_replace($keyword, '<span style="color:#FF0000;">' . $keyword . '</span>', $lines['post_title']);
                    $list_array[$key]['time']       = $lines['date_added'];
                    $list_array[$key]['content']    = auth::parse_ban_words($lines['post_content']);
                    
                    //作者信息
                    $author_data = $post_model->from('admin_users', 'user_name')->where('user_id=' . $lines['post_author'])->select(false);
                    $list_array[$key]['author']     = $author_data['user_name'];
                    
                    //分类信息
                    $term_data = $post_model->from('terms', 'term_name')->where('term_id=' . $lines['post_class'])->select(false);
                    $list_array[$key]['class']  = '<a href="' . $this->create_url('index/term') . '/?id=' . $lines['post_class'] . '" target="_self">' . $term_data['term_name'] . '</a>';
                    
                    //标签信息
                    $tag_data = $post_model->from(array('pt'=>'post_tags', 't'=>'tags'), 't.tag_name')->where('pt.post_id=' . $lines['post_id'])->where('pt.tag_id=t.tag_id')->select();
                    $tag_array = array();
                    if ($tag_data) {
                        foreach ($tag_data as $rows) {
                            $tag_array[] = '<a href="' . $this->create_url('index/tag') . '/?tag_name=' . urlencode($rows['tag_name']) . '" target="_self">' . $rows['tag_name'] . '</a>';
                        }
                    }
                    $list_array[$key]['tag'] = implode(',', $tag_array);
                    unset ($tag_array);
                    
                    //评论信息
                    if($lines['comment_status'] == 1) {                        
                        $list_array[$key]['comment']    = $post_model->count('comments', 'comment_id', 'post_id=' . $lines['post_id']);
                    } else {
                        $list_array[$key]['comment']    = 0;
                    }
                }
            }
            
            $pagelist = $this->instance('pagelist');
            $total_num_data = ($admin_login_status == true) ? $post_model->count('posts', 'post_id', 'post_type=0') : $post_model->count('posts', 'post_id', array('post_type=0','post_status=0'));
            
            $this->assign(array(
                'admin_login_status'    => $admin_login_status,
                'list_data'             => $list_array,
                'pagelist_css'          => $pagelist->load_css(),
                'pagelist_html'         => $pagelist->url($this->get_self_url() . '/?keyword=' . urlencode($keyword).'&page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
            ));
            
            //display page
            $this->display('index/index');
        }        
}