<?php
class Admin_commentController extends Controller {
        /**
         * 定义布局视图
         * 
         * @var string
         */
        protected $layout = 'admin_main';
        
        /**
         * 后台管理：评论列表管理页面
         */
        public function indexAction() {
             //判断登陆
            auth::parse_login();
            
            //获取参数
            $page = (int)$this->get('page');
            $page = (!$page) ? 1 : $page;
            
            //定义每页显示的评论的列表数
            $page_list_num = 10;
            
            //实例化model
            $comment_model = $this->model('comments');
            
            $comment_data = $comment_model->from('comments')->order('comment_id desc')->page_limit($page, $page_list_num)->select();
            
            //分页处理
            $pagelist = $this->instance('pagelist');
            
            $total_num_data = $comment_model->count('comments', 'comment_id');
            
            //获取全局设置信息
                        
            $config_data    = auth::get_config_data();
            
             //assign params
            $this->assign(array(
                'site_name'     => '评论管理',
                'list_data'     => $comment_data,
                'pagelist_css'  => $pagelist->load_css(),
                'pagelist_html' => $pagelist->url($this->get_self_url() . '/?page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
                'is_verify'     => $config_data['is_verify'],
            ));
            
            //display page
            $this->display();
        }
        
        /**
         * ajax删除评论
         */
        public function ajax_delete_commentAction() {
            //判断是否登陆
            auth::parse_login(true);
            
            //获取参数
            $mode       = (int)$this->post('mode');
            $list_id    = $this->post('list_id');
            $list_id    = ($mode == 1) ? $list_id : (int)$list_id;
            if(!$list_id) {
                exit ();
            }
            
            //实例化model
            $comment_model  = $this->model('comments');           
            
            $list_id_array = ($mode == 1) ? explode(',', $list_id) : array($list_id);
            $result_status = false;
            foreach ($list_id_array as $comment_id) {
                $comment_data = $comment_model->find($comment_id, array('post_id'));
                $comment_nums_data = $comment_model->count('comments', 'comment_id', 'post_id=' . $comment_data['post_id']);
                if ($comment_nums_data ==1) {
                    $comment_model->query("UPDATE `posts` SET `comment_status` = 0 WHERE `post_id` ={$comment_data['post_id']}");
                }
                $result_status = $comment_model->delete('comment_id=' . $comment_id);
                if(!$result_status) {
                    break;
                }
            }
            
            echo ($result_status == true) ? 101 : '对不起!操作失败,请重新操作';
        }
        
        /**
         * ajax审核评论
         */
        public function ajax_verlidata_commentAction() {
             //判断是否登陆
            auth::parse_login(true);
            
            //获取参数
            $mode       = (int)$this->post('mode');
            $list_id    = $this->post('list_id');
            $list_id    = ($mode == 1) ? $list_id : (int)$list_id;
            if(!$list_id) {
                exit ();
            }
            
            //实例化model
            $comment_model  = $this->model('comments');           
            
            $list_id_array = ($mode == 1) ? explode(',', $list_id) : array($list_id);
            $result_status = false;
            foreach ($list_id_array as $comment_id) {
                $result_status = $comment_model->update(array('approved'=>1), 'comment_id=' . $comment_id);
                if (!$result_status) {
                    break;
                }
            }
            
            echo ($result_status == true) ? 101 : '对不起!操作失败,请重新操作';
        }

        /**
         * 后台管理：敏感词管理页面
         */
        public function wordAction() {
             //判断登陆
            auth::parse_login();
            
            //获取参数
            $page = (int)$this->get('page');
            $page = (!$page) ? 1 : $page;
            
            //实例化model
            $word_model = $this->model('words');
            
            //定义每页显示的列表数
            $page_list_num = 10;
            
            $word_data = $word_model->from('words')->order('word_id desc')->page_limit($page, $page_list_num)->select();
            
            //分页处理
            $pagelist = $this->instance('pagelist');
            $total_num_data = $word_model->count('words', 'word_id');
            
             //assign params
            $this->assign(array(
                'site_name' => '敏感词管理',
                'list_data' => $word_data,
                'pagelist_css' => $pagelist->load_css('classic'),
                'pagelist_html' => $pagelist->url($this->get_self_url() . '/?page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
            ));
            
            //display page
            $this->display();
        }
        
        /**
         * ajax实现thickbox的编辑页面
         */
        public function ajax_tb_edit_wordsAction() {
             //判断是否登陆
            auth::parse_login(true);
            
            //获取参数
            $word_id = (int)$this->get('id');
            if (!$word_id) {
                exit ();
            }
            
            //实例化model
            $word_model = $this->model('words');
            
            $word_data = $word_model->find($word_id);
            
            //加载视图文件
            include $this->template();
        }
        
        /**
         * ajax完成敏感词的编辑
         */
        public function ajax_edit_wordsAction() {
            //判断是否登陆
            auth::parse_login(true);
            
            //获取参数
            $word_id        = (int)$this->post('word_id');
            $word_name      = $this->post('word_name');
            $replace_name   = $this->post('replace_name');
            if (!$word_id || !$word_name) {
                exit ();
            }
            $replace_name = (!$replace_name) ? '***' : $replace_name;
            
            //实例化model
            $word_model = $this->model('words');
            
            //查询所要编辑的敏感词是否存在
            $check_word_data = $word_model->from('words', 'word_id')->where('word_name=?', $word_name)->where('word_id!=' . $word_id)->select(false);
            if ($check_word_data) {
                echo 103;
                exit ();
            }
            
            $update_word_array = array(
                'word_name'     => $word_name,
                'word_replace'  => $replace_name,
            );
            
            //清除数据表内容缓存文件(注：model的自定义函数)
            $word_model->clear_cache_file();
            
            echo $word_model->update($update_word_array, 'word_id=' . $word_id) ? 101 : 100;
        }

        /**
         * AJAX删除敏感词
         */
        public function ajax_delete_wordsAction() {
            //判断是否登陆
            auth::parse_login(true);
            
            //获取参数
            $mode       = (int)$this->post('mode');
            $list_id    = $this->post('list_id');
            $list_id    = ($mode == 1) ? $list_id : (int)$list_id;
            if(!$list_id) {
                exit ();
            }
            
            $list_id_array = ($mode == 1) ? explode(',', $list_id) : array($list_id);
            
            //实例化model
            $word_model = $this->model('words');
            
            $result_status = false;
            foreach ($list_id_array as $word_id) {
                $result_status = $word_model->delete('word_id=' . $word_id);
                if (!$result_status) {
                    break;
                }
            }
            
            if ($result_status == false) {
                echo 100;
                exit ();
            }
            
             //清除数据表内容缓存文件(注：model的自定义函数)
            $word_model->clear_cache_file();
                
            echo 101;
        }

        /**
         * AJAX完成敏感词的添加
         */
        public function ajax_insert_wordsAction() {
            //判断是否登陆
            auth::parse_login(true);
            
            //获取参数
            $word_name      = $this->post('word_name');
            $replace_name   = $this->post('replace_name');
            if (!$word_name) {
                exit ();
            }
            $replace_name = (!$replace_name) ? '***' : $replace_name;
            
            //实例化model
            $word_model = $this->model('words');
            
            //查询所要添加的敏感词是否已存在
            $check_word_data = $word_model->getOne('word_name=?', $word_name, array('word_id'));
            if ($check_word_data) {
                echo 103;
                exit ();
            }
            
            $insert_word_array = array(
              'word_name'       => $word_name, 
              'word_replace'    => $replace_name,
            );
            
             //清除数据表内容缓存文件(注：model的自定义函数)
            $word_model->clear_cache_file();
            
            echo $word_model->insert($insert_word_array) ? 101 : 100;
        }        
}