<?php
class Admin_indexController extends Controller {
    /**
     * 定义布局视图
     * 
     * @var string
     */
    protected $layout = 'admin_main';
    
    /**
     * 后页管理首页
     */
	public function indexAction() {
        
        //分析登陆状态
        auth::parse_login();           
        
        //实例化model
        $post_model     = $this->model('posts');
        
        $post_num_data = $post_model->count('posts', 'post_id', 'post_type=0');
        $page_num_data = $post_model->count('posts', 'post_id', 'post_type=1');
        
        $comment_num_data = $post_model->count('comments', 'comment_id');
        
        
        $config_data = auth::get_config_data();
        
        if ($config_data['is_verify']) {
            $validate_num_data = $post_model->count('comments', 'comment_id', 'approved=1');
        }        
        
        $mysql_version = $post_model->execute("select version() as version", false);
        
        $list_data = array(
           'post'           => $post_num_data,
           'page'           => $page_num_data,
           'comment'        => $comment_num_data,
           'verify'         => $validate_num_data,           
        );
        
        if (function_exists("imagecreate")) {
            if(function_exists('gd_info')) {
                $ver_info = gd_info();
                $gd_ver = $ver_info['GD Version'];
            }else{
                $gd_ver = '支持';
            }
        }else{
            $gd_ver = '不支持';
        }

        //assing params
        $this->assign(array(
           'site_name'  => 'Smile Blog 管理首页',
           'is_verify' => $config_data['is_verify'],
           'list_data' => $list_data,
           'mysql_data'=> $mysql_version['version'],
            'gd_ver'   => $gd_ver,
        ));
        
        $this->display();
	}
    
    public function infoAction() {
        
        //登录分析
        auth::parse_login(true);
        
        phpinfo();
    }
}