<?php
class Admin_linkController extends Controller {
    /**
     * 定义布局视图
     * 
     * @var string
     */
    protected $layout = 'admin_main';
        
    /**
     * 后台管理：友情链接列表页面
     */
	public function indexAction() {
        //判断登陆
        auth::parse_login();
        
        //获取参数
        $page = (int)$this->get('page');
        $page = (!$page) ? 1 : $page;
        
        //定义每页显示的列表数
        $page_list_num = 10;
        
        //实例化model
        $link_model = $this->model('friend_links');
        
        $list_data = $link_model->from('friend_links', array('link_id', 'link_name', 'link_url', 'link_note'))->where('link_status=1')->order('sort_order asc')->page_limit($page, $page_list_num)->select();
        
        //分页处理
        $pagelist = $this->instance('pagelist');
        
        $total_num_data = $link_model->count('friend_links', 'link_id', 'link_status=1');
        
        //assign params
        $this->assign(array(
            'site_name'     => '链接管理',
            'page'          => $page,
            'list_data'     => $list_data,
            'pagelist_css'  => $pagelist->load_css(),
            'pagelist_html' => $pagelist->url($this->get_self_url() . '/?page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
         ));
            
        //display page
        $this->display();
	}
    
    /**
     * ajax删除链接
     */
    public function ajax_delete_linkAction() {
         //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $mode       = (int)$this->post('mode');
        $list_id    = $this->post('list_id');
        $list_id    = ($mode == 1) ? $list_id : (int)$list_id;
        if (!$list_id) {
            exit ();
        }
        
        $list_array = ($mode ==1) ? explode(',', $list_id) : array($list_id);
        
        //实例化model
        $link_model = $this->model('friend_links');
        
        $result_status = false;
        foreach ($list_array as $link_id) {
            $result_status = $link_model->delete('link_id=' . $link_id);
            if (!$result_status) {
                break;
            }
        }
        
        echo ($result_status == true) ? 101 : '对不起！操作失败,请重新操作';
    }
    
    /**
     * ajax实现thickbox编辑页面
     */
    public function ajax_tb_edit_linkAction() {
        //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $link_id = (int)$this->get('id');
        if(!$link_id) {
            exit ();
        }
        
        //实例化model
        $link_model = $this->model('friend_links');
        
        $link_data = $link_model->find($link_id);
        
        //加载视图
        include $this->template();
    }
    
    /**
     * ajax实现编辑链接
     */
    public function ajax_edit_linkAction() {
         //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $link_id    = (int)$this->post('link_id');
        $link_name  = $this->post('link_name');
        $link_url   = $this->post('link_url');
        $link_note  = $this->post('link_note');
        if (!$link_id || !$link_name || !$link_url) {
            exit ();
        }
        
         //实例化model
        $link_model = $this->model('friend_links');
        
        //查询所要编辑的网址是否已存在
        $check_link_data = $link_model->from('friend_links', 'link_id')->where('link_url=?', $link_url)->where('link_id!=' . $link_id)->select(false);
        if ($check_link_data) {
            echo '所要编辑的网址已存在';
            exit ();
        }
        
        $update_link_array = array(
            'link_name' => $link_name,
            'link_url'  => $link_url,
            'link_note' => $link_note,
        );
        
        echo $link_model->update($update_link_array, 'link_id=' . $link_id) ? 101 : '对不起!操作失败,请重新操作';
    }

    /**
     * 后台管理：添加新友情链接的操作页面
     */
    public function insert_newAction() {
        //判断登陆
        auth::parse_login();
            
        //assign params
        $this->assign(array(
            'site_name' => '添加新链接',
        ));
            
        //display page
        $this->display();
    }
    
    /**
     * ajax添加新链接
     */
    public function ajax_insert_linkAction() {
        //判断登陆
        auth::parse_login(true);
        
        //获取数据
        $link_name  = $this->post('link_name');
        $link_url   = $this->post('link_url');
        $link_note  = $this->post('link_note');
        if (!$link_name || !$link_url) {
            exit ();
        }
        
        if(!check::is_url($link_url)) {
            echo '输入的链接网址格式不正确!请重新输入';
            exit ();            
        }
        
        //实例化model
        $link_model = $this->model('friend_links');
        
        //查询所要添加的网址是否已存在
        $check_link_data = $link_model->getOne('link_url=?', $link_url, array('link_id'));
        if ($check_link_data) {
            echo '所要添加的链接网址已存在!';
            exit ();
        }
        
        $insert_link_array = array(
          'link_name'  => $link_name,
           'link_url'  => $link_url,
        );
        if ($link_note) {
            $insert_link_array['link_note'] = $link_note;
        }
        
        echo $link_model->insert($insert_link_array) ? 101 : '对不起!操作失败,请重新操作';
    }
}