<?php
class Admin_loginController extends Controller {   
    
         /**
         * 显示后台管理登陆form页面
         */
        public function indexAction() {            
            //parse login
            $this->parse_login();
            
            $this->set_layout();
            
            //display page
            $this->display();
        }
        
        /**
         * 完成用户名及密码验证等数据处理页面(供AJAX进行数据调用)
         */
        public function handle_loginAction() {           
            
            //session start
            session_start();
		
            //get params
            $user_name 	= $this->post('user_name');
            $password	= $this->post('user_password');
            $vdcode		= strtolower($this->post('vd_code'));
		
            //分析检验码
            if (strtolower(session::get('doit_tools_vdcode')) != $vdcode) {
                echo 105;
                exit();
            }
            
            //instance model
            $user_model = $this->model('admin_users');
            
            $user_data = $user_model->getOne('user_name=?', $user_name);
            if (!$user_data) {
                echo 103;
            } else {
                if ($user_data['user_password'] == substr(md5($password), 2)) {
                    $cookie_array = array('status'=>true, 'user_id'=>$user_data['user_id'], 'user_name'=>$user_name);
                    cookie::set('smile_admin_login', $cookie_array, 3600*4);
                    echo 101;
                } else {
                    echo 100;
                }
            }
        }
        
        /**
         * 用户退出管理的数据处理页面
         */
        public function logoutAction() {
             
            $cookie_array = array();
             cookie::set('smile_admin_login', $cookie_array);
            
             //跳转至登陆页面
            $this->redirect($this->get_action_url('index'));
        }
        
        /**
         * 验证码显示页面
         */
        public function vdcodeAction() {
            
            //load image_lib clss
            $image_lib = $this->instance('pincode');
		
            $image_lib->set_session_name('doit_tools_vdcode')->show();
        }
        
    /**
	 * 分析是否登陆
	 */
	public function parse_login() {
		
		$login_state = cookie::get('smile_admin_login');
		
		if ($login_state['status'] == true) {
			//跳转向首页
			$this->redirect($this->create_url('admin_index/index'));
		}
		
		return true;
	}
}