<?php
class Admin_pageController extends Controller {
    /**
     * 定义布局视图
     * 
     * @var string
     */
    protected $layout = 'admin_main';
        
    /**
     * 后台管理：评论列表管理页面
     */
	public function indexAction() {
        //判断登陆
        auth::parse_login();
        
        //获取参数
        $page = (int)$this->get('page');
        $page = (!$page) ? 1 : $page;
        
        //实例化model
        $post_model = $this->model('posts');
        
        //定义每页显示的列表数
        $page_list_num = 10;
        
        $post_data = $post_model->from('posts', array('post_id', 'post_title', 'post_author', 'date_added'))->where('post_type=1')->order('post_id desc')->select();        
        $list_array = array();
        if ($post_data) {
            foreach ($post_data as $key=>$lines) {
                $list_array[$key]['id']     = $lines['post_id'];
                $list_array[$key]['title']  = $lines['post_title'];
                $author_data = $post_model->from('admin_users', 'user_name')->where('user_id=' . $lines['post_author'])->select(false);
                $list_array[$key]['author'] = $author_data['user_name'];
                $list_array[$key]['time']   = $lines['date_added'];
            }
        }
        
        //处理分页
        $pagelist = $this->instance('pagelist');
        
        $total_num_data = $post_model->count('posts', 'post_id', 'post_type=1');
        
        //assign params
        $this->assign(array(
           'site_name'      => '页面列表',
           'list_data'      => $list_array,
           'page'           => $page,
            'pagelist_css'  => $pagelist->load_css('classic'),
            'pagelist_html' => $pagelist->url($this->get_self_url() . '/?page=')->total($total_num_data)->num($page_list_num)->page($page)->output(),
        ));
            
         //display page
        $this->display();
	}
    
    /**
     * 编辑页面
     */
    public function edit_articleAction() {
        //判断登陆
        auth::parse_login();
        
        //获取参数
        $post_id    = (int)$this->get('id');
        $page       = (int)$this->get('page');
        $page       = (!$page) ? 1 : $page;
        if (!$post_id) {
            exit ();
        }
        
        //实例化model
        $post_model     = $this->model('posts');
        $meta_model     = $this->model('post_meta');
        $tag_model      = $this->model('tags');
        $post_tag_model = $this->model('post_tags');
        
        //获取页面数据
        $post_data = $post_model->find($post_id);
        $meta_data = $meta_model->find($post_id);
        
        //获取标签
        $tag_data  = $post_tag_model->getAll('post_id=' . $post_id, null, array('tag_id'));
        $tag_str   = '';
        if ($tag_data) {
            $tag_array = array();
            foreach ($tag_data as $lines) {
                $tag_name_data  = $tag_model->find($lines['tag_id']);
                $tag_array[]    = $tag_name_data['tag_name'];
            }
            $tag_str = implode(',', $tag_array);
            unset ($tag_array);
        }
        
        //编辑器
        $editor = $this->module('kindeditor');
        
        $this->assign(array(
            'site_name' => '编辑页面',
            'post_data' => $post_data,
            'meta_data' => $meta_data,
            'editor_js' => $editor->get_simple_editor('content_box'),
            'tag_str'   => $tag_str,
        ));
        
        $this->display();
    }
    
    /**
     * ajax处理页面编辑
     */
    public function ajax_edit_pageAction() {
        //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $post_id    = (int)$this->post('post_id');
        $title      = $this->post('title');
        //对富文本编辑内容进行xss代码过滤,安全之需,无法抗拒
        $content    = trim(check::remove_xss($_POST['content']));
        $tag        = $this->post('tag');
        $keyword    = $this->post('keyword');
        $decription = $this->post('description');
        
        if (!$post_id || !$title || !$content) {
            exit ();
        }

        //实例化model
        $post_model     = $this->model('posts');
        $meta_model     = $this->model('post_meta');
        $tag_model      = $this->model('tags');
        $post_tag_model = $this->model('post_tags');
        
        //更改页面基本内容
        $update_post_array = array(
          'post_title'  => $title,
          'post_content' => $content,
          'date_modified' => date('Y-m-d H:i:s'),
        );
        
        if(!$post_model->update($update_post_array, 'post_id=' . $post_id)) {
            echo 100;
            exit ();
        }
        
        //更改meta数据
        $check_meta_data = $meta_model->find($post_id, array('post_id'));
        if($check_meta_data) {
            $update_meta_array = array(
                'meta_keyword'      => $keyword,
                'meta_description'  => $decription,
            );
            $meta_model->update($update_meta_array, 'post_id=' . $post_id);
        } else {
            if ($keyword || $decription) {
                $insert_meta_array['post_id'] = $post_id;
                if ($keyword) {
                    $insert_meta_array['meta_keyword'] = $keyword;
                }
                if ($decription) {
                    $insert_meta_array['meta_description'] = $decription;
                }
                $meta_model->insert($insert_meta_array);
            }
        }
        
        //更改相关联的标签
        $check_tag_data = $post_tag_model->getAll('post_id=' . $post_id, null, array('tag_id'));
        if ($check_tag_data) {
            foreach ($check_tag_data as $lines) {
                $tag_data = $tag_model->find($lines['tag_id']);
                if ($tag_data['count'] > 1) {
                    $tag_model->update(array('count'=>$tag_data['count'] - 1), 'tag_id=' . $lines['tag_id']);
                } else {
                    $tag_model->delete('tag_id=' . $lines['tag_id']);
                }
            }
            $post_tag_model->delete('post_id=' . $post_id);
        }
        
        if($tag) {
            $tag = str_replace('，', ',', $tag);
            $tag_array = explode(',', $tag);
            foreach ($tag_array as $tag_name) {
                $tag_name = trim($tag_name);
                $tag_tmp_data= $tag_model->getOne('tag_name=?', $tag_name, array('tag_id', 'count'));
                if ( $tag_tmp_data) {
                    $tag_model->update(array('count'=> $tag_tmp_data['count'] + 1), 'tag_id=' .  $tag_tmp_data['tag_id']);
                    $tag_id =  $tag_tmp_data['tag_id'];
                } else {
                    $tag_model->insert(array('tag_name'=>$tag_name));
                    $tag_id = $tag_model->get_insert_id();
                }
                
                $post_tag_model->insert(array('post_id'=>$post_id, 'tag_id'=>$tag_id));
            }
        }
        
        echo 101;
    }

    /**
     * ajax完成删除页面内容
     */
    public function ajax_delete_pageAction() {
        //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $mode       = (int)$this->post('mode');
        $list_id    = $this->post('list_id');
        $list_id    = ($mode == 1) ? $list_id : (int)$list_id;
        if (!$list_id) {
            exit ();
        }
        
        //实例化model
        $post_model     = $this->model('posts');
        $meta_model     = $this->model('post_meta');
        $tag_model      = $this->model('tags');
        $post_tag_model = $this->model('post_tags');
        
        $list_array = ($mode ==1) ? explode(',', $list_id) : array($list_id);
        
        $result_status = false;
        foreach ($list_array as $post_id) {
            $result_status = $post_model->delete('post_id=' . $post_id);
            if ($result_status) {
                //删除meta数据
                $meta_model->delete('post_id=' . $post_id);
                //删除相关联的标签
                $post_tag_data = $post_tag_model->getAll('post_id=' . $post_id, null, array('tag_id'));
                if ($post_tag_data) {
                    foreach ($post_tag_data as $rows) {
                        $tag_data = $tag_model->find($rows['tag_id']);
                        if ($tag_data['count'] > 1) {
                            $tag_model->update(array('count'=>$tag_data['count'] - 1), 'tag_id=' . $rows['tag_id']);
                        } else {
                            $tag_model->delete('tag_id=' . $rows['tag_id']);
                        }
                    }
                    $post_tag_model->delete('post_id=' . $post_id);
                }
            } else {
                break;
            }
        }
        
        echo ($result_status == true) ? 101 : 100;
    }

        /**
     * 后台管理：添加新PAGE页面
     */
    public function insert_newAction() {
         //判断登陆
         auth::parse_login();
         
        $admin_login_data = cookie::get('smile_admin_login');
        
        //编辑器
        $editor = $this->module('kindeditor');
        
         //assign params
        $this->assign(array(
            'site_name' => '添加新页面',
            'user_id' => $admin_login_data['user_id'],
            'editor_js' => $editor->get_simple_editor('content_box'),
        ));
            
        //display page
        $this->display();
    }
    
    /**
     * ajax添加新页面
     */
    public function ajax_insert_newAction() {
        //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $title          = $this->post('title');
        //富文本内容不让人省心呀,又得过滤xss代码,以防xss攻击
        $content        = trim(check::remove_xss($_POST['content']));
        $author         = $this->post('author');
        $tag            = $this->post('tag');
        $keyword        = $this->post('keyword');
        $description    = $this->post('description');
        if (!$title || !$content || !$author) {
            exit ();
        }
        
        //实例化model
        $post_model = $this->model('posts');
        
        $insert_post_array = array(
            'post_author'   => $author,
            'post_type'     => 1,
            'post_title'    => $title,
            'post_content'  => $content,
            'date_added'    => date('Y-m-d H:i:s'),
        );
        
        if (!$post_model->insert($insert_post_array)) {
            echo 100;
            exit ();
        }
        
        $post_id = $post_model->get_insert_id();
        
        //处理关键词及搜索简介
        if($keyword || $description) {
            $meta_model = $this->model('post_meta');
            
            $insert_meta_array['post_id']               = $post_id;
            if($keyword) {
                $insert_meta_array['meta_keyword']      = $keyword;
            }
            if($description) {
                $insert_meta_array['meta_description']  = $description;
            }
            
            $meta_model->insert($insert_meta_array);
        }
        
        //处理标签
        if ($tag) {
            $tag_model      = $this->model('tags');
            $post_tag_model = $this->model('post_tags');
            
            $tag = str_replace('，', ',', $tag);
            $tag_array = explode(',', $tag);
            foreach ($tag_array as $tag_name) {
                $tag_name = trim($tag_name);
                $tag_data = $tag_model->getOne('tag_name=?', $tag_name, array('tag_id', 'count'));
                if ($tag_data) {
                    $tag_model->update(array('count'=>$tag_data['count'] + 1), 'tag_id=' . $tag_data['tag_id']);
                    $tag_id = $tag_data['tag_id'];
                } else {
                    $tag_model->insert(array('tag_name'=>$tag_name));
                    $tag_id = $tag_model->get_insert_id();
                }
                
                $post_tag_model->insert(array('post_id'=>$post_id, 'tag_id'=>$tag_id));
            }
        }
        
        echo 101;
    }
}