<?php
class Admin_userController extends Controller {
    /**
     * 定义布局视图
     * 
     * @var string
     */
    protected $layout = 'admin_main';
    
    /**
     * 后台管理：用户管理页面
     */
	public function indexAction() {
         //判断登陆
        auth::parse_login();
        
        //获取参数
        $page = (int)$this->get('page');
        $page = (!$page) ? 1 : $page;
        
        //定义每页显示列表数
        $page_list_num = 10;
        
        //实例化model
        $user_model = $this->model('admin_users');
        
        $user_data = $user_model->from('admin_users', array('user_id', 'user_name', 'user_email', 'user_status'))->order('user_id desc')->page_limit($page, $page_list_num)->select();
        
        $list_array = array();
        if($user_data) {
            foreach ($user_data as $key=>$lines) {
                $list_array[$key]['id']     = $lines['user_id'];
                $list_array[$key]['name']   = $lines['user_name'];
                $list_array[$key]['email']  = $lines['user_email'];
                $list_array[$key]['role']   = ($lines['user_status'] == 1) ? '管理员' : '编辑';                
                $list_array[$key]['num']    = $user_model->count('posts', 'post_id', array('post_type=0','post_author=' . $lines['user_id']));
            }
        }
        
        //分页处理
        $pagelist = $this->instance('pagelist');
        $total_num_data = $user_model->count('admin_users', 'user_id');
        
        //assign params
        $this->assign(array(
            'site_name'     => '用户列表',
            'list_data'     => $list_array,
            'pagelist_css'  =>$pagelist->load_css(),
            'pagelist_html' => $pagelist->total($total_num_data)->url($this->get_self_url() . '/?page=')->num($page_list_num)->page($page)->output(),
        ));
            
        //display page
        $this->display();
	}
    
    /**
     * ajax删除用户
     */
    public function ajax_delete_userAction() {
         //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $list_id = $this->post('list_id');
        if (!$list_id) {
            exit ();
        }
        
        //实例化model
        $user_model = $this->model('admin_users');
        
        //查看当前操作者的角色.只有高级管理员有删除权限        
        $admin_login_data = cookie::get('smile_admin_login');
        $admin_user_id = $admin_login_data['user_id'];
        $check_role_data = $user_model->find($admin_user_id, array('user_status '));
        if (!$check_role_data['user_status']) {
            echo '你不是高级管理员,没有删除用户的操作权限!';
            exit ();
        }
        
        $list_array = explode(',', $list_id);
        
        $result_status = false;
        foreach ($list_array as $user_id) {
            //查询所删除的用户是否为高级管理员,高级管理员不能删除的
            $check_user_data = $user_model->getOne('user_id=' . $user_id, null, array('user_name', 'user_status'));
            if ($check_user_data['user_status'] == 1) {
                echo '对不起,你没有权限删除高级管理员:', $check_user_data['user_name'];
                exit ();
            }
            $result_status = $user_model->delete('user_id=' . $user_id);
            if (!$result_status) {
                break;
            }
        }
        
        echo ($result_status == true) ? 101 : '对不起!删除失败,请重新操作!';
    }

        /**
     * 后台管理：添加新用户操作页面
     */
    public function insert_newAction() {
         //判断登陆
        auth::parse_login();
        
        //assign params
        $this->assign(array(
            'site_name' => '添加新用户',
        ));
            
       //display page
       $this->display();
    }
    
    /**
     * ajax添加新用户
     */
    public function ajax_insert_userAction() {
         //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $user_name      = $this->post('name');
        $user_password  = $this->post('password');
        $user_email     = $this->post('email');
        $user_nickname  = $this->post('nickname');
        if (!$user_name || !$user_password || !$user_email) {
            exit ();
        }
        if (!check::is_email($user_email)) {
            echo '对不起,您输入的邮箱地址格式不正确!';
            exit ();
        }
        
        //实例化model
        $user_model = $this->model('admin_users');
        
        //查询所要添加的用户信息有无重复数据
        $user_name_data = $user_model->getOne('user_name=?', $user_name, array('user_id'));
        if ($user_name_data) {
            echo '对不起，所要添加的用户名已存在,请更换用户名';
            exit ();
        }
        
        $user_email_data = $user_model->getOne('user_email=?', $user_email, array('user_id'));
        if ($user_email_data) {
            echo '对不起,所要添加的邮箱已存在,请更换邮箱';
            exit ();
        }
        
        $insert_user_array = array(
            'user_name'     => $user_name,
            'user_password' => substr(md5($user_password), 2),
            'user_email'    => $user_email,
            'user_status'   => 0,
            'date_added'    => date('Y-m-d H:i:s'),
        );
        if ($user_nickname) {
            $insert_user_array['user_nickname'] = $user_nickname;
        }
        
        echo $user_model->insert($insert_user_array) ? 101 : '对不起！添加用户失败,请重新操作';
    }

        /**
     * 后台管理：我的资料信息页面
     */
    public function profileAction() {
         //判断登陆
        auth::parse_login();
        
        //获取参数
        $user_id = (int)$this->get('id');
        if (!$user_id) {
            $admin_login_data   = cookie::get('smile_admin_login');
            $user_id            = $admin_login_data['user_id'];
        }        
        if (!$user_id) {
            exit ();
        }
        
        //实例化model
        $user_model = $this->model('admin_users');
        
        $user_data = $user_model->find($user_id, array('user_id', 'user_name', 'user_email', 'user_nickname'));
        
        //assign params
        $this->assign(array(
            'site_name' => '我的资料',
            'user_data' => $user_data,
        ));
            
        //display page
        $this->display();    
    }
    
    /**
     * ajax编辑用户信息
     */
    public function ajax_edit_userAction() {
         //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $user_id        = (int)$this->post('user_id');
        $user_name      = $this->post('user_name');
        $user_email     = $this->post('user_email');
        $user_nickname  = $this->post('user_nickname');
        if (!$user_id || !$user_name || !$user_email) {
            exit ();
        }
        
        //实例化model
        $user_model = $this->model('admin_users');
        
        //查看当前操作者的角色.只有高级管理员有更改别的用户的权限        
        $admin_login_data = cookie::get('smile_admin_login');
        $admin_user_id = $admin_login_data['user_id'];
        $check_role_data = $user_model->find($admin_user_id, array('user_status '));
        if (($admin_user_id != $user_id) && (!$check_role_data['user_status'])) {
            echo '你不是高级管理员,没有更改其它用户信息的操作权限!';
            exit ();
        }
        
        //查询所要编辑的用户名及邮箱是否已存在
        $chekc_name_data = $user_model->from('admin_users', 'user_id')->where('user_name=?', $user_name)->where('user_id!=' . $user_id)->select(false);
        if ($chekc_name_data) {
            echo '对不起!所要编辑的用户名已被使用';
            exit ();
        }
        $chekc_email_data = $user_model->from('admin_users', 'user_id')->where('user_email=?', $user_email)->where('user_id!=' . $user_id)->select(false);
        if ($chekc_email_data) {
            echo '对不起!所要编辑的邮箱已被使用';
            exit ();
        }
        
        $update_user_array = array(
            'user_name'     => $user_name,
            'user_email'    => $user_email,
        );
        if ($user_nickname) {
            $update_user_array['user_nickname'] = $user_nickname;
        }
        //$this->dump($update_user_array);
        echo $user_model->update($update_user_array, 'user_id=' . $user_id) ? 101 : '对不起!操作失败,请重新操作!';
    }
    
    /**
     * ajax更改用户密码
     */
    public function ajax_edit_passwordAction() {
         //判断登陆
        auth::parse_login(true);
        
        //获取参数
        $user_id        = (int)$this->post('user_id');
        $user_password  = $this->post('user_password');
        if (!$user_id || !$user_password) {
            exit ();
        }
        
        //实例化model
        $user_model = $this->model('admin_users');
        
         //查看当前操作者的角色.只有高级管理员有更改别的用户的权限        
        $admin_login_data = cookie::get('smile_admin_login');
        $admin_user_id = $admin_login_data['user_id'];
        $check_role_data = $user_model->find($admin_user_id, array('user_status '));
        if (($admin_user_id != $user_id) && (!$check_role_data['user_status'])) {
            echo '你不是高级管理员,没有更改其它用户信息的操作权限!';
            exit ();
        }
        
        echo $user_model->update(array('user_password'=>substr(md5($user_password), 2)), 'user_id=' . $user_id) ? 101 : '对不起,更改密码操作失败！请重新操作';
    }
}