<?php
/**
 * auth.php
 * 
 * 权限验证，敏感词过滤，获取项目总体参数设置
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: auth.php 1.0 2011-8-28 15:02:57Z tommy $
 * @package extensions
 * @since 1.0
 */

class auth {
    
    /**
      * 分析是否登陆
      * 
      * @access private
      * @param boolean   $item   选项,当为true时，未登陆则不进行跳转
      * @return boolean
      */
    public static function parse_login($item = false) {
        
        $admin_login_data = cookie::get('smile_admin_login');
            
        if ($admin_login_data['status'] == false) {
            ($item === false) ? Controller::redirect(Controller::create_url('admin_login/index')) : exit();
        }
    }
    
    /**
     * 过滤敏感词
     * 
     * @access public
     * @param string $content
     * @return string
     */
    public function parse_ban_words($content) {
        
        if (!$content) {
            return false;
        }
        
        $word_model = Controller::model('words');
        
        $cache_db  = Controller::instance('cache_db');
        
        $words_data = $cache_db->lifetime(3600*24*7)->load('words', array('word_name', 'word_replace'));
        
        $ban_words_array        = array();
        $replace_words_array    = array();
        foreach ($words_data as $key=>$lines) {
            $ban_words_array[$key]      = $lines['word_name'];
            $replace_words_array[$key]  = $lines['word_replace'];
        }
        
        return str_replace($ban_words_array, $replace_words_array, $content);
    }
    
    /**
     * 获取项目设置的参数信息
     * 
     * @access pulic
     * @return string
     */
    public function get_config_data() {
        
         $db_cache = Controller::instance('cache_db');
         
         return $db_cache->load_config('config_options', 'option_name', 'option_value');
    }
}