<?php
// +---------------------------------------------------------------
// | Tommy Framework
// +---------------------------------------------------------------
// | Copyright (c) 2009 http://www.tommycode.com All rights reserved.
// +---------------------------------------------------------------
// | Author: streen003 <streen003gmail.com>
// +---------------------------------------------------------------

if(!defined('IN_DOIT')){exit();}

class calendar extends Base {
	

	
	//构造函数,用于初始化运行环境.
	public function __construct(){
		
	}
	
	//显示日历.
	public function output($year=FALSE, $month=FALSE){		
		//获得当前时间戳
		$time_now = isset($_SERVER['REQUEST_TIME']) ? $_SERVER['REQUEST_TIME'] : time();
		$year = empty($year) ? date('Y', $time_now) : $year;
		$month = empty($month) ? date('m', $time_now) : $month;		
		$year_now = date('Y',$time_now);
		$month_now = date('m',$time_now);
		$date_now = date('j', $time_now);		
		$time_index = mktime(0, 0, 0, $month, 1, $year);		
		//获取当前所在月份的总天数，第一天的星期数.
		$total_days = date('t', $time_index);
		$day_index = date('w', $time_index);		
		//计算日历的总行数。
		$total_lines = ceil( ($total_days + $day_index)/7 );		
		$html =<<<EOT
<!-- calendar begin -->
<table class="calendar">
<tr><td colspan="7" class="message">$year 年  $month 月</td></tr>
<tr class="menu">
  <td>日</td>
  <td>一</td>
  <td>二</td>
  <td>三</td>
  <td>四</td>
  <td>五</td>
  <td>六</td>
</tr>
EOT;

		for ($i=0; $i<$total_lines; $i++){			
			$html .= "<tr align=\"center\">";
			for ($k=0; $k<7; $k++){				
				$date_show = intval( 7*$i + $k - $day_index + 1);
				if(($date_show < 1)||($date_show>$total_days)){					
					$html .= "<td>&nbsp;</td>";
				}
				else
				{
					$html .= (($date_show==$date_now)&&($month_now==$month)&&($year_now==$year)) ? "<td class=\"today\">" . $date_show . "</td>" : "<td>" . $date_show . "</td>";
				}
			}
			$html .= "</tr>";
		}
		$html .= "</table><!-- calendar end -->";
		
		return $html;
	}
}