<?php
class Config_optionsModel extends Model {

	protected function get_primary_key() {
		return $this->primary_key = 'option_id';
	}

	protected function get_table_fields() {
		return $this->table_field = array (
  0 => 'option_id',
  1 => 'option_name',
  2 => 'option_value',
  3 => 'autoload',
);
	}
    
    /**
     * 自定义函数
     * 
     * 更改数据表内容
     */
    public function config_update($params) {
        
        //parse param
        if (!$params && !is_array($params)) {
            return false;
        }
        
        $result_status = true;
        foreach ($params as $key => $lines) {            
            if (!$this->update(array('option_value'=>$lines), 'option_name=?', $key)) {
                $result_status = false;
                break;
            }
        }
        
        if (!$result_status) {
            return false;
        }
        
        $db_cache = doit::singleton('cache_db');
        
        $db_cache->delete('config_options');
        
        return true;
    }
    
    
}