<?php
class title_nameWidget extends Widget {

	public function render(){
                 
         $config_data = auth::get_config_data();
         
         $action_id = doit::get_action_id();
         
         switch ($action_id) {
             case 'index':
                 $keyword       = $config_data['meta_keyword'];
                 $description   = $config_data['meta_description'];
                 $title         = '首页--' . $config_data['site_name'];
                 break;
             
             case 'article':              
             case 'page':
                 $post_id = (int)$this->get('id');
                 
                 //instance model
                 $meta_model = $this->model('post_meta');
                 
                 $meta_data = $meta_model->find($post_id);
                 $title_data = $meta_model->from('posts', 'post_title')->where('post_id=' . $post_id)->select(false);
                                  
                 $keyword       = ($meta_data['meta_keyword']) ? $meta_data['meta_keyword'] : $title_data['post_title'];
                 $description   = ($meta_data['meta_description']) ? $meta_data['meta_description'] : $title_data['post_title'] . '--' . $config_data['site_name'];
                 $title         = $title_data['post_title'] . '--' . $config_data['site_name'];
                 break;
             
             case 'term':
                 $term_id = (int)$this->get('id');
                 
                 //instancem model
                 $term_model = $this->model('terms');
                 $term_data  = $term_model->find($term_id);
                 
                 $keyword       = ($term_data['term_name']) ? $term_data['term_name'] : $config_data['meta_keyword'];
                 $description   = ($term_data['term_note']) ? $term_data['term_note'] : $config_data['meta_description'];
                 $title         = $term_data['term_name'] . '--' . $config_data['site_name'];
                 break;
             
             case 'tag':
                 $tag_name = $this->get('tag_name');
                 
                 $keyword       = $tag_name . ',' .$config_data['meta_keyword'];
                 $description   = $config_data['meta_description'];
                 $title         = $tag_name . '--' . $config_data['site_name'];                 
                 break;
             
             default :
                 $keyword       = $config_data['meta_keyword'];
                 $description   = $config_data['meta_description'];
                 $title         = $config_data['site_name'];
         }
         
         echo '<meta name="Keywords" content="' . $keyword . '" /><meta name="Description" content="' . $description . '" /><title>' . $title . '</title>';
	}
}