/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50510
Source Host           : 127.0.0.1:3306
Source Database       : smileblog

Target Server Type    : MYSQL
Target Server Version : 50510
File Encoding         : 65001

Date: 2011-08-07 02:17:28
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for `admin_users`
-- ----------------------------
DROP TABLE IF EXISTS `admin_users`;
CREATE TABLE `admin_users` (
  `user_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(32) NOT NULL,
  `user_password` char(30) NOT NULL,
  `user_status` tinyint(1) DEFAULT '1',
  `user_email` varchar(96) NOT NULL,
  `user_nickname` varchar(32) DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `date_last_login` datetime DEFAULT NULL,
  `last_ip` varchar(39) DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_name` (`user_name`),
  KEY `user_status` (`user_status`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of admin_users
-- ----------------------------
INSERT INTO `admin_users` VALUES ('1', 'doitphp', '0adc3949ba59abbe56e057f20f883e', '1', 'doitphp@qq.com', 'doit', '2011-07-19 22:19:00', '2011-07-19 22:19:00', '127.0.0.1');
INSERT INTO `admin_users` VALUES ('4', 'tommy', '0adc3949ba59abbe56e057f20f883e', '0', 'streen003@gmail.cm', 'doitphp的开发者', '2011-08-03 22:29:01', null, null);

-- ----------------------------
-- Table structure for `comments`
-- ----------------------------
DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `comment_id` int(9) NOT NULL AUTO_INCREMENT,
  `post_id` int(9) NOT NULL,
  `parent_id` int(9) DEFAULT '0',
  `approved` tinyint(1) DEFAULT '0',
  `comment_author` varchar(32) NOT NULL,
  `author_email` varchar(96) NOT NULL,
  `author_site` varchar(255) DEFAULT NULL,
  `comment_content` tinytext NOT NULL,
  `comment_ip` varchar(39) NOT NULL,
  `comment_date` datetime NOT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `post_id` (`post_id`),
  KEY `parent_id` (`parent_id`),
  KEY `approved` (`approved`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of comments
-- ----------------------------
INSERT INTO `comments` VALUES ('1', '1', '0', '0', 'ethan', 'ethan@gmail.com', 'http://tommyframework.com', '神奇的国度,天天都有奇迹', '127.0.0.1', '2011-08-07 02:10:51');

-- ----------------------------
-- Table structure for `config_options`
-- ----------------------------
DROP TABLE IF EXISTS `config_options`;
CREATE TABLE `config_options` (
  `option_id` smallint(5) NOT NULL AUTO_INCREMENT,
  `option_name` varchar(32) NOT NULL,
  `option_value` varchar(255) NOT NULL,
  `autoload` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of config_options
-- ----------------------------
INSERT INTO `config_options` VALUES ('1', 'site_name', 'SMILE 博客(1.1版)', '1');
INSERT INTO `config_options` VALUES ('2', 'site_description', 'Just DoitPHP demo!', '1');
INSERT INTO `config_options` VALUES ('3', 'meta_keyword', 'doitphp实例作品, doitphp', '1');
INSERT INTO `config_options` VALUES ('4', 'meta_description', 'doitphp的演示实例', '1');
INSERT INTO `config_options` VALUES ('5', 'max_list_num', '10', '1');
INSERT INTO `config_options` VALUES ('6', 'is_verify', '0', '1');

-- ----------------------------
-- Table structure for `friend_links`
-- ----------------------------
DROP TABLE IF EXISTS `friend_links`;
CREATE TABLE `friend_links` (
  `link_id` smallint(5) NOT NULL AUTO_INCREMENT,
  `sort_order` smallint(5) DEFAULT '0',
  `link_status` tinyint(1) DEFAULT '1',
  `link_name` varchar(32) NOT NULL,
  `link_url` varchar(255) NOT NULL,
  `link_note` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`link_id`),
  KEY `sort_order` (`sort_order`),
  KEY `link_status` (`link_status`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of friend_links
-- ----------------------------
INSERT INTO `friend_links` VALUES ('1', '0', '1', 'DoitPHP', 'http://www.doitphp.com', 'DoitPHP的官方网址');
INSERT INTO `friend_links` VALUES ('5', '0', '1', 'TommyCode', 'http://www.tommycode.com', 'DoitPHP的开发者个人博客');

-- ----------------------------
-- Table structure for `post_meta`
-- ----------------------------
DROP TABLE IF EXISTS `post_meta`;
CREATE TABLE `post_meta` (
  `post_id` int(9) NOT NULL DEFAULT '0',
  `meta_keyword` varchar(255) DEFAULT NULL,
  `meta_description` tinytext,
  PRIMARY KEY (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of post_meta
-- ----------------------------
INSERT INTO `post_meta` VALUES ('1', 'doitphp,奇迹', 'DoitPHP的演示实例Smile博客已发布');
INSERT INTO `post_meta` VALUES ('2', 'smile blog, doitphp', '关于smile blog的简介');

-- ----------------------------
-- Table structure for `post_tags`
-- ----------------------------
DROP TABLE IF EXISTS `post_tags`;
CREATE TABLE `post_tags` (
  `post_id` int(9) NOT NULL,
  `tag_id` int(9) NOT NULL,
  `sort_order` int(9) DEFAULT '0',
  PRIMARY KEY (`post_id`,`tag_id`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of post_tags
-- ----------------------------
INSERT INTO `post_tags` VALUES ('1', '1', '0');
INSERT INTO `post_tags` VALUES ('1', '2', '0');
INSERT INTO `post_tags` VALUES ('2', '5', '0');
INSERT INTO `post_tags` VALUES ('2', '2', '0');

-- ----------------------------
-- Table structure for `posts`
-- ----------------------------
DROP TABLE IF EXISTS `posts`;
CREATE TABLE `posts` (
  `post_id` int(9) NOT NULL AUTO_INCREMENT,
  `post_author` smallint(5) NOT NULL,
  `post_type` tinyint(1) NOT NULL,
  `post_class` smallint(5) DEFAULT '0',
  `post_status` tinyint(1) DEFAULT '0',
  `comment_status` tinyint(1) DEFAULT '0',
  `post_title` varchar(255) NOT NULL,
  `post_content` text NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`post_id`),
  KEY `post_author` (`post_author`),
  KEY `post_type` (`post_type`),
  KEY `post_class` (`post_class`),
  KEY `post_status` (`post_status`),
  FULLTEXT KEY `pos_title` (`post_title`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of posts
-- ----------------------------
INSERT INTO `posts` VALUES ('1', '1', '0', '7', '0', '1', '这是一个奇迹', '<p>作为DoitPHP的演示实例：SMILE博客竟然发布了！事情就是这么发生了。在这里我只能说：这是一个奇迹。</p>\n<p>不管你信不信，反正我信了！</p>', '2011-08-07 01:47:51', null);
INSERT INTO `posts` VALUES ('2', '1', '1', '0', '0', '0', '关于', '<p>&nbsp;&nbsp;&nbsp; 本博客为DoitPHP的演示实例。具有了一般博客程序的基本功能。由于开发时间紧迫，作品的VI做的有点粗糙(视图也没有采用DIV+CSS)，不过这不重要。重要的是演示DoitPHP的使用方法。</p>\n<p>&nbsp;&nbsp;&nbsp; 本程序只是DoitPHP的基本用法，当然本博客有很大的优化空间，代码可以做得更精简一些。对此，如果您能熟练使用DoitPHP时，您一定能看出来，且会有更好的解决办法。</p>\n<p>&nbsp;&nbsp;&nbsp; 因为只是用于演示作用，所以有些地方功能设计不是很完美...这也是为了尽快发布本作品，让那些想学习使用DoitPHP的朋友早日有个实例来研究..不得不程序开发“大跃进”。</p>\n<p>&nbsp;&nbsp;&nbsp; 本博客的数据库设计时就以一个功能非常强大的博客来设计的，有的字段本作品并没有用到,不过以后本博客进行升级时...也有扩展空间。</p>\n<p>&nbsp;&nbsp;&nbsp; 本博客的搜索功能极为简单,只搜索文章标题中的关键词...没有办法,这也是大跃时的结果。</p>\n<p>&nbsp;</p>\n<p>&nbsp;&nbsp;&nbsp; 注：本作品中已经将DoitPHP文件集成了进来。无需下载DoitPHP文件啦！</p>\n<p>&nbsp;&nbsp;&nbsp; 后台管理登陆用户名：doitphp&nbsp;&nbsp;&nbsp; 密码：123456</p>', '2011-08-07 02:09:06', '2011-08-07 02:15:41');

-- ----------------------------
-- Table structure for `tags`
-- ----------------------------
DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
  `tag_id` int(9) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(32) NOT NULL,
  `count` int(9) DEFAULT '1',
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tags
-- ----------------------------
INSERT INTO `tags` VALUES ('1', '奇迹', '1');
INSERT INTO `tags` VALUES ('2', '博客', '2');
INSERT INTO `tags` VALUES ('5', 'doitphp', '1');

-- ----------------------------
-- Table structure for `terms`
-- ----------------------------
DROP TABLE IF EXISTS `terms`;
CREATE TABLE `terms` (
  `term_id` smallint(5) NOT NULL AUTO_INCREMENT,
  `term_name` varchar(32) NOT NULL,
  `term_note` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `term_name` (`term_name`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of terms
-- ----------------------------
INSERT INTO `terms` VALUES ('1', 'Linux', 'linux相关技术文章');
INSERT INTO `terms` VALUES ('2', 'Apache', 'apache server相关文章');
INSERT INTO `terms` VALUES ('3', 'Mysql', 'mysql数据库');
INSERT INTO `terms` VALUES ('4', 'PHP', '一种流行的网络编辑语言');
INSERT INTO `terms` VALUES ('5', 'Nginx', 'another new web server');
INSERT INTO `terms` VALUES ('6', 'Python', '又一种编辑语言');
INSERT INTO `terms` VALUES ('7', '生活随笔', '记录自己的心情');

-- ----------------------------
-- Table structure for `words`
-- ----------------------------
DROP TABLE IF EXISTS `words`;
CREATE TABLE `words` (
  `word_id` int(9) NOT NULL AUTO_INCREMENT,
  `word_name` varchar(255) NOT NULL,
  `word_replace` varchar(255) NOT NULL,
  PRIMARY KEY (`word_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of words
-- ----------------------------
INSERT INTO `words` VALUES ('1', '中共', '法西斯');
INSERT INTO `words` VALUES ('2', '温家保', '影帝');
INSERT INTO `words` VALUES ('3', '胡锦涛', '天朝圣上');
INSERT INTO `words` VALUES ('4', '法轮功', '***');
INSERT INTO `words` VALUES ('5', '中国', '天朝');
INSERT INTO `words` VALUES ('6', '和谐号动车', '嗜血的魔鬼');
INSERT INTO `words` VALUES ('7', '中国铁道部', '冷血、没人性、一群MJJ的家伙');
