<?php
/**
 * Log.class.php
 * 
 * DoitPHP日志管理
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: Log.class.php 1.0 2010-10-24 21:36:00Z tommy $
 * @package core
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
	exit();
}

class Log extends Base {
	
	/**
	 * 写入日志
	 * 
	 * 将日志内容写入日志文件,并且当日志文件大小到达2M时,则写入新的日志文件
	 * @access public
	 * @param string $message   所要写入的日志内容
	 * @param string $level     日志类型. 参数：Warning, Error, Notice
	 * @param string $log_file_name  日志文件名
	 * @return boolean
	 */
	public static function write($message, $level = 'Error', $log_file_name = null) {
		
		//参数分析
		if (!$message) {
			return false;
		}
		
		if (is_null($log_file_name)) {			
			$log_file_name = APP_ROOT . 'logs/' . date('Y_m_d', $_SERVER['REQUEST_TIME']) . '.log';
		}
		
		//分析日志文件大小是否超过允许的最大值:2M.
		if (is_file($log_file_name) && filesize($log_file_name) >= 2097152) {			
			rename($log_file_name, APP_ROOT . 'logs/' . $_SERVER['REQUEST_TIME'] . '-' . basename($log_file_name));
		}
		
		error_log(date('[Y-m-d H:i:s]', $_SERVER['REQUEST_TIME']) . " {$level}: {$message}\r\n", 3, $log_file_name);
	}
	
	/**
	 * 显示日志内容
	 * 
	 * 显示日志文件内容,以列表的形式显示.便于程序调用查看日志
	 * @access public
	 * @param string $log_file_name 所要显示的日志文件内容,默认为null, 即当天的日志文件名.注:不带后缀名.log
	 * @return void
	 */ 
	public static function show($log_file_name = null) {
		
		//参数分析	
		$log_file_name =  is_null($log_file_name) ? APP_ROOT . 'logs/' . date('Y_m_d', $_SERVER['REQUEST_TIME']) . '.log' : APP_ROOT . 'logs/' . $log_file_name . '.log';
		
		$log_content = file_get_contents($log_file_name);
		
		$list_str_array = explode("\r\n", $log_content);
		unset($log_content);
		$total_lines = sizeof($list_str_array);
		
		//输出日志内容
		echo '<table width="85%" border="0" cellpadding="0" cellspacing="1" style="background:#0478CB; font-size:12px; line-height:25px;">';
		
		foreach ($list_str_array as $key=>$lines_str) {
							
			if ($key == $total_lines - 1) {
				continue;
			}
			
			$bg_color = ($key % 2 == 0) ? '#FFFFFF' : '#C6E7FF';
			
			echo '<tr><td height="25" align="left" bgcolor="' . $bg_color .'">&nbsp;' . $lines_str . '</td></tr>';
		}
		
		echo '</table>';
	}
}