<?php
/**
 * Module.class.php
 * 
 * DoitPHP系统module的基类
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: Module.class.php 1.0 2011-3-24 20:10:00Z tommy $
 * @package core
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
	exit();
}

abstract class Module extends Controller {
	
	/**
	 * 设置视图布局
	 * 
	 * 注:Module不支持布局
	 * @access public
	 * @return boolean
	 */
	public function set_layout() {
		
		return false;
	}
	
	/**
	 * 设置视图主题
	 * 
	 * 扩展module里本功能是不支持的,所以返回false
	 * @access public
	 * @return boolean
	 */
	public function set_theme() {
		
		return false;
	}
	
	/**
	 * 视图类的实例化
	 * 
	 * 注:扩展module的视图格式不支持html文件
	 * @access public
	 * @return boolean
	 */
	public function load_view() {
		
		return true;
	}
	
	/**
	 * 获取当前扩展module目录的路径
	 * 
	 * @access public
	 * @return string	目录的路径
	 */
	public function get_module_root() {
		
		return APP_ROOT . 'modules/' . $this->get_module_id() . DIRECTORY_SEPARATOR;
	}
	
	/**
	 * 获取当前Module目录的URL
	 * 
	 * @access public
	 * @return string	当前Moudle目录的URL
	 */
	public function get_module_url() {
		
		return $this->get_base_url() . 'modules/' . $this->get_module_id() . '/';
	}
	
	/**
	 * 扩展module的视图显示
	 * 
	 * 注:扩展module的视图文件放在特定的目录里,所以扩展module不支持多种主题
	 * @access public
	 * @param sring $view_name 视图文件名
	 * @param array $_data	视图变量数组(所要赋值的视图变量)
	 * @return void
	 */
	public function display($view_name = null, $_data = array()) {
		
		//参数分析
		$view_file = $this->template($view_name);
		
		if (!empty($_data) && is_array($_data)) {			
			extract($_data, EXTR_PREFIX_SAME, 'data');
			unset($_data);
		}
		
		ob_start();				
		include $view_file;				
		echo ob_get_clean();
	}
	
	/**
	 * 获取当前Module的名称
	 * 
	 * @access protected
	 * @return string	Module名称
	 */
	protected function get_module_id() {
		
		return substr(strtolower(get_class($this)), 0, -6);
	}
	
	/**
	 * 分析module的视图文件
	 * 

	 */
	public function template($file_name = null) {
		
		//获取当前module文件路径
		$module_name = $this->get_module_id();
			
		//参数分析
		if (!$file_name) {
			$file_name = $module_name;
		}				
		
		return APP_ROOT . 'modules/' . $module_name . '/views/' . $file_name . '.php';
	}
}