<?php
/**
 * Widget.class.php
 * 
 * DoitPHP挂件(widget)基类
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: Widget.class.php 1.0 2010-11-3 22:02:01Z tommy $
 * @package core
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
	exit();
}

abstract class Widget extends Controller {
	
	/**
	 * 显示当前页面内容
	 * 
	 * 注:由于挂件程序的视图文件放在特定的目录里,所以挂件不支持多种主题
	 * @access public
	 * @param sring $view_name	视图文件名
	 * @param array $_data		视图变量数组
	 * @return void
	 */
	public function display($view_name = null, $_data = array()) {
		
		//模板变量赋值
        if (!empty($this->_options)) {
       		extract($this->_options, EXTR_PREFIX_SAME, 'data');
            //清空不必要的内存占用
            $this->_options = array();
        }
                    
		//参数分析
		$view_file = $this->template($view_name);
		
		if (!empty($_data) && is_array($_data)) {			
			extract($_data, EXTR_PREFIX_SAME, 'data');
			unset($_data);
		}
		
		ob_start();				
		include $view_file;				
		echo ob_get_clean();
	}
	
	/**
	 * 分析挂件(widget)的视图文件路径
	 * 
	 * 注:这里的视图指的是挂件的视图文件
	 * @access public
	 * @param string $file_name	视图文件名.注:不含文件后缀
	 * @return string			文件路径
	 */
	public function template($file_name = null) {

		//参数分析
		if (is_null($file_name)) {
			$file_name = $this->get_widget_id();
		}
		
		return WIDGET_DIR . 'views/' . $file_name . '.php';
	}
	
	/**
	 * 获取当前Widget的名称
	 * 
	 * @access protected
	 * @return string
	 */
	protected function get_widget_id() {
		
		return substr(strtolower(get_class($this)), 0, -6);
	}
	
	/**
	 * 设置视图布局(layout)
	 * 
	 * 注:挂件中不支持layout
	 * @access public
	 * @return boolean
	 */
	public function set_layout() {
		
		return false;
	}
	
	/**
	 * 设置视图主题
	 * 
	 * 注:挂件中不支持视图主题
	 * @access public
	 * @return boolean
	 */
	public function set_theme() {
		
		return false;
	}
	
	/**
	 * 视图类的实例化
	 * 
	 * 注:视图文件仅限于HTML格式的
	 * @access public
	 * @return boolean
	 */
	public function load_view() {
		
		$this->view 				= View::getInstance();				
		$this->view->view_dir 		= WIDGET_DIR . 'views' . DIRECTORY_SEPARATOR;
		$this->view->compile_dir	= APP_ROOT . 'cache/views/widgets' . DIRECTORY_SEPARATOR;
		$this->view->widget			= $this->get_widget_id();		
		
		return true;
	}

	/**
	 * 运行挂件
	 * 
	 * @access public
	 * @return mixed
	 */
	public function render() {

		return true;
	}
}