<?php
/**
 * cache_xcache class file
 * 
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: cache_xcache.class.php 1.0 2010-12-4 15:30:01Z tommy $
 * @package cache
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
	exit();
}

class cache_xcache extends Base {
	
	/**
	 * 默认缓存时间
	 * 
	 * 如果设置为 0 表示缓存总是失效，设置为 null 则表示不检查缓存有效期
	 * @var integer
	 */
	protected $_default_life_time = 3600;
	
	/**
	 * 配置参数options
	 * 
	 * @var array
	 */
	protected $_options;
	
	/**
	 * 构造函数
	 * 
	 * @access public
	 * @return boolean
	 */
	public function __construct(array $options = null) {
		
		//分析xcache扩展模块
	 	if (!extension_loaded('xcache')) {
			Controller::halt('The xcache extension must be loaded before use!');
        }
		
		//当参数为空时,程序则自动加载config目录中的memcache.ini.php的配置文件
		if (!$options) {
			if (is_file(CONFIG_DIR . 'xcache.ini.php')) {
				$options = Controller::load_config('xcache');
			}
		}
		
		//参数分析
		if ($options) {
			foreach ($options as $key=>$value) {
           		$this->_options[$key] = $value;
        	}
		}
			 	        
		if (empty($this->_options['life_time'])) {
			$this->_options['life_time'] = $this->_default_life_time;
		}
		
		return true;
	}
	
	/**
	 * 写入缓存
	 * 
	 * @param string $key
	 * @param mixted $value
	 * @param integer $expire
	 * @return boolean $expire
	 */
	 public function set($key, $value, $expire = null) {
	 	
	 	if (is_null($expire)) {
	 		$expire = $this->_options['life_time'];
	 	}
	 	
	 	return xcache_set($key, $value, $expire);
	 }
	 
	 /**
	  * 读取缓存，失败或缓存撒失效时返回 false
	  * 
	  * @param string $id
	  * @return mixted
	  */
	 public function get($id) {
	 	
	 	if (xcache_isset($id)) {
	 		return xcache_get($id);
	 	}
	 	
	 	return false;
	 }
	 
	/**
	 * 删除指定的缓存
	 *
	 * @param string $id
	 * @return void
	 */
	 public function delete($id) {
	 	 
	 	return xcache_unset($key);
	 }
}