<?php
/**
 * excel class file
 * 
 * 用于生成excel文件操作
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: excel.class.php 1.0 2010-12-1 20:02:01Z tommy $
 * @package lib
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
	exit();
}

class excel extends Base {

	/**
	 * EXCEL表格的xml代码
	 * 
	 * @var string
	 */	
	protected $xml_table;
	
	/**
	 * EXCEL的标题xml代码
	 * 
	 * @var string
	 */
	protected $xml_menu;
	
	/**
	 * EXCEL的标题的个数
	 * 
	 * @var integer
	 */
	protected $col_num;
	
	/**
	 * 构造函数
	 * 
	 * @return void
	 */
	public function __construct() {
		
	}
	
	/**
	 * 处理EXCEL中一行代码,相当于HTML中的行标签<tr></tr>
	 * 
	 * @param  array $data
	 * @return string
	 */
	protected function handle_row($data) {
		
		//参数分析
		if (empty($data) || !is_array($data)) {			
			return false;
		}
				
		$xml = "<Row>\n";
		foreach ($data as $key=>$value) {			
			$xml .= ($key>0&&empty($data[$key-1])) ? $this->handle_index_cell($value, $key+1) : $this->handle_cell($value);
		}
		$xml .= "</Row>\n";
				
		return $xml;
	}
	
	/**
	 * 处理EXCEL多行数据的代码.
	 * 
	 * @param array $data
	 * @return string
	 */
	protected function add_rows($data) {
		
		//参数分析		
		if (empty($data) || !is_array($data) || !is_array($data[0])) {			
			return false;
		}
				
		$xml_array = array();
		foreach ($data as $row) {			
			$xml_array[] = $this->handle_row($row);
		}
				
		return implode('', $xml_array);
	}
	
	/**
	 * 配置EXCEL表格的标题
	 * 
	 * @param array $data 所要生成的excel的标题,注:参数为数组
	 * @return boolean
	 */
	public function set_menu($data) {
		
		//参数分析		
		if (empty($data) || !is_array($data) || is_array($data[0]) || array_search('', $data)) {			
			return false;
		}
				
		$this->col_num = sizeof($data);		
		$xml = "<Row ss:AutoFitHeight=\"0\" ss:Height=\"20\">\n";
		foreach ($data as $value) {			
			$type = (is_numeric($data)&&(substr($data, 0, 1)!=0)) ? 'Number' : 'String';			
			$xml .= "<Cell ss:StyleID=\"s22\"><Data ss:Type=\"" . $type . "\">" . $value . "</Data></Cell>\n";
		}
		$xml .= "</Row>\n";		
		$this->xml_menu = $xml;	
			
		return true;
	}
	
	/**
	 * 处理EXCEL表格的内容,相当于table.
	 * 
	 * @param array $data
	 * @return string
	 */
	public function get_data($data) {
				
		$xml_rows = $this->add_rows($data);
				
		if (empty($xml_rows)) {						
			if (empty($this->xml_menu)) {				
				return false;
			} else {				
				$row_num = 1;
				$col_num = $this->col_num;						
				$content = $this->xml_menu;
			}
		} else {			
			if (empty($this->xml_menu)) {				
				$row_num = sizeof($data);
				$col_num = sizeof($data[0]);				
				$content = $xml_rows;
			} else {				
				$row_num = sizeof($data)+1;
				$col_num = $this->col_num;				
				$content = $this->xml_menu.$xml_rows;
			}
		}
				
		return $this->xml_table = "<Table ss:ExpandedColumnCount=\"" . $col_num . "\" ss:ExpandedRowCount=\"" . $row_num . "\" x:FullColumns=\"1\"x:FullRows=\"1\" ss:DefaultColumnWidth=\"60\"ss:DefaultRowHeight=\"20\">\n" . $content . "</Table>\n";
	}
	
	/**
	 * 处理EXCEL表格信息代码
	 * 
	 * @return string
	 */
	protected function parse_table() {
				
		$xml_Worksheet = "<Worksheet ss:Name=\"Sheet1\">\n";
				
		if (empty($this->xml_table)) {			
			$xml_Worksheet .= "<Table ss:ExpandedColumnCount=\"0\" ss:ExpandedRowCount=\"0\" x:FullColumns=\"1\"
   x:FullRows=\"1\" ss:DefaultColumnWidth=\"60\" ss:DefaultRowHeight=\"20\"/>\n";
		} else{			
			$xml_Worksheet .= $this->xml_table;
		}
		
		$xml_Worksheet .= "<WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\"><ProtectObjects>False</ProtectObjects><ProtectScenarios>False</ProtectScenarios></WorksheetOptions></Worksheet>\n";
		
		return $xml_Worksheet;
	}
	
	/**
	 * 处理EXCEL中的表格,相当于html中的标签<td></td>
	 * 
	 * @param string $data
	 * @return string
	 */
	protected function handle_cell($data) {
		
		//参数分析		
		if (empty($data) || is_array($data)) {			
			return false;
		}
				
		$type = (is_numeric($data)&&(substr($data, 0, 1)!=0)) ? 'Number' : 'String';
				
		return "<Cell><Data ss:Type=\"".$type."\">" . $data . "</Data></Cell>\n";
	}
	
	/**
	 * 处理EXCEL中CELL代码,当该CELL前的一个CELL内容为空时.
	 * 
	 * @param string $data
	 * @param integer $key
	 * @return string
	 */
	protected function handle_index_cell($data, $key) {
		
		//参数分析
		if (empty($data) || is_array($data)) {			
			return false;
		}
				
		$type = (is_numeric($data)&&(substr($data, 0, 1)!=0)) ? 'Number' : 'String';
				
		return "<Cell ss:Index=\"" . $key . "\"><Data ss:Type=\"" . $type . "\">" . $data . "</Data></Cell>\n";
	}
	

	/**
	 * 分析EXCEL的文件头
	 * 
	 * @return tring
	 */
	protected function parse_header() {
				
		return "<?xml version=\"1.0\"?>
<?mso-application progid=\"Excel.Sheet\"?>
<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"
 xmlns:o=\"urn:schemas-microsoft-com:office:office\"
 xmlns:x=\"urn:schemas-microsoft-com:office:excel\"
 xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"
 xmlns:html=\"http://www.w3.org/TR/REC-html40\">\n";
	}
	
	/**
	 * 分析EXCEL的内容格式
	 * 
	 * @return string
	 */
	protected function parse_top() {
				
		return "<ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\">
  <WindowHeight>13500</WindowHeight>
  <WindowWidth>20340</WindowWidth>
  <WindowTopX>360</WindowTopX>
  <WindowTopY>75</WindowTopY>
  <ProtectStructure>False</ProtectStructure>
  <ProtectWindows>False</ProtectWindows>
 </ExcelWorkbook>
 <Styles>
  <Style ss:ID=\"Default\" ss:Name=\"Normal\">
   <Alignment ss:Vertical=\"Center\"/>
   <Borders/>
   <Font ss:FontName=\"宋体\" x:CharSet=\"134\" ss:Size=\"12\"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID=\"s22\">
   <Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Center\"/>
  </Style>
 </Styles>\n";
	}
	
	/**
	 * 分析EXCEL的结尾
	 * 
	 * @return string
	 */
	protected function parse_footer() {
				
		return "<Worksheet ss:Name=\"Sheet2\">
  <Table ss:ExpandedColumnCount=\"0\" ss:ExpandedRowCount=\"0\" x:FullColumns=\"1\"
   x:FullRows=\"1\" ss:DefaultColumnWidth=\"60\" ss:DefaultRowHeight=\"20\"/>
  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
 <Worksheet ss:Name=\"Sheet3\">
  <Table ss:ExpandedColumnCount=\"0\" ss:ExpandedRowCount=\"0\" x:FullColumns=\"1\"
   x:FullRows=\"1\" ss:DefaultColumnWidth=\"60\" ss:DefaultRowHeight=\"20\"/>
  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
 </Workbook>";
	}
	
	/**
	 * 生成EXCEL文件并下载.
	 * 
	 * @param string $file_name	所要生成的excel的文件名,注:文件名中不含后缀名
	 */
	public function download($file_name) {
		
		//参数分析		
		if (empty($file_name)) {
			return false;
		}
				
		header('Pragma: no-cache');
		header("Content-Type: application/vnd.ms-excel; name=\"".$file_name.".xls\"");
        header("Content-Disposition: inline; filename=\"" . $file_name . ".xls\"");
		$excel_xml = $this->parse_header().$this->parse_top().$this->parse_table().$this->parse_footer();
		
		echo $excel_xml;
	}
	
	/**
	 * 构晰函数
	 * 
	 * @return void
	 */
	public function __destruct(){		
		
		exit;
	}
}