<?php
/**
 * file_upload class file
 * 
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: file_upload.class.php 1.0 2010-12-3 18:50:01Z tommy $
 * @package lib
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
	exit();
}

class file_upload extends Base {
	
    /**
     * 文件大小
     * 
     * @var integer
     */	
	protected $limit_size;
	
	/**
	 * 文件名字
	 * 
	 * @var string
	 */
	protected $file_name;
	
	/**
	 * 文件类型
	 * 
	 * @var string
	 */
	protected $limit_type;
	
	
	/**
	 * 构造函数
	 * 
	 * @access public
	 * @return boolean
	 */
	public function  __construct() {		
		
		$this->limit_size = 2097152;	//默认文件大小 2M		
		return true;
	}
	
	/**
	 * 初始化运行环境
	 * 
	 * @param string $file
	 * @return boolean
	 */
	protected function parse_init($file) {		
		
		$this->file_name = $file;
				
		if ($this->file_name['size'] > $this->limit_size) {			
			echo '文件:'.$this->file_name['name'].' 大小超出上传限制!';
			exit();
		}		
		if ($this->limit_type) {			
			$this->parse_mimetype($file);
		}
				
		return true;
	}
	
	/**
	 * 设置上传文件的大小限制.
	 * 
	 * @param integer $size
	 * @return unkonow
	 */
	public function set_limit_size($size) {
		
		if ($size) {
			$this->limit_size = $size;
		}
		
		return $this;
	}

	/**
	 * 设置上传文件允许的格式
	 * 
	 * @param string $type
	 * @return unkonow
	 */
	public function set_limit_type($type) {
		
		if (!$type || !is_array($type)) {
			return false;
		}
		
		$this->limit_type = $type;		
		return $this;
	}

	/**
	 * 验证上传文件的格式
	 * 
	 * @return boolean
	 */
	protected function parse_mimetype() {		
		
		//上传文件允许的格式
		$mime_type = array(
		'jpg'=>'image/jpeg',
		'gif'=>'image/gif',
		'png'=>'image/png',
		'bmp'=>'image/bmp',
		'html'=>'text/html',
		'css'=>'text/css',
		'wbmp'=>'image/vnd.wap.wbmp',
		'js'=>'application/x-javascript', 
		'swf'=>'application/x-shockwave-flash',
		'xml'=>'application/xhtml+xml',
		'php'=>'application/x-httpd-php',
		'txt'=>'text/plain',
		'wma'=>'audio/x-ms-wma',
		'mp3'=>'audio/mpeg',
		'zip'=>'application/zip',
		'rar'=>'application/x-rar-compressed',
		'flv'=>'flv-application/octet-stream',
		);
		
		//判断limit_type是否在允许上传文件格式列表之内
		$mime_type_key = array_keys($mime_type);
		
		foreach($this->limit_type as $type) {
			if (!in_array($type, $mime_type_key)) {				
				echo '文件格式不在允许上传的范围之内!';
				exit();
			}
		}
			
		$allow_type_array = array();
		foreach($this->limit_type as $type) {
			$allow_type_array[] = $mime_type[$type];
		}
		
		if (!in_array($this->file_name['type'], $allow_type_array)) {
			echo '上传失败:你上传的文件格式不正确!';
			exit();
		}
				
		return true;
	}
	
	/**
	 * 上传文件
	 * 
	 * @param string $file_upload	文件名字	
	 * @param string $file_name		上传后的目标文件名
	 * @return boolean
	 */
	public function upload($file_upload, $file_name) {		
		
		//参数分析
		if (!is_array($file_upload) || empty($file_name)) {
			return false;
		}
		
		$this->parse_init($file_upload);
					
		if (!move_uploaded_file($this->file_name['tmp_name'], $file_name)) {				
			return false;
		}			
		
		return true;
	}
}