<?php
/**
 * form.class.php
 * 
 * 表单参数验证.主要用于前台提交表单时对表单元素的检查
 * 注：本类函数所返回的数据均为js片段.要结合jquery来使用.
 * @author tommy <streen003@gmail.com>
 * @copyright Copyright (c) 2010 Tommycode Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: form.class.php 1.0 2011-8-15 PM 07:45:08Z tommy $
 * @package lib
 * @since 1.0
 */
 
if (!defined('IN_DOIT')) {
	exit();
}

class form extends Base {
	
	/**
	 * 检查文本框内容是否为空
	 * 
	 * 在表单提交时,用JS验证某 input 的text输入框内容是否为空
	 * 本函数通过解析为相关的JS代码，通过JS来判断的.主要用于前台页面
	 * 
	 * @param string $obj_tag		所要验证的input的文本输入框的选择器标签
	 * @param string $info			提示信息
	 * @param string $resutl_tag	用于显示提示信息的区域的选择器标签. 注：本参数可为空,当为空时,则默认为alert('提示信息').
	 * @return string
	 */
	public static function is_empty($obj_tag, $info, $resutl_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info) {
			return false;
		}
		
		$string  = "if($('" . $obj_tag . "').val() == ''){";
		$string .= (!is_null($info)) ? "$('" . $resutl_tag . "').html('" . $info . "').show();" : "alert('" . $info . "');";
		$string .= "$('" . $obj_tag . "').focus();$('" . $obj_tag . "').css('border-color', '#C00');return false;}";
		
		return $string;
	}
	
	/**
	 * 检查两个文本输入框内容是否一致
	 * 
	 * 常用于密码和确认密码的验证
	 * @param string $obj_tag			选择器标签（密码）
	 * @param string $obj_confirm_tag 	选择器标签(确认密码)
	 * @param string $info				提示信息
	 * @param string $result_tag		用于显示提示信息的区域的选择器标签. 注：本参数可为空,当为空时,则默认为alert('提示信息').
	 * @return string
	 */
	public static function is_same($obj_tag, $obj_confirm_tag, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$obj_confirm_tag || !$info) {
			return false;
		}
		
		$string  = "if($('" . $obj_tag ."').val() != $('" . $obj_confirm_tag . "').val()) {";
		$string .= (!is_null($result_tag)) ? "$('" . $result_tag . "').html('" . $info . "').show();" : "alert('" . $info . "');";
		$string .= "$('" . $obj_confirm_tag . "').focus();$('" . $obj_confirm_tag . "').css('border-color', '#C00');return false;}";
		
		return $string;
	}
	
	/**
	 * 检查字符串长度
	 * 
	 * 当不等合字符串要求时,提示错误信息
	 * @param string $obj_tag		所要验证的input的文本输入框的选择器标签
	 * @param integer $min_num		最少数字长度
	 * @param integer $max_num  	最大数字长度
	 * @param string $info			提示信息
	 * @param string $resutl_tag	用于显示提示信息的区域的选择器标签. 注：本参数可为空,当为空时,则默认为alert('提示信息').
	 * @return string
	 */
	public static function is_len($obj_tag, $min_num = null, $max_num = null, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info || (is_null($min_num) && is_null($max_num))) {
			return false;
		}
		
		$string = "if (!(";
		if (!is_null($min_num) && !is_null($max_num)) {
			$string .= "$('" . $obj_tag . "').val().length >= {$min_num} && $('" . $obj_tag . "').val().length <= {$max_num}";
		} else if (!is_null($min_num)){
			$string .= "$('{$obj_tag}').val().length >= {$min_num}";
		} else {
			$string .= "$('{$obj_tag}').val().length <= {$max_num}";
		}
		$string .= ")) {" . ((!is_null($result_tag)) ? "$('{$result_tag}').html('{$info}').show();" : "alert('{$info}');") . "$('{$obj_tag}').focus();$('{$obj_tag}').css('border-color', '#C00');return false;}";
		
		return $string;
	}
	
	/**
	 * 检查是否为数字
	 * 
	 * @param string	$obj_tag	选择器标签
	 * @param string	$info		提示信息
	 * @param string	$result_tag 显示提示信息的HTML的选择器标签
	 * @return string
	 */
	public static function is_num($obj_tag, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info) {
			return false;
		}
		
		return "if(!/^[-+]?\d+$/.test($('{$obj_tag}').val())){" . ((!is_null($result_tag)) ? "$('{$result_tag}').html('{$info}').show();" : "alert('{$info}');") . "$('{$obj_tag}').focus();$('{$obj_tag}').css('border-color', '#C00');return false;}";
	}
	
	/**
	 * 检查是否为英文字符、数字、下划线的组合字符串
	 * 
	 * 常用于检查用户名的是否含有非法字符
	 * @param string	$obj_tag	选择器标签
	 * @param string	$info		提示信息
	 * @param string	$result_tag 显示提示信息的HTML的选择器标签
	 * @return string
	 */
	public static function is_string($obj_tag, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info) {
			return false;
		}
		
		return "if(!/^[a-z,A-Z0-9-_]+$/.test($('{$obj_tag}').val())){" . ((!is_null($result_tag)) ? "$('{$result_tag}').html('{$info}').show();" : "alert('{$info}');") . "$('{$obj_tag}').focus();$('{$obj_tag}').css('border-color', '#C00');return false;}";
	}
	
	/**
	 * 检查是否含有非法字符
	 * 
	 * 常用于检查用户名的是否含有非法字符
	 * @param string	$obj_tag	选择器标签
	 * @param string	$info		提示信息
	 * @param string	$result_tag 显示提示信息的HTML的选择器标签
	 * @return string
	 */
	public static function is_invalid_str($obj_tag, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info) {
			return false;
		}
		
		return "if(/[!#$%^&*(){}~`\"';:?+=<>/\[\]]+/.test($('{$obj_tag}').val())){" . ((!is_null($result_tag)) ? "$('{$result_tag}').html('{$info}').show();" : "alert('{$info}');") . "$('{$obj_tag}').focus();$('{$obj_tag}').css('border-color', '#C00');return false;}";
	}
	
	/**
	 * 检查是否为邮箱
	 * 
	 * @param string	$obj_tag	选择器标签
	 * @param string	$info		提示信息
	 * @param string	$result_tag 显示提示信息的HTML的选择器标签
	 * @return string
	 */
	public static function is_email($obj_tag, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info) {
			return false;
		}
		
		return "if(!/^[a-z0-9&\-_.]+@[\w\-_]+([\w\-.]+)?\.[\w\-]+$/.test($('{$obj_tag}').val())){" . ((!is_null($result_tag)) ? "$('{$result_tag}').html('{$info}').show();" : "alert('{$info}');") . "$('{$obj_tag}').focus();$('{$obj_tag}').css('border-color', '#C00');return false;}";
	}
	
	/**
	 * 检查是否为网址
	 * 
	 * @param string	$obj_tag	选择器标签
	 * @param string	$info		提示信息
	 * @param string	$result_tag 显示提示信息的HTML的选择器标签
	 * @return string
	 */
	public static function is_url($obj_tag, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info) {
			return false;
		}
		
		return "if(!/^(http|ftp|https|ftps):\/\/[a-zA-Z0-9]+\.[a-zA-Z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/.test($('{$obj_tag}').val())){" . ((!is_null($result_tag)) ? "$('{$result_tag}').html('{$info}').show();" : "alert('{$info}');") . "$('{$obj_tag}').focus();$('{$obj_tag}').css('border-color', '#C00');return false;}";
	}
	
	/**
	 * 检查是否为邮政编码
	 * 
	 * @param string	$obj_tag	选择器标签
	 * @param string	$info		提示信息
	 * @param string	$result_tag 显示提示信息的HTML的选择器标签
	 * @return string
	 */
	public static function is_post_num($obj_tag, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info) {
			return false;
		}
		
		return "if(!/^[1-9][0-9]{5}$/.test($('{$obj_tag}').val())){" . ((!is_null($result_tag)) ? "$('{$result_tag}').html('{$info}').show();" : "alert('{$info}');") . "$('{$obj_tag}').focus();$('{$obj_tag}').css('border-color', '#C00');return false;}";
	}
	
	/**
	 * 检查是否为手机号
	 * 
	 * @param string	$obj_tag	选择器标签
	 * @param string	$info		提示信息
	 * @param string	$result_tag 显示提示信息的HTML的选择器标签
	 * @return string
	 */
	public static function is_mobile($obj_tag, $info, $result_tag = null) {
		
		//参数判断
		if (!$obj_tag || !$info) {
			return false;
		}
		
		return "if(!/^13[\d]{9}$|14^[0-9]\d{8}|^15[0-9]\d{8}$|^18[0-9]\d{8}$/.test($('{$obj_tag}').val())){" . ((!is_null($result_tag)) ? "$('{$result_tag}').html('{$info}').show();" : "alert('{$info}');") . "$('{$obj_tag}').focus();$('{$obj_tag}').css('border-color', '#C00');return false;}";
	}
	
	/**
	 * 密码强度分析
	 * 
	 * 利用jquery的密码强度插件,来检查密码的强度,并在密码框架的右侧将结果显示出来.注：使用本函数前应先加载jquery.
	 * @param string $obj_tab
	 * @return string
	 */
	public static function password_strength($obj_tab) {
		
		//参数判断
		if (!$obj_tab) {
			return false;
		}
		
		//分析JS文件存放目录
		$base_dir_url = Controller::get_base_url() . 'assets/doit/js/';
		$string  = "<script type=\"text/javascript\" src=\"" . $base_dir_url . "jquery/jquery.passwordStrength.min.js?version=1.0\"></script>";
		$string .= "<script type=\"text/javascript\">$(document).ready(function(){\$('{$obj_tab}').passwordStrength();});</script>";
		
		return $string;
	}
}