<?php
/**
 * script class file
 * 
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: script.class.php 1.0 2010-12-2 21:00:01Z tommy $
 * @package lib
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
	exit();
}

class script extends Base {
	
	/**
	 * 加载JS文件(只限doitphp集成的js文件)
	 * 
	 * @access public
	 * @return string $script_name js文件名(不含后缀)
	 * @return string
	 */
	public static function add($script_name) {
		
		//参数分析
		if (!$script_name) {
			return false;
		}

		$script_name = strtolower(trim($script_name));
		
		//分析JS文件存放目录
		$base_dir_url = Controller::get_base_url() . 'assets/doit/js/';
		
		switch ($script_name) {

			case 'jquery':
				$html = "<script type=\"text/javascript\" src=\"" . $base_dir_url . "jquery/jquery.min.js?version=1.6.2\"></script>\r";
				break;
				
			case 'thickbox':
				$html = "<script type=\"text/javascript\">if(typeof tb_pathToImage!='string'){var tb_pathToImage=\"" . $base_dir_url . "thickbox/loading.gif\"}</script><script type=\"text/javascript\" src=\"" . $base_dir_url . "thickbox/thickbox.min.js?version=3.1\"></script>\r<link href=\"" . $base_dir_url . "thickbox/thickbox.css\" rel=\"stylesheet\" type=\"text/css\" />\r";
				break;
							
			case 'form':
				$html = "<script type=\"text/javascript\" src=\"" . $base_dir_url . "jquery/jquery.form.min.js?version=2.8.3\"></script>\r";
				break;
				
			case 'calendar':
				$html = "<script type=\"text/javascript\" src=\"" . $base_dir_url . "calendar/WdatePicker.js?version=4.7.2\"></script>\r";
				break;
					
			case 'tabs_menu':
				$html = "<script type=\"text/javascript\" src=\"" . $base_dir_url . "jquery/jquery.tabs_menu.min.js?version=1.0\"></script>\r";
				break;
				
			case 'tooltip':
				$html = "<script type=\"text/javascript\" src=\"" . $base_dir_url . "jquery/jquery.tooltip.min.js?version=1.0\"></script>\r";
				break;
				
			case 'checkbox':
				$html = "<script type=\"text/javascript\" src=\"" . $base_dir_url . "jquery/jquery.checkbox.min.js?version=1.1\"></script>\r";
				break;
				
			case 'lazyload':
				$html = "<script type=\"text/javascript\" src=\"" . $base_dir_url . "jquery/jquery.lazyload.min.js?version=20110810\"></script>\r";
				break;				
				
			default:				
				$html = "<script type=\"text/javascript\" src=\"" . $script_name . ".js\"></script>\r";				
		}
		
		return $html;
	}		
	
	/**
	 * 调用日历
	 * 
	 * @param string $tag			选择器标签
	 * @param string $start_date	可选的开始日期
	 * @param string $end_date		可选的结束日期
	 * @param string $date_fomat	日期格式.注：本参数支持时分秒
	 * @return string
	 */
	public static function calendar($tag, $start_date = null, $end_date = null, $date_fomat = null) {
		
		//参数分析.
		if (!$tag) {
			return false;
		}
		
		//自定义日历参数
		$calendar_params = '';
		if (!is_null($start_date)) {
			$calendar_params .= ((!$calendar_params) ? '{' : ',') . 'minDate:\'' . $start_date . '\'';
		}
		if (!is_null($end_date)) {
			$calendar_params .= ((!$calendar_params) ? '{' : ',') . 'maxDate:\'' . $end_date . '\'';
		}
		if(!is_null($date_fomat)) {
			$calendar_params .= ((!$calendar_params) ? '{' : ',') . 'dateFmt:\'' . $date_fomat . '\'';
		}
		$calendar_params .= (!$calendar_params) ? '' : '}';
		
		return "<script type=\"text/javascript\">\$(document).ready(function(){\$('" . $tag . "').addClass('doitphp_calendar');\$('" . $tag . "').click(function(){WdatePicker(" . $calendar_params . ");});});</script>\r";
	}
	
	/**
	 * 处理jquery的ajax post JS代码. 注:非jquery的$.post,而是$.ajax
	 * 
	 * @param string $url			接收网址
	 * @param string $data			参数
	 * @param string $beforeSend	数据提交前的处理函数
	 * @param string $success		数据提交后的处理函数
	 * @return string
	 */
	public static function ajax_post($url, $data = null, $beforeSend = null, $success = null) {
		
		//参数分析
		if (!$url) {
			return false;
		}
		
		$html = "\$.ajax({url:'{$url}',type:'POST',";
		if (!is_null($data)) {
			$html .= is_array($data) ? "data:'" . http_build_query($data) . "'," : "data:'{$data}',";
		}
		if (!is_null($beforeSend)) {
			$html .= "beforeSend:{$beforeSend},";
		}
		if (!is_null($success)) {
			$html .= "success:{$success},";
		}
		$html .= "});\r";
		
		return $html;
	}

	/**
	 * 处理jquery的ajax GET代码. 注:非jquery的$.get,而是$.ajax
	 * 
	 * @param string $url			接收网址
	 * @param string $data			参数
	 * @param string $beforeSend	数据提交前的处理函数
	 * @param string $success		数据提交后的处理函数
	 * @return string
	 */
	public static function ajax_get($url, $data = null, $beforeSend = null, $success = null) {
		
		//参数分析
		if (!$url) {
			return false;
		}
		
		$html = "\$.ajax({url:'{$url}',type:'GET',";
		if (!is_null($data)) {
			$html .= is_array($data) ? "data:'" . http_build_query($data) . "'," : "data:'{$data}',";
		}
		if (!is_null($beforeSend)) {
			$html .= "beforeSend:{$beforeSend},";
		}
		if (!is_null($success)) {
			$html .= "success:{$success},";
		}
		
		return $html . "});\r";
	}

	/**
	 * Ajax Loading 加载图片的HTML代码,small为小图片.
	 * 
	 * @param string $options	图片类型(非图片格式类型)
	 * @return string
	 */
	public static function ajax_loading_image($options = 'small') {		
		
		switch ($options) {

			case 'small':
				$image_name = 'ajax_loading_small.gif';
				break;

			case 'big':
				$image_name = 'ajax_loading_big.gif';
				break;

			case 'bar':
				$image_name = 'ajax_loading_bar.gif';
				break;

			case 'snake':
				$image_name = 'ajax_loading_snake.gif';
				break;

			case 'ring':
				$image_name = 'ajax_loading_ring.gif';
				break;

			default : $image_name = 'ajax_loading_small.gif';
		}
				
		return '<img src="' . Controller::get_base_url() . 'assets/doit/images/' . $image_name . '"/>';				
	}	

	/**
	 * 处理$.load()的jquery代码.
	 * 
	 * @param string $tag			jquery的选择器标签
	 * @param string $url			所要加载内容的网址
	 * @param string $image_option	ajax loading图片类型
	 * @return string
	 */
	public static function ajax_box_load($tag, $url, $image_option = 'small', $loading_img_id = 'doitphp_ajax_loading_image') {
		
		//参数分析.
		if (!$tag || !$url) {
			return false;
		}
		
		$base_dir_url = Controller::get_base_url() . 'assets/doit/';
		
		//选择ajax loading image 的类型.
		switch ($image_option) {

			case 'small':
				$image_name = 'ajax_loading_small.gif';
				break;

			case 'big':
				$image_name = 'ajax_loading_big.gif';
				break;

			case 'bar':
				$image_name = 'ajax_loading_bar.gif';
				break;

			case 'snake':
				$image_name = 'ajax_loading_snake.gif';
				break;

			case 'ring':
				$image_name = 'ajax_loading_ring.gif';
				break;

			default : $image_name = 'ajax_loading_small.gif';
		}

		//组装JS代码
		return "<script type=\"text/javascript\">\$(document).ready(function() {\$('" . $tag . "').append('<img src=\"" . $base_dir_url . "images/" . $image_name . "\" id=\"" . $loading_img_id . "\"/>');var left=parseInt((\$('" . $tag . "').width()-\$('#" . $loading_img_id . "').width())/2);var top=parseInt((\$('" . $tag . "').height()-\$('#" . $loading_img_id . "').height())/2);\$('#" . $loading_img_id . "').css({'margin-top':top+'px','margin-left':left+'px'});\$('" . $tag."').load('" . $url . "',function() {\$('#" . $loading_img_id . "').remove()})});</script>\r";
	}
	
	/**
	 * 处理jquery 插件 lazyload的调用代码
	 * 
	 * @access public
	 * @param string	$tag	图片的选择器标签
	 * @param string 	$options	图片类型(非图片格式类型)
	 * @return string
	 */
	public static function lazyload($tag = 'img', $options = 'small') {
		
		switch ($options) {

			case 'small':
				$image_name = 'ajax_loading_small.gif';
				break;

			case 'big':
				$image_name = 'ajax_loading_big.gif';
				break;

			case 'bar':
				$image_name = 'ajax_loading_bar.gif';
				break;

			case 'snake':
				$image_name = 'ajax_loading_snake.gif';
				break;

			case 'ring':
				$image_name = 'ajax_loading_ring.gif';
				break;

			default : $image_name = 'ajax_loading_small.gif';
		}
		
		return "<script type=\"text/javascript\">\$(document).ready(function(){\$('" . $tag . "').lazyload({placeholder:'" . Controller::get_base_url() . 'assets/doit/images/' . $image_name . "',effect:'fadeIn'});});</script>\r";
	}
	
	/**
	 * 完成jquery form插件提交表单数据的JS代码
	 * 
	 * @access public
	 * @param string $form_tags	form标签的选择器
	 * @param string $before_fn 提交表单前所绑定的函数名
	 * @param string $success_fn 提交表单后所绑定的函数名
	 * @return string
	 */
	public static function ajax_form($form_tags, $before_fn, $success_fn) {
		
		return '<script type="text/javascript">$(document).ready(function(){$(\'' . $form_tags. '\').ajaxForm({beforeSubmit:' . $before_fn . ',success:' . $success_fn . '});});</script>';
	}
}