<?php
/**
 * xml class file
 * 
 * 注:本类生成xml文件只限内容极为简单数据,如操作复杂数据请用php5.0自带的simpleXml函数组
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: xml.class.php 1.0 2010-12-4 20:10:01Z tommy $
 * @package lib
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
	exit();
}

class xml extends Base {
	
	/**
	 * 加载xml文件.支持文件名及xml代码.
	 * 
	 * @param string $file_name	xml文件名或xml代码内容
	 * @return string
	 */
	public static function load_xml($file_name) {		
		
		if (!$file_name) {			
			return false;
		}
						
		return (strpos($file_name, '<?xml')===false) ? simplexml_load_file($file_name) : simplexml_load_string($file_name);
	}

	/**
	 * 数据转化为xml代码.
	 * 
	 * @param array $data	xml内容数组
	 * @return string
	 */
	protected function data2xml($data) {		
		
		if (!$data) {			
			return false;
		}
		
		if (is_object($data)) {			
			$data = get_object_vars($data);
		}
				
		$xml = "";
		foreach ($data as $key=>$value) {			
			if (is_array($value)) {				
				foreach ($value as $k=>$v) {					
					$xml .= is_numeric($k) ? $this->add_child($key, $v) : "<".$key.">\r".$this->add_child($k,$v)."</".$key.">\r";
				}
			} else {				
				$xml .= "<".$key.">".$value."</".$key.">\r";
			}
		}
				
		return $xml;
	}
	
	/**
	 * 进行对xml编码.
	 * 
	 * @param string $data xml内容数组
	 * @param string $root
	 * @return string
	 */
	public function xml_encode($data, $root = null) {		
		
		if (!$data) {			
			return false;
		}
		
		$root = is_null($root) ? 'root' : trim($root);		
		$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r";
		$xml .= "<".$root.">\r";
		$xml .= $this->data2xml($data);
		$xml .= "</".$root.">";
				
		return $xml;
	}
	
	/**
	 * 处理XML代码.
	 * 
	 * @param string $tag
	 * @param string $value
	 * @return string
	 */
	protected function add_child($tag, $value) {		
		
		if (!$tag || !$value) {			
			return false;
		}
				
		if (is_array($value)) {			
			$xml = "";
			foreach ($value as $key=>$lines) {				
				if (is_array($lines)) {					
					$xml .="<".$tag.">\r";
					foreach ($lines as $k=>$v) {						
						$xml .= is_numeric($k) ? $this->add_child($key,$v) : "<".$key.">\r".$this->add_child($k,$v)."</".$key.">\r";
					}
					$xml .= "</".$tag.">\r";
				} else {					
					$xml .= is_numeric($key) ? "<".$tag.">".$lines."</".$tag.">\r" : "<".$key.">".$lines."</".$key.">\r";
				}
			}
		} else {			
			$xml .= "<".$tag.">".$value."</".$tag.">\r";
		}
				
		return $xml;
	}
}