<?php
if (!defined('IN_DOIT')) { exit(); }

class KindeditorModule extends Module {
	
	/**
	 * kindeditor js文件加载次数
	 * 
	 * @var integer
	 */
	public static $load_nums = 0;
	
	/**
	 * 构造函数
	 * 
	 * @access public
	 * @return void
	 */
	public function __construct() {
			
	}
	
	/**
	 * 获取编辑器
	 * 
	 * @access public
	 * @param  string $editor_id 		textarea标签的ID
	 * @param  string $browse_url		浏览服务器图片文件页面的URL.默认为相关页面(高级应用)
	 * @param  string $upload_url		图片上传服务页面的URL.默认为相关页面(高级应用)
	 * @return string
	 */
	public function get_editor($editor_id, $browse_url = null, $upload_url = null) {
		
		//define current module url
		$base_url = $this->get_module_url();
		
		$output_str = '';
		if (self::$load_nums == 0) {
			$output_str .= '<script type="text/javascript" src="' . $base_url . 'kindeditor/kindeditor-min.js"></script>';
		}
		
		$ext_str  = '';
		$ext_str .= 'fileManagerJson:\'' . ((!is_null($browse_url)) ? $browse_url : $base_url . 'kindeditor/php/file_manager_json.php') . '\',';
		$ext_str .= 'imageUploadJson:\'' . ((!is_null($upload_url)) ? $upload_url : $base_url . 'kindeditor/php/upload_json.php') . '\',';
		
		$output_str .= '<script type="text/javascript">KE.show({id:\'' . $editor_id . '\',' . $ext_str .' allowFileManager:true,});</script>';
		
		self::$load_nums ++;
		setcookie('doitphp_kindeditor_auth', md5('doitphp'), time()+3600, '/');
		  
		return $output_str;
	}
	
	/**
	 * 获取简单主题的编辑器
	 * 
	 * @access public
	 * @param  string $editor_id 		textarea标签的ID
	 * @return string
	 */
	public function get_simple_editor($editor_id) {
		
		//define current module url
		$base_url = $this->get_module_url();
		
		$output_str = '';
		if (self::$load_nums == 0) {
			$output_str .= '<script type="text/javascript" src="' . $base_url . 'kindeditor/kindeditor-min.js"></script>';
		}
		
		return $output_str .= "<script type=\"text/javascript\">KE.show({id : '{$editor_id}',resizeMode : 1,allowPreviewEmoticons : false,allowUpload : false,items : ['fontname', 'fontsize', '|', 'textcolor', 'bgcolor', 'bold', 'italic', 'underline','removeformat', '|', 'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist','insertunorderedlist', '|', 'emoticons', 'image', 'link']});</script>";
	}
	
	/**
	 * 析构函数
	 * 
	 * @access public
	 * @return void
	 */
	public function __destruct() {
		
		self::$load_nums = 0;
	}
}