<?php
if(!defined('CORE_ROOT')) exit;
require_once(CORE_ROOT.'include/oauth.func.php');
if(!empty($setting_txwbkey)) {
	$qqconfig = array(
		'key' => $setting_txwbkey,
		'secret' => $setting_txwbsecret,
		'callback' => $homepage.'akcms_user.php?action=txwbcallback'
	);
	$oauth = qqoauth();
}

function qqoauth() {
	global $qqconfig, $user;
	if(!empty($_SESSION['qqrequesttoken'])) {
		$qqconfig['requesttoken'] = $_SESSION['qqrequesttoken'];
		$qqconfig['requestsecret'] = $_SESSION['qqrequestsecret'];
	} else {
		$qqconfig['requesttoken'] = $qqconfig['requestsecret'] = '';
	}
	if(!empty($_SESSION['qqaccesstoken'])) {
		$qqconfig['accesstoken'] = $_SESSION['qqaccesstoken'];
		$qqconfig['accesssecret'] = $_SESSION['qqaccesssecret'];
	} elseif($user->uid > 0) {
		$userinfo = $user->userinfo();
		$qqconfig['accesstoken'] = $userinfo['qqaccesstoken'];
		$qqconfig['accesssecret'] = $userinfo['qqaccesssecret'];
	} else {
		$qqconfig['accesstoken'] = $qqconfig['accesssecret'] = '';
	}
	return new oauth($qqconfig);
}

function getrequesttoken() {
	global $oauth, $qqconfig;
	$_SESSION = array();
	$qqconfig['requesttoken'] = $qqconfig['requestsecret'] = $qqconfig['accesstoken'] = $qqconfig['accesssecret'] = '';
	$oauth = new oauth($qqconfig);
	$params = array(
		'oauth_callback' => $qqconfig['callback']
	);
	$url = 'https://open.t.qq.com/cgi-bin/request_token';
	$params = $oauth->iniparams($url, 'GET', $params);
	unset($params['oauth_token']);
	$html = $oauth->request($url, 'GET', $params);
	return htmltoparams($html);
}

function htmltoparams($html) {
	$pairs = explode('&', $html);
	$params = array();
	foreach($pairs as $pair) {
		$split = explode('=', $pair, 2);
		$k = urldecode($split[0]);
		$v = isset($split[1]) ? urldecode($split[1]) : '';
		if(isset($params[$k])) {
			$params[$k] = array($params[$k]);
			$params[$k][] = $v;
		} else {
			$params[$k] = $v;
		}
	}
	return $params;
}

function getaccesstoken($verifier) {
	global $oauth, $qqconfig;
	$params = array(
		'oauth_verifier' => $verifier,
		'oauth_token' => $oauth->requesttoken
	);
	$url = 'https://open.t.qq.com/cgi-bin/access_token';
	$params = $oauth->iniparams($url, 'GET', $params);
	$html = $oauth->request($url, 'GET', $params);
	return htmltoparams($html);
}

function getuserinfo() {
	global $oauth, $qqconfig;
	$params = array(
		'format' => 'xml'
	);
	$url = 'http://open.t.qq.com/api/user/info';
	$params = $oauth->iniparams($url, 'GET', $params);
	$xml = $oauth->request($url, 'GET', $params);
	$array = xml2array($xml);
	return fromutf8($array['root']['data']);
}

function postweibo($content, $picurl = '') {
	global $oauth, $qqconfig, $onlineip;
	if(!isset($oauth)) return false;
	$content = gbktoutf8($content);
	$params = array(
		'format' => 'json',
		'content' => $content
	);
	if($picurl == '') {
		$url = 'http://open.t.qq.com/api/t/add';
	} else {
		$url = 'http://open.t.qq.com/api/t/add_pic_url';
		$params['pic_url'] = $picurl;
	}
	$params = $oauth->iniparams($url, 'POST', $params);
	$html = $oauth->request($url, 'POST', $params);
	return $html;
}
?>