<?php
defined('IN_SOFT') or exit('Access Denied');
session_start();
if(!is_login())
{
	show_opInfo(lang('loggedOut'), '', 'e', 'index.php?m=login');
}

$action = array('optimize', 'repair', 'backup', 'restore', 'formRestore');
$a = (isset($_GET['a']) && in_array($_GET['a'], $action)) ? $_GET['a'] : '';

//$_backup['list'], $_backup['other_table']
$_backup['other_table'] = array();
$tables = $_ada->list_tables($_config['db']['db']);
foreach($tables as $table)
{
	$t['name'] = $table;
	$t['records'] = $_ada->count_row($table);
	if(preg_match('/'.$_config['db']['prefix'].'/', $table))
	{
		$_backup['list'][] = $t;
	}
	else
	{
		$_backup['other_table'][] = $t;
	}
}

//$_backup['structure_file'], $_backup['data_file'], $_backup['other_file']
$dataDir = SITE_ROOT.'data/db_backup/';
$dataFileSet = scandir($dataDir);
$_backup['structure_file'] = '';
$_backup['data_file'] = array();
foreach($dataFileSet as $dfs)
{
	if(preg_match('/table_structure/', $dfs))
	{
		$_backup['structure_file'] = $dfs;
	}
	elseif(preg_match('/'.$_config['db']['prefix'].'/', $dfs))
	{
		$_backup['data_file'][] = $dfs;
	}
	elseif(filesize("{$dataDir}/{$dfs}") > 0)
	{
		$_backup['other_file'][] = $dfs;
	}
}

if('optimize' == $a)
{
	$table = filter_str($_GET['table']) ? filter_str($_GET['table']) : $_POST['table'];
	if(!empty($table))
	{
		if(is_array($table))
		{
			foreach($table as $t)
			{
				$_ada->optimize_table($t);
			}
		}
		else
		{
			$_ada->optimize_table($table);
		}
		show_opInfo(lang('optimizeSuccess'), 'index.php?m=backup');
	}
	else
	{
		show_opInfo(lang('optimizeFailed'), 'index.php?m=backup', 'e');
	}
}
elseif('repair' == $a)
{
	$table = filter_str($_GET['table']) ? filter_str($_GET['table']) : $_POST['table'];
	if(!empty($table))
	{
		if(is_array($table))
		{
			foreach($table as $t)
			{
				$_ada->repair_table($t);
			}
		}
		else
		{
			$_ada->repair_table($table);
		}
		show_opInfo(lang('repairSuccess'), 'index.php?m=backup');
	}
	else
	{
		show_opInfo(lang('repairFailed'), 'index.php?m=backup', 'e');
	}
}
elseif('backup' == $a)
{
	//deal structure file
	$backupStructure = $_POST['backup_structure'];
	if($backupStructure)
	{
		if(!empty($_backup['structure_file']))
		{
			$sFOld = "{$dataDir}{$_backup['structure_file']}";
			if(file_exists($sFOld))
			{
				unlink($sFOld);
			}
		}
		$structureStr = '';
		foreach($tables as $t)
		{
			$structureStr .= $_ada->get_table_structure($t);
		}
		$structureFile = "{$dataDir}table_structure_".date ('YmdHis').random_char(8).".txt";
		$fpS = fopen($structureFile, 'w');
		fwrite($fpS, $structureStr);
		fclose($fpS);
	}

	//deal data file
	$table = filter_str($_GET['table']) ? filter_str($_GET['table']) : $_POST['table'];
	if(!empty($table))
	{
		if(is_array($table))
		{
			foreach($table as $t)
			{
				foreach($_backup['data_file'] as $df)
				{
					if($t == substr($df, 0, strlen($df) - 27))
					{
						unlink("{$dataDir}{$df}");
					}
				}
				$dataStr = $_ada->get_table_data($t);
				$dataFile = "{$dataDir}{$t}_".date ('YmdHis').random_char(8).".txt";
				$fpD = fopen($dataFile, 'w');
				fwrite($fpD, $dataStr);
				fclose($fpD);
			}
		}
		else
		{
			foreach($_backup['data_file'] as $df)
			{
				if($table == substr($df, 0, strlen($df) - 27))
				{
					unlink("{$dataDir}{$df}");
				}
			}
			$dataStr = $_ada->get_table_data($table);
			$dataFile = "{$dataDir}{$table}_".date ('YmdHis').random_char(8).".txt";
			$fpD = fopen($dataFile, 'w');
			fwrite($fpD, $dataStr);
			fclose($fpD);
		}
	}
	show_opInfo(lang('backupSuccess'), 'index.php?m=backup');
}
elseif('restore' == $a)
{
	//deal structure file
	$restoreStructure = $_POST['restore_structure'];
	$deleteBackupFile = $_POST['delete_backup_file'];
	$sF = "{$dataDir}{$_backup['structure_file']}";
	if($restoreStructure)
	{
		if(empty($_backup['structure_file']) || !file_exists($sF))
		{
			show_opInfo(lang('structureFileNotExists'), 'index.php?m=backup', 'e');
		}
		$_ada->restore_data($sF);
		if($deleteBackupFile)
		{
			unlink($sF);
		}
	}

	//deal data
	$dataFile = filter_str($_GET['data_file']) ? filter_str($_GET['data_file']) : $_POST['data_file'];
	if(!empty($dataFile))
	{
		if(is_array($dataFile))
		{
			foreach($dataFile as $dF)
			{
				$currentTable = substr($dF, 0, strlen($dF) - 27);
				if(in_array($currentTable, $tables))
				{
					$_ada->truncate_table($currentTable);
				}
				$_ada->restore_data("{$dataDir}{$dF}");
				if($deleteBackupFile)
				{
					unlink("{$dataDir}{$dF}");
				}
			}
		}
		else
		{
			$currentTable = substr($dataFile, 0, strlen($dataFile) - 27);
			if(in_array($currentTable, $tables))
			{
				$_ada->truncate_table($currentTable);
			}
			$_ada->restore_data("{$dataDir}{$dataFile}");
			if($deleteBackupFile)
			{
				unlink("{$dataDir}{$dataFile}");
			}
		}
	}
	show_opInfo(lang('restoreSuccess'), 'index.php?m=backup');
}
elseif('formRestore' == $a)
{
	$_page['icon'] = 'backup/restore.png';
	$_page['title'] = lang('restore');
	$adminHomeLink = "<a href=\"#\" url=\"index.php?m=overview\">".lang('adminHome')."</a> &gt ";
	$_page['position'] = $adminHomeLink.$_page['title'];

	$_tpl->assign('_page', $_page);
	$_tpl->assign('_lang', $_lang);
	$_tpl->assign('_backup', $_backup);
	$_tpl->display('backup_restore.html');
}
else
{
	$_page['icon'] = 'backup.png';
	$_page['title'] = lang('backup');
	$adminHomeLink = "<a href=\"#\" url=\"index.php?m=overview\">".lang('adminHome')."</a> &gt ";
	$_page['position'] = $adminHomeLink.$_page['title'];

	$_tpl->assign('_page', $_page);
	$_tpl->assign('_lang', $_lang);
	$_tpl->assign('_backup', $_backup);
	$_tpl->display('backup.html');
}
?>