<?php
defined('IN_SOFT') or exit('Access Denied');
session_start();

$action = array('login', 'logout');
$a = (isset($_GET['a']) && in_array($_GET['a'], $action)) ? $_GET['a'] : '';

if('login' == $a)
{
	$userName = filter_str($_POST['userName']);
	$password = filter_str($_POST['password']);
	$lang = filter_str($_POST['lang']);
	$VCode = filter_str($_POST['VCode']);
	$loginError = array();
	if(0 == strlen($userName)){
		$loginError[] = lang('userNameNoNull');
	}
	if(0 == strlen($password))
	{
		$loginError[] = lang('passwordNoNull');
	}
	if(0 == strlen($lang))
	{
		$loginError[] = lang('languageNoNull');
	}
	if(0 == strlen($VCode))
	{
		$loginError[] = lang('vcodeNoNull');
	}
	if(FOUNDER_NAME != $userName || FOUNDER_PW != encrypt($password))
	{
		$loginError[] = lang('loginInvalid');
	}
	if(strtoupper($_SESSION['VCode']) != strtoupper($VCode))
	{
		$loginError[] = lang('vcodeInvalid');
	}
	if(!empty($loginError))
	{
		show_opInfo($loginError, '', 'e', 'index.php?m=login');
	}
	else
	{
		$_SESSION['login_status'] = 1;
		set_cookie('language', $lang, 86400);
		show_opInfo(lang('loginSuccess'), 'index.php?m=login', 's', 'index.php?m=index');
	}
}
elseif('logout' == $a)
{
	$_SESSION['login_status'] = 0;
	show_opInfo(lang('logoutSuccess'), '', 's', 'index.php?m=login');
}
else
{
	$langSet = $_ale->langSet;
	$defaultLang = get_cookie('language') ? get_cookie('language') : SITE_DEFAULT_LANG;
	$_tpl->assign('defaultLang', $defaultLang);
	$_tpl->assign('langSet', $langSet);

	$_page['title'] = lang('adminLogin');
	$_tpl->assign('_page', $_page);
	$_tpl->assign('_lang', $_lang);
	$_tpl->display('login.html');
}
?>