<?php
defined('IN_SOFT') or exit('Access Denied');
session_start();
if(!is_login())
{
	show_opInfo(lang('loggedOut'), '', 'e', 'index.php?m=login');
}

$action = array('add', 'delete', 'edit', 'editOrder', 'toggle', 'formAdd', 'formEdit');
$a = (isset($_GET['a']) && in_array($_GET['a'], $action)) ? $_GET['a'] : '';

//$_slide['list']
$slideNum = $_ada->count_row("`#@__slide`");
$_apage = new Apage($slideNum, 20);
$_slide['list'] = $_ada->fetch_array("`#@__slide`", "*", "", "ORDER BY `order_num`");

$slideImageDir = 'static/upload/slide/';
$uploadDir = SITE_ROOT.$slideImageDir;
$_aupload = new Aupload(array('uploadDir' => $uploadDir));
$_aimage = new Aimage(array('sourceDir' => $uploadDir, 'outputDir' => $uploadDir));

if('add' == $a)
{
	$title = filter_str($_POST['title']);
	$abstract = filter_str($_POST['abstract']);
	$url = filter_str($_POST['url']);
	$orderNum = filter_num($_POST['order_num']);
	$available = filter_num($_POST['available']);

	//deal with picture
	$pictureSourceFile = $_aupload->upload('slide_picture_upload');
	$thumbSourceFile = $_aupload->upload('thumbnail_upload');
	if(!empty($pictureSourceFile))
	{
		$slidePicture = '/'.SITE_PATH.$slideImageDir.$pictureSourceFile['name'];
		if(!empty($thumbSourceFile))
		{
			$thumbFile = $_aimage->thumbnail($thumbSourceFile['name'], 180, 60);
			unlink($uploadDir.$thumbSourceFile['name']);
			$thumbnail = '/'.SITE_PATH.$slideImageDir.$thumbFile['name'];
		}
		elseif(0 == strlen(filter_str($_POST['thumbnail'])))
		{
			$thumbFile = $_aimage->thumbnail($pictureSourceFile['name'], 180, 60);
			$thumbnail = '/'.SITE_PATH.$slideImageDir.$thumbFile['name'];
		}
		else
		{
			$thumbnail = filter_str($_POST['thumbnail']);
		}
	}
	elseif(0 != strlen(filter_str($_POST['slide_picture'])))
	{
		$slidePicture = filter_str($_POST['slide_picture']);
		$pictureName = basename($slidePicture);
		$newPicture = SITE_ROOT.ltrim(filter_str($_POST['slide_picture']), '/\\');
		if(!empty($thumbSourceFile))
		{
			$thumbFile = $_aimage->thumbnail($thumbSourceFile['name'], 180, 60);
			unlink($uploadDir.$thumbSourceFile['name']);
			$thumbnail = '/'.SITE_PATH.$slideImageDir.$thumbFile['name'];
		}
		elseif(0 != strlen(filter_str($_POST['thumbnail'])))
		{
			$thumbnail = filter_str($_POST['thumbnail']);
		}
		elseif(file_exists($newPicture) && !is_dir($newPicture))
		{
			$thumbFile = $_aimage->thumbnail($pictureName, 180, 60);
			$thumbnail = '/'.SITE_PATH.$slideImageDir.$thumbFile['name'];
		}
		else
		{
			show_opInfo(lang('thumbnailNoNull'), 'index.php?m=slide', 'e');
		}
	}
	else{
		show_opInfo(lang('slidePictureNoNull'), 'index.php?m=slide', 'e');
	}

	if(0 != strlen($title))
	{
		$_ada->insert("`#@__slide`",
		"`title`, `abstract`, `thumbnail`, `slide_picture`, `url`, `order_num`, `available`",
		"'{$title}', '{$abstract}', '{$thumbnail}', '{$slidePicture}', '{$url}', '{$orderNum}', '{$available}'");
		show_opInfo(lang('addSuccess'), 'index.php?m=slide');
	}
	else
	{
		show_opInfo(lang('addFailed'), 'index.php?m=slide', 'e');
	}
}
elseif('delete' == $a)
{
	$slideId = filter_num($_GET['slide_id']) ? filter_num($_GET['slide_id']) : $_POST['slide_id'];
	if(0 != strlen($slideId))
	{
		if(is_array($slideId))
		{
			foreach($slideId as $sId)
			{
				$relatedImage = $_ada->fetch_array("`#@__slide`", "`thumbnail`, `slide_picture`", "WHERE `slide_id` = '{$sId}'");
				$oldThumb = SITE_ROOT.ltrim($relatedImage[0]['thumbnail'], '/\\');
				if(file_exists($oldThumb) && !is_dir($oldThumb))
				{
					@unlink($oldThumb);
				}
				$oldPicture = SITE_ROOT.ltrim($relatedImage[0]['slide_picture'], '/\\');
				if(file_exists($oldPicture) && !is_dir($oldPicture))
				{
					@unlink($oldPicture);
				}
				$_ada->delete("`#@__slide`", "WHERE `slide_id` = '{$sId}'");
			}
		}
		else
		{
			$relatedImage = $_ada->fetch_array("`#@__slide`", "`thumbnail`, `slide_picture`", "WHERE `slide_id` = '{$slideId}'");
			$oldThumb = SITE_ROOT.ltrim($relatedImage[0]['thumbnail'], '/\\');
			if(file_exists($oldThumb) && !is_dir($oldThumb))
			{
				@unlink($oldThumb);
			}
			$oldPicture = SITE_ROOT.ltrim($relatedImage[0]['slide_picture'], '/\\');
			if(file_exists($oldPicture) && !is_dir($oldPicture))
			{
				@unlink($oldPicture);
			}
			$_ada->delete("`#@__slide`", "WHERE `slide_id` = '{$slideId}'");
		}
		show_opInfo(lang('deleteSuccess'), 'index.php?m=slide');
	}
	else
	{
		show_opInfo(lang('deleteFailed'), 'index.php?m=slide', 'e');
	}
}
elseif('edit' == $a)
{
	$slideId = filter_num($_POST['slide_id']);
	$title = filter_str($_POST['title']);
	$abstract = filter_str($_POST['abstract']);
	$url = filter_str($_POST['url']);
	$orderNum = filter_num($_POST['order_num']);
	$available = filter_num($_POST['available']);

	//deal with picture
	$pictureSourceFile = $_aupload->upload('slide_picture_upload');
	$thumbSourceFile = $_aupload->upload('thumbnail_upload');
	if(!empty($pictureSourceFile))
	{
		$slidePicture = '/'.SITE_PATH.$slideImageDir.$pictureSourceFile['name'];
		$oldPicture = SITE_ROOT.ltrim(filter_str($_POST['slide_picture']), '/\\');
		if(file_exists($oldPicture) && !is_dir($oldPicture))
		{
			@unlink($oldPicture);
		}
		if(!empty($thumbSourceFile))
		{
			$thumbFile = $_aimage->thumbnail($thumbSourceFile['name'], 180, 60);
			unlink($uploadDir.$thumbSourceFile['name']);
			$thumbnail = '/'.SITE_PATH.$slideImageDir.$thumbFile['name'];
			$oldThumb = SITE_ROOT.ltrim(filter_str($_POST['thumbnail']), '/\\');
			if(file_exists($oldThumb) && !is_dir($oldThumb))
			{
				@unlink($oldThumb);
			}
		}
		elseif(0 == strlen(filter_str($_POST['thumbnail'])))
		{
			$thumbFile = $_aimage->thumbnail($pictureSourceFile['name'], 180, 60);
			$thumbnail = '/'.SITE_PATH.$slideImageDir.$thumbFile['name'];
			$oldThumb = SITE_ROOT.ltrim(filter_str($_POST['thumbnail']), '/\\');
			if(file_exists($oldThumb) && !is_dir($oldThumb))
			{
				@unlink($oldThumb);
			}
		}
		else
		{
			$thumbnail = filter_str($_POST['thumbnail']);
		}
	}
	elseif(0 != strlen(filter_str($_POST['slide_picture'])))
	{
		$slidePicture = filter_str($_POST['slide_picture']);
		$pictureName = basename($slidePicture);
		$newPicture = SITE_ROOT.filter_str($_POST['slide_picture']);
		if(!empty($thumbSourceFile))
		{
			$thumbFile = $_aimage->thumbnail($thumbSourceFile['name'], 180, 60);
			unlink($uploadDir.$thumbSourceFile['name']);
			$thumbnail = '/'.SITE_PATH.$slideImageDir.$thumbFile['name'];
			$oldThumb = SITE_ROOT.ltrim(filter_str($_POST['thumbnail']), '/\\');
			if(file_exists($oldThumb) && !is_dir($oldThumb))
			{
				unlink($oldThumb);
			}
		}
		elseif(0 != strlen(filter_str($_POST['thumbnail'])))
		{
			$thumbnail = filter_str($_POST['thumbnail']);
		}
		elseif(file_exists($newPicture) && !is_dir($newPicture))
		{
			$thumbFile = $_aimage->thumbnail($pictureName, 180, 60);
			$thumbnail = '/'.SITE_PATH.$slideImageDir.$thumbFile['name'];
			$oldThumb = SITE_ROOT.ltrim(filter_str($_POST['thumbnail']), '/\\');
			if(file_exists($oldThumb) && !is_dir($oldThumb))
			{
				unlink($oldThumb);
			}
		}
		else
		{
			show_opInfo(lang('thumbnailNoNull'), 'index.php?m=slide', 'e');
		}
	}
	else{
		show_opInfo(lang('slidePictureNoNull'), 'index.php?m=slide', 'e');
	}

	if(!empty($slideId) && 0 != strlen($title))
	{
		$_ada->update("`#@__slide`",
		"`title` = '{$title}',
		`abstract` = '{$abstract}',
		`thumbnail` = '{$thumbnail}',
		`slide_picture` = '{$slidePicture}',
		`url` = '{$url}',
		`order_num` = '{$orderNum}',
		`available` = '{$available}'",
		"WHERE `slide_id` = '{$slideId}'");
		show_opInfo(lang('editSuccess'), 'index.php?m=slide');
	}
	else
	{
		show_opInfo(lang('editFailed'), 'index.php?m=slide', 'e');
	}
}
elseif('editOrder' == $a)
{
	if(is_array($orderNum = $_POST['order_num']))
	{
		foreach($orderNum as $sId => $order)
		{
			$_ada->update("`#@__slide`", "`order_num` = '{$order}'", "WHERE `slide_id` = '{$sId}'");
		}
		show_opInfo(lang('applyOrderSuccess'), 'index.php?m=slide');
	}
	else
	{
		show_opInfo(lang('applyOrderFailed'), 'index.php?m=slide', 'e');
	}
}
elseif('toggle' == $a)
{
	$available = $_GET['available'] ? 0 : 1;
	$slideId = filter_num($_GET['slide_id']);
	if(0 != strlen($slideId))
	{
		$_ada->update("`#@__slide`", "`available` = {$available}", "WHERE `slide_id` = '{$slideId}'");
		show_opInfo(lang('toggleSuccess'), 'index.php?m=slide');
	}
	else
	{
		show_opInfo(lang('toggleFailed'), 'index.php?m=slide', 'e');
	}
}
elseif('formAdd' == $a)
{
	$_slide['current']['title'] = '';
	$_slide['current']['abstract'] = '';
	$_slide['current']['thumbnail'] = '';
	$_slide['current']['slide_picture'] = '';
	$_slide['current']['url'] = '';
	$_slide['current']['order_num'] = '0';
	$_slide['current']['available'] = '1';
	$_slide['action'] = "index.php?m=slide&a=add";

	$_page['icon'] = 'slide/add.png';
	$_page['title'] = lang('slideAdd');
	$adminHomeLink = "<a href=\"#\" url=\"index.php?m=overview\">".lang('adminHome')."</a> &gt ";
	$slideLink = "<a href=\"#\" url=\"index.php?m=slide\">".lang('slide')."</a> &gt; ";
	$_page['position'] = $adminHomeLink.$slideLink.$_page['title'];

	$_tpl->assign('_page', $_page);
	$_tpl->assign('_lang', $_lang);
	$_tpl->assign('_slide', $_slide);
	$_tpl->display('slide_form.html');
}
elseif('formEdit' == $a)
{
	$slideId = filter_num($_GET['slide_id']);
	$_slide['current'] = $_ada->fetch_array("`#@__slide`", "*", "WHERE `slide_id` = '{$slideId}'");
	$_slide['current'] = $_slide['current'][0];
	$_slide['action'] = "index.php?m=slide&a=edit";

	$_page['icon'] = 'slide/edit.png';
	$_page['title'] = lang('slideEdit');
	$adminHomeLink = "<a href=\"#\" url=\"index.php?m=overview\">".lang('adminHome')."</a> &gt ";
	$slideLink = "<a href=\"#\" url=\"index.php?m=slide\">".lang('slide')."</a> &gt; ";
	$_page['position'] = $adminHomeLink.$slideLink.$_page['title'];

	$_tpl->assign('_page', $_page);
	$_tpl->assign('_lang', $_lang);
	$_tpl->assign('_slide', $_slide);
	$_tpl->display('slide_form.html');
}
else
{
	$_page['icon'] = 'slide.png';
	$_page['title'] = lang('slideList');
	$adminHomeLink = "<a href=\"#\" url=\"index.php?m=overview\">".lang('adminHome')."</a> &gt ";
	$slideLink = "<a href=\"#\" url=\"index.php?m=slide\">".lang('slide')."</a> &gt; ";
	$_page['position'] = $adminHomeLink.$slideLink.$_page['title'];
	$_page['showPageNum'] = $_apage->show_pageNum();

	$_tpl->assign('_page', $_page);
	$_tpl->assign('_lang', $_lang);
	$_tpl->assign('_slide', $_slide);
	$_tpl->display('slide.html');
}
?>