function loadJS(url, callback, charset)
{
	var script = document.createElement('script');
	script.onload = script.onreadystatechange = function ()
	{
		if(script && script.readyState && /^(?!(?:loaded|complete)$)/.test(script.readyState)) return;
		script.onload = script.onreadystatechange = null;
		script.src = '';
		script.parentNode.removeChild(script);
		script = null;
		if(callback)callback();
	};
	script.charset=charset || document.charset || document.characterSet;
	script.src = url;
	try {document.getElementsByTagName("head")[0].appendChild(script);} catch (e) {}
}

$(document).ready(function(){
	var pathname = location.href.substring(0, location.href.lastIndexOf('/'));
	var parentpath = pathname.substring(0, pathname.lastIndexOf('/'));
	var editorPath = parentpath + "/static/js/kindeditor/kindeditor.js";
	loadJS(editorPath, function(){
		KE.init({
				id : 'simple_editor',
				resizeMode : 1,
				allowPreviewEmoticons : false,
				allowUpload : false,
				syncType : "auto",
				items : [
				'source','|','fontname', 'fontsize', '|',
				'textcolor', 'bgcolor', 'bold', 'italic', 'underline','removeformat', '|',
				'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist','insertunorderedlist']
		});
		KE.create('simple_editor');
	});
});