<?php
define('IN_SOFT', true);

require_once('./install.func.php');

//soft version info
define('SITE_ROOT', rtrim(dirname(dirname(__FILE__))).'/');
define('SOFT_NAME', 'Alog');
define('SOFT_CHARSET', 'utf-8');
define('SOFT_DB_CHARSET', 'UTF8');
define('SOFT_CODE_NAME', 'DaXu');
define('SOFT_VERSION', '2.0.1.6');
define('SOFT_AUTHOR', 'asthis.net');
define('SOFT_AUTHOR_URL', 'http://www.asthis.net/');
define('UPDATE_INFO_URL', 'http://code.asthis.net/updateinfo/log.js');
//soft install file
define('INSTALL_LOCK_FILE', SITE_ROOT."data/install.lock.php");
define('SQL_FILE', SITE_ROOT."install/sqltable.txt");
define('DEFINE_FILE', SITE_ROOT."cfg/define.cfg.php");
define('CONFIG_FILE', SITE_ROOT."cfg/mysql.cfg.php");
//site install info
define('SITE_HOST', 'http://'.get_env('HTTP_HOST').'/');
$_t_site_path = trim(dirname(dirname(get_env('SCRIPT_NAME'))), '\\/').'/';
if('/' == $_t_site_path){$_t_site_path = '';}
define('SITE_PATH', $_t_site_path);
define('SITE_MANAGE_PATH', 'admin/');
define('SITE_DEFAULT_LANG', 'zh-cn');
define('SITE_DEFAULT_TIMEZONE', 'Etc/GMT-8');
//smarty config
require_once(SITE_ROOT.'lib/smarty/Smarty.class.php');
$_tpl = new Smarty();
$_tpl->template_dir = SITE_ROOT.'install/tpl/';
$_tpl->compile_dir = SITE_ROOT.'install/tpl_c/';
$_tpl->caching = false;
$_tpl->left_delimiter = '<{';
$_tpl->right_delimiter = '}>';
//template var
$tpl_var = array(
	'soft_name' => SOFT_NAME,
	'soft_charset' => SOFT_CHARSET,
	'soft_code_name' => SOFT_CODE_NAME,
	'soft_version' => SOFT_VERSION,
	'soft_author' => SOFT_AUTHOR,
	'soft_author_url' => SOFT_AUTHOR_URL,
	'update_info_url' => UPDATE_INFO_URL,
	'site_url' => SITE_HOST.SITE_PATH,
	'site_manage_url' => SITE_HOST.SITE_PATH.SITE_MANAGE_PATH,
	'tpl_path' => SITE_HOST.SITE_PATH.'install/tpl/',
	'tpl_dir' => SITE_ROOT.'install/tpl/'
);
$_tpl->assign('tpl_var', $tpl_var);

//install config
$systemItems = array(
	'os' => array('r' => 'noLimit', 'b' => 'unix'),
	'phpVersion' => array('r' => '5.1', 'b' => '5.2'),
	'uploadMaxFilesize' => array('r' => 'noLimit', 'b' => '2M'),
	'gdVersion' => array('r' => '2.0', 'b' => '2.0'),
	'diskSpace' => array('r' => '20M', 'b' => 'noLimit')
);
$dirfileItems = array(
	'cacheDir' => array('type' => 'dir', 'path' => '/cache'),
	'dataDir' => array('type' => 'dir', 'path' => '/data'),
	'configDir' => array('type' => 'dir', 'path' => '/cfg'),
	'defineFile' => array('type' => 'file', 'path' => '/define.inc.php'),
);
$functionItems = array(
	array('name' => 'file_get_contents'),
	array('name' => 'scandir')
);

header('Content-Type: text/html; charset='.SOFT_CHARSET);

//load language file
load_langFile();
$_tpl->assign('lang', $lang);

check_install_lock();

if(!isset($_GET['installLang']))
{
	step0();
}
else
{
	$step = isset($_POST['step']) ? $_POST['step'] : 1;
	switch($step)
	{
		case '1':
			step1();
			break;
		case '2':
			step2();
			break;
		case '3':
			step3();
			break;
		case '4':
			step4();
			break;
		case '5':
			$errorMessage = check_post(trim_array($_POST));
			$errorMessage .= check_db($_POST['dbHost'],
									$_POST['dbUser'],
									$_POST['dbPw'],
									$_POST['dbDb'],
									$_POST['dbPrefix']);
			if('' != $errorMessage)
			{
				step4($errorMessage);
			}
			else
			{
				step5();
			}
			break;
		case '6':
			step6();
			break;
		default:
			step1();
			break;
	}
}
?>