<?php
defined('IN_SOFT') or exit('Access Denied');

//choose language
function step0()
{
	global $_tpl;
	include_once('./lang/lang_set.php');
	$selectHight = count($langSet) > 5 ? count($langSet) : 5;
	$hal = strtolower(substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 5));
	$_tpl->assign('selectHight', $selectHight);
	$_tpl->assign('hal', $hal);
	$_tpl->assign('langSet', $langSet);
	$_tpl->display('index.html');
}
//show introduce
function step1()
{
	global $_tpl;
	$_tpl->display('step1.html');
}
//show license
function step2()
{
	global $_tpl;
	$_tpl->display('step2.html');
}
//check environment
function step3()
{
	global $_tpl, $systemItems, $dirfileItems, $functionItems;
	$checkNextStep = true;
	check_system($systemItems, $checkNextStep);
	check_dirfile($dirfileItems, $checkNextStep);
	check_function($functionItems, $checkNextStep);
	foreach($systemItems as $k => $v)
	{
		$systemItems[$k]['r'] = lang($v['r']);
		$systemItems[$k]['b'] = lang($v['b']);
		$systemItems[$k]['c'] = lang($v['c']);
		if(1 == $v['s'])
		{
			$systemItems[$k]['c_c'] = 'class="y"';
		}
		else
		{
			$systemItems[$k]['c_c'] = 'class="n"';
		}
	}
	foreach($dirfileItems as $k => $v)
	{
		$dirfileItems[$k]['type'] = lang($v['type']);
		$dirfileItems[$k]['c'] = lang($v['c']);
		if(1 == $v['s'])
		{
			$dirfileItems[$k]['c_c'] = 'class="y"';
		}
		else
		{
			$dirfileItems[$k]['c_c'] = 'class="n"';
		}
	}
	foreach($functionItems as $k => $v)
	{
		if(1 == $v['s'])
		{
			$functionItems[$k]['c_c'] = 'class="y"';
			$functionItems[$k]['s'] = lang('support');
		}
		else
		{
			$functionItems[$k]['c_c'] = 'class="n"';
			$functionItems[$k]['s'] = lang('nonsupport');
		}
	}
	$_tpl->assign('checkNextStep', $checkNextStep);
	$_tpl->assign('systemItems', $systemItems);
	$_tpl->assign('dirfileItems', $dirfileItems);
	$_tpl->assign('functionItems', $functionItems);
	$_tpl->display('step3.html');
	unset($systemItems);
	unset($dirfileItems);
	unset($functionItems);
}
//setup installation
function step4($errorMessage = '')
{
	global $_tpl;
	$formV['dbHost'] = isset($_POST['dbHost']) ? $_POST['dbHost'] : 'localhost';
	$formV['dbUser'] = isset($_POST['dbUser']) ? $_POST['dbUser'] : 'root';
	$formV['dbPw'] = isset($_POST['dbPw']) ? $_POST['dbPw'] : '';
	$formV['dbDb'] = isset($_POST['dbDb']) ? $_POST['dbDb'] : strtolower(SOFT_NAME);
	$formV['dbPrefix'] = isset($_POST['dbPrefix']) ? $_POST['dbPrefix'] : strtolower(SOFT_NAME).'_';
	$formV['founderName'] = isset($_POST['founderName']) ? $_POST['founderName'] : 'admin';
	$formV['founderEmail'] = isset($_POST['founderEmail']) ? $_POST['founderEmail'] : '';
	$formV['founderPw'] = isset($_POST['founderPw']) ? $_POST['founderPw'] : '';
	$_tpl->assign('formV', $formV);
	$_tpl->assign('errorMessage', $errorMessage);
	$_tpl->display('step4.html');
}
//write data
function step5()
{
	$siteSeed = random(8);

	$sql = file_get_contents(SQL_FILE);
	$sql = str_replace('1234555555',time(), $sql);
	$sql = str_replace('(\'cookie_salt\', \'alog\');','(\'cookie_salt\', \''.$siteSeed.'\');', $sql);
	@file_put_contents(SQL_FILE, $sql);

	global $_tpl;
	$_tpl->display('header.html');
	$_tpl->display('step5.html');
	$_tpl->display('footer.html');
	connect_db($_POST['dbHost'], $_POST['dbUser'], $_POST['dbPw'], $_POST['dbDb']);
	$progressScript = run_sql(SQL_FILE);

	$define = array(
		'SOFT_NAME' => SOFT_NAME,
		'SOFT_CHARSET' => SOFT_CHARSET,
		'SOFT_VERSION' => SOFT_VERSION,
		'SOFT_CODE_NAME' => SOFT_CODE_NAME,
		'SOFT_AUTHOR' => SOFT_AUTHOR,
		'SOFT_AUTHOR_URL' => SOFT_AUTHOR_URL,
		'UPDATE_INFO_URL' => UPDATE_INFO_URL,
		'SITE_SEED' => $siteSeed,
		'SITE_HOST' => SITE_HOST,
		'SITE_PATH' => SITE_PATH,
		'SITE_ROOT' => SITE_ROOT,
		'SITE_DEFAULT_LANG' => SITE_DEFAULT_LANG,
		'SITE_DEFAULT_TIMEZONE' => SITE_DEFAULT_TIMEZONE,
		'FOUNDER_NAME' => $_POST['founderName'],
		'FOUNDER_EMAIL' => $_POST['founderEmail'],
		'FOUNDER_PW' => md5(md5($_POST['founderPw']).$siteSeed)
	);
	save_define_file($define, DEFINE_FILE);

	save_config_file();
}
//lock installation
function step6()
{
	global $_tpl;
	install_lock();
	$_tpl->display('step6.html');
}

function load_langFile()
{
	$langNameSet = str_replace('.lang.php', '', scandir(SITE_ROOT.'install/lang/'));
	if(isset($_GET['installLang']) && in_array($_GET['installLang'], $langNameSet))
	{
		$langName = $_GET['installLang'];
	}
	elseif(in_array($_SERVER['HTTP_ACCEPT_LANGUAGE'], $langNameSet))
	{
		$langName = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
	}
	else
	{
		$langName = SITE_DEFAULT_LANG;
	}
	$langFile = SITE_ROOT.'install/lang/'.$langName.'.lang.php';
	if(file_exists($langFile))
	{
		include($langFile);
	}
}

function lang($langKey, $force = true)
{
	return isset($GLOBALS['lang'][$langKey]) ? $GLOBALS['lang'][$langKey] : ($force ? $langKey : '');
}

function check_install_lock()
{
	if(file_exists(INSTALL_LOCK_FILE))
	{
		echo lang('softHasBeenInstalled');
		exit();
	}
}

function check_system(&$systemItems, &$checkNextStep)
{
	$systemItems['os']['c'] = PHP_OS;
	$systemItems['phpVersion']['c'] = PHP_VERSION;
	$systemItems['uploadMaxFilesize']['c'] = @ini_get('file_uploads') ? ini_get('upload_max_filesize') : 'unknow';
	$temp = function_exists('gd_info') ? gd_info() : array('GD Version' => lang('nonsupport'));
	$systemItems['gdVersion']['c'] = empty($temp['GD Version']) ? 'inexistence' : rtrim(ltrim($temp['GD Version'], 'bundled ('),'compatible)');
	unset($temp);
	if(function_exists('diskFreeSpace'))
	{
		$systemItems['diskSpace']['c'] = floor(diskFreeSpace(SITE_ROOT) / (1024*1024)).'M';
	}
	else
	{
		$systemItems['diskSpace']['c'] = 'unknow';
	}

	foreach($systemItems as $k => $v)
	{
		if($v['r'] != 'noLimit' && ($systemItems[$k]['c'] - $v['r']) < 0)
		{
			$systemItems[$k]['s'] = 0;
			$checkNextStep = 0;
		}
		else
		{
			$systemItems[$k]['s'] = 1;
		}
	}
}

function check_dirfile(&$dirfileItems, &$checkNextStep)
{
	foreach($dirfileItems as $k => $v)
	{
		$path = SITE_ROOT.$v['path'];
		if('dir' == $v['type'])
		{
			if(!dir_writable($path))
			{
				if(is_dir($path))
				{
					$dirfileItems[$k]['c'] = 'readOnly';
				}
				else
				{
					$dirfileItems[$k]['c'] = 'inexistence';
				}
				$dirfileItems[$k]['s'] = 0;
				$checkNextStep = 0;
			}
			else
			{
				$dirfileItems[$k]['c'] = 'writable';
				$dirfileItems[$k]['s'] = 1;
			}
		}
		else
		{
			if(file_exists($path))
			{
				if(is_writable($path))
				{
					$dirfileItems[$k]['c'] = 'writable';
					$dirfileItems[$k]['s'] = 1;
				}
				else
				{
					$dirfileItems[$k]['c'] = 'readOnly';
					$dirfileItems[$k]['s'] = 0;
					$checkNextStep = 0;
				}
			}
			else
			{
				if(dir_writable(dirname($path))) {
					$dirfileItems[$k]['s'] = 1;
					$dirfileItems[$k]['c'] = 'writable';
				}
				else {
					$dirfileItems[$k]['s'] = 0;
					$checkNextStep = 0;
					$dirfileItems[$k]['c'] = 'inexistence';
				}
			}
		}
	}
}

function check_function(&$functionItems, &$checkNextStep)
{
	foreach($functionItems as $k => $v)
	{
		if(function_exists($v['name']))
		{
			$functionItems[$k]['s'] = 1;
		}
		else
		{
			$functionItems[$k]['s'] = 0;
			$checkNextStep = 0;
		}
	}
}

function get_env($varName)
{
	if(isset($_SERVER[$varName]))
	{
		return $_SERVER[$varName];
	}
	elseif(isset($_ENV[$varName]))
	{
		return $_ENV[$varName];
	}
	elseif(getenv($varName))
	{
		return getenv($varName);
	}
	elseif(function_exists('apache_getenv') && apache_getenv($varName, true))
	{
		return apache_getenv($varName, true);
	}
	return false;
}

/* 目录是否可写 */
function dir_writable($dir)
{
	if(!is_dir($dir))
	{
		mk_dir($dir, 0777);
	}
	if(is_dir($dir))
	{
		if($fp = @fopen("$dir/test.txt", 'w'))
		{
			@fclose($fp);
			@unlink(realpath("$dir/test.txt"));
			return true;
		}
	}
	return false;
}

/* 创建可写目录(尝试检测上一级目录) */
function mk_dir($dir, $mode = 0777)
{
	if(is_dir($dir) || @mkdir($dir, $mode))
	{
		return true;
	}
	if(!@mkdir(dirname($dir), 0777))
	{
		return false;
	}
	return @mkdir($dir, $mode);
}


function check_post($p)
{
	$errorMessage = '';
	foreach($p as $k => $v)
	{
		if(0 == strlen($v))
		{
			$errorMessage .= "\r\n".lang($k).lang('noEmpty').'<br />';
		}
	}
	return $errorMessage;
}

function check_db($dbHost, $dbUser, $dbPw, $dbDb, $dbPrefix)
{
	$errorMessage = '';
	if(!@mysql_connect($dbHost, $dbUser, $dbPw))
	{
		$errno = mysql_errno();
		if(1045 == $errno)
		{
			$errorMessage = lang('dbErrno1045');
		}
		elseif(2003 == $errno)
		{
			$errorMessage = lang('dbErrno2003');
		}
		else
		{
			$errorMessage = lang('dbConnectError');
		}
	}
	elseif(!@mysql_select_db($dbDb))
	{
		@mysql_query("CREATE DATABASE `{$dbDb}` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci") or $errorMessage = lang('dbDbInexistence');
	}
	elseif($query = mysql_query("SHOW TABLES FROM `{$dbDb}`"))
	{
		while ($row = mysql_fetch_row($query))
		{
			if(preg_match("/^{$dbPrefix}/", $row[0]))
			{
				$errorMessage = lang('dbPrefixExist');
			}
		}
	}
	return $errorMessage;
}

function trim_array($a = array(), $charList = '')
{
	if(0 == strlen($charList))
	{
		foreach($a as $k => $v)
		{
			$a[$k] = trim($v);
		}
	}
	else
	{
		foreach($a as $k => $v)
		{
			$a[$k] = trim($v, $charList);
		}
	}
	return $a;
}

function random($length)
{
	$hash = '';
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
	$max = strlen($chars) - 1;
	for($i = 0; $i < $length; $i++)
	{
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

function connect_db($dbHost, $dbUser, $dbPw, $dbDb)
{
	@mysql_connect($dbHost, $dbUser, $dbPw);
	@mysql_select_db($dbDb);
	@mysql_query('SET NAMES '.SOFT_DB_CHARSET);

}

function run_sql($sqlFile)
{
	$sqlFile = file($sqlFile);
	$sql = '';
	foreach($sqlFile as $row)
	{
		if(substr($row, 0, 2) != '--' && substr($row, 0, 2) != '/*' && substr($row, 0, 1) != '#' && trim($row) != '')
		{
			$sql .= $row;
		}
	}
	$sql = str_replace('prefix_', $_POST['dbPrefix'], $sql);
	$query = trim_array(explode(";\n", $sql));

	$c = 1;
	$t = count($query);
	foreach($query as $q)
	{
		$table = '';
		preg_match('/`\w*`/', $q, $table);
		$m = lang('installSuccess');
		if('DROP TABLE' == substr(strtoupper($q), 0, 10))
		{
			$m = lang('dropTable').$table[0];
		}
		if('CREATE TABLE' == substr(strtoupper($q), 0, 12))
		{
			$m = lang('createTable').$table[0];
		}
		if('INSERT INTO' == substr(strtoupper($q), 0, 11))
		{
			$m = lang('insertDataInto').$table[0];
		}
		if('SET SQL_MODE' == substr(strtoupper($q), 0, 12))
		{
			$m = lang('setSqlMode');
		}
		$b = round($c/$t*100, 0);
		mysql_query($q);
		show_progress($m, $b);
		$c++;
	}
	return $progressScript;
}

function show_progress($message, $barLength)
{
	echo "<script type=\"text/javascript\">show_progress('{$message}', '{$barLength}%');</script>\r\n";
	@ob_flush();
	@flush();
}

function save_define_file($define, $defineFile)
{
	$s = "<?php\r\n";
	$s .= "defined('IN_SOFT') or exit('Access Denied');\r\n";
	foreach($define as $k => $v)
	{
		$s .= "define('".$k."', '".$v."');\r\n";
	}
	$s .= '?>';
	@file_put_contents($defineFile, $s);
}

function save_config_file()
{
	$s = "<?php\r\n";
	$s .= "defined('IN_SOFT') or exit('Access Denied');\r\n";
	$s .= "//mysql database config\r\n";
	$s .= "\$_config['db']['host'] = '".$_POST['dbHost']."';\r\n";
	$s .= "\$_config['db']['user'] = '".$_POST['dbUser']."';\r\n";
	$s .= "\$_config['db']['pw'] = '".$_POST['dbPw']."';\r\n";
	$s .= "\$_config['db']['charset'] = '".SOFT_DB_CHARSET."';\r\n";
	$s .= "\$_config['db']['pconnect'] = '0';\r\n";
	$s .= "\$_config['db']['db'] = '".$_POST['dbDb']."';\r\n";
	$s .= "\$_config['db']['prefix'] = '".$_POST['dbPrefix']."';\r\n";
	$s .= "?>";
	@file_put_contents(CONFIG_FILE, $s);
}

function install_lock()
{
	date_default_timezone_set(SITE_DEFAULT_TIMEZONE);
	$s = "<?php\r\n";
	$s .= "//install information\r\n";
	$s .= "//----------------------------------------\r\n";
	$s .= "//soft: ".SOFT_NAME." ".SOFT_CODE_NAME." ".SOFT_CHARSET." version".SOFT_VERSION."\r\n";
	$s .= "//installation language: ".$_GET['installLang']."\r\n";
	$s .= "//host: ".SITE_HOST.SITE_PATH."\r\n";
	$s .= "//time: ".date('Y-m-d H:i:s T', time())."\r\n";
	$s .= "header(\"location:".SITE_HOST.SITE_PATH."\");\r\n";
	$s .= "?>";
	@file_put_contents(INSTALL_LOCK_FILE, $s);
}
?>