<?php
if(!defined('D_S'))
{
	define('D_S', DIRECTORY_SEPARATOR);
}

//Asthis Database Access(for mysql)
//need ALog.class support
class ADA
{
	private $host = 'localhost';
	private $user = 'root';
	private $pw = '';
	private $db = '';
	private $charset = 'UTF8';
	private $pconnect = false;
	private $prefix = "prefix_";

	private $connect;
	private $result;
	private $ADAError = array();
	private $ADAQuery = array();
	public $logSwitch = array('error' => true, 'query' => false);

	public function __construct($db)
	{
		$classVar = get_class_vars(get_class($this));
		foreach($db as $k => $v)
		{
			if(array_key_exists($k, $classVar))
			{
				$this->$k = $v;
			}
		}
		$this->connect($this->host, $this->user, $this->pw, $this->pconnect);
		$this->select_db($this->db);
		$this->set_charset($this->charset);
	}

	private function connect($dbHost, $dbUser, $dbPw, $pconnect)
	{
		if(true == $pconnect)
		{
			$this->connect = @mysql_pconnect($dbHost, $dbUser, $dbPw);
		}
		else
		{
			$this->connect = @mysql_connect($dbHost, $dbUser, $dbPw);
		}
		$this->get_opInfo('connect host: '.$dbHost);
	}

	public function select_db($database)
	{
		@mysql_select_db($database, $this->connect);
		$this->get_opInfo('select database: '.$database);
	}

	public function set_charset($dbCharset = 'UTF8')
	{
		@mysql_query('SET NAMES '.$dbCharset);
		$this->get_opInfo('set charset: '.$dbCharset);
	}

	public function query($sql)
	{
		if(empty($sql))
		{
			$this->ADAError[] = "SQL query is null.";
		}
		else
		{
			$sql = str_replace("#@__", $this->prefix, $sql);
			if($this->result = @mysql_query($sql))
			{
				$this->get_opInfo('run sql: '.$sql);
				return $this->result;
			}
			else
			{
				$this->ADAError[] = "SQL query result is null: ".$sql;
				$this->get_opInfo('run sql: '.$sql);
			}
		}
		return NULL;
	}

	public function count_row($tableName, $where = '')
	{
		$sql = "SELECT COUNT(*) AS `rowSum` FROM ".$tableName." ".$where;
		if($this->result = $this->query($sql))
		{
			$row = mysql_fetch_array($this->result);
			$this->get_opInfo('count rows: '.$tableName);
			return $row['rowSum'];
		}
		return 0;
	}

	public function fetch_array($table, $field = '*', $where = '', $order = '', $limit = '')
	{
		if('' != $table)
		{
			$sql = "SELECT {$field} FROM {$table} {$where} {$order} {$limit}";
			if($this->result = $this->query($sql))
			{
				$array = array();
				while ($a = mysql_fetch_array($this->result))
				{
					$array[] = $a;
				}
				$this->get_opInfo('fetch array: table = '.$table);
				return $array;
			}
			return NULL;
		}
	}

	public function insert($table, $field = '', $value)
	{
		if('' != $table && '' != $value)
		{
			$field = $field ? "($field)" : '';
			$sql = "INSERT INTO {$table}{$field} VALUES({$value})";
			if($this->query($sql))
			{
				$this->result = NULL;
				$this->get_opInfo('insert: table = '.$table.', value = '.$value);
				return true;
			}
		}
		return false;
	}

	public function update($table, $set, $where, $order = '', $limit = '')
	{
		if('' != $table && '' != $set && '' != $where)
		{
			$sql = "UPDATE {$table} SET {$set} {$where} {$order} {$limit}";
			if($this->query($sql))
			{
				$this->result = NULL;
				$this->get_opInfo('update: table = '.$table.', where = '.$where);
				return true;
			}
		}
		return false;
	}

	public function delete($table, $where, $order = '', $limit = '')
	{
		if('' != $table && '' != $where)
		{
			$sql = "DELETE FROM {$table} {$where} {$order} {$limit}";
			if($this->query($sql))
			{
				$this->result = NULL;
				$this->get_opInfo('delete: table = '.$table.', where = '.$where);
				return true;
			}
		}
		return false;
	}

	public function list_tables($database)
	{
		if('' != $database)
		{
			if($this->result = @mysql_list_tables($database))
			{
				$tables = array();
				while ($tbl = mysql_fetch_row($this->result))
				{
					$tables[] = $tbl[0];
				}
				$this->get_opInfo('list tables: database = '.$database);
				return $tables;
			}
			return NULL;
		}
	}

	public function optimize_table($table)
	{
		if(!empty($table))
		{
			$sql = "OPTIMIZE TABLE `{$table}`";
			if($this->query($sql))
			{
				$this->result = NULL;
				$this->get_opInfo('optimize table: table = '.$table);
			}
			return true;
		}
		return false;
	}

	public function repair_table($table)
	{
		if(!empty($table))
		{
			$sql = "REPAIR TABLE `{$table}`";
			if($this->query($sql))
			{
				$this->result = NULL;
				$this->get_opInfo('repair table: table = '.$table);
			}
			return true;
		}
		return false;
	}

	public function truncate_table($table)
	{
		if(!empty($table))
		{
			$sql = "TRUNCATE TABLE `{$table}`";
			if($this->query($sql))
			{
				$this->result = NULL;
				$this->get_opInfo('truncate table: table = '.$table);
			}
			return true;
		}
		return false;
	}

	public function get_table_structure($table, $drop_switch = true)
	{
		if(!empty($table))
		{
			$str = "";
			if($drop_switch)
			{
				$str .= "DROP TABLE IF EXISTS `{$table}`;\r\n";
			}
			$sql = "SHOW CREATE TABLE `{$table}`";
			if($this->result = $this->query($sql))
			{
				$create = mysql_fetch_row($this->result);
				$str .= $create[1];
				$str .= ";\r\n\r\n";
				$this->result = NULL;
				$this->get_opInfo('get table structure: table = '.$table);
				return $str;
			}
		}
		return NULL;
	}

	public function get_table_data($table)
	{
		if(!empty($table))
		{
			$str = '';
			$sql = "SELECT * FROM `{$table}`";
			if($this->result = $this->query($sql))
			{
				$fieldsNum = mysql_num_fields($this->result);
				$rowsNum = mysql_num_rows($this->result);

				while ($row = mysql_fetch_row($this->result))
				{
					$comma = '';
					$str .= "INSERT INTO `{$table}` VALUES(";
					for($i = 0; $i < $fieldsNum; $i++) {
						$str .= $comma."'".mysql_escape_string($row[$i])."'";
						$comma = ",";
					}
					$str .= ");\r\n";
				}
				$this->result = NULL;
				$this->get_opInfo('get table data: table = '.$table);
				return $str;
			}
		}
		return NULL;
	}

	public function restore_data($dataFile)
	{
		if(!empty($dataFile))
		{
			$rows = '';
			$sql = '';
			$data = file($dataFile);
			foreach($data as $row)
			{
				if(substr($row, 0, 2) != '--' && substr($row, 0, 2) != '/*' && substr($row, 0, 1) != '#' && trim($row) != '')
				{
					$rows .= $row;
				}
			}
			$sql = trim_array(explode(";\r\n", trim($rows)));
			foreach($sql as $v)
			{
				if(!empty($v))
				{
					$this->query($v);
				}
			}
			$this->result = NULL;
			$this->get_opInfo('restore data: data file = '.$dataFile);
			return true;
		}
		return false;
	}

	private function get_opInfo($opInfo = '')
	{
		if(0 != mysql_errno())
		{
			$this->ADAError[] = mysql_errno().': '.mysql_error();
		}
		if(!empty($opInfo))
		{
			$this->ADAQuery[] = $opInfo;
		}
	}

	private function log()
	{
		if($this->logSwitch['error'])
		{
			$ADAAlog = new Alog(array('logType' => 'ADA'));
			$ADAAlog->write_log($this->ADAError);
		}
		if($this->logSwitch['query'])
		{
			$ADAAlog = new Alog(array('logType' => 'ADA'));
			$ADAAlog->write_log($this->ADAQuery);
		}
	}

	function free_result($result)
	{
		if(!empty($result))
		{
			mysql_free_result($result);
			$this->get_opInfo('free result.');
		}
	}

	public function close()
	{
		if($this->connect)
		{
			mysql_close($this->connect);
			$this->get_opInfo('close connect.');
		}
	}

	public function __destruct()
	{
		$this->log();
		$this->free_result($this->result);
		$this->close();
	}

	public function __toString()
	{
		return 'Asthis Database Access Class';
	}
}

/**
Usage:
----------------------------------------
$_config['db']['host'] = 'localhost';
$_config['db']['user'] = 'cblee';
$_config['db']['pw'] = '1';
$_config['db']['charset'] = 'UTF8';
$_config['db']['pconnect'] = false;
$_config['db']['db'] = 'vos1';
$_config['db']['prefix'] = 'vos_';
require_once('./lib/ADA.class.php');
$_ada = new ADA($_config['db']);
$_ada->query('SELECT * FROM `vos` WHERE `id` = '1');
*/
?>