<?php
if(!defined('D_S'))
{
	define('D_S', DIRECTORY_SEPARATOR);
}
if(!defined('ALE_DEFAULT_LANG_DIR'))
{
	define('ALE_DEFAULT_LANG_DIR', 'lang');
}
if(!defined('ALE_DEFAULT_CORE_LANG_FILE'))
{
	define('ALE_DEFAULT_CORE_LANG_FILE', 'core.lang.php');
}
if(!defined('ALE_DEFAULT_LANG_NAME'))
{
	define('ALE_DEFAULT_LANG_NAME', 'zh-cn');
}
if(!defined('ALE_DEFAULT_LANG_NAME_SET_FILE'))
{
	define('ALE_DEFAULT_LANG_NAME_SET_FILE', 'langName_set.php');
}

function lang($langKey, $force = true)
{
	return isset($GLOBALS['_lang'][$langKey]) ? $GLOBALS['_lang'][$langKey] : ($force ? $langKey : '');
}

//Asthis Language Engine
//need ALog.class support
class ALE
{
	private $langDir = ALE_DEFAULT_LANG_DIR;
	private $coreLangFile = ALE_DEFAULT_CORE_LANG_FILE;
	public $langName;
	public $langSet;
	public $ALEError = array();
	public $logSwitch = true;

	public function __construct($langName = ALE_DEFAULT_LANG_NAME)
	{
		$this->langSet = $this->get_lang_set();
		if(!empty($langName))
		{
			if(!array_key_exists($langName, $this->langSet))
			{
				$this->langName = ALE_DEFAULT_LANG_NAME;
			}
			else
			{
				$this->langName = $langName;
			}
		}
		else
		{
			$this->langName = ALE_DEFAULT_LANG_NAME;
		}
		$this->load_lang_file($this->coreLangFile);
	}

	public function load_lang_file($langFile)
	{
		$fileName = $this->langDir.D_S.$this->langName.D_S.$langFile;
		global $_lang;
		if(null == $_lang)
		{
			$_lang = array();
		}
		$extendLang = array();
		if(file_exists($fileName))
		{
			include($fileName);
			$_lang = array_merge($_lang, $extendLang);
		}
		else
		{
			$this->ALEError[] = "load language file failed: ".$this->langName.D_S.$langFile;
		}
	}

	private function get_lang_set()
	{
		$langSet = scandir($this->langDir);
		foreach($langSet as $k => $v)
		{
			if('.' == $v || '..' == $v || ALE_DEFAULT_LANG_NAME_SET_FILE == $v)
			{
				unset($langSet[$k]);
			}
		}
		$langNameSetFile = $this->langDir.D_S.ALE_DEFAULT_LANG_NAME_SET_FILE;
		if(file_exists($langNameSetFile))
		{
			include($langNameSetFile);
			foreach($langNameSet as $k => $v)
			{
				if(!in_array($k, $langSet))
				{
					unset($langNameSet[$k]);
				}
			}
			return $langNameSet;
		}
		else
		{
			return array_flip(array_values($langSet));
		}
	}

	private function log()
	{
		if(!empty($this->ALEError) && $this->logSwitch)
		{
			$ALEAlog = new Alog(array('logType' => 'ALE'));
			$ALEAlog->write_log($this->ALEError);
		}
	}

	public function __destruct()
	{
		$this->log();
	}

	public function __toString()
	{
		return 'Asthis Language Engine Class';
	}
}


/**
Core.lang.php Example:
----------------------------------------
<?php
$extendLang = array(
	'testTxt' => 'Test text',
	);
?>
*/

/**
Extend.lang.php Example:
----------------------------------------
<?php
$extendLang = array(
	'extendTestTxt' => 'Extend test text',
	);
?>
*/

/**
Usage:
----------------------------------------
define('ALE_DEFAULT_LANG_DIR', 'lang');
define('ALE_DEFAULT_CORE_LANG_FILE', 'core.lang.php');
define('ALE_DEFAULT_LANG_NAME', 'zh-cn');
require_once('./lib/ALE.class.php');
$_ale = new ALE();
print_r($_ale->get_lang_set());
echo lang('testTxt').'<br>';
$_ale->langName = 'en';
$_ale->load_lang_file('index.lang.php');
echo lang('extendTestTxt').'<br>';
echo lang('undefineTxt').'<br>';
*/
?>